/*
 * Decompiled with CFR 0.152.
 */
package com.sun.comm.jdapi;

import com.sun.comm.jdapi.DAConstants;
import com.sun.comm.jdapi.DAObject;
import com.sun.comm.jdapi.DASpNameCount;
import com.sun.comm.jdapi.DAUtil;
import java.util.Iterator;
import java.util.Vector;

public class DAAttribute {
    private String _name = null;
    private int _opType = 1;
    private int _attrType = 16;
    private Vector _values = new Vector();
    public static final int NONE = 1;
    public static final int ADD = 2;
    public static final int REPLACE = 4;
    public static final int DELETE = 8;
    public static final int OPTIONAL = 16;
    public static final int REQUIRED = 32;
    public static final int OVERWRITE = 64;
    public static final int COS = 128;
    public static final int STATUS = 256;
    static final int MAIL_SERVICE_TYPE = 512;
    static final int CAL_SERVICE_TYPE = 1024;
    static final int SEARCH = 2048;

    public DAAttribute(String theName, int theOp, String[] theValues) {
        this.initValues(theName, theValues);
        this._opType = theOp;
        this._attrType = 16;
    }

    public DAAttribute(String theName, int theOp, String theValue) {
        String[] aValues = new String[]{theValue};
        this.initValues(theName, aValues);
        this._opType = theOp;
        this._attrType = 16;
    }

    public DAAttribute(String theName, String theValue) {
        String[] aValues = new String[]{theValue};
        this.initValues(theName, aValues);
        this._opType = 1;
        this._attrType = 16;
    }

    public DAAttribute(String theName, String[] theValues) {
        this.initValues(theName, theValues);
        this._opType = 1;
        this._attrType = 16;
    }

    DAAttribute(String theName) {
        this.setName(theName);
        this._opType = 1;
        this._attrType = 16;
    }

    public String[] getValues() {
        int aSize = this._values.size();
        String[] aStrings = null;
        Object aErrorMessage = null;
        if (aSize < 1) {
            return null;
        }
        aStrings = new String[1];
        aStrings = this._values.toArray(aStrings);
        return aStrings;
    }

    public String getFirstValue() {
        String[] aValues = this.getValues();
        if (aValues != null) {
            return aValues[0];
        }
        return null;
    }

    public String getName() {
        return this._name;
    }

    public int getOperation() {
        return this._opType;
    }

    public int getType() {
        return this._attrType;
    }

    public boolean isType(int theAttributeType) {
        int aResult = 0;
        aResult = theAttributeType & this._attrType;
        return aResult != 0;
    }

    public void setName(String theName) {
        this._name = theName;
    }

    public void setOperation(int theOp) {
        this._opType = theOp;
    }

    public void addValue(String theValue) {
        if (theValue == null) {
            return;
        }
        DAUtil.addAStringToVector(this._values, theValue, 1003, 1001);
    }

    public void setValues(String[] theValues) {
        this._values.removeAllElements();
        this.addValues(theValues);
    }

    public void addValues(String[] theValues) {
        DAUtil.addStringsToVector(this._values, theValues, 1003, 1001);
    }

    public void removeValue(String theValue) {
        if (theValue == null) {
            return;
        }
        DAUtil.removeAStringFromVector(this._values, theValue, 1001);
    }

    public void removeValues(String[] theValues) {
        if (theValues == null) {
            return;
        }
        DAUtil.removeStringsFromVector(this._values, theValues, 1001);
    }

    public void clearValues() {
        this._values.removeAllElements();
    }

    boolean equals(DAObject theTargetAttribute) {
        boolean aBoolean = false;
        aBoolean = this._name.equalsIgnoreCase(theTargetAttribute.getName());
        return aBoolean;
    }

    public boolean equals(Object theObject) {
        boolean aBoolean = false;
        DAAttribute aAttribute = (DAAttribute)theObject;
        aBoolean = this._name.equalsIgnoreCase(aAttribute.getName());
        return aBoolean;
    }

    void setType(int theType) {
        this._attrType = theType;
    }

    boolean matchesValue(String theValue) {
        Iterator aIterator = this._values.iterator();
        DASpNameCount aService = null;
        String aValue = null;
        if (this._name.equalsIgnoreCase(DAConstants.AVAILABLE_SERVICES)) {
            while (aIterator.hasNext()) {
                aService = new DASpNameCount((String)aIterator.next());
                if (!aService.matches(theValue)) continue;
                return true;
            }
        } else {
            aIterator = this._values.iterator();
            while (aIterator.hasNext()) {
                aValue = (String)aIterator.next();
                if (!aValue.matches(theValue)) continue;
                return true;
            }
        }
        return false;
    }

    private void initValues(String theName, String[] theValues) {
        DAUtil.addStringsToVector(this._values, theValues, 1003, 1001);
        this._name = theName;
    }

    void print() {
        for (int i = 0; i < this._values.size(); ++i) {
            System.out.println(this._name + ": " + (String)this._values.elementAt(i));
        }
    }
}

