/*
 * Decompiled with CFR 0.152.
 */
package netscape.ldap.util;

import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.ldap.util.RDN;

public final class DN
implements Serializable {
    private Vector m_rdns = new Vector();
    public static int RFC = 0;
    public static int OSF = 1;
    private int m_dnType = RFC;
    static final long serialVersionUID = -8867457218975952548L;
    public static final char[] ESCAPED_CHAR = new char[]{',', '+', '\"', '\\', '<', '>', ';'};

    public DN() {
    }

    public DN(String string) {
        String string2 = this.neutralizeEscapes(string);
        if (string2 == null) {
            return;
        }
        if (string2.indexOf(44) != -1 || string2.indexOf(59) != -1) {
            this.parseRDNs(string2, string, ",;");
        } else if (string.indexOf(47) != -1) {
            this.m_dnType = OSF;
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            Vector<RDN> vector = new Vector<RDN>();
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (RDN.isRDN(string3)) {
                    vector.addElement(new RDN(string3));
                    continue;
                }
                return;
            }
            int n = vector.size() - 1;
            while (n >= 0) {
                this.m_rdns.addElement(vector.elementAt(n));
                --n;
            }
        } else if (RDN.isRDN(string)) {
            this.m_rdns.addElement(new RDN(string));
        }
    }

    public void addRDN(RDN rDN) {
        if (this.m_dnType == RFC) {
            this.addRDNToFront(rDN);
        } else {
            this.addRDNToBack(rDN);
        }
    }

    public void addRDNToBack(RDN rDN) {
        this.m_rdns.addElement(rDN);
    }

    public void addRDNToFront(RDN rDN) {
        this.m_rdns.insertElementAt(rDN, 0);
    }

    public boolean contains(DN dN) {
        return this.isDescendantOf(dN);
    }

    public int countRDNs() {
        return this.m_rdns.size();
    }

    public boolean equals(DN dN) {
        return dN.toRFCString().toUpperCase().equals(this.toRFCString().toUpperCase());
    }

    public String[] explodeDN(boolean bl) {
        if (this.m_rdns.size() == 0) {
            return null;
        }
        String[] stringArray = new String[this.m_rdns.size()];
        int n = 0;
        while (n < this.m_rdns.size()) {
            stringArray[n] = bl ? ((RDN)this.m_rdns.elementAt(n)).getValue() : ((RDN)this.m_rdns.elementAt(n)).toString();
            ++n;
        }
        return stringArray;
    }

    public int getDNType() {
        return this.m_dnType;
    }

    public DN getParent() {
        DN dN = new DN();
        int n = this.m_rdns.size() - 1;
        while (n > 0) {
            dN.addRDN((RDN)this.m_rdns.elementAt(n));
            --n;
        }
        return dN;
    }

    public Vector getRDNs() {
        return this.m_rdns;
    }

    public static boolean isDN(String string) {
        if (string.equals("")) {
            return true;
        }
        DN dN = new DN(string);
        return dN.countRDNs() > 0;
    }

    /*
     * Unable to fully structure code
     */
    public boolean isDescendantOf(DN var1_1) {
        var2_2 = var1_1.m_rdns;
        var3_3 = this.m_rdns;
        var4_4 = var2_2.size() - 1;
        var5_5 = var3_3.size() - 1;
        if (var5_5 >= var4_4 && !this.equals(var1_1)) ** GOTO lbl13
        return false;
lbl-1000:
        // 1 sources

        {
            var6_6 = (RDN)var2_2.elementAt(var4_4);
            var7_7 = (RDN)var3_3.elementAt(var5_5);
            if (!var7_7.equals(var6_6)) {
                return false;
            }
            --var4_4;
            --var5_5;
lbl13:
            // 2 sources

            ** while (var4_4 >= 0 && var5_5 >= 0)
        }
lbl14:
        // 1 sources

        return true;
    }

    public boolean isRFC() {
        return this.m_dnType == RFC;
    }

    private String neutralizeEscapes(String string) {
        String string2 = RDN.neutralizeEscapes(string);
        if (string2 == null) {
            return null;
        }
        String string3 = string2.trim();
        if (string3.length() == 0) {
            return string2;
        }
        if (string3.charAt(0) == ';' || string3.charAt(0) == ',') {
            return null;
        }
        int n = string3.length() - 1;
        if (string3.charAt(n) == ';' || string3.charAt(n) == ',') {
            return null;
        }
        return string2;
    }

    private void parseRDNs(String string, String string2, String string3) {
        int n = 0;
        int n2 = 0;
        RDN rDN = null;
        StringTokenizer stringTokenizer = new StringTokenizer(string, string3);
        while (stringTokenizer.hasMoreElements()) {
            String string4 = stringTokenizer.nextToken();
            n2 = n + string4.length();
            rDN = new RDN(string2.substring(n, n2));
            if (rDN.getTypes() == null) {
                this.m_rdns.removeAllElements();
                return;
            }
            this.m_rdns.addElement(rDN);
            n = n2 + 1;
        }
    }

    public void setDNType(int n) {
        this.m_dnType = n;
    }

    public String toOSFString() {
        String string = "";
        int n = 0;
        while (n < this.m_rdns.size()) {
            if (n != 0) {
                string = "/" + string;
            }
            RDN rDN = (RDN)this.m_rdns.elementAt(n);
            string = String.valueOf(rDN.toString()) + string;
            ++n;
        }
        return string;
    }

    public String toRFCString() {
        String string = "";
        int n = 0;
        while (n < this.m_rdns.size()) {
            if (n != 0) {
                string = String.valueOf(string) + ",";
            }
            string = String.valueOf(string) + ((RDN)this.m_rdns.elementAt(n)).toString();
            ++n;
        }
        return string;
    }

    public String toString() {
        if (this.m_dnType == RFC) {
            return this.toRFCString();
        }
        return this.toOSFString();
    }
}

