#!/bin/ksh

#############################################################################
##
## iMS monitoring and alarm script
##
## This script is part an example framework of what can be done.
## There are MANY ways that you can take this from here.
##
## File: date_util.sh
## 	 script to do various date manipulations
##
#############################################################################
##
#

if [ -z "$offset" ]; then
    offset=7
fi

###################################################################################
# We need the date in several formats
#
#           DD-Mon-YYYY, YYYY/MM/DDMM, and Dayname Mon Year"
#
# The reason we need these different date formats is because dates are recorded in 
# different formats in the mail.log_current and other logfiles. 
#
# Find out if we should process a log file from today or one from yesterday. With
# information, manipulate the current date to get either yesterdays date format or 
# todays date formats. Currently no account is taken for leap years. That is left as
# a future improvement or as an exercise to the reader. 
#
###################################################################################

case $1 in 
"normalize" )
	date "+%H %M" | awk '{
              tens_Units = $2/10
              split(tens_Units, digits, ".")
              hh = $1
              if (hh < 10) {
                        if (digits[2] < 5 ) {
                            printf("%s:%1d0\n", $1, ($2/10))
                        } else {
                            printf("%s:%1d5\n", $1, ($2/10))
                        }
              } else {
                        if (digits[2] < 5 ) {
                            printf("%2d:%1d0\n", $1, ($2/10))
                        } else {
                            printf("%2d:%1d5\n", $1, ($2/10))
                        }
              }
        }'
	;;
*)
if [ ! -z $TODAY ]; then
    string=`date +'%e-%b-%Y:%Y\/%m\/%m%d%Y:%a %b %m %Y %Z'`
else
    string=`date +'%d %b %Y %m %Z %e %a'| gawk '{
        if ($1 == "01") {
            if ($2 == "Jan")
                printf("31-Dec-%s:%s\/12\/1231%s:%s Dec 31 %s %s",($3-1),($3-1),($3-1),$7,($3-1),$5)
            else if ($2 == "Feb")
                printf("31-Jan-%s:%s\/01\/0131%s:%s Jan 31 %s %s",$3,$3,$3,$7,$3,$5)
            else if ($2 == "Mar")
                printf("28-Feb-%s:%s\/02\/0228%s:%s Feb 28 %s %s",$3,$3,$3,$7,$3,$5)
            else if ($2 == "Apr")
                printf("31-Mar-%s:%s\/03\/0331%s:%s Mar 31 %s %s",$3,$3,$3,$7,$3,$5)
            else if ($2 == "May")
                printf("30-Apr-%s:%s\/04\/0430%s:%s Apr 30 %s %s",$3,$3,$3,$7,$3,$5)
            else if ($2 == "Jun")
                printf("31-May-%s:%s\/05\/0531%s:%s May 31 %s %s",$3,$3,$3,$7,$3,$5)
            else if ($2 == "Jul")
                printf("30-Jun-%s:%s\/06\/0630%s:%s Jun 30 %s %s",$3,$3,$3,$7,$3,$5)
            else if ($2 == "Aug")
                printf("31-Jul-%s:%s\/07\/0731%s:%s Jul 31 %s %s",$3,$3,$3,$7,$3,$5)
            else if ($2 == "Sep")
                printf("31-Aug-%s:%s\/08\/0831%s:%s Aug 31 %s %s",$3,$3,$3,$7,$3,$5)
            else if ($2 == "Oct")
                printf("30-Sep-%s:%s\/09\/0930%s:%s Sep 30 %s %s",$3,$3,$3,$7,$3,$5)
            else if ($2 == "Nov")
                printf("31-Oct-%s:%s\/10\/1031%s:%s Oct 31 %s %s",$3,$3,$3,$7,$3,$5)
            else if ($2 == "Dec")
                printf("30-Nov-%s:%s\/11\/1130%s:%s Nov 30 %s %s",$3,$3,$3,$7,$3,$5)
        } else {
            if (($1 - 1) < 10 )
                printf("0%s-%s-%s:%s\\\/%s\\\/%s0%s%s:%s %s %s %s",($1-1),$2,$3,$3,$4,$4,($1-1),$3,$7,$2,($6-1),$3)
            else
                printf("%s-%s-%s:%s\\\/%s\\\/%s%s%s:%s %s %s %s",($1-1),$2,$3,$3,$4,$4,($1-1),$3,$7,$2,($6-1),$3) }
        }'`
fi

OLDIFS="$IFS"
IFS=":"
set -A datestring $string
IFS="$OLDIFS"

##
## convert the date to seconds since epoch. 
##

epochsecs=`gawk -v datestring="${datestring[2]}" ' BEGIN {
    # Initialize table of month lengths
    for (i=1; i<=12; i++) {
      if (i==2) {
        _tm_months[0,i]=28; _tm_months[1,i]=29;
      } else if ((i==4)||(i==6)||(i==9)||(i==11))
        _tm_months[0,i] = _tm_months[1,i] = 30;
      else
        _tm_months[0,i] = _tm_months[1,i] = 31;
    } 
    monthnum["Jan"]=1; monthnum["Feb"]=2; monthnum["Mar"]=3;
    monthnum["Apr"]=4; monthnum["May"]=5; monthnum["Jun"]=6;
    monthnum["Jul"]=7; monthnum["Aug"]=8; monthnum["Sep"]=9;
    monthnum["Oct"]=10; monthnum["Nov"]=11; monthnum["Dec"]=12;
}
# decide if a year is a leap year
function _tm_isleap(year) {
    return (year % 4 == 0 && year % 100 != 0) || (year % 400 == 0)
}
# convert a date into seconds
function _tm_addup(total, yearsecs, daysecs, hoursecs, i, j)
{
    hoursecs = 60 * 60; daysecs = 24 * hoursecs; yearsecs = 365 * daysecs; 
    total = (year - 1970) * yearsecs

    # extra day for leap years
    for (i = 1970; i < year; i++)
        if (_tm_isleap(i))
            total += daysecs

    j = _tm_isleap(year)
    for (i = 1; i < month; i++)
        total += _tm_months[j, i] * daysecs
  
    total += (day - 1) * daysecs
    return total
}
BEGIN {
  split(datestring, q, " ")
  monthabr = q[2]; day=q[3]; year=q[4];
  month = monthnum[monthabr];
  epochtime = _tm_addup(day, month, year);
  printf("%s", epochtime)

}'`

(( epochsecs = $epochsecs + $offset * 3600 ))

echo "$string:$epochsecs"

;;
esac  #end case

## end of script
