[
{
    blockid="main";
    help=ug_mailuser_main;
    layout=[border];
    localvar={
	.displayname.text="Mail";
        .tab1.title="Settings";
	.tab2.title="Delivery";
	.tab3.title="Forwarding";
	.tab4.title="Auto-Reply";
	.tab5.title="Authorised Services";

	.property.text="Properties...";

	.host.text="Messaging server host name: ";
	.mail.text="Primary email address:";
	.enable.text="Enable POP/IMAP delivery";
	.programdelivery.text="Program delivery";
	.unixdelivery.text="UNIX delivery";
	.unixdelivery.help="If this user is hosted by the UNIX version of the messaging server, you may select the \"UNIX delivery\" option to store messages in the user's UNIX mail file.";

	.forward.text="Please specify email address(es) you would like to have the user's email messages forwarded to";

        /* .autoreplymode.labels=[Off, Echo, Vacation, Autoreply]; */
        .autoreplymode.labels=[Off, Echo, Vacation];
        
	.autoreplytext.help="Reply text:";
	.response.ext="Response to external senders";
	.response.int="Response to internal senders";
	.autoreplysubject="Auto Reply subject line";
	.autoreplytimeouttext="Auto reply timeout";
	.autoreplytimeout.units=["Hour(s)","Day(s)"];
	.startend.text="Vacation start/end date";
	.start.text="Start:";
	.end.text="End:";
	.alternateaddress.header="Alternate Addresses";
	.alternateaddress.error="Addresses already exist. Please specify a different address.";
	.forwardaddress.header="Forwarding address";

	.delivery.error="You must sepecify a delivery option or forwarding.";

	.enable.border=[titled,"Enable the following service(s) for the user"];
	.enableimap="IMAP";
	.enablepop="POP";
	.enablehttp="HTTP";
	/* Changes for IMS 5.0 */
	.enablesmtp="SMTP";
	.enableum="Unified Messaging";
	/* Changes for IMS 5.0 */

	.allow.imap=true;
	.allow.pop=true;
	.allow.http=true;
	/* Changes for IMS 5.0 */
	.allow.smtp=true;
	.allow.um=true;
	/* Changes for IMS 5.0 */

	vacationstartdate="-";
	vacationenddate="-";
	
	.col1.header = "Service";
	.col2.header = "Applies to";
	.services.add="Add rule for authorised services ";
	.services.edit="Modify rule for authorised services ";
    };
    content=[
        {
            ctrl=tabbedpane;
            id=mailusertabs;
            content= [
                {
                    ctrl=pane;
                    help=ug_mailuser_settings;
                    title=$.tab1.title;
		    layout=[ybox];
                    content=[
			{
			    ctrl=pane;
			    content=[
				{
				    ctrl=label;
				    text=$.host.text;
				    wrap=$g.label.size1;
				    aligny=0.5;
				},
				{
				    ctrl=rigid;
				},
				{
				    ctrl=text;
				    val=$mailhost;
				    aligny=0.5;
				    validate=com.netscape.management.msgserv.util.ValidFQDN;
				    errhint=$.host.text;
				}
			    ]
			},
			{
			    ctrl=vstrut;
			},
			{
			    ctrl=pane;
			    content=[
				{
				    ctrl=label;
				    text=$.mail.text;
				    wrap=$g.label.size1;
				    aligny=0.5;
				},
				{
				    ctrl=rigid;
				},
				{
				    ctrl=text;
				    id=mailaddress;
				    val=$mail;
				    validate=com.netscape.management.msgserv.util.ValidEMailAddress;
				    errhint=$.mail.text;
				    aligny=0.5;
				    focus=true;
				}
			    ]
			},
			{
			    ctrl=vstrut;
			},
			{
			    ctrl=table;
			    addui=altaddress;
			    addtext=$g.addbutton.text;
			    edittext=$g.editbutton.text;
			    deltext=$g.deletebutton.text;
			    addtitle=$.alternateaddress.header;
			    showedit=true;
			    editui=altaddress;
			    edittitle=$.alternateaddress.header;
			    stdtable=true;
			    val=$mailalternateaddress;
			    delimiter=" ";
			    visiblerows=5;
			    columns=[
				{
				    header=$.alternateaddress.header;
				    unique=$.alternateaddress.error;
				    varname=altaddr;
				}
			    ];
			},			
			{
			    ctrl=vstrut;
			}						
                    ]
                },
                {
                    ctrl=pane;
                    help=ug_mailuser_delivery;
                    title=$.tab2.title;
		    layout=[ybox];
                    content=[
			{
			    ctrl=togglepane;
			    text=$.enable.text;
			    val=$maildeliveryoption.mailbox;
			    showmodified=false;
			    content=[
			        {
			            ctrl=hglue;
			        },
			        {
			            ctrl=button;
			            text=$.property.text;
			            dialog=maildeliver;
			            dialogtitle=$.enable.text;
			            alignx=1.0;
			        }
			    ]
			},
			{
			    ctrl=togglepane;
			    text=$.programdelivery.text;
			    val=$maildeliveryoption.program;
			    showmodified=false;
			    content=[
			        {
			            ctrl=hglue;
			        },
			        {
			            ctrl=button;
			            text=$.property.text;
			            dialog=programdeliver;
			            dialogtitle=$.programdelivery.text;
			            alignx=1.0;
			        }
			    ]
			},
			{
			    ctrl=vstrut;
			},
			{
			    ctrl=togglepane;
			    showmodified=false;
			    text=$.unixdelivery.text;
			    val=$maildeliveryoption.unix;
			    content=[
			        {
			            ctrl=label;
			            text=$.unixdelivery.help;
			            wrap=$g.label.size4;
			            candisable=false;
			        }
			    ]
			}
                    ]
                },
                {
                    ctrl=pane;
                    help=ug_mailuser_forwarding;
                    title=$.tab3.title;
		    layout=[ybox];
		    content=[
			{
			    ctrl=pane;
			    layout=[ybox];
			    content=[
				{
				    ctrl=label;
				    text=$.forward.text;
				    wrap=$g.label.size4;
				},
				{
				    ctrl=vstrut;
				},
				{
				    ctrl=table;
				    stdtable=true;
				    showedit=true;
				    addui=forward;
				    addtext=$g.addbutton.text;
			      edittext=$g.editbutton.text;
			      deltext=$g.deletebutton.text;
				    editui=forward;
				    val=$mailforwardingaddress;
				    delimiter=" ";
				    visiblerows=5;
				    columns=[
				    	{
					    header=$.forwardaddress.header;
					    varname=forwardaddr;
					}
				    ];
				}
			    ]
			}
		    ]
		},
                {
                    ctrl=pane;
                    help=ug_mailuser_reply;
                    title=$.tab4.title;
                    layout=[gridbag];
                    content=[
                        {
                            ctrl=label;
                            text="Auto-Reply Mode";
                            constraint={
                                gridx=0;
                                gridy=0;
                                gridwidth=2;
                                weightx=1;
                                fill=h;
                                insets=$g.insets.comp;
                            }
                        },
			{
			    ctrl=choice;
			    id=autoreplymodectrl;
			    style=radio;
			    /* items=["",echo,vacation,reply]; */
			    items=["",echo,reply];
			    labels=$.autoreplymode.labels;
			    text=Off;
			    group=autoreplygroup;
			    val=$mailautoreplymode;
                            constraint={
                                gridx=0;
                                gridy=1;
                                gridheight=2;
                                gridwidth=2;
                                anchor=west;
                                insets=$g.insets.comp;
                            }
			},
			{
			    ctrl=togglepane;
			    id=startendctrl;
			    val=$hasstartend;
			    text=$.startend.text;
			    showmodified=false;
                            constraint={
                                gridx=2;
                                gridy=1;
                                gridheight=2;
                                gridwidth=4;
                                anchor=north;
                                insets=$g.insets.comp;
                            }
			    layout=[gridbag];
			    content=[
				{
				    ctrl=label;
				    text=$.start.text;
				    constraint={
					gridx=0;
					gridy=0;
					insets=[3,3,3,3];
					anchor=west;
				    }
				},
				{
				    ctrl=com.netscape.management.msgserv.util.DATETIMEeditor;
				    help=ug_mailuser_main_vacationstartdate;
				    id=startctrl;
				    val=$vacationstartdate;
				    constraint={
					gridx=1;
					gridy=0;
					insets=[3,3,3,3];
					anchor=west;
				    }
				},
				{
				    ctrl=label;
				    text=$.end.text;
				    constraint={
					gridx=0;
					gridy=1;
					insets=[3,3,3,3];
					anchor=west;
				    }
				},
				{
				    ctrl=com.netscape.management.msgserv.util.DATETIMEeditor;
				    help=ug_mailuser_main_vacationenddate;
				    id=endctrl;
				    val=$vacationenddate;
				    constraint={
					gridx=1;
					gridy=1;
					insets=[3,3,3,3];
					anchor=west;
				    }
				}
			    ]
			},
			{
				ctrl=label;
				id=mailautoreplytimeoutlabel;
				text=$.autoreplytimeouttext;
				constraint={
                                gridx=2;
                                gridy=4;
                                gridwidth=2;
                                weightx=1;
                                fill=h;
                                insets=$g.insets.comp;
                            }
			},
			{
				ctrl=number;
				id=mailautoreplytimeoutctrl;
				val=$mailautoreplytimeout;
				label=mailautoreplytimeoutlabel;
				unit=hr;
				items=[hr,day];
				labels=$.autoreplytimeout.units;
				constraint={
                                gridx=4;
                                gridy=4;
                                gridwidth=2;
                                weightx=1;
                                fill=h;
                                insets=$g.insets.comp;
                            }				
			},
			{
			    ctrl=separator;
			    constraint={
                                gridx=0;
                                gridy=5;
                                weightx=1;
                                gridwidth=6;
                                gridheight=1;
                                fill=h;
                                insets=$g.insets.comp;
                            }
			},
			{
			    ctrl=label;
			    id=autoreplysubjectlabel;
                            text=$.autoreplysubject;
                            constraint={
                                gridx=0;
                                gridy=6;
                                gridwidth=2;                                
                                gridheight=1;
                                weightx=1;
                                fill=h;
                                insets=$g.insets.comp;
                            }
			},
			{
				ctrl=text;
				id=autoreplysubjectctrl;
				label=autoreplysubjectlabel;
				val=$mailautoreplysubject;
				constraint={
                                gridx=2;
                                gridy=6;
                                gridwidth=4;                                
                                gridheight=1;
                                weightx=1;
                                fill=h;
                                insets=$g.insets.comp;
                            }
			},
			{
			    ctrl=separator;
			    constraint={
                                gridx=0;
                                gridy=7;
                                weightx=1;                                
                                gridwidth=6;
                                gridheight=1;
                                fill=h;
                                insets=$g.insets.comp;
                            }
			},
			{
			    ctrl=label;
                            text=$.response.int;
                            constraint={
                                gridx=0;
                                gridy=8;
                                weightx=1;
                                gridwidth=6;
                                gridheight=1;
                                fill=h;
                                insets=$g.insets.comp;
                            }
			},			
			{
			    ctrl=switchboard;
			    id=autoreplyinttextctrl;
			    switchborder=false;
                            constraint={
                                gridx=0;
                                gridy=9;
                                gridwidth=6;
                                weightx=1;
                                weighty=1;
                                fill=h;
                                anchor=northwest;
                                insets=$g.insets.comp;
                            }
			    switch=[
				{
				    ctrl=choice;
				    id=replyintlang;
				    items=$g.usrlang.items;
				    labels=$g.usrlang.labels;
				    sendmodified=false;
				}
			    ];
			    content=[
				{
				    ctrl=textarea;
				    id=replyinttext;
				    label=autoreplyinttexthelpctrl;
				}
			    ];
			},
			{
				ctrl=vstrut;
				constraint={
                                gridx=0;
                                gridy=10;
                                gridwidth=6;
                                gridheight=1;
                                weightx=1;
                                fill=h;
                                insets=$g.insets.comp;
                            }
				
			},
			{
			    ctrl=label;
                            text=$.response.ext;
                            constraint={
                                gridx=0;
                                gridy=11;
                                gridwidth=6;
                                gridheight=1;
                                weightx=1;
                                fill=h;
                                insets=$g.insets.comp;
                            }
			},			
			{
			    ctrl=switchboard;
			    id=autoreplytextctrl;
			    switchborder=false;
                            constraint={
                                gridx=0;
                                gridy=12;
                                gridwidth=6;
                                weightx=1;
                                weighty=1;
                                fill=h;
                                anchor=northwest;
                                insets=$g.insets.comp;
                            }
			    switch=[
				{
				    ctrl=choice;
				    id=replylang;
				    items=$g.usrlang.items;
				    labels=$g.usrlang.labels;
				    sendmodified=false;
				}
			    ];
			    content=[
				{
				    ctrl=textarea;
				    id=replytext;
				    label=autoreplytexthelpctrl;
				}
			    ];
			}
                    ]
                },
                {
                     ctrl=pane;
                     title=$.tab5.title;
                     /* HELP NEEDS TO BE ADDED */
	             help=ug_mailuser_auth;		
                     layout=[border];
                     content=[
                     	{
                     		ctrl=table;
                     		id=servicestable;
                     		stdtable=true;
                     		showedit=true;
                     		constraint=center;
                     		addtitle=$.services.add;
                     		edittitle=$.services.edit;
        	     		addui=authorisedservices;
		 	            addtext=$g.addbutton.text;
			            edittext=$g.editbutton.text;
			            deltext=$g.deletebutton.text;
	    			editui=authorisedservices;  
	    			delimiter="$";
        	     		visiblerows=13; 		
        	     		buttonsat=south;
        	     		val=$mailallowedserviceaccess;
        	     		columns =
        			[
        		    		{
                 				header = $.col1.header;
                 				width=225;
                 				varname=allowedservices;
               	 	    		},
                	    		{
                 				header = $.col2.header;
                 				width=225;
                 				varname=clientinfo;
                	    		}
        			];
        		}
        	     ]
                }
            ]
        }
    ]
},                
{
    blockid=altaddress;
    help=ug_mailuser_altaddress;
    localvar={
        /* translate this block */
        .label.text="Alternate email address for this user:";
	.label.hint="Alternate email address";
    };
    content=[
	{
	    ctrl=label;
	    wrap=$g.label.size3;
	    text=$.label.text;
	},
	{
	    ctrl=text;
	    val=$altaddr;
	    validate=com.netscape.management.msgserv.util.ValidAltAddress;
	    errhint=$.label.hint;
	    focus=true;
	}
    ]
},
{
    blockid=accessdomain;
    help=ug_mailuser_accessdomain;
    localvar={
        .label.text="Access domain name:";
    };
    content=[
	{
	    ctrl=label;
	    wrap=$g.label.size3;
	    text=$.label.text;
	},
	{
	    ctrl=text;
	    val=$accdomain;
	    focus=true;
	}
    ]
},
{
    blockid=forward;
    help=ug_mailuser_forward;
    localvar={
        /* translate this block */
        .label.text="Forwarding address:";
    };
    content=[
	{
	    ctrl=label;
	    wrap=$g.label.size3;
	    text=$.label.text;
	},
	{
	    ctrl=text;
	    val=$forwardaddr;
	    focus=true;
	    validate=com.netscape.management.msgserv.util.ValidEMailAddress;
	    errhint=$.label.text;
	}
    ]
},
{
    blockid=maildeliver;
    help=ug_mailuser_deliver;
    localvar={
	.storepath.text="Message store name:";
	.quota.text="Mail storage limit:";
	.msgquota.text="No. of Message limit:";
	.quota.nolimit="Unlimited";
	.quota.default="Use default";
	.msgquota.nolimit="Unlimited";
	.msgquota.default="Use default";
	.quota.limit="Limit to";
	.msgquota.limit="Limit to";
	.quota.units=["KByte(s)", "MByte(s)"];
	.accessdomain.help="List of domains accessible to user for mail:";
	.accessdomain.header="Access domains";
    };
    content=[
	{
	    ctrl=pane;
	    content=[
		{
		    ctrl=label;
		    text=$.storepath.text;
		    wrap=$g.label.size1;
		},
		{
		    ctrl=rigid;
		},
		{
		    ctrl=text;
		    val=$mailmessagestore;
		    focus=true;
		}
	    ]
	},
	{
	    ctrl=vstrut;
	},
	{
	    ctrl=pane;
	    content=[
		{
		    ctrl=label;
		    text=$.quota.text;
		    wrap=$g.label.size1;
		},
		{
		    ctrl=rigid;
		},
		{
		    ctrl=pane;
		    layout=[ybox];
		    content=[
			{
			    ctrl=togglepane;
			    text=$.quota.default;
			    group=g1;
			    val=$mailquota.no;
			    style=radio;
			    showmodified=false;
			},
			{
			    ctrl=togglepane;
			    text=$.quota.nolimit;
			    group=g1;
			    val=$mailquota.unlimited;
			    style=radio;
			    showmodified=false;	
			},
			{
			    ctrl=togglepane;
			    group=g1;
			    text=$.quota.limit;
			    inline=true;
			    val=$mailquota.yes;
			    style=radio;
			    showmodified=false;
			    content=[
				{
				    ctrl=number;
				    val=$mailquota;
				    unit=byte;
				    items=[kb,mb];
				    labels=$.quota.units;
				},
				{
				    ctrl=hglue;
				}
			    ]
			}
		    ]
		}
	    ]
	},
	{
	    ctrl=pane;
	    content=[
		{
		    ctrl=label;
		    text=$.msgquota.text;
		    wrap=$g.label.size1;
		},
		{
		    ctrl=rigid;
		},
		{
		    ctrl=pane;
		    layout=[ybox];
		    content=[
			{
			    ctrl=togglepane;
			    text=$.msgquota.default;
			    group=g2;
			    val=$mailmsgquota.no;
			    style=radio;
			    showmodified=false;
			},
			{
			    ctrl=togglepane;
			    text=$.msgquota.nolimit;
			    group=g2;
			    val=$mailmsgquota.unlimited;
			    style=radio;
			    showmodified=false;	
			},
			{
			    ctrl=togglepane;
			    group=g2;
			    text=$.msgquota.limit;
			    inline=true;
			    val=$mailmsgquota.yes;
			    style=radio;
			    showmodified=false;
			    content=[
				{
				    ctrl=number;
				    val=$mailmsgquota;
				    min=-1;
				},
				{
				    ctrl=hglue;
				}
			    ]
			}
		    ]
		}
	    ]
	},
	{
	    ctrl=vstrut;
	}
	/**
	,
	{
	    ctrl=label;
	    text=$.accessdomain.help;
	    wrap=$g.label.size4;
	},
	{
	    ctrl=vstrut;
	},
	{
	    ctrl=table;
	    stdtable=true;
	    addui=accessdomain;
	    addtext=$g.addbutton.text;
			edittext=$g.editbutton.text;
			deltext=$g.deletebutton.text;
	    editui=accessdomain;
	    val=$mailaccessdomain;
	    delimiter=" ";
	    visiblerows=5;
	    buttonsat=east;
	    columns=[
		{
		    header=$.accessdomain.header;
		    varname=accdomain;
		}
	    ];
	}	
	**/
    ]
},
{
    blockid=programdeliver;
    help=ug_mailuser_program;
    localvar={
	.programdelivery.help="Specify one or more commands, with arguments, to use in program delivery.";
    };
    content=[
	{
	    ctrl=label;
	    text=$.programdelivery.help;
	    wrap=$g.label.size4;
	},
	{
	    ctrl=textarea;
	    val=$mailprogramdeliveryinfo;
	    focus=true;
	},
	{
	    ctrl=vstrut;
	}
    ]
},
{
	blockid=authorisedservices;
	/** NEED To ADD HELP **/
	help=ug_mailuser_auth_popup;
	custom="com.netscape.management.msgserv.AuthorisedServicesControl";
	localvar={
		.services="Service";
		.services.list=["IMAP","POP","SMTP","HTTP","All"];
		.services.allow="Allow";
		.services.deny="Deny";
		.client="Applies to";
	};
	content=[
	{
		ctrl=pane;
		layout=[gridbag];
                content=[
                	{
                    		ctrl=label;
                    		text=$.services;
                    		wrap=$g.label.size0;
                    		constraint={
                                	gridx=0;
                                	gridy=0;
                                	gridwidth=3;
                                	gridheight=1;
                                	weightx=1;
                                	weighty=1;
                                	anchor=west;
                                	insets=$g.insets.comp;
                            	}
                	},
                	{
                    		ctrl=label;
                    		text=$.services.allow; 
                    		wrap=$g.label.size0;
                    		constraint={
                                	gridx=3;
                                	gridy=0;
                                	gridwidth=2;
                                	gridheight=1;
                                	weightx=1;
                                	weighty=1;
                                	anchor=west;
                                	insets=$g.insets.comp;
                            	}
                	},
                	{
                    		ctrl=label;
                    		text=$.services.deny;
                    		wrap=$g.label.size0;
                    		constraint={
                                	gridx=5;
                                	gridy=0;
                                	gridwidth=2;
                                	gridheight=1;
                                	weightx=1;
                                	weighty=1;
                                	anchor=west;
                                	insets=$g.insets.comp;
                            	}
                	},                	
                	{
                    		ctrl=label;
                    		text=$.client;
                    		wrap=$g.label.size1;
                    		constraint={
                                	gridx=7;
                                	gridy=0;
                                	gridwidth=8;
                                	gridheight=1;
                                	weightx=1;
                                	weighty=1;
                                	anchor=west;
                                	fill=h;
                                	insets=$g.insets.comp;
                            	}
                	},                	
			{
			    ctrl=separator;
			    constraint={
                                gridx=0;
                                gridy=1;
                                weightx=1;
                                gridwidth=15;
                                gridheight=1;
                                fill=h;
                                insets=$g.insets.comp;
                            }
			},
                	{
                    		ctrl=choice;
                    		id=servicelist;
                    		items=$.services.list;
                    		sendmodified=true;
                    		val=$service.value;
                    		constraint={
                                	gridx=0;
                                	gridy=2;
                                	gridwidth=3;
                                	gridheight=2;
                                	weightx=1;
                                	weighty=1;
                                	anchor=west;
                                	insets=$g.insets.comp;
                            	}
                	},
                	{
                		ctrl=togglepane;
                		id=allow;
                		style=radio;
                		group=servicegroup;                		
                    		sendmodified=true;
                		constraint={
                                	gridx=3;
                                	gridy=2;
                                	gridwidth=2;
                                	gridheight=1;
                                	weightx=1;
                                 	weighty=1;
                                	anchor=west;
                                	insets=$g.insets.comp;
                            	}
                	},
                	{
                		ctrl=togglepane;
                		id=deny;
                		style=radio;
                		group=servicegroup;                		
                    		sendmodified=true;
                		constraint={
                                	gridx=5;
                                	gridy=2;
                                	gridwidth=2;
                                	gridheight=1;
                                	weightx=1;
                                	weighty=1;
                                	anchor=west;
                                	insets=$g.insets.comp;
                            	}
                	}, 
                	{
                		ctrl=text;
                		id=clienttext;
                		val=$clientinfo;                		
                    		sendmodified=true;
	    			focus=true;
                		constraint={
                                	gridx=7;
                                	gridy=2;
                                	gridwidth=8;
                                	gridheight=1;
                                	weightx=1;
                                	weighty=1;
                                	anchor=west;
                                	fill=h;
                                	insets=$g.insets.comp;
                            	}
                	}                	                 	
                ]
		}	
	]	
}
]
