/*
 *  hello_world.c
 *
 *    Send a "Hello world!" message.
 *
 *  Copyright (c) 2003, Sun Microsystems, Inc.  All Rights Reserved.
 */

#include <stdio.h>
#include <stdlib.h>
#include "mtasdk.h"

mta_nq_t *ctx = NULL;
static void quit(void);
#define CHECK(x) if(x) quit();

int main(int argc, const char *argv[])
{
     char buf[100];

     /* Initialize the MTA SDK */
     CHECK(mtaInit(0));

     /* Start a new message; From: postmaster */
     CHECK(mtaEnqueueStart(&ctx, mtaPostmasterAddress(NULL, NULL, 0), 0, 0));

     /* Enqueue the message to root */
     CHECK(mtaEnqueueTo(ctx, (argv[1] ? argv[1] : "root"), 0, 0));

     /* Date: header line */
     CHECK(mtaEnqueueWriteLine(ctx, "Date: ", 0,
			       mtaDateTime(buf, NULL, sizeof(buf), 0), 0,
			       NULL));

     /* Subject: header line */
     CHECK(mtaEnqueueWriteLine(ctx, "Subject: " __FILE__, 0, NULL));

     /* Blank line ending the header and starting the message body */
     CHECK(mtaEnqueueWriteLine(ctx, "", 0, NULL));

     /* Text of the message body (2 lines) */
     CHECK(mtaEnqueueWriteLine(ctx, "Hello", 0, NULL));
     CHECK(mtaEnqueueWriteLine(ctx, "   world!", 0, NULL));

     /* Enqueue the message */
     CHECK(mtaEnqueueFinish(ctx, 0));

     /* All done */
     mtaDone();
     return 0;
}

void quit(void)
{
     fprintf(stderr, "The MTA API returned the error code %d\n  %s\n",
	     mta_errno, mtaStrError(mta_errno, 0));
     if (ctx)
	  mtaEnqueueFinish(ctx, MTA_ABORT, 0);
     exit(1);
}
