/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.smime.security.capi;

import com.sun.messaging.smime.applet.AppletLogger;
import com.sun.messaging.smime.applet.util.dllHandler;
import com.sun.messaging.smime.security.capi.CardTokenCAPI;
import com.sun.messaging.smime.security.cardapi.CardAdmin;
import com.sun.messaging.smime.security.cardapi.CardException;
import com.sun.messaging.smime.security.cardapi.CardParameters;
import com.sun.messaging.smime.security.cardapi.CardReader;
import com.sun.messaging.smime.security.cardapi.CardToken;
import java.io.File;

public class CardReaderCAPI
extends CardReader {
    private final CardTokenCAPI m_token;
    private CardAdmin m_admin;
    private CardParameters m_params;
    private boolean m_bLoadedDLL = false;

    public CardReaderCAPI(CardParameters params) {
        super(params.getProviderName());
        this.m_params = params;
        AppletLogger.log((String)"Using CAPI card provider");
        this.m_token = new CardTokenCAPI(params.getProviderName());
    }

    public CardToken getToken() {
        return this.m_token;
    }

    public void shutdown() throws CardException {
    }

    public void registerCardAdmin(CardAdmin admin) throws CardException {
        this.m_admin = admin;
        if (!this.m_bLoadedDLL) {
            String sLibPath = this.m_admin.getDllPath(this.m_params.getProviderName());
            String sDll = (String)this.m_params.getParameters().get("library");
            File dllPath = null;
            if (sLibPath != null) {
                dllPath = new File(sLibPath, sDll);
            } else {
                dllPath = new File(System.getProperty("java.io.tmpdir"), sDll);
                dllHandler dll = new dllHandler();
                dll.loadLibraryFileFromCAB(dllPath);
            }
            AppletLogger.log((String)("Load Capi DLL from " + dllPath.getAbsolutePath()));
            if (dllPath.exists() && dllPath.canRead()) {
                try {
                    System.load(dllPath.getAbsolutePath());
                }
                catch (Throwable e) {
                    AppletLogger.log((String)("DLL Load failed:" + e.getMessage()));
                    throw new CardException("DLL Load failed:" + e.getMessage());
                }
                AppletLogger.log((String)"Loaded Capi DLL");
                this.m_bLoadedDLL = true;
            } else {
                AppletLogger.error((String)"Failed to load Capi DLL");
            }
        }
        if (this.m_token != null) {
            this.m_token.registerCardAdmin(admin);
        }
    }
}

