/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.smime.security.pkcs11.wrapper;

import com.sun.messaging.smime.applet.AppletLogger;
import com.sun.messaging.smime.security.pkcs11.wrapper.CK_ATTRIBUTE;
import com.sun.messaging.smime.security.pkcs11.wrapper.CK_C_INITIALIZE_ARGS;
import com.sun.messaging.smime.security.pkcs11.wrapper.CK_INFO;
import com.sun.messaging.smime.security.pkcs11.wrapper.CK_MECHANISM;
import com.sun.messaging.smime.security.pkcs11.wrapper.CK_MECHANISM_INFO;
import com.sun.messaging.smime.security.pkcs11.wrapper.CK_NOTIFY;
import com.sun.messaging.smime.security.pkcs11.wrapper.CK_SESSION_INFO;
import com.sun.messaging.smime.security.pkcs11.wrapper.CK_SLOT_INFO;
import com.sun.messaging.smime.security.pkcs11.wrapper.CK_TOKEN_INFO;
import com.sun.messaging.smime.security.pkcs11.wrapper.PKCS11Constants;
import com.sun.messaging.smime.security.pkcs11.wrapper.PKCS11Exception;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;

public class PKCS11
implements PKCS11Constants {
    private long pNativeData;
    private static final Map c = new HashMap();
    private final String d;
    private static boolean e;
    private static final String f = "pkcs11smime";

    public native void C_Logout(long var1) throws PKCS11Exception;

    public native CK_SESSION_INFO C_GetSessionInfo(long var1) throws PKCS11Exception;

    public static synchronized void releaseAllInstance() {
        if (c != null) {
            c.clear();
        }
    }

    public native void C_Finalize(Object var1) throws PKCS11Exception;

    public static synchronized PKCS11 getInstance(String pkcs11ModulePath, CK_C_INITIALIZE_ARGS pInitArgs, boolean omitInitialize) throws IOException, PKCS11Exception {
        PKCS11 pkcs11 = (PKCS11)c.get(pkcs11ModulePath);
        if (pkcs11 == null) {
            pkcs11 = pInitArgs != null && (pInitArgs.flags & 2L) != 0L ? new PKCS11(pkcs11ModulePath) : new SynchronizedPKCS11(pkcs11ModulePath);
            if (!omitInitialize) {
                pkcs11.C_Initialize(pInitArgs);
            }
            c.put(pkcs11ModulePath, pkcs11);
        }
        return pkcs11;
    }

    private native void connect(String var1) throws IOException;

    public native int C_SignRecover(long var1, byte[] var3, int var4, int var5, byte[] var6, int var7, int var8) throws PKCS11Exception;

    public native void C_SignInit(long var1, CK_MECHANISM var3, long var4) throws PKCS11Exception;

    public native void C_SignRecoverInit(long var1, CK_MECHANISM var3, long var4) throws PKCS11Exception;

    public native int C_DecryptFinal(long var1, long var3, byte[] var5, int var6, int var7) throws PKCS11Exception;

    public native long[] C_GetMechanismList(long var1) throws PKCS11Exception;

    public native void C_Login(long var1, long var3, char[] var5) throws PKCS11Exception;

    private native void disconnect();

    public native void C_SeedRandom(long var1, byte[] var3) throws PKCS11Exception;

    public native void C_DestroyObject(long var1, long var3) throws PKCS11Exception;

    public native void C_SignUpdate(long var1, long var3, byte[] var5, int var6, int var7) throws PKCS11Exception;

    private static native void finalizeLibrary();

    PKCS11(String pkcs11ModulePath) throws IOException {
        if (!this.a()) {
            this.b(this.loadLibraryFromResource());
            PKCS11.initializeLibrary();
        }
        this.connect(pkcs11ModulePath);
        this.d = pkcs11ModulePath;
    }

    public void finalize() throws Throwable {
        this.disconnect();
    }

    public native void C_CloseSession(long var1) throws PKCS11Exception;

    public native CK_SLOT_INFO C_GetSlotInfo(long var1) throws PKCS11Exception;

    private synchronized boolean a() {
        return e;
    }

    public native long[] C_GetSlotList(boolean var1) throws PKCS11Exception;

    public native void C_DecryptInit(long var1, CK_MECHANISM var3, long var4) throws PKCS11Exception;

    public native void C_FindObjectsFinal(long var1) throws PKCS11Exception;

    public native CK_INFO C_GetInfo() throws PKCS11Exception;

    public native int C_DecryptUpdate(long var1, long var3, byte[] var5, int var6, int var7, long var8, byte[] var10, int var11, int var12) throws PKCS11Exception;

    public String toString() {
        return "Module name: " + this.d;
    }

    public native void C_FindObjectsInit(long var1, CK_ATTRIBUTE[] var3) throws PKCS11Exception;

    public native byte[] C_SignFinal(long var1) throws PKCS11Exception;

    native void C_Initialize(Object var1) throws PKCS11Exception;

    public native void C_GenerateRandom(long var1, byte[] var3) throws PKCS11Exception;

    public native CK_MECHANISM_INFO C_GetMechanismInfo(long var1, long var3) throws PKCS11Exception;

    private synchronized void b(boolean libLoaded) {
        e = libLoaded;
    }

    public native long[] C_FindObjects(long var1, long var3) throws PKCS11Exception;

    private static native void initializeLibrary();

    public native byte[] C_Sign(long var1, byte[] var3) throws PKCS11Exception;

    public native long C_OpenSession(long var1, long var3, Object var5, CK_NOTIFY var6) throws PKCS11Exception;

    private boolean loadLibraryFromResource() {
        String libFileName = System.mapLibraryName(f);
        String tmpDir = System.getProperty("java.io.tmpdir");
        try {
            File dirDll = new File(tmpDir);
            dirDll.mkdirs();
            File f = new File(dirDll, libFileName);
            String absoluteLibPath = f.getAbsolutePath();
            boolean bWriteDll = true;
            if (f.exists()) {
                int num;
                MessageDigest md = MessageDigest.getInstance("SHA-1");
                FileInputStream fin = new FileInputStream(f);
                byte[] buf = new byte[1024];
                while ((num = fin.read(buf)) != -1) {
                    md.update(buf, 0, num);
                }
                fin.close();
                byte[] existingLibDigest = md.digest();
                InputStream newLibStream = this.getClass().getClassLoader().getResourceAsStream(libFileName);
                if (newLibStream != null) {
                    int num2;
                    buf = new byte[1024];
                    md.reset();
                    while ((num2 = newLibStream.read(buf)) != -1) {
                        md.update(buf, 0, num2);
                    }
                    newLibStream.close();
                    byte[] newLibDigest = md.digest();
                    if (MessageDigest.isEqual(newLibDigest, existingLibDigest)) {
                        bWriteDll = false;
                        AppletLogger.log("Existing lib same as downloaded. Use existing lib");
                    } else {
                        boolean bDelete = false;
                        try {
                            AppletLogger.log("Deleting existing lib");
                            bDelete = f.delete();
                        }
                        catch (SecurityException e) {
                            AppletLogger.log("Security error deleting existing: " + e.toString());
                        }
                        if (!bDelete) {
                            AppletLogger.log("Failed to delete existing native lib. Native lib loading aborted");
                            return false;
                        }
                    }
                } else {
                    bWriteDll = false;
                    AppletLogger.log("Cannot find lib in downloaded jar. Use existing lib");
                }
            }
            if (bWriteDll) {
                InputStream in = this.getClass().getClassLoader().getResourceAsStream(libFileName);
                if (in == null) {
                    AppletLogger.log("No Input");
                    return false;
                }
                if (in.available() == 0) {
                    AppletLogger.log("Empty Input");
                    return false;
                }
                FileOutputStream out = new FileOutputStream(f);
                byte[] b = new byte[2048];
                int count = 0;
                while (count != -1) {
                    count = in.read(b);
                    if (count <= 0) continue;
                    out.write(b, 0, count);
                }
                out.flush();
                out.close();
            }
            AppletLogger.log("CardApi: loading native lib: " + absoluteLibPath);
            System.load(absoluteLibPath);
            AppletLogger.log("CardApi: loaded native lib: " + absoluteLibPath);
            return true;
        }
        catch (Exception e) {
            AppletLogger.log(e);
            return false;
        }
    }

    public native void C_GetAttributeValue(long var1, long var3, CK_ATTRIBUTE[] var5) throws PKCS11Exception;

    public native CK_TOKEN_INFO C_GetTokenInfo(long var1) throws PKCS11Exception;

    public native int C_Decrypt(long var1, byte[] var3, int var4, int var5, byte[] var6, int var7, int var8) throws PKCS11Exception;

    static class SynchronizedPKCS11
    extends PKCS11 {
        public synchronized int C_SignRecover(long hSession, byte[] in, int inOfs, int inLen, byte[] out, int outOufs, int outLen) throws PKCS11Exception {
            return super.C_SignRecover(hSession, in, inOfs, inLen, out, outOufs, outLen);
        }

        public synchronized void C_FindObjectsFinal(long hSession) throws PKCS11Exception {
            super.C_FindObjectsFinal(hSession);
        }

        public synchronized CK_INFO C_GetInfo() throws PKCS11Exception {
            return super.C_GetInfo();
        }

        public synchronized int C_Decrypt(long hSession, byte[] in, int inOfs, int inLen, byte[] out, int outOfs, int outLen) throws PKCS11Exception {
            return super.C_Decrypt(hSession, in, inOfs, inLen, out, outOfs, outLen);
        }

        public synchronized void C_CloseSession(long hSession) throws PKCS11Exception {
            super.C_CloseSession(hSession);
        }

        public synchronized void C_Finalize(Object pReserved) throws PKCS11Exception {
            super.C_Finalize(pReserved);
        }

        public synchronized void C_DecryptInit(long hSession, CK_MECHANISM pMechanism, long hKey) throws PKCS11Exception {
            super.C_DecryptInit(hSession, pMechanism, hKey);
        }

        public synchronized void C_Login(long hSession, long userType, char[] pPin) throws PKCS11Exception {
            super.C_Login(hSession, userType, pPin);
        }

        public synchronized byte[] C_Sign(long hSession, byte[] pData) throws PKCS11Exception {
            return super.C_Sign(hSession, pData);
        }

        public synchronized void C_GetAttributeValue(long hSession, long hObject, CK_ATTRIBUTE[] pTemplate) throws PKCS11Exception {
            super.C_GetAttributeValue(hSession, hObject, pTemplate);
        }

        public synchronized long[] C_FindObjects(long hSession, long ulMaxObjectCount) throws PKCS11Exception {
            return super.C_FindObjects(hSession, ulMaxObjectCount);
        }

        SynchronizedPKCS11(String pkcs11ModulePath) throws IOException {
            super(pkcs11ModulePath);
        }

        public synchronized CK_SESSION_INFO C_GetSessionInfo(long hSession) throws PKCS11Exception {
            return super.C_GetSessionInfo(hSession);
        }

        public synchronized void C_GenerateRandom(long hSession, byte[] randomData) throws PKCS11Exception {
            super.C_GenerateRandom(hSession, randomData);
        }

        public synchronized void C_SignRecoverInit(long hSession, CK_MECHANISM pMechanism, long hKey) throws PKCS11Exception {
            super.C_SignRecoverInit(hSession, pMechanism, hKey);
        }

        public synchronized CK_TOKEN_INFO C_GetTokenInfo(long slotID) throws PKCS11Exception {
            return super.C_GetTokenInfo(slotID);
        }

        public synchronized CK_MECHANISM_INFO C_GetMechanismInfo(long slotID, long type) throws PKCS11Exception {
            return super.C_GetMechanismInfo(slotID, type);
        }

        public synchronized int C_DecryptFinal(long hSession, long directOut, byte[] out, int outOfs, int outLen) throws PKCS11Exception {
            return super.C_DecryptFinal(hSession, directOut, out, outOfs, outLen);
        }

        public synchronized long C_OpenSession(long slotID, long flags, Object pApplication, CK_NOTIFY Notify) throws PKCS11Exception {
            return super.C_OpenSession(slotID, flags, pApplication, Notify);
        }

        public synchronized void C_SignInit(long hSession, CK_MECHANISM pMechanism, long hKey) throws PKCS11Exception {
            super.C_SignInit(hSession, pMechanism, hKey);
        }

        public synchronized void C_DestroyObject(long hSession, long hObject) throws PKCS11Exception {
            super.C_DestroyObject(hSession, hObject);
        }

        public synchronized void C_Logout(long hSession) throws PKCS11Exception {
            super.C_Logout(hSession);
        }

        public synchronized long[] C_GetMechanismList(long slotID) throws PKCS11Exception {
            return super.C_GetMechanismList(slotID);
        }

        synchronized void C_Initialize(Object pInitArgs) throws PKCS11Exception {
            super.C_Initialize(pInitArgs);
        }

        public synchronized void C_SeedRandom(long hSession, byte[] pSeed) throws PKCS11Exception {
            super.C_SeedRandom(hSession, pSeed);
        }

        public synchronized void C_SignUpdate(long hSession, long directIn, byte[] in, int inOfs, int inLen) throws PKCS11Exception {
            super.C_SignUpdate(hSession, directIn, in, inOfs, inLen);
        }

        public synchronized void C_FindObjectsInit(long hSession, CK_ATTRIBUTE[] pTemplate) throws PKCS11Exception {
            super.C_FindObjectsInit(hSession, pTemplate);
        }

        public synchronized CK_SLOT_INFO C_GetSlotInfo(long slotID) throws PKCS11Exception {
            return super.C_GetSlotInfo(slotID);
        }

        public synchronized int C_DecryptUpdate(long hSession, long directIn, byte[] in, int inOfs, int inLen, long directOut, byte[] out, int outOfs, int outLen) throws PKCS11Exception {
            return super.C_DecryptUpdate(hSession, directIn, in, inOfs, inLen, directOut, out, outOfs, outLen);
        }

        public synchronized byte[] C_SignFinal(long hSession) throws PKCS11Exception {
            return super.C_SignFinal(hSession);
        }

        public synchronized long[] C_GetSlotList(boolean tokenPresent) throws PKCS11Exception {
            return super.C_GetSlotList(tokenPresent);
        }
    }
}

