/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.smime.security.pkcs11;

import com.sun.messaging.smime.security.cardapi.CardAdmin;
import com.sun.messaging.smime.security.cardapi.CardException;
import com.sun.messaging.smime.security.cardapi.CardParameters;
import com.sun.messaging.smime.security.cardapi.CardToken;
import com.sun.messaging.smime.security.pkcs11.C031;
import com.sun.messaging.smime.security.pkcs11.C054;
import com.sun.messaging.smime.security.pkcs11.PKCS11CardReader;
import com.sun.messaging.smime.security.pkcs11.wrapper.PKCS11Exception;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.X509Certificate;
import javax.crypto.BadPaddingException;
import javax.security.auth.login.LoginException;

class PKCS11CardToken
extends CardToken {
    private final PKCS11CardReader e;
    private CardAdmin f;
    private final CardParameters g;
    private static final String h = "SmartCard";
    private final C054 i;
    private static final byte[] j = new byte[]{48, 32, 48, 12, 6, 8, 42, -122, 72, -122, -9, 13, 2, 5, 5, 0, 4, 16};

    public X509Certificate[] getCertificateChain(X509Certificate cert) throws CardException {
        try {
            return this.i.k().b(cert);
        }
        catch (PKCS11Exception e) {
            throw new CardException("Certificate chain building error", e);
        }
    }

    public byte[] decrypt(X509Certificate cert, String algorithm, byte[] encryptedData) throws CardException, InvalidKeyException, BadPaddingException {
        PrivateKey key = null;
        this.a();
        if (this.needsLogin()) {
            boolean loginSucceeded = false;
            while (!loginSucceeded) {
                String pwd = this.f.getLogin(h, "Please input card PIN");
                if (pwd == null) {
                    throw new CardException("Card login canceled by user");
                }
                try {
                    this.d(pwd.toCharArray());
                    loginSucceeded = true;
                }
                catch (C031 e) {
                    throw e;
                }
                catch (LoginException e) {
                }
                catch (CardException e) {
                }
            }
        }
        try {
            key = this.i.k().g(cert);
        }
        catch (PKCS11Exception e) {
            throw new CardException("Private access error", e);
        }
        return this.b(key, algorithm, encryptedData);
    }

    private void a() throws CardException {
        if (this.e.isShutdown) {
            throw new C031("Reader has been shutdown");
        }
        if (!this.isValid()) {
            throw new C031("Token has been removed");
        }
    }

    private byte[] b(PrivateKey key, String algorithm, byte[] encryptedData) throws CardException, InvalidKeyException, BadPaddingException {
        if (!"RSA".equals(algorithm) && !"1.2.840.113549.1.1.1".equals(algorithm)) {
            throw new BadPaddingException("Only RSA decryption supported");
        }
        try {
            return this.i.a().a(key, encryptedData);
        }
        catch (PKCS11Exception e) {
            throw new CardException("Error accessing token", e);
        }
    }

    public boolean needsLogin() throws CardException {
        try {
            return this.isValid() && !this.i.e(null);
        }
        catch (PKCS11Exception e) {
            throw new CardException("Error querying token", e);
        }
    }

    private byte[] c(PrivateKey key, String algorithm, byte[] hash) throws CardException, InvalidKeyException, SignatureException {
        if (!"MD5withRSA".equals(algorithm) && !"SHA1withRSA".equals(algorithm)) {
            throw new SignatureException("Only MD5withRSA and SHA1withRSA signing supported");
        }
        try {
            try {
                ByteArrayOutputStream bout = new ByteArrayOutputStream();
                bout.write(j);
                bout.write(hash);
                byte[] digestInfo = bout.toByteArray();
                return this.i.g().a(key, digestInfo);
            }
            catch (IOException e) {
                throw new CardException("Message digest IO error: " + e.toString());
            }
        }
        catch (PKCS11Exception e) {
            throw new CardException("Error accessing token", e);
        }
    }

    public X509Certificate[] getUserCertificates() throws CardException {
        this.a();
        try {
            return this.i.k().f();
        }
        catch (PKCS11Exception e) {
            throw new CardException("Error accessing token", e);
        }
    }

    PKCS11CardToken(PKCS11CardReader reader, C054 token, CardParameters parameters) {
        super(parameters.getProviderName());
        this.e = reader;
        this.i = token;
        this.g = parameters;
    }

    public byte[] sign(X509Certificate cert, String algorithm, byte[] encryptedData) throws CardException, InvalidKeyException, BadPaddingException {
        PrivateKey key = null;
        this.a();
        if (this.needsLogin()) {
            boolean loginSucceeded = false;
            while (!loginSucceeded) {
                String pwd = this.f.getLogin(h, "Please input card PIN");
                if (pwd == null) {
                    throw new CardException("Card login canceled by user");
                }
                try {
                    this.d(pwd.toCharArray());
                    loginSucceeded = true;
                }
                catch (C031 e) {
                    throw e;
                }
                catch (LoginException e) {
                }
                catch (CardException e) {
                }
            }
        }
        try {
            key = this.i.k().g(cert);
            return this.c(key, algorithm, encryptedData);
        }
        catch (PKCS11Exception e) {
            throw new CardException("Private access error", e);
        }
        catch (SignatureException e) {
            throw new CardException("Signing error", e);
        }
    }

    private void d(char[] pin) throws CardException, LoginException {
        this.a();
        try {
            if (this.i.e(null)) {
                return;
            }
            this.i.f(pin);
        }
        catch (PKCS11Exception e) {
            throw new CardException("Error querying token", e);
        }
    }

    public X509Certificate[] getTrustedCertificates() throws CardException {
        this.a();
        try {
            return this.i.k().k();
        }
        catch (PKCS11Exception e) {
            throw new CardException("Error accessing token", e);
        }
    }

    public boolean isValid() {
        return !this.e.isShutdown && this.i.o();
    }

    public void registerCardAdmin(CardAdmin admin) {
        this.f = admin;
    }
}

