/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.smime.security.fedcard;

import com.sun.messaging.smime.applet.AppletLogger;
import com.sun.messaging.smime.security.cardapi.CardAdmin;
import com.sun.messaging.smime.security.cardapi.CardConfiguration;
import com.sun.messaging.smime.security.cardapi.CardException;
import com.sun.messaging.smime.security.cardapi.CardParameters;
import com.sun.messaging.smime.security.cardapi.CardReader;
import com.sun.messaging.smime.security.cardapi.CardToken;
import com.sun.messaging.smime.security.fedcard.FedConfigParser;
import com.sun.messaging.smime.security.fedcard.FedToken;
import java.util.ArrayList;

public class FedReader
extends CardReader {
    private final CardToken b;
    private CardAdmin c;
    private final CardReader[] d;

    public CardToken getToken() throws CardException {
        return this.b;
    }

    public FedReader(String configString) throws CardException {
        super("FED");
        AppletLogger.log("CardApi: FedReader got configuration string: " + configString);
        try {
            FedConfigParser parser = new FedConfigParser(configString);
            CardParameters[] configParams = parser.getConfigs();
            ArrayList<CardConfiguration> configList = new ArrayList<CardConfiguration>(0);
            for (int i = 0; i < configParams.length; ++i) {
                CardConfiguration config = new CardConfiguration(configParams[i]);
                configList.add(config);
            }
            CardConfiguration[] configs = configList.toArray(new CardConfiguration[0]);
            ArrayList<CardReader> readerList = new ArrayList<CardReader>();
            for (int i = 0; i < configs.length; ++i) {
                try {
                    CardReader card = configs[i].getCardReader();
                    AppletLogger.log("CardApi: Loaded reader: " + card.getType());
                    if (card == null) continue;
                    readerList.add(card);
                    continue;
                }
                catch (CardException e) {
                    boolean b = false;
                }
            }
            if (readerList.isEmpty()) {
                AppletLogger.log("CardApi: No reader loaded");
                throw new CardException("No card reader loaded");
            }
            this.d = readerList.toArray(new CardReader[0]);
            this.b = new FedToken(this);
        }
        catch (Exception e) {
            AppletLogger.log("CardApi: Configuration error: " + e);
            throw new CardException("Configuration error: " + e);
        }
    }

    public void registerCardAdmin(CardAdmin admin) throws CardException {
        this.c = admin;
        for (int i = 0; i < this.d.length; ++i) {
            this.d[i].registerCardAdmin(this.c);
        }
    }

    CardReader[] a() {
        return this.d;
    }

    public void shutdown() throws CardException {
        for (int i = 0; i < this.d.length; ++i) {
            this.d[i].shutdown();
        }
    }
}

