/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ens.jms;

import com.iplanet.ens.gap.Gap;
import com.iplanet.ens.gap.GapMsg;
import com.iplanet.ens.gap.GapMsgListener;
import com.iplanet.ens.jms.EnsMessageConsumer;
import com.iplanet.ens.jms.EnsTextMessage;
import com.iplanet.ens.jms.EnsTopicSession;
import java.util.StringTokenizer;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;

public class EnsTopicSubscriber
extends EnsMessageConsumer
implements TopicSubscriber,
GapMsgListener {
    Topic topic;
    String _renlUrl;
    TopicSession _topicSession;
    TopicPublisher _topicPublisher;
    boolean _reliable;
    MessageListener _ml;

    EnsTopicSubscriber(Gap gap, Topic topic) {
        super(gap);
        this.topic = topic;
        this._reliable = false;
    }

    EnsTopicSubscriber(Gap gap, Topic topic, String string, EnsTopicSession ensTopicSession) throws JMSException {
        super(gap);
        this.topic = topic;
        this._topicSession = ensTopicSession;
        this._topicPublisher = ensTopicSession.createPublisher(null);
        this._renlUrl = "anp:///anonymous:anonymous:" + string + "?rc=0&seqnum=";
        this._reliable = true;
    }

    public Topic getTopic() throws JMSException {
        return this.topic;
    }

    public boolean getNoLocal() throws JMSException {
        throw new JMSException("not implemented");
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        super.setMessageListener(messageListener);
        if (messageListener != null) {
            this.gConn.addListener(this);
        }
        this._ml = messageListener;
    }

    public void onMessage(GapMsg gapMsg) {
        if (gapMsg == null && this._ml != null) {
            this._ml.onMessage(null);
            return;
        }
        try {
            if (this._ml != null && gapMsg.getAddress().startsWith(this.topic.getTopicName())) {
                String string = gapMsg.getAddress();
                StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
                String string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                String string4 = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "?");
                String string5 = stringTokenizer2.nextToken();
                String string6 = stringTokenizer2.nextToken();
                EnsTextMessage ensTextMessage = new EnsTextMessage();
                ensTextMessage.setText(gapMsg.getPayload());
                ensTextMessage.setStringProperty("ensMsgURI", string5);
                ensTextMessage.setStringProperty("ensMsgParam", string6);
                ensTextMessage.importProperties(string6);
                ensTextMessage.setJMSType(string3);
                ensTextMessage.setJMSMessageID("ID: " + gapMsg.getTxnID());
                ensTextMessage.setStringProperty("ensMsgNum", string4);
                ensTextMessage.setStringProperty("ensSessID", gapMsg.getSessID());
                ensTextMessage.setStringProperty("ensTxnID", gapMsg.getTxnID());
                ensTextMessage.setIntProperty("ensPayloadLen", gapMsg.getLen());
                this._ml.onMessage((Message)ensTextMessage);
                if (this._reliable) {
                    Topic topic = this._topicSession.createTopic(this._renlUrl + string4.substring(4));
                    TextMessage textMessage = this._topicSession.createTextMessage(null);
                    this._topicPublisher.publish(topic, (Message)textMessage);
                }
            }
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
    }
}

