// I18N Resource file
var i18n = new Array()
var fldr = new Array()

// APPLET LOADING MESSAGE VARIABLE
i18n['wait_for_applet'] = 'Please wait while applet loads.<br>This may take a while depending on your system speed...'

// DO NOT TRANSLATE AS STRINGS-JUST VALUES
i18n['fontface'] = 'PrimaSans BT,Verdana,sans-serif'
i18n['fontface1'] = i18n['fontface']
i18n['fontface2'] = 'Times New Roman,Times,serif'
i18n['fontface3'] = 'Courier New,Courier,mono'
i18n['nbsp'] = '&nbsp;'

//Spell Checker
i18n['settings autospell']='Spell check'
i18n['settings autospell exp']='Always check spelling before sending a message'
i18n['spellok']='OK'
i18n['AutoSpellCheck']='Check spelling before message is sent'
i18n['spell error']='Server error: Unable to spell check'
i18n['spelldicterror']='Server error: Language dictionary unavailable'
i18n['select  comp lang']='Select language'
i18n['spelldict']='Dictionary'
i18n['spell change'] = '&nbsp;&nbsp;Change&nbsp;&nbsp;&nbsp;'
i18n['spell changeall'] = 'Change All'
i18n['spell ignoreall'] = '&nbsp;Ignore All&nbsp;'
i18n['spell_progress']='Please wait. The spell checker will start momentarily.'
i18n['send_progress']='Sending in progress'
i18n['spell_no_mistakes']=" No misspelled words"
i18n['spell_select_lang']="Please select a language"
i18n['spell_nothing']='Nothing to check'
i18n['send_anyway']= 'Your message contains words the spell checker does not recognize. Would you like to send it anyway?'
i18n['done_anyway']= 'Your message still contains words the spell checker does not recognize.'
i18n['spell_window_title']='Spell Check Message'
i18n['spell yes']="Yes"
i18n['spell no']="No"
i18n['spelltool done']="Done"
i18n['spelltool help']=" Help "
i18n['No Suggestions']='No Suggestion'
i18n['Suggestions']='Suggestions'
i18n['sp_edit']='Edit...'
i18n['sp_replace']='Replace the word with:'

//SMIME
i18n['smime not available']='SMIME has not been Configured correctly or the Applet has not been loaded'
i18n['smime recipients failure']='Error in adding recipient:'
i18n['Signed Message']='Signed Message'
i18n['Invalid Signature']='Invalid Signature'
i18n['Invalid Encryption']='Invalid Encryption'
i18n['Encrypted Message']='Encrypted Message'
i18n['url_error']="Error in adding the URL "
i18n['set_message_error']="Error in processing encrypted or signed message: "
i18n['smtp_server_unavailable']="SMTP server not available"
i18n['cert_chain_invalid']="Certificate chain is invalid.\n Do you still want to send the message?"
i18n['cert_revoked']="Certificate revoked for some recipient(s).\n Do you still want to send the message?"
i18n['crl_server_unreachable']="CRL (Certificate revocation list) validation server unavailable.\n Do you still want to send the message?"
i18n['rec_cert_notfound']="Following recipient(s) do not have the necessary certificate.\nRemove these recipient(s) to send the message:\n"
i18n['all_rec_cert_notfound']="None of the recipients have the necessary certificate"
i18n['self_rec_cert_notfound']="You do not have the necessary certificate to send yourself a copy.\nDisable the Sent Messages option to send the message."
i18n['invalid recipient msg']="Certificates for the following recipients:\n"
i18n['invalid sender cert msg']="sender's copy"
i18n['have error msg']="\nhave the following errors:\n"
i18n['smime_send_anyway']="\n Do you still want to send the message?"
i18n['cert not selected'] ="Not Selected"
i18n['select cert']="Select a Signing Certificate"
i18n['invalid recipient'] = " invalid recipient(s):"
i18n['crl_status_header'] = "Status"
i18n['removing original forward'] = "You may not remove original message and/or attachment(s)."
i18n['Exceed message size.'] = "Exceeded maximum message size.  Remove some attachments."
i18n['login_prompt'] = "Please enter your pin."
i18n['login_accept'] = "OK"
i18n['login_cancel'] = "Cancel"
i18n['Sign Option'] = "Sign Message"
i18n['Encrypt Option'] = "Encrypt Message"
i18n['Unexpected SMIME error'] = "Please report unexpected SMIME error code: "
i18n['draft not saved']= "The draft was not saved."
i18n['message not sent']= "The message was not sent."
i18n['crl sign revoke']= " ***** signing certificate is revoked ! "
i18n['crl decrypt revoke']= " ***** decryption certificate is revoked ! "
i18n['crl unexpected code']= " ***** Please report unexpected certificate verification code "
i18n['SMIME processing failed']= "SMIME processing failed.  Attachment list not reliable."
i18n['unsupported platform']= "unsupported platform"
i18n['no Habanero support']= 'SMIME not supported in Comm Express with old interface.  Use applet_fs_lr.html.'
i18n['SSL CA Root failed']= "Configuration failure: check SSL Root CA certificates"
i18n['trusted Root failed']= "Configuration failure: check trusted Root CA certificates"
i18n['Applet config failed']= "Configuration failure: Certificate store not supported on this platform"
i18n['tampered msg']= 'Perhaps the message was tampered with.'
i18n['unknown parts']= "These MIME message parts could not be processed:\n"
i18n['unknown parts trailer']= "\nDisplaying those parts that can be."

// Compose window toolbar
i18n['compose_send']='Send Message'
i18n['compose_attach']='Attach File to Message'
i18n['compose_spell']='Spell Check Message'
i18n['compose_editor']='Switch Editor(Plain Text or HTML)'


// General
i18n['INBOX'] = 'Inbox'
i18n['trash folder'] = 'Trash'
i18n['draft folder'] = 'Drafts'
i18n['sent folder'] = 'Sent'
i18n['sent folder IE'] = 'Sent Items'
i18n['loading'] = 'Loading: please wait...'
i18n['noselect folder'] = '  ***'
i18n['selectLabel'] = 'Select'
i18n['Select All']= 'Select All'
i18n['Deselect All']= 'Deselect All'
i18n['no msg'] = 'This folder contains no message.'

// For localdirectory search
i18n['localdirsearch']="3 200"

// Localized folder names
fldr['INBOX'] = 'Inbox'
fldr['Trash'] = 'Trash'
fldr['Drafts'] = 'Drafts'
fldr['Sent'] = 'Sent'
fldr['Sent Items'] = 'Sent Items'

// Window titles
i18n['app title'] = 'Sun Java System Communications Express'
i18n['sjs app title'] = 'Sun Java System Messenger Express'
i18n['frame title'] = i18n['app title'] + ' - Please View Frame 1'
i18n['attach title'] = 'Attach File'
i18n['collect title'] = 'Collect External Mail'
i18n['compose title'] = 'New Message'
i18n['lookup title'] = 'LDAP Lookup'
i18n['receipt title'] = 'Return Receipt'
i18n['editgroup title'] = 'Update Group'
i18n['editentry title'] = 'Update Contact'
i18n['newgroup title'] = 'New Group'
i18n['newentry title'] = 'New Contact'
i18n['comprecipient title'] = 'Select Recipients from Personal Address Book'

// Tabs
i18n['folders'] = 'Folders'
i18n['message'] = 'Message'
i18n['pab'] = 'Addresses'
i18n['options'] = 'Options'
i18n['search results'] = 'Search Result'
i18n['searching'] = 'Searching ...'
i18n['netcenter'] = 'Netcenter'

i18n['SpellCk']='Spell Check'

function i18n_tab_header(user) {
  if(user != null)
     return '<nobr>&nbsp;&nbsp;Welcome ' + user + '</nobr>'
  else
     return ' '
}

function i18n_quota_warning(percent) {
  return 'WARNING: You are currently operating at ' + percent +
         '% of your quota.'
}
function i18n_maxsize(maxsize) {
  return '(Maximum size of the message including all attachments should not exceed ' + maxsize +
         'kb.)'
}
function i18n_msgQuota_warning(percent) {
  return 'WARNING: You are currently operating at ' + percent +
         '% of your message quota.'
}

// Error Messages

i18n['fldr selfmove'] = 'Moving a folder to itself is not allowed' 
i18n['fldr noinbox'] = 'Creating a subfolder in INBOX is not allowed'
i18n['mbox nopermission'] = 'You do not have permissions to move messages to this folder'
i18n['mbox selfmove'] = 'Messages cannot be moved to the folder that they are already in'
i18n['msg nopermission'] = i18n['mbox nopermission']
i18n['msg selfmove'] = i18n['mbox selfmove']
i18n['send errno'] = 'Send errno: '
i18n['attachment select error'] = 'Error selecting attachment: '


// Message Headers
i18n['selected'] = 'Selected'
i18n['seen'] = 'Seen'
i18n['from'] = 'From'
i18n['date'] = 'Date'
i18n['recvdate'] = 'Received'
i18n['sentdate'] = 'Sent'
i18n['to'] = 'To'
i18n['cc'] = 'Cc'
i18n['bcc'] = 'Bcc'
i18n['subject'] = 'Subject'
i18n['sender'] = 'Sender'
i18n['body'] = 'Body'
i18n['attachments'] = 'Attachments'
i18n['size'] = 'Size'
i18n['unread'] = 'Unread'
i18n['no subject'] = '[ No Subject ]'
i18n['duplicates ignored'] = ' Duplicates ignored'
i18n['search invalidfolder'] = 'Invalid folder selected. Please select a valid folder to search.'

// Tool Bars
i18n['delete'] = 'Delete'
i18n['undelete'] = 'Undelete'
i18n['expunge'] = 'Expunge'
i18n['rename'] = 'Rename'
i18n['new folder'] = 'New'
i18n['subscribe'] = 'Share'
i18n['help'] = 'Help'
i18n['logout'] = 'Log Out'
i18n['home'] = 'Home'
i18n['helptip'] = 'Display Help for This Page'
i18n['attach'] = 'Attach'
i18n['draft'] = 'Save Draft'
i18n['send'] = 'Send'
i18n['cancel'] = 'Cancel'
i18n['compose_help']= 'Help'
i18n['compose'] = 'Compose'
i18n['search'] = 'Search'
i18n['get mail'] = 'Get Mail'
i18n['update'] = 'Refresh'
i18n['forward'] = 'Forward'
i18n['forwardinline'] = 'Forward Inline'
i18n['reply'] = 'Reply'
i18n['reply all'] = 'Reply All'
i18n['add sender'] = 'Add Sender'
i18n['previous'] = 'Previous'
i18n['printable'] = 'Printable'
i18n['next'] = 'Next'
i18n['lookup'] = 'Address'
i18n['quote'] = 'Quote'
i18n['new search'] = 'Revise'
i18n['add all addresses'] = 'Add Addresses'
i18n['sharefolder toolbar'] = 'Share'
i18n["attach_help"] = 'Help'

// Shared Folders
i18n["share folder"] = 'Share Folder'
i18n["Shared Folders Title"] = 'Set Folder Permissions'
i18n["SetPermissions Header"] = 'Folder :'
i18n["SetPermissions AddUser"] = 'Permissions List '
i18n["SetPermissions AddUser1"] = 'To share this folder with other users, use \"Search\" to locate a user.'
i18n["SetPermissions Subtitle1"] = 'Enter a user ID, then click \"Add\".'
i18n["SetPermissions Searchtitle"] = 'To Search for a user, click \"Search\".'
i18n["SetPermissions subtitle2"] = 'Set permissions:'
i18n["SetPermissions info"] = 'Then, set the permissions for that user.' 
i18n["SetPermissions read"] = 'Read only'
i18n["SetPermissions readwrite"] = 'Read and write'
i18n["SetPermissions readwriteaccess"] = 'Read, write, and manage access'
i18n["SetPermissions User"] = 'User ID'
i18n["SetPermissions Permission"] = 'Permissions'
i18n["SetPermissions Delete"] = 'Remove'
i18n["SetPermissions ok"] = 'OK'
i18n["SetPermissions apply"] = 'Apply'
i18n["SetPermissions cancel"] = 'Cancel'
i18n["SetPermissions Help"] = 'Help'
i18n["SetPermissions Alert1"] = 'User is already on the list'
i18n["SetPermissions AddButton"] = 'Add'
i18n["SetPermissions SearchButton"] = 'Search...'
i18n["SetPermissions Alert2"] = 'Please enter the user name'
i18n["SetPermissions subtitle3"] = 'Select one user from the list and click Add'
i18n["SetPermissions subtitle4"] = 'Search for users'
i18n["SetPermissions selfadd"] = 'Sharing a folder with yourself is not allowed'
i18n["SetPermissions none"] = 'None'
i18n["directdelivery"] = 'Enable direct delivery of email to folder:  '
i18n["SetPermissions owneraddalert"] = 'Sharing a folder with yourself is not allowed'
i18n["SetPermissions SearchResultHeader"] = 'Please select the user(s) from the list below'
i18n["SetPermissions nopermissionslaert"] = 'You do not have permission for setting permission'
i18n["SetPermissions Remove"] = 'Remove'
i18n["SetPermissions InvalidUser"] = 'Invalid User'
i18n['SetPermissions anyone'] = 'anyone'
i18n['Mail Delivery Address'] = 'Mail Delivery Address'
i18n['Folders shared by '] = 'Folders shared by '
i18n[ 'All Shared folders'] =  'All Shared folders'
i18n['Initial help text'] = 'Select the folders to view from the menu above.'

// Folders
i18n['fldr personal'] = 'Personal Folders'
i18n['fldr shared'] = 'Subscribed Shared Folders'
i18n['fldr file header'] = 'Move Selected Folder To'
i18n['fldr noinferiors'] = 'Subfolder not allowed'
i18n['fldr delete inbox'] = 'System folders - cannot be deleted'
i18n['fldr move inbox'] = 'System folders - cannot be moved'
i18n['fldr noselect'] = 'This folder cannot be modified.'
i18n['fldr cannotselect'] = 'This folder is not selectable'
i18n['fldr empty trash'] = 'Empty Trash'
i18n['fldr messages'] = 'Messages'
i18n['fldr nodelete'] = 'This folder cannot be renamed.'
i18n['fldr exists']= 'Folder already exists.'
i18n['fldr select']= 'Select a folder.'
i18n['fldr nopermissions'] = 'You do not have permission for creating a sub folder'
i18n['fldr nopermissionsdelete'] = 'You do not have permission for deleting a sub folder'
i18n['fldr unsubscribe'] = 'Cannot Unsubscribe the Folder'
i18n['Folder Actions'] = 'Folder Actions'

i18n['subscribe'] = 'Subscribe'
i18n['subscribe windowtitle'] = 'Subscribe to Shared Folders'
i18n['unsubscribe'] = 'Unsubscribe'
i18n['Subscribe Header1'] = 'Shared Folders are organized by their owner. Thus, type the owner\'s name, email address,'
i18n['Subscribe Header2'] = ' or phone number below and click \"Search\". Select the desired folder(s) and click \"Subscribe\"'
i18n['No Unsubscribed Folders'] = 'There are no folders to subscribe'
i18n['No Shared Folders'] = 'There are no shared folders for this user'
i18n['subscribe select'] = 'Select'
i18n['subscribe Folder'] = 'Folder'
i18n['subscribe owner'] = 'Owner'
i18n['subscribe searchHeader'] = 'Please select the User ID from the list'
i18n['subscribe User ID'] = 'User ID'
i18n['subscribe Name'] = 'Name'
i18n['subscribe E-Mail'] = 'Email'
i18n['subscribe owner Header'] = 'Owner\'s'
i18n['subscribe search title'] = 'Select User ID'
i18n['subscribe Search'] = 'Search'
i18n['subscribe Result'] = 'Subscribe search result for '

//Rtf
i18n['colorTitle'] = 'Select Color'
i18n['FontsizeLabel'] = 'Size'
i18n['FontnameLabel'] = 'Font'
i18n['Block Format'] = 'Format'
i18n['ViewHTMLSource'] = 'View HTML Source'
i18n['switchEditor']= 'Text/HTML'
i18n['colorColorLabel'] = 'Color : '
i18n['colorOkLabel'] = ' OK '
i18n['colorCancelLabel']= ' Cancel '
i18n['emoCloseLabel'] = ' Close '
i18n['Smiley'] = 'Insert Emoticon'
i18n['Cut'] = 'Cut'
i18n['Copy'] = 'Copy'
i18n['Paste'] = 'Paste'
i18n['Bold'] = 'Bold'
i18n['Italics'] = 'Italics'
i18n['Underline'] = 'Underline'
i18n['Change foreground color'] = 'Text Color'
i18n['Change Background color'] = 'Background Color'
i18n['Left Justify'] = 'Align Left'
i18n['Center Justify'] = 'Align Center'
i18n['Right Justify'] = 'Align Right'
i18n['Insert Ordered List'] = 'Number List'
i18n['Insert bullets'] = 'Bullet List'
i18n['Outdent'] = 'Decrease Indent '
i18n['Indent'] = 'Increase Indent'
i18n['Create HyperLink'] = 'Insert HyperLink'
i18n['make text left to right align'] = 'Make text left to right aligned'
i18n['make text right to left align'] = 'Make text right to left aligned'
i18n['all formatting will be lost'] = 'All formatting will be lost. Proceed ?'
i18n['Please uncheck "View HTML source" to use the formatting tools'] = 'Please uncheck "View HTML source" to use the formatting tools'
i18n['Compose in'] = 'Compose in '
i18n['Plain Text'] = 'Plain Text'
i18n['Rich Text (HTML)']= 'Rich Text (HTML)'
//Attach Dialog

i18n['Attach Header'] = 'Click Browse to select a file to attach, then click Add to attach the file to this message.'
i18n['Attach Col1'] = 'File Attachment'
i18n['Attach Col2'] = 'Size'
i18n['Attach Remove'] = 'Remove'
i18n['Attach Add'] = 'Add'
i18n['Attachments'] = 'Attachments'
i18n['Action'] = 'Action'

//Tooltips
i18n['folder actions'] = 'Folder Actions'
i18n['folder update'] = 'Update Folders'
i18n['folder new'] = 'New Folder'
i18n['folder rename'] = 'Rename Folder'
i18n['folder share'] = 'Share Folder'
i18n['folder delete'] = 'Delete Selected Folder'
i18n['folder subscribe'] = 'Subscribe to Shared  Folder'
i18n['folder unsubscribe'] = 'Unsubscribe Folder'
i18n['folder owner'] = 'Owner of Shared Folder'
i18n['mbox getmail'] = 'Get Mail'
i18n['mbox search'] = 'Search'
i18n['mbox delete'] = 'Delete Selected Messages'
i18n['mbox trash'] = 'Mark Selected Message as Deleted'
i18n['mbox actions'] = 'Actions'
i18n['mbox expunge'] = 'Expunge'
i18n['mbox undelete'] = 'Undelete'
i18n['mbox seen'] = 'Mark as Read'
i18n['mbox unseen'] = 'Mark as Unread'
i18n['mbox flagged'] = 'Flag for Followup'
i18n['mbox unflagged'] = 'Clear Flag'
i18n['mbox view'] = 'View'
i18n['mbox action checkbox'] = 'Action checkbox'

i18n['seen up'] = 'Sort descending by message type'
i18n['seen dn'] = 'Sort ascending by message type' 
i18n['recv up'] = 'Sort descending by date received '
i18n['recv dn'] = 'Sort ascending by received date'
i18n['from up'] = 'Sort descending by message sender'
i18n['from dn'] = 'Sort ascending by message sender'
i18n['size up'] = 'Sort descending by message size'
i18n['size dn'] = 'Sort ascending by message size'
i18n['subj up'] = 'Sort descending by message subject'
i18n['subj dn'] = 'Sort ascending by message subject'


i18n['name up'] = 'Sort descending by display name'
i18n['name dn'] = 'Sort ascending by display name'
i18n['mail up'] = 'Sort descending by email address'
i18n['mail dn'] = 'Sort ascending by email address'
i18n['attach dn'] = 'Sort ascending by attachment presence'
i18n['attach up'] = 'Sort decending by attachment presence'
i18n['priority dn']  = 'Sort ascending by message priority'
i18n['priority up'] = 'Sort descending by message priority'

i18n['msg compose'] = 'Compose Message'
i18n['msg reply'] = 'Reply to Message'
i18n['msg replyall'] = 'Reply All to Message'
i18n['msg forward'] = 'Forward Message'
i18n['msg delete'] = 'Delete Message'
i18n['msg addall'] = 'Add all addresses to the address book'
i18n['msg prev'] = 'Previous Message'
i18n['msg next'] = 'Next Message'
i18n['msg close'] = 'Close Message'
i18n['msg All'] = 'All'
i18n['msg Flagged'] = 'Flagged'
i18n['msg UnRead'] = 'Unread'
i18n['msg Deleted'] = 'Deleted'
i18n['msg UnreadDel'] = 'Unread, Deleted'
i18n['msg Read'] = 'Read'
i18n['msg ReadDel'] = 'Read, Deleted'
i18n['msg ReadAns'] = 'Read, Answered'
i18n['msg ReadAnsDel'] = 'Read, Answered, Deleted'
i18n['msg Attachment'] = 'Attachment'
i18n['msg FullHeader'] = 'View message header detail'
i18n['msg NormalHeader'] = 'View brief message header'
i18n['msg priority'] = 'Priority'
i18n['msg high'] = 'Priority: Urgent'
i18n['msg low'] = 'Priority: Non-Urgent'


i18n['pab update'] = 'Update Address Book'
i18n['pab new'] = 'New Contact'
i18n['pab group'] = 'New Group'
i18n['pab search'] = 'Search Address Book'
i18n['pab editgroup'] = 'Edit Group'

function prompt_delete_folder(m, i, nested) {

  var fname = m
  if (nested==-1)
    nested = ''
  else
    nested = ' and its subfolders'
  for(j=0; j < fldr.length; j++)
  {
    if(fldr[j] == m)
    {
      fname = fldr[j]
      break
    }
  }

  return 'Delete folder "' + fname + '"' + nested + '?'
}

function prompt_new_folder(m) {

  var fname = m
  for(i=0; i < fldr.length; i++)
  {
    if(fldr[i] == m)
    {
      fname = fldr[i]
      break
    }
  }

  return 'Create new folder in ' + fname + ' named:'
}

function prompt_rename_folder(f) {
  return 'Rename folder "' + f + '" to:'
}

function prompt_subscribe_folder() {
  return 'Subscribe to folder:'
}

function prompt_unsubscribe_folder(f) {
  return 'Unsubscribe from folder "' + f + '":'
}

function prompt_empty_folder(m) {
 var fname = fldr[m]

  if (fname == null)
    fname = m
  return 'Permanently remove all messages in ' + fname + '?'
}

// Mailbox
i18n['file selected msg'] = 'Move to Folder...'
i18n['copy selected msg'] = 'Copy Messages to Folder'
i18n['select folder'] = 'Select Folder'
i18n['mbox select all'] = 'Select all messages'
i18n['confirm expunge'] = 'Permanently remove selected messages?'
i18n['confirm expunge all'] = 'No messages selected. Permanently remove all deleted messages?'

function i18n_mbox_date(d, now, laurel) {
  var i, s = '', timeformat
  
  if(laurel)
    timeformat = main.cfg['sunUCTimeFormat'] ? main.cfg['sunUCTimeFormat'] : 12

  i = d.getHours()
  if (i == 0)
    s = 12
  else if (i < 13)
    s = i
  else {
    if(timeformat == 12)
      s = i - 12
    else
      s = i
  }
  s += ':'
  if (d.getMinutes() <= 9)
    s += '0'
  s += d.getMinutes()
  if(timeformat == 12)
  {
    if (i < 12)
      s += ' am'
    else
      s += ' pm'
  }

  var t = ''

  if(!(d.getDate() == now.getDate() && d.getMonth() == now.getMonth() && d.getYear() == now.getYear())) {
    i = d.getUTCFullYear()
    
    var f = main.cfg['meDateFormat']
    var format = f ? f.charAt(0) : '0'
    var deli = f ? f.charAt(1) : '/'

    if(laurel) {
      var lformat = main.cfg['sunUCDateFormat']
      deli = main.cfg['sunUCDateDelimiter'] ? main.cfg['sunUCDateDelimiter'] : '/'
      format = lformat ? lformat.charAt(0) : '0'
    }
    
    switch(format){
      case '0': case 'M':
           t = (d.getMonth() + 1) + deli + d.getDate() + deli + i
           break
      case '1': case 'D':
           t = d.getDate() + deli +(d.getMonth() + 1)  + deli + i
           break
      case '2': case 'Y':
           t = i + deli + (d.getMonth() + 1) + deli + d.getDate()
           break
    }
    t += ' ';
  }
 
  return t + s
}

function i18n_mbox_empty(m) {
  var fname = fldr[m]

  if (fname == null)
    fname = m
  return '<b>' + html(fname) + '</b>' + ' contains no messages'
}

function i18n_mbox_query(s, total, unread, used, limit, msgUsed, msgLimit,mb) {
  var mbox = mb ? mb : main.mboxFrame.mbox

  if (s == '') {
    var i

    if (total > 0) {
      s = '<nobr>' + total + ' Message' + (total > 1 ? 's' : '')
      if (unread == 0)
        s += ' (' + unread + ' unread) -'
      else
        s += ' (<b>' + unread + ' unread</b>) -'
      i = parseInt(used)
      s += size(i) + ' ('
      i = parseInt(limit)
      if (i < 0)
        s += 'no limit'
      else
        s += size(i) + ' limit'
      s += ')'
      s += ' -  ' + msgUsed + ' total messages ('
      if (msgLimit < 0)
        s += 'no limit'
      else
        s += msgLimit + ' limit'
      s += ')</nobr>'
    }
    return s
  } else {
    var a, val = split(s, '%:$>')
    var f
    var strflr = val[2].replace(/</g, "&lt;")

    a = split(val[val.length - 1], '/')
    if (a.length == 1 && fldr[a[a.length - 1]])
      f = fldr[a[a.length - 1]]
    else
      f = a[a.length - 1]
    if (mboxFrame.sortid.length == 0)
      s = 'No matches'
    else if (mboxFrame.sortid.length == 1)
      s = '1 Match'
    else
      s = total + ' Matches'
    s += ' for: '
    return  s +
      val[1].charAt(0).toUpperCase() + val[1].substring(1).toLowerCase() + ' ' +
      (val[0].length == 0 ? 'contains' : 'does not contain') +
//      ' "' + val[2] + '"' + ' in ' + 
      ' "' + strflr + '"' + ' in ' +
      '<a href="javascript:main.refreshMbox(\''+mbox+'\')" ' +
      'onMouseOver="return hint(\''+mbox+'\')" ' +
      'onMouseOut="return hint()">' + html(f) + '</a>'
  }
}

function i18n_confirm_unselected_expunge(m) {
  var fname = fldr[m]

  if (fname == null)
    fname = m
  return 'No messages selected.\nRemove all deleted messages in ' + fname + '?'
}

// Message
i18n['file msg'] = 'Move message to folder:'
i18n['msg image'] = '[ image ]'
i18n['msg file prefix'] = 'File:'
i18n['msg vcard'] = 'vCard'
i18n['msg signature'] = 'Digital Signature'
i18n['msg encrypted'] = 'Encrypted(cannot decode)'
i18n['msg enveloped'] = 'Enveloped-data'
i18n['msg signature unverified'] = 'Unverified Signature'
i18n['msg brief'] = 'View brief message headers'
i18n['msg all'] = 'View message header detail'

// Message Composition
i18n['fwd'] = 'Fwd: '
i18n['re'] = 'Re: '
i18n['attachment pending'] = 'Attachments pending. Please wait'
i18n['cancel message'] = 'Close message and abandon changes?'
i18n['draft message'] = 'Draft message has not been encrypted. It will be transmitted\nin clear text. Are you sure you want to continue?'
i18n['sign message'] = 'You have not selected a signing certificate.  Save message to draft then select certificate from options page.'
i18n['spell message'] = 'Spell checking requires that the message be transmitted in clear text for checking. Do you want to continue?'
i18n['recipient'] = 'Recipients'
i18n['recipient mini help'] = 'Separate multiple recipients using a comma.'
i18n['invalid addr'] = 'Email address contains invalid characters'
i18n['no recipient'] = 'This message has no recipients listed. Please click To, Cc or Bcc to add an email address.'
i18n['no subject confirm'] = 'This message has no subject. Would you like to send it anyway? '
i18n['original message'] = 'Original Message'
i18n['original forward'] = 'Original Message and Attachments'
i18n['reply text'] = 'Original Message'
i18n['remove'] = 'Remove'
i18n['reply separator'] = '----- Original Message -----'
i18n['priority'] = 'Priority'
i18n['priority n'] = 'Normal'
i18n['priority h'] = 'Urgent'
i18n['priority l'] = 'Non-Urgent'
i18n['receipt'] = 'Request receipt'
i18n['receipt n'] = 'None'
i18n['receipt d'] = 'When delivered'
i18n['receipt r'] = 'When viewed'
i18n['receipt b'] = 'Both'
i18n['no mail'] = 'No mail address. Cannot send messages'
i18n['reply too long'] = 'The original message is too large to quote.\nIt will be included as an attachment.'
i18n['reply no text'] = 'Messenger Express cannot quote the original message in plain text.\nIt will be included as an attachment.'
i18n['add empty t'] = 'Send this message to:'
i18n['add empty c'] = 'Send a carbon copy of this message to:'
i18n['add empty b'] = 'Send a blind carbon copy of this message to:'
i18n['sent status'] = 'Mail submitted successfully'
i18n['noHTTPResponse'] = 'The message is taking a long time to send.  Try sending or recomposing it again.'

// Return receipt
i18n['receipt request'] = 'Receipt requested. Send acknowledgment?'
i18n['receipt subject'] = 'Return Receipt (displayed) - '

function i18n_receipt_text(from) {
  return 'This is a return receipt for the mail that you sent to\r\n' + from +
    '.\r\n\r\n' +
    'Note: this return receipt only acknowledges that the message was\r\n' +
    'displayed on the recipient\'s machine. There is no guarantee that the\r\n' +
    'content has been read or understood.'
}

// Attachment
i18n['attach missing'] = 'No file selected'
i18n['attach empty'] = 'Empty or invalid file'
i18n['attach msg canceled'] = 'Message canceled'
i18n['attach non ascii allowed'] = 'Cannot attach a file with non ASCII filename'
i18n['attach pending'] = 'Attachment pending. Cancel to abort...'
i18n['attach limited'] = 'Attachments are limited to '
i18n['attach maxlimit'] = 'Maximum Attachments Reached'

function i18n_attach_msg() {
  return '<ul><li>Click <b>Browse...</b> ' +
    (IE >= 3 && IE < 4 ? 'Must have IE file upload patch' : 'to select a file.') + 
    '<li>After selecting a file, click <b>Attach</b>.' +
    '<li>This window will close when the file transfer is complete.' +
    '</ul>'
}

// POP3 Collection
i18n['collect'] = 'Collect'
i18n['collect long'] = 'External Mail'
i18n['collect host'] = 'POP server'
i18n['collect user'] = 'POP user ID'
i18n['collect pass'] = 'Password'
i18n['collect folder'] = 'Save to folder'
i18n['collect delete'] = 'Delete messages from server'
i18n['collect pending'] = 'Collection pending. Please wait...'
i18n['collect no host'] = 'POP server must be specified.'
i18n['collect no user'] = 'User ID must be specified.'
i18n['collect no pass'] = 'Account password must be specified.'
i18n['msg nocollect'] = 'You do not have permissions to collect messages to this folder'

// LDAP Lookup
i18n['ldap givenname'] = 'First Name'
i18n['ldap sn'] = 'Last Name'
i18n['ldap cn'] = 'Name'
i18n['ldap mail'] = 'Email'
i18n['ldap phone'] = 'Phone #'
i18n['ldap searching'] = 'Searching. Please wait...'
i18n['close'] = 'Close'

// Options
i18n['account summary'] = 'Account Summary'
i18n['summary exp'] = 'Contact your system administrator if you want to modify any of the following information.'
i18n['email addrs'] = 'Email Addresses'
i18n['email addrs exp'] = 'Your account configuration enables you to receive mail addressed to any of the following:'
i18n['quota'] = 'Quota'
i18n['quota exp'] = 'Your system administrator may limit the amount of disk space available for mail storage.'
i18n['quota limit'] = 'Your mailbox disk quota is:'
i18n['no limit'] = 'Not Limited'
i18n['quota usage'] = 'Your current disk consumption is:'
i18n['message quota limit'] = 'Your message quota is:'
i18n['message quota usage'] = 'Your current message count is:'
i18n['password'] = 'Password'
i18n['passwd exp'] = 'Use this form to change the password you use to access Messenger Express.'
i18n['passwd old'] = '1. Enter your old password:'
i18n['passwd new'] = '2. Enter your new password:'
i18n['passwd confirm'] = '3. Confirm your new password:'
i18n['passwd again'] = '(for confirmation)'
i18n['passwd submit'] = 'Change Password'
i18n['clear'] = 'Reset'
i18n['new pass alert'] = 'Please enter a new password.'
i18n['old pass alert'] = 'Please enter your old password.'
i18n['pass mismatch alert'] = 'The two entries for your new password do not match. Please re-enter.'
i18n['pass changed'] = 'Password change was successful'
i18n['personal'] = 'Personal Information'
i18n['personal exp'] = 'Use this form to change personal information.'
i18n['personal cn'] = 'Name'
i18n['personal cn exp'] = 'As it appears on outgoing messages:'
i18n['personal lang'] = 'Preferred Language'
i18n['personal lang exp'] = 'Use the following default language:'
i18n['personal lang changed'] = 'Your preferred language has changed.\n\nIn order for this change to take effect\nyou will need to log out and log in again.'
i18n['personal replyto'] = 'Reply-to Address'
i18n['personal replyto exp'] = 'If different from '
i18n['personal vcard'] = 'vCard'
i18n['personal vcard exp'] = 'Your vCard contains the following information:'
i18n['personal signature'] = 'Signature'
i18n['personal signature exp'] = 'Include this text in each message you compose:'
i18n['delivery'] = 'Delivery'
i18n['vacation'] = 'Vacation Message'
i18n['vacation exp'] = 'Use this form to set up automatic replies for periods when you cannot read your email.'
i18n['vacation toggle'] = 'Enable automatic vacation reply.'
i18n['vacation date format exp'] = ' (mm/dd/yyyy)'
i18n['vacation date separator'] = '/'
i18n['vacation invalid date'] = 'Invalid Date'
i18n['vacation invalidautoreplytimeout'] = 'Invalid Number of Days'
i18n['vacation start exp'] = 'Start vacation notice on: '
i18n['vacation end exp'] = 'Stop vacation notice on: '
i18n['vacation timeout exp'] = 'Number of days between replies to repeat senders: '
i18n['vacation subject exp'] = 'Subject:'
i18n['vacation internal msg exp'] = 'The following text will be included in your vacation message to internal senders:'
i18n['vacation msg'] = 'This is an automatic reply. I am on vacation or otherwise unable to read my email. I will read your message when I return.\n\nThank you.'
i18n['vacation msg exp'] = 'The following text will be included in your vacation message to external senders. If no vacation message is specified for internal senders, the same text will be sent as your vacation message to the internal senders.'
i18n['startgreaterend'] = 'The end date should be at least one day later than the start date'
i18n['notBeforeToday'] = 'Please enter a date (a date from today\'s date forward is allowed)'
i18n['mdy']='Month, Day, Year'
i18n['dmy']='Day, Month, Year'
i18n['ymd']='Year, Month, Day'
i18n['noReplyIfNoText']= 'If vacation is enabled, the vacation reply text should not be empty.'
i18n['settings'] = 'Settings'
i18n['settings exp'] = 'Use this form to modify the behavior of Messenger Express.'
i18n['settings delete'] = 'Deleting Mail'
i18n['settings exit empty'] = 'Empty folder on logout'
i18n['settings delete imap'] = 'Mark messages deleted (use ' + i18n['expunge'] + ' to delete permanently)'
i18n['settings exit expunge'] = 'Remove deleted messages from Inbox on logout'
i18n['settings draft'] = 'Message Drafts'
i18n['settings sent'] = 'Sent Messages'
i18n['settings smime'] = 'Secure Messaging'
i18n['settings smime sign'] = 'Sign all outgoing Messages'
i18n['settings smime encrypt'] = 'Encrypt all outgoing Messages'
i18n['settings delivery'] = 'Mail Forwarding'
i18n['settings forward exp'] = 'Forward copies of new messages to (one address per line):'
i18n['settings forward enable'] = 'Enable forwarding'
i18n['settings no copy'] = 'Don\'t leave copy on server'
i18n['settings quote'] = 'Reply Quoting'
i18n['settings quote exp'] = 'Automatically quote original message when replying.'
i18n['appearance'] = 'Appearance'
i18n['appearance exp'] = 'Use this form to modify the look of Messenger Express.'
i18n['appearance colors'] = 'Color Scheme'
i18n['appearance colors spacer'] = '&nbsp; &nbsp; &nbsp;'
i18n['appearance bar'] = 'Toolbar'
i18n['appearance bar both'] = 'Show icons and text'
i18n['appearance bar icons'] = 'Show icons only'
i18n['appearance bar text'] = 'Show text only'
i18n['appearance page'] = 'Message List View'
i18n['appearance page exp'] = 'Show ' +
  '<select name="meViewSize"><option value="10">10</option>' +
  '<option value="20">20</option><option value="40">40</option>' +
  '<option value="60">60</option><option value="80">80</option>' +
  '<option value="100">100</option></select> messages per page'
i18n['appearance sort'] = 'Sort messages ' +
  '<select name="meSortOrder"><option value="F">Oldest First</option>' +
  '<option value="R">Oldest Last</option></select>'
i18n['appearance date exp'] = 'Date '
i18n['appearance date format exp'] = 'Format '+
  '<select name="meDateFormatFormat"><option value="0">' + i18n['mdy'] + '</option>' +
  '<option value="1">' + i18n['dmy'] + '</option>' +
  '<option value="2">' + i18n['ymd'] + '</option></select>'
i18n['appearance date delimiter exp'] = 'Delimiter '
i18n['appearance fonts'] = 'Display Font'
i18n['appearance fonts face'] = 'Face'
i18n['appearance fonts space'] = 'Spacing'
i18n['serif'] = 'Serif'
i18n['sans serif'] = 'Sans Serif'
i18n['mono'] = 'Mono'
i18n['appearance fonts size'] = 'Size'
i18n['appearance fonts xl'] = 'Largest'
i18n['appearance fonts l'] = 'Larger'
i18n['appearance fonts m'] = 'Default'
i18n['appearance fonts s'] = 'Smaller'
i18n['appearance fonts xs'] = 'Smallest'
i18n['submit changes'] = 'Save Changes'
i18n['not changed'] = 'No options have changed.'
i18n['success'] = 'Account Update Succeeded'
i18n['NDA'] = 'Delegated Administrator'
i18n['filters'] = 'Mail Filters'
i18n['loadingFilters'] = 'Loading Filters...'
i18n['InvalidMsgSizePrompt'] = 'Please enter the message size.'
i18n['InvalidMobileFwdPrompt'] = 'Invalid/no input data. Please re-enter.'
i18n['InvalidFilterNamePrompt'] = 'Please enter a valid filter name.'
i18n['DuplicateFilterPrompt'] = 'Duplicate filter name. Please enter a different name.'
i18n['InvalidSieveFormat'] = 'Invalid filter format. Please contact your help desk for support.'
i18n['No forwarding address'] = 'Please provide email address to forward';


function i18n_invalidemailaddress(addr) {
  alert('"' + addr + '"' +  'is invalid as email address')
}

// Alerts
i18n['js error'] = 'JavaScript Error'
i18n['line'] = 'Line'
i18n['login failed'] = 'Login failed'
i18n['timeout'] = 'Session timed out. Log in again'
i18n['FolderNameWithSpace'] = 'Folder name cannot be blank'
i18n['orphanwin'] = 'Window inactive, could not proceed'

// Time Arrays
var months = new Array('January', 'February', 'March', 'April', 'May', 'June',
  'July', 'August', 'September', 'October', 'November', 'December')
var days = new Array('Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday',
  'Friday', 'Saturday')

function i18n_time(d) {
  var i, s

  i = d.getHours()
  if (i >= 13)
    s = i - 12
  else
    s = i
  s += ':'
  if (d.getMinutes() < 10)
    s += '0'
  s += d.getMinutes()
  if (i < 12)
    s += ' am'
  else
    s += ' pm'
  return s
}

function i18n_update(d) {
  var i = d.getYear()

  if (i < 1000)
    i += 1900
  return days[d.getDay()] + ', ' + months[d.getMonth()] + ' ' + d.getDate() +
    ', ' + i + ' ' + i18n_time(d)
}

function i18n_compose_controls() {
  return '<table border=0 cellpadding=3 cellspacing=0>\n' +
    '<tr><td><input size=20 name=recipient></td>\n' +
    '<td nowrap>' + font() + 'As' + '</td>' +
    main.button(i18n['to'], 'parent.add(\'t\')') +
    main.button(i18n['cc'], 'parent.add(\'c\')') +
    main.button(i18n['bcc'], 'parent.add(\'b\')') +
    '</td></tr>\n</table>\n'
}

// LDAP lookup
function i18n_ldap_controls() {
  return '<table border=0 cellpadding=3 cellspacing=0 height=100%>\n' +
    '<tr><td colspan=4>' + font() +
    '<select name="dir">\n' +
    '<option value="3 200">Search the local directory</option>\n' +
    '<option value="3 200 ldap://memberdir.netscape.com/ou=member_directory,o=netcenter.com">' + 
    'Search Netscape Netcenter</option>\n' +
    //'<option value="3 40 ldap://ldap.bigfoot.com/">' +
    //'Search Bigfoot</option>\n' +
    '<option value="2 100 ldap://ldap.infospace.com/c=US">' +
    'Search InfoSpace</option>\n' +
    //'<option value="2 100 ldap://ldap.switchboard.com/c=US">' +
    //'Search Switchboard</option>\n' +
    '<option value="3 100 ldap://directory.verisign.com/">' +
    'Search Verisign</option>\n' +
    '<option value="2 100 ldap://ldap.whowhere.com/c=US">' +
    'Search WhoWhere</option>\n' +
    //'<option value="2 25 ldap://ldap.yahoo.com/">' +
    //'Search Yahoo!</option>\n' +
    '</select>\n' +
    font() + 'for people whose' + 
    '</td></tr>\n' +
    '<tr><td>' + font() +
    '<select name="attr">\n' +
    '<option value="cn">Full name</option>\n' +
    '<option value="givenname">First name</option>\n' +
    '<option value="sn">Last name</option>\n' +
    '<option value="mail">Email</option>\n' +
    '<option value="telephonenumber">Phone #</option>\n' +
    '</select>\n' +
    '</td>\n' +
    '<td>' + font() +
    '<select name="rule">\n' +
    '<option value="contains">contains</option>\n' +
    //'<option value="does not">does not contain</option>\n' +
    '<option value="equal">is</option>\n' +
    //'<option value="not equal">is not</option>\n' +
    '<option value="sound">sounds like</option>\n' +
    '<option value="begin">begins with</option>\n' +
    '<option value="end">ends with</option>\n' +
    '</select>\n' +
    '</td>\n' +
    '<td><input name="string">' + i18n['nbsp'] + '</td>\n' +
    main.button(i18n['search'], 'parent.doSearch()') +
    main.button(i18n['close'], 'parent.cancel()') +
    '</tr>\n' +
    '</table>\n'
}

function i18n_select_directory_options(what)
{
  if(what=='1')
    return '<SELECT class="ActMenu" name=dir><option value="3 200">Search Corporate Directory</option>\n'+
          '</SELECT>'+main.font() + '&nbsp;for users whose'

  else if(what=='2')
    return '<SELECT  class="ActMenu" name=dir><option value="3 200">Search Corporate Directory</option>\n'+
          main.cfgFrame.pabEnabled ? '<option value="3 200 1">Search Personal Address Book</option>\n' : '' +
          '</select>\n' +
          main.font() + 'for contacts or groups whose'
  else if(what=='3')
    return '<SELECT  class="ActMenu" name=dir><option>&#8212;&#8212;&nbsp;Select from Folders&nbsp;&#8212;&#8212;</option>'+
          (main.cfgFrame.pabEnabled ? '<option value="*">All Shared Folders</option>\n' : '') +
          (main.cfgFrame.pabEnabled ? '<option value="dir">Search Shared Folders by User</option>\n' : '') +
          '</select>&nbsp;&nbsp;&nbsp;' + main.nbutton('Go', ' Go ', "parent.subscribeOptions()") + '\n'
}

function i18n_ldap_no_match(attr, rule, value) {
  return 'No matches for contacts whose ' + attr.toLowerCase() + ' ' +
    rule.toLowerCase() + ' <b>' + html(value) + '</b>'
}

function i18n_ldap_match(end, attr, rule, value) {
  return end + ' Match' + (end == 1 ? '' : 'es') +
    ' for contacts whose ' + attr.toLowerCase() + ' ' + rule.toLowerCase() +
    ' <b>' + html(value) + '</b>'
}

function i18n_search_list() {
  var width1

  if(NN > 0) {
    width1 = win ? 12 : 25
  }
  else
    width1 = 30

  return '<table><tr valign="top"><td><img src="../imx/spacer.gif" width="17" height="1"></td>'+
     '<td nowrap>' + font() + 'Search ' +
    folderSelectionBreadCrumbs('srchfldrList', '', null, false, null, main.mboxFrame.mbox,main.cfgFrame.sub,'') + ' for messages where' +
    '</td>\n'+
    '<td>'+i18n['nbsp']+'</td>\n'+
    '</tr>\n' +
    '<tr valign="top"><td colspan="3"><IMG src="../imx/spacer.gif" width="1" height="9">'+
    '</td></tr>\n'+
    '<tr><td>'+i18n['nbsp']+'</td>\n'+ 
    '<td nowrap>'+ font() +
    '<select name="header">\n' +
    '<option value="FROM">Sender</option>\n' +
    '<option value="SUBJECT">Subject</option>\n' +
    '<option value="BODY">Body</option>\n' +
    '<option value="TO">Recipient</option>\n' +
    '</select>\n' +
    '<select name="rule">\n' +
    '<option value="">contains</option>\n' +
    '<option value="NOT ">does not contain</option>\n' +
    '</select>\n' +
    '<input type=text name="string">\n'+
    main.nbutton('search', i18n['search'], "parent.doSearch()") + '</td>\n'+
    '<td>'+i18n['nbsp']+'</td>\n'+
    '</tr></table>\n'
}

function i18n_settings_delete_trash(folder) {
  return 'Move deleted messages to ' + folder
}

function i18n_settings_draft_folder(folder) {
  return 'Keep message drafts in ' + folder
}

function i18n_settings_sent_folder(folder) {
  return 'When sending a message place a copy in ' + folder
}

function i18n_settings_wrap_width() {
  return 'Wrap messages at <input size=2 name="meWrapWidth"> characters'
}

function vc(attr, name, sz) {
  return '<tr><td align=right>' + font() + attr +
    ':</td>\n<td><input name=' + name + ' size=' + sz + '></td></tr>\n'
}

function i18n_personal_vcard() {
  return '<table border=0 cellpadding=3 cellspacing=0>\n' +
    '<tr><td></td><td>' + font() + '<input type=checkbox name=vcard>' +
    'Attach vCard to messages</td></tr>\n' +
    vc('First Name', 'nf', 32) +
    vc('Last Name', 'nl', 32) +
    vc('Full Name', 'fn', 32) +
    vc('Title', 'ti', 32) +
    vc('Organization', 'or', 32) +
    vc('Department', 'od', 32) +
    vc('Email', 'ei', 32) +
    vc('Home Page', 'ur', 32) +
    vc('Work Phone', 'tw', 14) +
    vc('Home Phone', 'th', 14) +
    vc('Fax', 'tf', 14) +
    vc('Pager', 'tp', 14) +
    vc('Cellular', 'tc', 14) +
    vc('Address', 'ad', 32) +
    vc('City', 'ci', 32) +
    vc('State', 'st', 32) +
    vc('Zip', 'zi', 32) +
    vc('Country', 'co', 32) +
    '</tr></table>\n'
}

function i18n_wrap(ln, ch, c, sep, maxchars) {
  return ''
}

function i18n_squote(str) {
  var c, i
  var s = ''

  if (str == null)
    return s
  for (i = 0; i < str.length; i++ ) {
    c = str.charAt(i)
    if (c == '\'')
      s += '\\\''
    else if (c == '\\')
      s += '\\\\'
    else if (c == '\t')
      s += '\\t'
    else
      s += c
  }
  return s
}

i18n['af']='Afrikaans'
i18n['ar']='Arabic'
i18n['ca']='Catalan'
i18n['zh-CN']='Chinese/Simplified'
i18n['zh-TW']='Chinese/Traditional'
i18n['cs']='Czech'
i18n['hr']='Croatian'
i18n['da']='Danish'
i18n['nl']='Dutch'
i18n['en']='English'
i18n['fi']='Finnish'
i18n['fr']='French'
i18n['gl']='Galician'
i18n['de']='German'
i18n['el']='Greek'
i18n['he']='Hebrew'
i18n['hu']='Hungarian'
i18n['is']='Icelandic'
i18n['ga']='Irish'
i18n['it']='Italian'
i18n['ja']='Japanese'
i18n['ko']='Korean'
i18n['no']='Norwegian'
i18n['pl']='Polish'
i18n['pt']='Portuguese'
i18n['ro']='Romanian'
i18n['sk']='Slovak'
i18n['sl']='Slovenian'
i18n['es']='Spanish'
i18n['sv']='Swedish'
i18n['th']='Thai'
i18n['tr']='Turkish'

function i18n_preferredlanguagelist()
{
  var lang_list = new Array('af','ar','ca','zh-CN','zh-TW','cs','hr','da','nl',
      'en','fi','fr','gl','de','el','he','hu','is','ga','it','ja','ko','no','pl',
      'pt','ro','sk','sl','es','sv','th','tr')
  var s = '<select name="preferredLanguage">'
  for (i=0; i<lang_list.length; i++)
    s+='<option value="'+ lang_list[i] + '">' + i18n[lang_list[i]] + '</option>'
  return s+'</select>'
}

function i18n_search_options()
{
  var s = '<select name="attr" size="1">' +
        '<option value="cn">Full name</option>' +
        '<option value="givenname">First name</option>' +
        '<option value="sn">Last name</option>' +
        '<option value="mail">Email</option>' +
        '<option value="uid">User ID</option>' +
        '<option value="telephonenumber">Phone #</option>\n' +
        '</select>' +
        '&nbsp;&nbsp;<select name="rule">' +
        '<option value="contains">contains</option>' +
        '<option value="equal">is</option>\n' +
        '<option value="begin">begins with</option>\n' +
        '<option value="sound">sounds like</option>' +
        '<option value="end">ends with</option>' +
        '</select>'
  return s
}

function i18n_month_list()
{
  var s=''
  for(i=0;i<12;i++){
    s=s+'<option value="'+i+'">'+months[i]+'</option>'
  }
  return s
}

function getImportedMessage(num) {
  return 'Imported ' + num + ' entries'
}

function i18n_day_list()
{
  var s=''
  for(i=1;i<32;i++){
    s=s+'<option value="'+(i-1)+'">'+i+'</option>'
  }
  return s
}

function i18n_year_list()
{
  var s=''
  var d= new Date()
  var year=d.getYear()

  for(i=year;i<year+4;i++){
    s=s+'<option name="'+i+'" value="'+i+'">'+i+'</option>'
  }
  return s
}

// Personal Address Book (PAB)
i18n['default PAB'] = 'Address Book'
i18n['list indent'] = '- '
i18n['scl sep'] = '______________________________'
i18n['Current Folder'] = 'Current Folder'
i18n['Mail'] = 'Mail'
i18n['Calendar'] = 'Calendar'
i18n['Options'] = 'Options'
i18n['Address Book'] = 'Address Book'
i18n['Word'] = 'Word'

//RTF tool bar
function i18n_rtf_options() {
  return '<select size="1" style="display: none" id="rtf_block" name="block" ' +
  'onChange="execute(\'formatBlock\',\'\' ,this.value);this.selectedIndex=0">'+
  '<option value="" selected>' + i18n['Block Format'] + '</option>'+
  '<option value="Normal">Normal</option>'+
  '<option value="Paragraph">Paragraph</option>'+
  '<option value="&lt;H1&gt;">Heading 1</option>'+
  '<option value="&lt;H2&gt;">Heading 2</option>'+
  '<option value="&lt;H3&gt;">Heading 3</option>'+
  '<option value="&lt;H4&gt;">Heading 4</option>'+
  '<option value="&lt;H5&gt;">Heading 5</option>'+
  '<option value="&lt;H6&gt;">Heading 6</option>'+
  '</select>&nbsp;&nbsp;&nbsp;'+
  '<select size="1" style="display: none" id="rtf_fname" name="fname" ' +
  'onChange="execute(\'FontName\',\'\',this.value);this.selectedIndex=0">;'+
  '<option selected>'+i18n['FontnameLabel']+'</option>'+
  '<option value="Times">Times</option>'+
  '<option value="Helvetica">Helvetica</option>'+
  '<option value="Western">Western</option>'+
  '<option value="Courier">Courier</option>'+
  '<option value="serif">Serif</option>'+
  '<option value="sans-serif">Sans-Serif</option>'+
  '<option value="Arial">Arial</option>'+
  '<option value="cursive">Cursive</option>'+ '&nbsp;'+
  '</select>&nbsp;&nbsp;&nbsp;'+ 
  '<select size="1" style="display: none" id="rtf_fsize" name="fsize" ' +
  'onChange="execute(\'FontSize\',\'\',this.value);this.selectedIndex=0"">' +
  '<option selected>'+i18n['FontsizeLabel']+'</option>'+
  '<option value="1">1</option>'+
  '<option value="2">2</option>'+
  '<option value="3">3</option>'+
  '<option value="4">4</option>'+
  '<option value="5">5</option>'+
  '<option value="6">6</option>'+
  '<option value="7">7</option>'+
  '</select>'
}

i18n['contain'] = 'contains'
i18n['not contain'] = 'does not contains'
i18n['match all'] = 'Match all of the following'
i18n['match any'] = 'Match any of the following'
i18n['for messages where'] = 'for messages where'
i18n['sub or sender'] = 'Quick Search'
i18n['of'] = 'of' 
i18n['manage folders'] = 'Manage Folders'
i18n['Showing'] = 'Showing'
i18n['attachment_help_header'] = "Attachment Help"
i18n['attachment_help'] = "Attachment Help"
i18n['onbehalf'] = "; on behalf of; "
