/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.smime.security.fedcard;

import com.sun.messaging.smime.applet.AppletLogger;
import com.sun.messaging.smime.security.cardapi.CardAdmin;
import com.sun.messaging.smime.security.cardapi.CardException;
import com.sun.messaging.smime.security.cardapi.CardReader;
import com.sun.messaging.smime.security.cardapi.CardToken;
import com.sun.messaging.smime.security.fedcard.FedReader;
import java.security.InvalidKeyException;
import java.security.SignatureException;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Hashtable;
import javax.crypto.BadPaddingException;

public class FedToken
extends CardToken {
    private final FedReader a;
    private Hashtable b;
    private CardAdmin c;

    public byte[] decrypt(X509Certificate encryptionCert, String algorithm, byte[] encryptedData) throws CardException, InvalidKeyException, BadPaddingException {
        String uniqueId = encryptionCert.getIssuerDN().getName() + encryptionCert.getSerialNumber().toString();
        AppletLogger.log("CardApi: Decrypting with cert: " + encryptionCert.getSubjectDN().getName() + " " + encryptionCert.getSerialNumber().toString());
        CardReader reader = (CardReader)this.b.get(uniqueId);
        if (reader == null) {
            AppletLogger.log("CardApi: Cannot find reader that has: " + encryptionCert.getSubjectDN().getName() + " " + encryptionCert.getSerialNumber().toString());
            throw new CardException("Cannot find the reader of the credential.");
        }
        AppletLogger.log("CardApi: find reader");
        CardToken token = reader.getToken();
        if (token != null && token.isValid()) {
            AppletLogger.log("CardApi: Decrypting with provider: " + token.getProviderName());
            return token.decrypt(encryptionCert, algorithm, encryptedData);
        }
        AppletLogger.log("CardApi: No valid token");
        throw new CardException("No valid token");
    }

    public X509Certificate[] getUserCertificates(X509CertSelector selector, String providerName) throws CardException {
        String uniqueId;
        int j;
        X509Certificate[] certs;
        CardToken tk;
        int i;
        if (providerName == null || providerName.length() == 0) {
            throw new CardException("Invalid provider name");
        }
        AppletLogger.log("CardApi: Prefered token provider: " + providerName);
        Hashtable<String, X509Certificate> userCerts = new Hashtable<String, X509Certificate>(1);
        CardReader[] readers = this.a.a();
        AppletLogger.log("CardApi: Readers: " + readers.length);
        for (i = 0; i < readers.length; ++i) {
            tk = readers[i].getToken();
            if (tk == null || !tk.getProviderName().equals(providerName) || tk == null || !tk.isValid()) continue;
            AppletLogger.log("CardApi: Retrieving user certs from: " + tk.getProviderName());
            certs = tk.getUserCertificates();
            for (j = 0; j < certs.length; ++j) {
                if (!selector.match(certs[j]) || userCerts.containsKey(uniqueId = certs[j].getIssuerDN().getName() + certs[j].getSerialNumber().toString())) continue;
                userCerts.put(uniqueId, certs[j]);
                this.b.put(uniqueId, readers[i]);
                AppletLogger.log("CardApi: Got cert: " + certs[j].getSubjectDN().getName() + " " + certs[j].getSerialNumber().toString());
            }
        }
        if (userCerts.size() > 0) {
            return userCerts.values().toArray(new X509Certificate[0]);
        }
        for (i = 0; i < readers.length; ++i) {
            tk = readers[i].getToken();
            if (tk == null || !tk.isValid() || tk.getProviderName().equals(providerName)) continue;
            AppletLogger.log("CardApi: Retrieving user certs from: " + tk.getProviderName());
            certs = tk.getUserCertificates();
            for (j = 0; j < certs.length; ++j) {
                if (!selector.match(certs[j]) || userCerts.containsKey(uniqueId = certs[j].getIssuerDN().getName() + certs[j].getSerialNumber().toString())) continue;
                userCerts.put(uniqueId, certs[j]);
                this.b.put(uniqueId, readers[i]);
                AppletLogger.log("CardApi: Got cert: " + certs[j].getSubjectDN().getName() + " " + certs[j].getSerialNumber().toString());
            }
        }
        if (userCerts.size() > 0) {
            return userCerts.values().toArray(new X509Certificate[0]);
        }
        return new X509Certificate[0];
    }

    public void registerCardAdmin(CardAdmin admin) {
        this.c = admin;
    }

    public boolean isValid() throws CardException {
        boolean isValid = false;
        CardReader[] readers = this.a.a();
        for (int i = 0; i < readers.length; ++i) {
            CardToken tk = readers[i].getToken();
            if (tk == null || !tk.isValid()) continue;
            isValid = true;
            break;
        }
        return isValid;
    }

    public X509Certificate[] getCertificateChain(X509Certificate cert) throws CardException {
        String uniqueId = cert.getIssuerDN().getName() + cert.getSerialNumber().toString();
        CardReader reader = (CardReader)this.b.get(uniqueId);
        if (reader == null) {
            throw new CardException("Cannot find the reader of the credential.");
        }
        CardToken token = reader.getToken();
        if (token != null && token.isValid()) {
            return token.getCertificateChain(cert);
        }
        throw new CardException("The credential has been removed");
    }

    public X509Certificate[] getTrustedCertificates(String providerName) throws CardException {
        throw new CardException("This method has not been implemented in FedToken. TODO!");
    }

    public X509Certificate[] getUserCertificates() throws CardException {
        AppletLogger.log("CardApi: Retrieving all user certs");
        Hashtable<String, X509Certificate> allCerts = new Hashtable<String, X509Certificate>(3);
        CardReader[] readers = this.a.a();
        AppletLogger.log("CardApi: Readers: " + readers.length);
        for (int i = 0; i < readers.length; ++i) {
            CardToken tk = readers[i].getToken();
            if (tk == null || !tk.isValid()) continue;
            AppletLogger.log("CardApi: Retrieving user certs from: " + tk.getProviderName());
            X509Certificate[] certs = tk.getUserCertificates();
            for (int j = 0; j < certs.length; ++j) {
                String uniqueId = certs[j].getIssuerDN().getName() + certs[j].getSerialNumber().toString();
                if (allCerts.containsKey(uniqueId)) continue;
                allCerts.put(uniqueId, certs[j]);
                this.b.put(uniqueId, readers[i]);
                AppletLogger.log("CardApi: Got cert: " + certs[j].getSubjectDN().getName() + " " + certs[j].getSerialNumber().toString());
            }
        }
        return allCerts.values().toArray(new X509Certificate[0]);
    }

    public X509Certificate[] getTrustedCertificates() throws CardException {
        throw new CardException("This method has not been implemented in FedToken. TODO!");
    }

    public byte[] sign(X509Certificate signatureCert, String algorithm, byte[] hash) throws CardException, InvalidKeyException, SignatureException, BadPaddingException {
        String uniqueId = signatureCert.getIssuerDN().getName() + signatureCert.getSerialNumber().toString();
        AppletLogger.log("CardApi: Signing with cert: " + signatureCert.getSubjectDN().getName() + " " + signatureCert.getSerialNumber().toString());
        CardReader reader = (CardReader)this.b.get(uniqueId);
        if (reader == null) {
            AppletLogger.log("CardApi: Cannot find reader that contains: " + signatureCert.getSubjectDN().getName() + " " + signatureCert.getSerialNumber().toString());
            throw new CardException("Cannot find the reader of the credential.");
        }
        AppletLogger.log("CardApi: find reader");
        CardToken token = reader.getToken();
        if (token != null && token.isValid()) {
            AppletLogger.log("CardApi: Signing with provider: " + token.getProviderName());
            return token.sign(signatureCert, algorithm, hash);
        }
        AppletLogger.log("CardApi: No valid token");
        throw new CardException("No valid token");
    }

    FedToken(FedReader reader) throws CardException {
        super("FED");
        this.a = reader;
        this.b = new Hashtable(4);
    }

    public void shutdown() throws CardException {
        this.a.shutdown();
    }

    public String getProviderName(X509Certificate cert) throws CardException {
        String uniqueId = cert.getIssuerDN().getName() + cert.getSerialNumber().toString();
        CardReader reader = (CardReader)this.b.get(uniqueId);
        CardToken token = reader.getToken();
        return token.getProviderName();
    }
}

