/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.smime.applet;

import com.sun.messaging.smime.applet.AppletConstants;
import com.sun.messaging.smime.applet.AppletLogger;
import com.sun.messaging.smime.applet.AppletParameters;
import com.sun.messaging.smime.applet.LDAPPasswordCrypto;
import com.sun.messaging.smime.applet.SMIMEAppletAPI;
import com.sun.messaging.smime.applet.X509CertWrapper;
import com.sun.messaging.smime.applet.util.Base64;
import java.applet.Applet;
import java.awt.Color;
import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;

public abstract class SMIMEAppletBase
extends Applet {
    protected String m_loginpw = "";
    protected boolean m_bDoSmtpsAuth = false;
    protected static final int SEND_SMTPS = 1;
    protected String m_crlRequestURL = null;
    protected int m_nLastErrorNumber = 0;
    protected String m_OCSPRequestURL = null;
    protected boolean m_bFinalInitializationDone = false;
    protected String m_strSMTPServer = null;
    protected long maxMessageSize = 2000000L;
    protected int m_iTSDelta = 0;
    protected static final int SEND_HTTPS = 3;
    protected int m_nlastUID = -1;
    protected String m_strSendURL = null;
    protected Vector m_vTrustedLdapServer = null;
    protected String m_smtpLoginStr = "";
    protected C038 m_ldapTrusted = null;
    protected int m_sendMethod = 0;
    protected Vector m_vCertLdapServer = null;
    protected String m_wmapSid = null;
    protected boolean m_bInBrowser;
    protected String m_strLDAP = null;
    protected Image m_image = null;
    protected String m_certRequestURL = null;
    protected String m_strLastErrorMsgText = "";
    protected C027 m_certVerify = null;
    protected boolean m_bUseLDAP = false;
    protected int m_nSMTPPort = 25;
    protected String userCertFilter;
    protected static final int SEND_HTTP = 2;
    protected boolean m_bLogging = false;
    private Hashtable a;
    protected String m_cookie = null;
    public static SimpleDateFormat[] g_DateFormats = new SimpleDateFormat[]{new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z")};
    protected long maxPostSize = 2000000L;
    protected String m_logindn = "";
    protected Vector m_vNonAuthDomains = new Vector();
    protected static final int SEND_SMTP = 0;

    public int verifyCertificate(C045 toVerify, boolean bVerify, boolean bCRLCheck, String sEmail, Date dateMsg) {
        int iVerified = 0;
        try {
            if (sEmail != null) {
                String sCertAddr = X509CertWrapper.getSubjectAltName(toVerify.i(), 1);
                if (sCertAddr == null || sCertAddr.length() == 0) {
                    sCertAddr = X509CertWrapper.getSubjectDNValue(toVerify.i(), "EMAILADDRESS|E");
                }
                if (!sEmail.equalsIgnoreCase(sCertAddr)) {
                    iVerified = 7;
                }
            }
            if (iVerified == 0 && (bVerify || bCRLCheck)) {
                if (this.m_certVerify == null) {
                    this.m_certVerify = new C090();
                    this.m_certVerify.b(bVerify);
                    if (bCRLCheck) {
                        this.m_certVerify.f(this.getCRLChecker());
                    }
                    if (this.m_ldapTrusted == null) {
                        if (this.m_bUseLDAP) {
                            Enumeration e = this.m_vTrustedLdapServer.elements();
                            while (e.hasMoreElements()) {
                                String strTrusted = (String)e.nextElement();
                                this.m_ldapTrusted = new C022(strTrusted, this.m_logindn, this.m_loginpw);
                            }
                        } else {
                            this.m_ldapTrusted = C022.a();
                        }
                    }
                    this.m_certVerify.o(this.m_ldapTrusted);
                } else {
                    this.m_certVerify.b(bVerify);
                    if (bCRLCheck) {
                        this.m_certVerify.f(this.getCRLChecker());
                    } else {
                        this.m_certVerify.f(null);
                    }
                }
                AppletLogger.log("isCertificateVerified: extracting info");
                iVerified = this.m_certVerify.n(toVerify, dateMsg);
            }
        }
        catch (Exception exp) {
            AppletLogger.log(exp);
            AppletLogger.log("verifyCertificate: caught exception: verify cert failed: " + sEmail + " message: " + exp.getMessage());
            this.setError(AppletConstants.ERR_CERT_VERIFY, exp.getMessage());
            iVerified = 3;
        }
        return iVerified;
    }

    protected void addtoCache(String sEmail, X509Certificate[] arrCerts) {
        if (arrCerts == null) {
            AppletLogger.log("addtoCache: caching no Certificates for " + sEmail);
        } else {
            AppletLogger.log("addtoCache: caching " + arrCerts.length + " Certificates for " + sEmail);
            this.a.put(sEmail, arrCerts);
        }
    }

    protected void setLastUID(int nUID) {
        this.m_nlastUID = nUID;
    }

    protected void setImage(Image newImage) {
        this.m_image = newImage;
    }

    protected abstract Applet getOwner();

    public void resetError() {
        this.m_nLastErrorNumber = 0;
        this.m_strLastErrorMsgText = null;
    }

    protected X509Certificate[] lookupCertLDAP(String sEmail) throws AddressException, CertificateException {
        C016 ldap = new C016(true, true, this.m_logindn, this.m_loginpw);
        ldap.h(this.m_vCertLdapServer);
        ldap.g(this.m_vTrustedLdapServer);
        ldap.k(null);
        ldap.e(false);
        ldap.f(this.userCertFilter);
        InternetAddress inetAddress = new InternetAddress(sEmail);
        List listCerts = ldap.i(inetAddress.getAddress(), this.m_crlRequestURL);
        X509Certificate[] arrCerts = null;
        if (listCerts == null || listCerts.size() == 0) {
            this.m_nLastErrorNumber = ldap.b();
            this.m_strLastErrorMsgText = ldap.c();
        } else {
            arrCerts = new X509Certificate[listCerts.size()];
            for (int idx = 0; idx < listCerts.size(); ++idx) {
                C045 cert = (C045)listCerts.get(idx);
                arrCerts[idx] = cert.i();
            }
        }
        if (ldap.b() != 0) {
            this.m_nLastErrorNumber = ldap.b();
            this.m_strLastErrorMsgText = ldap.c();
        }
        return arrCerts;
    }

    protected Date getMessageTime(C047 msg) {
        Date dateMsg = null;
        Date dateSent = msg.c();
        Date dateReceived = msg.H();
        if (dateSent != null && dateReceived != null) {
            Date dateDiff;
            dateMsg = this.m_iTSDelta == 0 ? dateReceived : ((dateDiff = new Date(dateReceived.getTime() - (long)(this.m_iTSDelta * 1000))).before(dateSent) ? dateSent : dateReceived);
        }
        return dateMsg;
    }

    public boolean validateAppletParams() {
        boolean bValid = false;
        this.m_nLastErrorNumber = 0;
        this.m_strLastErrorMsgText = "";
        StringBuffer bufMissing = new StringBuffer();
        if (this.m_strSendURL == null || this.m_strSendURL.length() == 0) {
            bufMissing.append("SMIMEAppletAPI.PARAM_SENDURL param is required ");
        }
        switch (this.m_sendMethod) {
            case 0: 
            case 1: {
                if (this.m_wmapSid == null || this.m_wmapSid.length() <= 0) break;
                AppletLogger.log("SMIMEAppletAPI.PARAM_WMAPSID will be ignored SMTP(S) send method");
                break;
            }
            case 2: 
            case 3: {
                if (this.m_wmapSid == null || this.m_wmapSid.length() == 0) {
                    bufMissing.append("\n SMIMEAppletAPI.PARAM_WMAPSID is required for HTTP(S) send method");
                }
                if (this.m_bDoSmtpsAuth) {
                    AppletLogger.log("SMIMEAppletAPI.PARAM_SMTPAUTH will be ignored HTTP(S) send method");
                }
                if (this.m_vNonAuthDomains.size() <= 0) break;
                AppletLogger.log("SMIMEAppletAPI.PARAM_SMTPNOAUTH will be ignored HTTP(S) send method");
                break;
            }
            default: {
                bufMissing.append("\n SMIMEAppletAPI.PARAM_SENDMETHOD param is required ");
            }
        }
        if (this.m_strLDAP == null || this.m_strLDAP.length() == 0) {
            bufMissing.append("\n SMIMEAppletAPI.PARAM_LDAP param is required ");
        }
        if (bufMissing.length() > 0) {
            this.setError(AppletConstants.ERR_CFG_ERROR, bufMissing.toString());
        } else {
            bValid = true;
        }
        return bValid;
    }

    protected void setError(int nError, String sError) {
        AppletLogger.log(sError);
        this.m_nLastErrorNumber = nError;
        this.m_strLastErrorMsgText = sError;
    }

    protected X509Certificate[] getCachedCerts(String sEmail) {
        return (X509Certificate[])this.a.get(sEmail);
    }

    protected boolean readLdapIni() {
        this.resetError();
        boolean bOK = true;
        AppletLogger.log("Begin readLdapIni");
        if (this.m_strLDAP == null || this.m_strLDAP.length() == 0) {
            this.setError(AppletConstants.ERR_LDAP_CFG);
            bOK = false;
        } else {
            try {
                ArrayList<SimpleDateFormat> listTimeFormats = new ArrayList<SimpleDateFormat>();
                URL smimeConfURL = new URL(this.m_strLDAP);
                URLConnection urlConn = null;
                if (smimeConfURL.getProtocol().equalsIgnoreCase("https")) {
                    short port = AppletParameters.getInstance().getWmapSSLPort();
                    URL sslURL = new URL("https", smimeConfURL.getHost(), port, smimeConfURL.getFile());
                    SSLSocketFactory factory = C039.l().k(smimeConfURL.getHost());
                    HttpsURLConnection sslConn = (HttpsURLConnection)sslURL.openConnection();
                    sslConn.setSSLSocketFactory(factory);
                    urlConn = sslConn;
                } else {
                    urlConn = smimeConfURL.openConnection();
                }
                BufferedReader in = new BufferedReader(new InputStreamReader(urlConn.getInputStream()));
                String strLine = in.readLine();
                while (strLine != null) {
                    if ((strLine = strLine.trim()).length() > 0 && strLine.charAt(0) != '#') {
                        int index = strLine.indexOf("==");
                        if (index == -1) {
                            this.setError(AppletConstants.ERR_LDAP_CFG_LINE, strLine);
                            bOK = false;
                            break;
                        }
                        String identifier = strLine.substring(0, index).trim();
                        String strValue = strLine.substring(index + 2, strLine.length()).trim();
                        AppletLogger.log("Evaluating Tokens [" + identifier + "][" + strValue + "]");
                        if (identifier.equalsIgnoreCase("certurl")) {
                            String strLdap = strValue;
                            AppletLogger.log("readLdapIni: Adding LDAP Server string: " + strLdap);
                            if (this.m_vCertLdapServer == null) {
                                this.m_vCertLdapServer = new Vector();
                            }
                            this.m_vCertLdapServer.addElement(strLdap);
                        } else if (identifier.equalsIgnoreCase("logindn")) {
                            this.m_logindn = strValue;
                        } else if (identifier.equalsIgnoreCase("loginpw")) {
                            try {
                                LDAPPasswordCrypto pwCrypto = new LDAPPasswordCrypto();
                                this.m_loginpw = pwCrypto.d(strValue);
                            }
                            catch (Exception exp) {
                                this.setError(AppletConstants.ERR_LDAP_CFG_PW);
                                bOK = false;
                            }
                        } else if (identifier.equalsIgnoreCase("usercertfilter")) {
                            this.userCertFilter = strValue;
                        } else if (identifier.equalsIgnoreCase("timestampdelta")) {
                            try {
                                this.m_iTSDelta = Integer.parseInt(strValue);
                            }
                            catch (NumberFormatException exp) {
                                this.setError(AppletConstants.ERR_LDAP_CFG_TSDELTA);
                                this.m_iTSDelta = 0;
                                bOK = false;
                            }
                        } else if (identifier.equalsIgnoreCase("timeformat")) {
                            try {
                                SimpleDateFormat sdf = new SimpleDateFormat(strValue);
                                listTimeFormats.add(sdf);
                            }
                            catch (IllegalArgumentException exp) {
                                this.setError(AppletConstants.ERR_LDAP_CFG_TIME);
                                bOK = false;
                            }
                        } else {
                            AppletLogger.log("readLdapIni: Unrecognized line in smime.conf");
                        }
                    }
                    strLine = in.readLine();
                }
                in.close();
                if (listTimeFormats.size() > 0) {
                    listTimeFormats.addAll(Arrays.asList(g_DateFormats));
                    g_DateFormats = listTimeFormats.toArray(new SimpleDateFormat[listTimeFormats.size()]);
                }
            }
            catch (C041 e) {
                this.setError(AppletConstants.ERR_LDAP_CFG_IO, e.getMessage());
                AppletLogger.log(e);
                bOK = false;
            }
            catch (IOException ioe) {
                this.setError(AppletConstants.ERR_LDAP_CFG_IO, ioe.getMessage());
                AppletLogger.log(ioe);
                bOK = false;
            }
        }
        if (this.m_vTrustedLdapServer == null || this.m_vTrustedLdapServer.size() == 0) {
            this.setError(AppletConstants.ERR_LDAP_CFG_IO, "No trusted cert URL");
            bOK = false;
        }
        if (this.m_vCertLdapServer == null || this.m_vCertLdapServer.size() == 0) {
            this.setError(AppletConstants.ERR_LDAP_CFG_IO, "No LDAP URL for encryption cert retrieval");
            bOK = false;
        }
        if (!(this.m_vTrustedLdapServer != null && this.m_vTrustedLdapServer.size() != 0 || this.m_vCertLdapServer != null && this.m_vCertLdapServer.size() != 0)) {
            this.setError(AppletConstants.ERR_LDAP_CFG_IO, "No trusted cert URL; No LDAP URL for encryption cert retrieval");
            bOK = false;
        }
        return bOK;
    }

    public int getLastUID() {
        return this.m_nlastUID;
    }

    protected X509Certificate[] lookupCertWMAP(String sEmail) throws AddressException, CertificateException {
        C066 wmap = new C066(this.m_certRequestURL, this.m_wmapSid);
        InternetAddress inetAddress = new InternetAddress(sEmail);
        List listCerts = null;
        C023 clist = null;
        X509Certificate[] arrCerts = null;
        for (int i = 0; i < 3; ++i) {
            try {
                clist = wmap.o(inetAddress.getAddress(), "certUsage");
                break;
            }
            catch (Exception exp) {
                AppletLogger.log("Cert request attempt:" + i);
                AppletLogger.log("Failed to get response from server:" + exp);
                try {
                    Thread.currentThread();
                    Thread.sleep(1000L);
                }
                catch (InterruptedException exp2) {
                    AppletLogger.log("in lookupCertWMAP:" + exp2);
                }
                continue;
            }
        }
        try {
            if (clist == null) {
                clist = wmap.o(inetAddress.getAddress(), "certUsage");
            }
            listCerts = clist.a();
            if (clist.e() != -1) {
                this.m_nLastErrorNumber = clist.e();
                this.m_strLastErrorMsgText = clist.f();
                AppletLogger.log("WMAP error in lookupCertWMAP for " + sEmail + " :  " + this.m_strLastErrorMsgText);
            }
            if (listCerts != null && listCerts.size() > 0) {
                arrCerts = new X509Certificate[listCerts.size()];
                for (int idx = 0; idx < listCerts.size(); ++idx) {
                    String cstr = (String)listCerts.get(idx);
                    byte[] bits = Base64.b(cstr);
                    C045 cert = new C045(bits);
                    arrCerts[idx] = cert.i();
                }
            }
        }
        catch (Exception exp) {
            AppletLogger.log(exp);
        }
        return arrCerts;
    }

    public boolean setAppletParameter(String sParam, String sValue) {
        boolean bOK;
        block76: {
            bOK = false;
            AppletLogger.log("Set Applet param " + sParam + " = " + sValue);
            if (this.m_bFinalInitializationDone) {
                AppletLogger.log("Set Applet param called after Final Initialization: cmd ignored");
                return bOK;
            }
            if (sValue != null) {
                if ("wmap.sid".equalsIgnoreCase(sParam)) {
                    this.m_wmapSid = sValue;
                    C039.l().t(sValue);
                    bOK = true;
                } else if ("mail.sendmethod".equalsIgnoreCase(sParam)) {
                    if (sValue != null) {
                        if (sValue.equalsIgnoreCase("smtp")) {
                            this.m_sendMethod = 0;
                            AppletLogger.log("Send method smtp");
                        } else if (sValue.equalsIgnoreCase("smtps")) {
                            this.m_sendMethod = 1;
                            AppletLogger.log("Send method http");
                        } else if (sValue.equalsIgnoreCase("http")) {
                            this.m_sendMethod = 2;
                            AppletLogger.log("Send method https");
                        } else if (sValue.equalsIgnoreCase("https")) {
                            this.m_sendMethod = 3;
                            AppletLogger.log("Send method smtps");
                        } else {
                            AppletLogger.log("Unknown send method");
                            throw new NullPointerException("No mail.sendmethod parameter defined.");
                        }
                    }
                    bOK = true;
                } else {
                    if ("mail.sendurl".equalsIgnoreCase(sParam)) {
                        this.m_strSendURL = sValue;
                        bOK = true;
                        try {
                            if (this.m_strSendURL.indexOf(58) >= 0) {
                                int colon = this.m_strSendURL.indexOf(58);
                                String strSMTPPort = this.m_strSendURL.substring(colon + 1);
                                AppletLogger.log("init: SMTP Port is " + strSMTPPort);
                                this.m_nSMTPPort = Integer.parseInt(strSMTPPort);
                                this.m_strSMTPServer = this.m_strSendURL.substring(0, colon);
                                AppletLogger.log("init: SMTP Server is " + this.m_strSendURL);
                                break block76;
                            }
                            this.m_nSMTPPort = 25;
                            this.m_strSMTPServer = this.m_strSendURL;
                        }
                        catch (Exception exp) {
                            if (this.m_sendMethod == 1 || this.m_sendMethod == 0) {
                                AppletLogger.log(exp);
                                bOK = false;
                            }
                            break block76;
                        }
                    }
                    if ("smtpauth".equalsIgnoreCase(sParam)) {
                        this.m_bDoSmtpsAuth = Boolean.valueOf(sValue);
                        if (this.m_bDoSmtpsAuth) {
                            this.m_smtpLoginStr = new String("");
                        }
                        bOK = true;
                    } else if ("smtp.nonauth".equalsIgnoreCase(sParam)) {
                        this.m_vNonAuthDomains.clear();
                        if (sValue != null && !sValue.equalsIgnoreCase("none")) {
                            if (sValue.indexOf(",") >= 0) {
                                StringTokenizer tokens = new StringTokenizer(sValue, ",");
                                while (tokens.hasMoreTokens()) {
                                    String sToken = tokens.nextToken().trim();
                                    if (sToken.length() <= 0) continue;
                                    AppletLogger.log("init: SMTP No auth for  " + sToken);
                                    this.m_vNonAuthDomains.add(sToken);
                                }
                            } else if (sValue.trim().length() > 0) {
                                AppletLogger.log("init: SMTP No auth for  " + sValue);
                                this.m_vNonAuthDomains.add(sValue);
                            }
                        } else {
                            AppletLogger.log("init: SMTP auth for all domains");
                        }
                        bOK = true;
                    } else if ("ldap".equalsIgnoreCase(sParam)) {
                        this.m_strLDAP = sValue;
                        bOK = true;
                    } else if ("logging".equalsIgnoreCase(sParam)) {
                        this.m_bLogging = Boolean.valueOf(sValue);
                        AppletLogger.setLogging(this.m_bLogging);
                        System.out.println("logging = " + this.m_bLogging);
                        bOK = true;
                    } else if ("crl.request.url".equalsIgnoreCase(sParam)) {
                        this.m_crlRequestURL = sValue;
                        C039.l().q(sValue);
                        bOK = true;
                    } else if ("cert.request.url".equalsIgnoreCase(sParam)) {
                        this.m_certRequestURL = sValue;
                        C039.l().p(sValue);
                        bOK = true;
                    } else if ("ocsp.request.url".equalsIgnoreCase(sParam)) {
                        this.m_OCSPRequestURL = sValue;
                        C039.l().s(sValue);
                        bOK = true;
                    } else if ("service.http.maxpostsize".equalsIgnoreCase(sParam)) {
                        this.maxPostSize = Long.parseLong(sValue);
                        bOK = true;
                    } else if ("service.http.maxmessagesize".equalsIgnoreCase(sParam)) {
                        this.maxMessageSize = Long.parseLong(sValue);
                        bOK = true;
                    } else if ("service.http.sslport".equalsIgnoreCase(sParam)) {
                        AppletParameters.getInstance().setWmapSSLPort(Short.parseShort(sValue));
                        bOK = true;
                    } else if ("local.webmail.smime.crl.checkoverssl".equalsIgnoreCase(sParam)) {
                        if (sValue.equals("0") || sValue.equalsIgnoreCase("false")) {
                            AppletParameters.getInstance().setCrlCheckOrverSSL(false);
                        } else {
                            AppletParameters.getInstance().setCrlCheckOrverSSL(true);
                        }
                        bOK = true;
                    } else if ("applet.login.prompt".equalsIgnoreCase(sParam)) {
                        SMIMEAppletAPI.PINDialog.g = sValue;
                        bOK = true;
                    } else if ("applet.login.accept".equalsIgnoreCase(sParam)) {
                        SMIMEAppletAPI.PINDialog.h = sValue;
                        bOK = true;
                    } else if ("applet.login.cancel".equalsIgnoreCase(sParam)) {
                        SMIMEAppletAPI.PINDialog.k = sValue;
                        bOK = true;
                    } else if ("applet.trust.ssl.rootca".equalsIgnoreCase(sParam)) {
                        if (sValue != null && sValue.length() > 0) {
                            StringTokenizer tokens = new StringTokenizer(sValue, ";");
                            X509Certificate[] cacerts = new X509Certificate[tokens.countTokens()];
                            int certIndex = 0;
                            bOK = true;
                            while (tokens.hasMoreTokens()) {
                                String certStr = (String)tokens.nextElement();
                                byte[] bits = Base64.b(certStr);
                                ByteArrayInputStream in = new ByteArrayInputStream(bits);
                                BufferedInputStream inStream = new BufferedInputStream(in);
                                X509Certificate cert = null;
                                try {
                                    CertificateFactory cf = CertificateFactory.getInstance("X.509");
                                    cert = (X509Certificate)cf.generateCertificate(inStream);
                                }
                                catch (Exception e) {
                                    AppletLogger.log("SSL Root Certs: Cannot read root cert[" + certIndex + "] " + e);
                                    bOK = false;
                                }
                                cacerts[certIndex++] = cert;
                            }
                            C039.l().b(cacerts);
                            AppletLogger.log("SSL Root Certs: " + certIndex + " SSL certificates detected");
                        }
                    } else if ("applet.trust.chain.rootca".equalsIgnoreCase(sParam)) {
                        if (sValue != null && sValue.length() > 0) {
                            StringTokenizer tokens = new StringTokenizer(sValue, ";");
                            C045[] cacerts = new C045[tokens.countTokens()];
                            int certIndex = 0;
                            bOK = true;
                            while (tokens.hasMoreTokens()) {
                                String certStr = (String)tokens.nextElement();
                                byte[] bits = Base64.b(certStr);
                                C045 cert = null;
                                try {
                                    cert = new C045(bits);
                                }
                                catch (Exception e) {
                                    AppletLogger.log("TrustedCerts: Failed to create cert[" + certIndex + "] " + e);
                                    bOK = false;
                                }
                                cacerts[certIndex++] = cert;
                            }
                            C022.a().c(cacerts);
                            AppletLogger.log("TrustedCerts: " + certIndex + " trusted certificates detected");
                        }
                    } else if ("applet.timestamp".equalsIgnoreCase(sParam)) {
                        try {
                            this.m_iTSDelta = Integer.parseInt(sValue);
                        }
                        catch (NumberFormatException exp) {
                            this.setError(AppletConstants.ERR_LDAP_CFG_TSDELTA);
                            this.m_iTSDelta = 0;
                            bOK = false;
                        }
                    } else if ("wmap.cookie".equalsIgnoreCase(sParam)) {
                        AppletLogger.log("Setting Cookie:" + sValue);
                        this.m_cookie = sValue;
                        C039.l().a(sValue);
                        bOK = true;
                    } else if ("applet.final.init".equalsIgnoreCase(sParam)) {
                        this.m_bFinalInitializationDone = true;
                        bOK = this.m_bUseLDAP ? this.readLdapIni() : true;
                    }
                }
            }
        }
        return bOK;
    }

    protected void setError(AppletConstants.ErrorValue error) {
        this.setError(error.m_iCode, error.m_sError);
    }

    protected C072 getCRLChecker() {
        if (this.m_crlRequestURL.endsWith("crl.msc") || this.m_crlRequestURL.endsWith("crlcheck.jsp")) {
            return new C035(this.m_crlRequestURL, this.m_wmapSid);
        }
        return new C089(this.m_crlRequestURL);
    }

    protected void setError(AppletConstants.ErrorValue error, Throwable cause) {
        this.setError(error.m_iCode, error.m_sError + " Exception : " + cause.getMessage());
    }

    protected Image getImage() {
        return this.m_image;
    }

    public int getLastErrorNumber() {
        return this.m_nLastErrorNumber;
    }

    public String getLastErrorMsgText() {
        return this.m_strLastErrorMsgText;
    }

    public void init() {
        String color = this.getOwner().getParameter("color");
        if (color == null) {
            throw new NullPointerException("No color parameter defined.");
        }
        this.setBackground(Color.decode(color));
        String image = this.getOwner().getParameter("image");
        if (image != null) {
            try {
                InputStream in = ClassLoader.getSystemResourceAsStream(image);
                byte[] b = new byte[in.available()];
                in.read(b);
                this.setImage(Toolkit.getDefaultToolkit().createImage(b));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.setAppletParameter("logging", this.getOwner().getParameter("logging"));
        this.setAppletParameter("color", this.getOwner().getParameter("color"));
        this.setAppletParameter("image", this.getOwner().getParameter("image"));
        this.setAppletParameter("wmap.sid", this.getOwner().getParameter("wmap.sid"));
        this.setAppletParameter("mail.sendmethod", this.getOwner().getParameter("mail.sendmethod"));
        this.setAppletParameter("mail.sendurl", this.getOwner().getParameter("mail.sendurl"));
        this.setAppletParameter("smtpauth", this.getOwner().getParameter("smtpauth"));
        this.setAppletParameter("smtp.nonauth", this.getOwner().getParameter("smtp.nonauth"));
        this.setAppletParameter("ldap", this.getOwner().getParameter("ldap"));
        this.setAppletParameter("throw", this.getOwner().getParameter("throw"));
        this.setAppletParameter("crl.request.url", this.getOwner().getParameter("crl.request.url"));
        this.m_bInBrowser = true;
    }

    protected void setError(AppletConstants.ErrorValue error, String sDetail) {
        this.setError(error.m_iCode, sDetail);
    }

    public SMIMEAppletBase() {
        this.a = new Hashtable();
    }

    protected X509Certificate[] lookupCert(String sEmail) throws AddressException, CertificateException {
        X509Certificate[] arrCerts = null;
        arrCerts = this.getCachedCerts(sEmail);
        if (arrCerts == null) {
            arrCerts = this.m_bUseLDAP ? this.lookupCertLDAP(sEmail) : this.lookupCertWMAP(sEmail);
            this.addtoCache(sEmail, arrCerts);
        } else {
            AppletLogger.log("lookupCert: using Cached Certificates for " + sEmail);
        }
        return arrCerts;
    }
}

