/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1OutputStream;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Time;

public class C088 {
    private AlgorithmIdentifier o;
    private DERObjectIdentifier p;
    private C000 q = new C000();
    private byte[] r;
    private C046 s;
    private ASN1Set t;
    private ASN1Set u;
    private AlgorithmIdentifier v;

    public byte[] a() {
        try {
            return this.k(this.v.getParameters());
        }
        catch (Exception e) {
            throw new RuntimeException("exception getting encyrption parameters " + e);
        }
    }

    public byte[] b() {
        return this.r;
    }

    public C000 c() {
        return this.q;
    }

    public AttributeTable d() {
        if (this.u == null) {
            return null;
        }
        return new AttributeTable(this.u);
    }

    public String e() {
        return this.v.getObjectId().getId();
    }

    String f() {
        String digestAlgOID = this.i();
        if ("1.2.840.113549.2.5".equals(digestAlgOID)) {
            return "MD5";
        }
        if ("1.3.14.3.2.26".equals(digestAlgOID)) {
            return "SHA1";
        }
        return digestAlgOID;
    }

    public boolean g(X509Certificate cert, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, CertificateExpiredException, CertificateNotYetValidException, C063 {
        Attribute t;
        MessageDigest digest;
        Signature signature;
        if (sigProvider != null) {
            signature = Signature.getInstance(this.f() + "with" + this.l(), sigProvider);
            digest = MessageDigest.getInstance(this.f(), sigProvider);
        } else {
            signature = Signature.getInstance(this.f() + "with" + this.l());
            digest = MessageDigest.getInstance(this.f());
        }
        AttributeTable attr = this.d();
        if (attr != null && (t = attr.get(CMSAttributes.signingTime)) != null) {
            Time time = Time.getInstance((Object)t.getAttrValues().getObjectAt(0));
            cert.checkValidity(time.getDate());
        }
        return this.n(digest, signature, cert.getPublicKey(), attr);
    }

    public boolean h(PublicKey key, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, C063 {
        MessageDigest digest;
        Signature signature;
        if (sigProvider != null) {
            signature = Signature.getInstance(this.f() + "with" + this.l(), sigProvider);
            digest = MessageDigest.getInstance(this.f(), sigProvider);
        } else {
            signature = Signature.getInstance(this.f() + "with" + this.l());
            digest = MessageDigest.getInstance(this.f());
        }
        return this.n(digest, signature, key, this.d());
    }

    public String i() {
        return this.o.getObjectId().getId();
    }

    public AttributeTable j() {
        if (this.t == null) {
            return null;
        }
        return new AttributeTable(this.t);
    }

    C088(SignerInfo info, DERObjectIdentifier contentType, C046 content) {
        this.p = contentType;
        try {
            SignerIdentifier s = info.getSID();
            if (s.isTagged()) {
                ASN1OctetString octs = ASN1OctetString.getInstance((Object)s.getId());
                this.q.setSubjectKeyIdentifier(octs.getOctets());
            } else {
                IssuerAndSerialNumber iAnds = IssuerAndSerialNumber.getInstance((Object)s.getId());
                ByteArrayOutputStream bOut = new ByteArrayOutputStream();
                ASN1OutputStream aOut = new ASN1OutputStream((OutputStream)bOut);
                aOut.writeObject((Object)iAnds.getName());
                this.q.setIssuer(bOut.toByteArray());
                this.q.setSerialNumber(iAnds.getSerialNumber().getValue());
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("invalid sid in SignerInfo");
        }
        this.o = info.getDigestAlgorithm();
        this.u = info.getAuthenticatedAttributes();
        this.t = info.getUnauthenticatedAttributes();
        this.v = info.getDigestEncryptionAlgorithm();
        this.r = info.getEncryptedDigest().getOctets();
        this.s = content;
    }

    private byte[] k(DEREncodable obj) throws IOException {
        if (obj != null) {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            ASN1OutputStream aOut = new ASN1OutputStream((OutputStream)bOut);
            aOut.writeObject((Object)obj);
            return bOut.toByteArray();
        }
        return null;
    }

    String l() {
        String encryptionAlgOID = this.e();
        if ("1.2.840.10040.4.3".equals(encryptionAlgOID)) {
            return "DSA";
        }
        if ("1.2.840.10040.4.1".equals(encryptionAlgOID)) {
            return "DSA";
        }
        if ("1.2.840.113549.1.1.1".equals(encryptionAlgOID)) {
            return "RSA";
        }
        if ("1.2.840.113549.1.1.5".equals(encryptionAlgOID)) {
            return "RSA";
        }
        return encryptionAlgOID;
    }

    public byte[] m() {
        try {
            return this.k(this.o.getParameters());
        }
        catch (Exception e) {
            throw new RuntimeException("exception getting digest parameters " + e);
        }
    }

    private boolean n(MessageDigest digest, Signature signature, PublicKey key, AttributeTable signedAttrTable) throws C063 {
        try {
            signature.initVerify(key);
            if (this.s == null) {
                throw new IllegalArgumentException("no content specified for signature verification.");
            }
            if (this.u == null) {
                this.s.b(new C086(signature));
            } else {
                this.s.b(new C050(digest));
                byte[] hash = digest.digest();
                Attribute dig = signedAttrTable.get(CMSAttributes.messageDigest);
                Attribute type = signedAttrTable.get(CMSAttributes.contentType);
                if (dig == null) {
                    throw new SignatureException("no hash for content found in signed attributes");
                }
                if (type == null) {
                    throw new SignatureException("no content type id found in signed attributes");
                }
                byte[] signedHash = ((ASN1OctetString)dig.getAttrValues().getObjectAt(0)).getOctets();
                if (!MessageDigest.isEqual(hash, signedHash)) {
                    throw new SignatureException("content hash found in signed attributes different");
                }
                DERObjectIdentifier typeOID = (DERObjectIdentifier)type.getAttrValues().getObjectAt(0);
                if (!typeOID.equals((Object)this.p)) {
                    throw new SignatureException("contentType in signed attributes different");
                }
                ByteArrayOutputStream bOut = new ByteArrayOutputStream();
                DEROutputStream dOut = new DEROutputStream((OutputStream)bOut);
                dOut.writeObject((Object)this.u);
                dOut.close();
                signature.update(bOut.toByteArray());
            }
            return signature.verify(this.b());
        }
        catch (InvalidKeyException e) {
            throw new C063("key not appropriate to signature in message.", e);
        }
        catch (IOException e) {
            throw new C063("can't process mime object to create signature.", e);
        }
        catch (SignatureException e) {
            throw new C063("invalid signature format in message.", e);
        }
    }
}

