/*
 * Decompiled with CFR 0.152.
 */
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.PKIXCertPathChecker;
import java.security.cert.X509Certificate;
import java.util.Calendar;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class C004
extends PKIXCertPathChecker {
    public void init(boolean forward) throws CertPathValidatorException {
        if (forward) {
            throw new CertPathValidatorException();
        }
    }

    public boolean isForwardCheckingSupported() {
        return false;
    }

    public void check(Certificate cert, Collection unresolvedCritExts) throws CertPathValidatorException {
        X509Certificate[] trustedRoots = C039.l().u();
        for (int i = 0; i < trustedRoots.length; ++i) {
            if (!cert.equals(trustedRoots[i])) continue;
            return;
        }
        String wmapUrl = C039.l().o();
        String sid = C039.l().f();
        C035 wmapCrlChecker = new C035(wmapUrl, sid);
        if (!(cert instanceof X509Certificate)) {
            throw new CertPathValidatorException("Certificate is not X509");
        }
        C045 certiaCert = null;
        int ret = 2;
        try {
            certiaCert = new C045((X509Certificate)cert);
            try {
                ret = wmapCrlChecker.a(null, certiaCert, Calendar.getInstance().getTime());
            }
            catch (C041 e) {
                throw new CertPathValidatorException("Cannot check server certificate revocation status");
            }
            switch (ret) {
                case 0: {
                    break;
                }
                case 1: {
                    throw new CertPathValidatorException("Certificate Revoked");
                }
                default: {
                    throw new CertPathValidatorException("Certificate revocation status unknown");
                }
            }
        }
        catch (C015 e) {
            throw new CertPathValidatorException(e);
        }
    }

    public Set getSupportedExtensions() {
        HashSet<String> set = new HashSet<String>();
        set.add("2.5.29.31");
        return set;
    }
}

