/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ens.test;

import com.iplanet.ens.jms.EnsTopicConnFactory;
import com.iplanet.ens.test.EnsRigCommand;
import com.iplanet.ens.test.EnsRigException;
import com.iplanet.ens.test.EnsRigSession;
import java.io.IOException;
import java.util.Hashtable;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;

public class EnsRig {
    private static EnsRigCommand readCommand() throws IOException, EnsRigException {
        byte[] byArray = new byte[256];
        if (System.in.read(byArray) > 1) {
            String string = new String(byArray);
            string = string.trim();
            return EnsRigCommand.parse(string);
        }
        return null;
    }

    public static void usage() {
        System.out.println("Usage: EnsRig <server-host> <server-port>");
    }

    public static void main(String[] stringArray) {
        Hashtable<String, EnsRigSession> hashtable = new Hashtable<String, EnsRigSession>();
        String string = "127.0.0.1";
        int n = 7997;
        if (stringArray.length == 1) {
            n = new Integer(stringArray[0]);
        } else if (stringArray.length > 1) {
            string = stringArray[0];
            n = new Integer(stringArray[1]);
        }
        try {
            EnsTopicConnFactory ensTopicConnFactory = new EnsTopicConnFactory("EnsText", string, n, System.out);
            System.out.println(" *** EnsRig Ready");
            block12: while (true) {
                EnsRigCommand ensRigCommand;
                if ((ensRigCommand = EnsRig.readCommand()) == null) {
                    continue;
                }
                switch (ensRigCommand.type) {
                    case 1: {
                        EnsRigSession ensRigSession;
                        if (hashtable.get(ensRigCommand.sid) == null) {
                            TopicConnection topicConnection = ensTopicConnFactory.createTopicConnection();
                            TopicSession topicSession = topicConnection.createTopicSession(false, 1);
                            ensRigSession = new EnsRigSession(ensRigCommand.sid, topicConnection, topicSession);
                            hashtable.put(ensRigCommand.sid, ensRigSession);
                            continue block12;
                        }
                        throw new EnsRigException("session " + ensRigCommand.sid + " already active");
                    }
                    case 5: {
                        EnsRigSession ensRigSession = (EnsRigSession)hashtable.get(ensRigCommand.sid);
                        if (ensRigSession != null) {
                            hashtable.remove(ensRigCommand.sid);
                            ensRigSession.close();
                            continue block12;
                        }
                        throw new EnsRigException("session " + ensRigCommand.sid + " inactive");
                    }
                    case 2: {
                        EnsRigSession ensRigSession = (EnsRigSession)hashtable.get(ensRigCommand.sid);
                        if (ensRigSession != null) {
                            ensRigSession.addSubscriber(ensRigCommand.eventRef);
                            continue block12;
                        }
                        throw new EnsRigException("session " + ensRigCommand.sid + " inactive");
                    }
                    case 8: {
                        EnsRigSession ensRigSession = (EnsRigSession)hashtable.get(ensRigCommand.sid);
                        if (ensRigSession != null) {
                            ensRigSession.addSubscriber(ensRigCommand.eventRef, ensRigCommand.renlId);
                            continue block12;
                        }
                        throw new EnsRigException("session " + ensRigCommand.sid + " inactive");
                    }
                    case 3: {
                        EnsRigSession ensRigSession = (EnsRigSession)hashtable.get(ensRigCommand.sid);
                        if (ensRigSession != null) {
                            ensRigSession.removeSubscriber(ensRigCommand.eventRef);
                            continue block12;
                        }
                        throw new EnsRigException("session " + ensRigCommand.sid + " inactive");
                    }
                    case 4: {
                        EnsRigSession ensRigSession = (EnsRigSession)hashtable.get(ensRigCommand.sid);
                        if (ensRigSession != null) {
                            ensRigSession.publish(ensRigCommand.eventRef, ensRigCommand.payload);
                            continue block12;
                        }
                        throw new EnsRigException("session " + ensRigCommand.sid + " inactive");
                    }
                    case 6: {
                        System.out.println("EnsRig says bye bye");
                        System.exit(0);
                        return;
                    }
                    case 7: {
                        System.out.println("Available commands: ");
                        System.out.println("    login <sid>");
                        System.out.println("    logout <sid>");
                        System.out.println("    subscribe <sid> <rid> <event_ref>");
                        System.out.println("    rsub <sid> <rid> <event_ref> <renl_id>");
                        System.out.println("    unsubscribe <sid> <rid> <event_ref>");
                        System.out.println("    publish <sid> <rid> <event_ref> <event_data>");
                        System.out.println("    help");
                        System.out.println("    exit");
                        System.out.println("");
                        System.out.println("Arguments:");
                        System.out.println("    <sid>       session id");
                        System.out.println("    <rid>       request id (for reply correlation)");
                        System.out.println("    <event_ref> event reference");
                        System.out.println("");
                        continue block12;
                    }
                }
                System.out.println("Unsupported command");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(1);
            System.out.println("EnsRig says bye bye");
            System.exit(0);
            return;
        }
    }
}

