/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.smime.security.capi;

import com.sun.messaging.smime.applet.AppletLogger;
import com.sun.messaging.smime.security.capi.CAPIBridge;
import com.sun.messaging.smime.security.cardapi.CardAdmin;
import com.sun.messaging.smime.security.cardapi.CardException;
import com.sun.messaging.smime.security.cardapi.CardToken;
import java.io.ByteArrayInputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;

public class CardTokenCAPI
extends CardToken {
    Map m_mapCerts;
    List m_listTrusted;
    X509Certificate[] m_arrCerts;
    CardAdmin m_cardAdmin;

    protected CardTokenCAPI(String sProv) {
        super(sProv);
    }

    public boolean isValid() throws CardException {
        return true;
    }

    public X509Certificate[] getUserCertificates() throws CardException {
        if (this.m_mapCerts == null) {
            this.m_mapCerts = this.loadUserCerts();
            this.m_arrCerts = this.m_mapCerts.keySet().toArray(new X509Certificate[this.m_mapCerts.size()]);
        }
        return this.m_arrCerts;
    }

    public X509Certificate[] getTrustedCertificates() throws CardException {
        if (this.m_listTrusted == null) {
            this.m_listTrusted = this.loadCerts("CA");
        }
        return this.m_listTrusted.toArray(new X509Certificate[this.m_listTrusted.size()]);
    }

    public byte[] sign(X509Certificate signatureCert, String algorithm, byte[] hash) throws CardException, InvalidKeyException, SignatureException, BadPaddingException {
        String sAlias = (String)this.m_mapCerts.get(signatureCert);
        String sAlg = "MD5";
        if (algorithm.equalsIgnoreCase("MD5withRSA")) {
            sAlg = "MD5";
        } else if (algorithm.equalsIgnoreCase("SHA1withRSA")) {
            sAlg = "SHA1";
        }
        return CAPIBridge.signDigest(sAlias, sAlg, hash);
    }

    public byte[] decrypt(X509Certificate encryptionCert, String algorithm, byte[] encryptedData) throws CardException, InvalidKeyException, BadPaddingException {
        String sAlias = (String)this.m_mapCerts.get(encryptionCert);
        return CAPIBridge.decrypt(sAlias, "RSA", encryptedData);
    }

    public X509Certificate[] getCertificateChain(X509Certificate cert) throws CardException {
        return new X509Certificate[]{cert};
    }

    public void registerCardAdmin(CardAdmin tokenAdmin) {
        this.m_cardAdmin = tokenAdmin;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map loadUserCerts() throws CardException {
        ArrayList<Integer> listCerts = new ArrayList<Integer>();
        HashMap<X509Certificate, String> mapCerts = new HashMap<X509Certificate, String>();
        int iStore = this.openStore("MY");
        try {
            int iCertContext = CAPIBridge.CertEnumCertificatesInStore(iStore, 0);
            if (iCertContext == 0) {
                throw new CardException("No Certs MY");
            }
            while (iCertContext != 0) {
                listCerts.add(new Integer(iCertContext));
                byte[] bytesCert = CAPIBridge.CertGetCert(iCertContext);
                if (bytesCert != null) {
                    ByteArrayInputStream bIn = new ByteArrayInputStream(bytesCert);
                    try {
                        CertificateFactory cFactory = CertificateFactory.getInstance("X.509");
                        X509Certificate cert = (X509Certificate)cFactory.generateCertificate(bIn);
                        String sAlias = CAPIBridge.CertGetCertAlias(iCertContext);
                        if (sAlias != null) {
                            mapCerts.put(cert, sAlias);
                        } else {
                            AppletLogger.error((String)("No alias for " + ((Object)cert.getSubjectDN()).toString()));
                        }
                    }
                    catch (CertificateException exp) {
                        throw new CardException("Failed to decode CAPI cert", (Throwable)exp);
                    }
                }
                iCertContext = CAPIBridge.CertEnumCertificatesInStore(iStore, iCertContext);
            }
        }
        finally {
            this.closeStore(iStore);
        }
        return mapCerts;
    }

    private int openStore(String strStore) throws CardException {
        int iStoreHandle = CAPIBridge.CertOpenSystemStore(0, strStore);
        if (iStoreHandle == 0) {
            throw new CardException("Failed to open CAPI Cert store: " + strStore);
        }
        return iStoreHandle;
    }

    private void closeStore(int iStore) throws CardException {
        if (iStore > 0 && !CAPIBridge.CertCloseStore(iStore, 1)) {
            throw new CardException("Failed to close store");
        }
    }

    private void testCert(X509Certificate cert) {
        try {
            Cipher cipher = Cipher.getInstance("RSA/ECB/PKCS1Padding");
            String sToEncrypt = "This is a load of stuff to encrypt";
            cipher.init(1, cert.getPublicKey());
            byte[] bytesEncryted = cipher.doFinal(sToEncrypt.getBytes());
            byte[] bytesDecrypted = this.decrypt(cert, "RSA", bytesEncryted);
            String sDecrypted = new String(bytesDecrypted);
            if (sDecrypted.equals(sToEncrypt)) {
                System.out.println("Decrypted OK");
            } else {
                System.out.println("Decryption failed.");
            }
            String sToSign = "This is load of stuff to sign";
            byte[] bytesToSign = sToSign.getBytes();
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] sigHash = md.digest(bytesToSign);
            byte[] bytesSignature = this.sign(cert, "RSA", sigHash);
            Signature sig = Signature.getInstance("MD5withRSA");
            sig.initVerify(cert.getPublicKey());
            sig.update(bytesToSign);
            if (sig.verify(bytesSignature)) {
                System.out.println("Signature OK");
            } else {
                System.out.println("Signature Failed");
            }
        }
        catch (Exception exp) {
            exp.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List loadCerts(String sStore) throws CardException {
        ArrayList<X509Certificate> listCerts = new ArrayList<X509Certificate>();
        int iStore = this.openStore(sStore);
        try {
            int iCertContext = CAPIBridge.CertEnumCertificatesInStore(iStore, 0);
            if (iCertContext == 0) {
                throw new CardException("No Certs " + sStore);
            }
            while (iCertContext != 0) {
                byte[] bytesCert = CAPIBridge.CertGetCert(iCertContext);
                if (bytesCert != null) {
                    ByteArrayInputStream bIn = new ByteArrayInputStream(bytesCert);
                    try {
                        CertificateFactory cFactory = CertificateFactory.getInstance("X.509");
                        X509Certificate cert = (X509Certificate)cFactory.generateCertificate(bIn);
                        listCerts.add(cert);
                    }
                    catch (CertificateException exp) {
                        throw new CardException("Failed to decode CAPI cert", (Throwable)exp);
                    }
                }
                iCertContext = CAPIBridge.CertEnumCertificatesInStore(iStore, iCertContext);
            }
        }
        finally {
            this.closeStore(iStore);
        }
        return listCerts;
    }
}

