/****************************************************************************/
/*                                                                          */
/*  APIDEF.H - C declarations for the PMDF subroutine library API           */
/*                                                                          */
/*  Author:   Dan Newman (dan@innosoft.com)                                 */
/*            Summer 1991, Winter 1992                                      */
/*            PMDF Project, Innosoft International, Inc.                    */
/*                                                                          */
/*  Copyright (c) 1991, 1992 PMDF Project                                   */
/*                Innosoft International, Inc.                              */
/*                                                                          */
/*  All rights reserved.                                                    */
/*                                                                          */
/****************************************************************************/

#ifndef __PMDF_APIDEF__
#define __PMDF_APIDEF__

#ifdef __cplusplus
extern "C" {
#endif

/* PMDF V6.0 */
#define PMDF_VERSION 60
#define PMDF_VERSION_STR "6.0"

/* Include the PMDF_send item codes */
#if defined(VMS) && !defined(__VMS)
#  define __VMS 1
#endif

#include <time.h>

#ifdef __VMS
#  include "pmdf_com:senddef.h"
#  include "pmdf_com:apihdrdef.h"
#  include "pmdf_com:apikeydef.h"
#  include "pmdf_com:pmdf_err.h"
#else
#    include "senddef.h"
#    include "apihdrdef.h"
#    include "apikeydef.h"
#    include "pmdf_err.h"
#endif

/* The following four constants come from UTILCONSTA.INC */
#define SHORTALFA_SIZE                40
#define ALFA_SIZE                    256
#define BIGALFA_SIZE                1024
#define CHANLENGTH                    32

/* The following constants come from OSCONSTA.INC */
#define KEY_LENGTH                    32
#define DATA_LENGTH                   80
#define LONG_KEY_LENGTH               80
#define LONG_DATA_LENGTH       ALFA_SIZE
#define HUGE_KEY_LENGTH              128
#define HUGE_DATA_LENGTH       BIGALFA_SIZE
#define PMDF_ALIAS_ADDRESS_BIT 0x00000001 /* Address                          */
#define PMDF_ALIAS_FAX_BIT     0x00000002 /* Address using FAX ORnames        */
#define PMDF_ALIAS_MR_BIT      0x00000004 /* Address using MR ORnames         */
#define PMDF_ALIAS_X400_BIT    0x00000008 /* Address using MHS88 ORnames      */
#define PMDF_ALIAS_PUBLIC_BIT  0x40000000 /* Others may use this alias        */
#define PMDF_ALIAS_EXPAND_BIT  0x20000000 /* Show the alias's value in header */
#define PMDF_ALIAS_RECEIPT_BIT 0x10000000 /* Receipts to pass through to list */
#define PMDF_REVERSE_AUTOGEN_BIT 0x02000000 /* Entry auto generated           */

/* Delivery flags.  Definitive forms are in mmmod.h */
#define PMDF_DFLAGS_SIEVEFILEINTO 0x00000001 /* Subaddress from Sieve fileinto*/
#define PMDF_DFLAGS_QUOTABYPASS   0x00000002 /* Enable quota bypass           */
#define PMDF_DFLAGS_DOTSTUFF      0x00000004 /* Msg requires SMTP dot stuffing*/

/* The following three constants come from api.c */
#define PMDF_CACHE_CALLBACK             8
#define PMDF_RESTART_CALLBACK          16
#define PMDF_SHUTDOWN_CALLBACK         24
#define PMDF_DEBUG_CALLBACK            32

/* Indices into the databases array in api.c */
#define PMDF_DATABASE_ALIAS             1
#define PMDF_DATABASE_DIRECTORY         2
#define PMDF_DATABASE_DOMAIN            3
#define PMDF_DATABASE_FROM_MR           4
#define PMDF_DATABASE_FROM_X400         5
#define PMDF_DATABASE_GENERAL           6
#define PMDF_DATABASE_PERSONAL_ALIAS    7
#define PMDF_DATABASE_REVERSE           8
#define PMDF_DATABASE_TO_MR             9
#define PMDF_DATABASE_TO_X400          11
#define PMDF_DATABASE_USER_PROFILE     12
#define PMDF_DATABASE_POPSTORE_FORWARD 13
#define PMDF_DATABASE_OEM_PRIVATE      14
#define PMDF_DATABASE_PIPE             15
#define PMDF_DATABASE_FORWARD          16
#define PMDF_DATABASE_PASSWORD         17
#define PMDF_DATABASE_POPSTORE_USER    18
#define PMDF_DATABASE_POPSTORE_GROUP   19
#define PMDF_DATABASE_OEM_PRIVATE2      20
#define PMDF_DATABASE_SSR		21

/* Indices into the search_types array in api.c */
#define PMDF_DATABASE_GET_FIRST         1
#define PMDF_DATABASE_GET_NEXT          2
#define PMDF_DATABASE_GET_FIRST_ROOT    3
#define PMDF_DATABASE_GET_NEXT_ROOT     4
#define PMDF_DATABASE_GET_FIRST_ALL     5
#define PMDF_DATABASE_GET_NEXT_ALL      6

/* Address property types for use with PMDFgetAddressProp */
#define PMDF_PROP_ADDRESS               1
#define PMDF_PROP_DOMAIN                2
#define PMDF_PROP_FRIENDLY              3
#define PMDF_PROP_LOCAL                 4
#define PMDF_PROP_PHRASE                5
#define PMDF_PROP_PROPER                6
#define PMDF_PROP_ROUTE                 7

/* Disposition types for PMDFrecipientDisposition */
#define PMDF_DISP_DEFERRED            1
#define PMDF_DISP_DELIVERED           2
#define PMDF_DISP_FAILED              3
#define PMDF_DISP_RELAYED             4
#define PMDF_DISP_RELAYED_FOREIGN     5
#define PMDF_DISP_RETURN              6
#define PMDF_DISP_TIMEDOUT            7

#define PMDF_RECEIPT_HEADER             1
#define PMDF_RECEIPT_NOHEADER           2
#define PMDF_RECEIPT_FAILURES           4
#define PMDF_RECEIPT_SUCCESSES          8
#define PMDF_RECEIPT_DELAYS            16
#define PMDF_RECEIPT_GENERATE          32
#define PMDF_RECEIPT_NEVER             64
#define PMDF_RECEIPT_FIRST            128
#define PMDF_RECEIPT_NOTARY           256
#define PMDF_RECEIPT_INTERMEDIATE     512

#define PMDF_CL_DEFAULT_STYLE   0
#define PMDF_CL_VMS_STYLE       1
#define PMDF_CL_UNIX_STYLE      2
#define PMDF_CL_VMSEXT_STYLE    3
#define PMDF_CL_WNT_STYLE       4
#define PMDF_CL_REST_LITERAL   32
#define PMDF_CL_GENERATE_USAGE 64

typedef struct {
  char username[ALFA_SIZE+1];
  int  username_len;
} PMDF_auth_info;

typedef struct PMDF_queue_info_s {
  struct {
    int  length;
    char body[ALFA_SIZE];
  } queue_name;
  struct PMDF_queue_info_s *next;
} PMDF_queue_info;

typedef struct PMDF_channel_counters_s {
  char channel_name[CHANLENGTH+1];
  int received_messages;
  int submitted_messages;
  int stored_messages;
  int delivered_messages;
  int received_volume;
  int submitted_volume;
  int stored_volume;
  int delivered_volume;
  int received_recipients;
  int submitted_recipients;
  int stored_recipients;
  int delivered_recipients;
  struct PMDF_channel_counters_s *next;
  int rejected_messages;
  int failed_messages;
  int attempted_messages;
  int rejected_volume;
  int failed_volume;
  int attempted_volume;
  int rejected_recipients;
  int failed_recipients;
  int attempted_recipients;
  int delivered_first_messages;
  int delivered_first_queue_count;
  int delivered_first_queue_time;
  int delivered_queue_count;
  int delivered_queue_time;
} PMDF_channel_counters;

typedef struct PMDF_channel_associations_s {
  struct PMDF_channel_associations_s *next; /* Pointer to next assoc. record */
  int  index, cindex;                       /* Reserved fields */
  int  channel_name_len;                    /* Length of channel name */
  int  time_stamp_len;                      /* Length of time stamp info */
  int  association_info_len;                /* Length of association info */
  int  application_info_len;                /* Length of application info */
  char channel_name[CHANLENGTH+1];          /* Channel name; null terminated */
  char time_stamp[SHORTALFA_SIZE+1];        /* Time stamp for record; null term. */
  char association_info[ALFA_SIZE+1];       /* Association info; null terminated */
  char application_info[SHORTALFA_SIZE+1];  /* Application info; null terminated */
} PMDF_channel_associations;  

typedef struct PMDF_hdr_line_s {
  char                   *line;
  int                     line_length;
  struct PMDF_hdr_line_s *next_line;
} PMDF_hdr_line;
typedef PMDF_hdr_line *PMDF_hdr[HL_LAST_HEADER + 1];

typedef struct {
  int   item_code;
  char *item_address;
  int   item_reserved;
  int   item_length;
} PMDF_item_list;

typedef struct {
  int   item_code;
  int   item_blength;
  void *item_address;
  int   item_length;
  int   item_status;
} PMDF_keyword_item_list;

typedef struct {
  unsigned long by_time_rel;
  time_t        by_time_abs;
  char          by_mode;
  char          by_trace;
} PMDF_deliver_by_t;

typedef struct {int really_is_void;} PMDF_addr;

typedef struct {int really_is_void;} PMDF_dq;

typedef struct {int really_is_void;} PMDF_nq;

typedef struct {int really_is_void;} PMDF_cl;

typedef struct {int really_is_void;} PMDF_opt;

typedef struct {int really_is_void;} PMDF_channel;

typedef struct {int really_is_void;} PMDF_qc;

extern int  PMDFabortMessage (PMDF_nq **);
extern void PMDFabortProgram (char *, int, int);
extern int  PMDFaddHeaderLine (PMDF_hdr **, int, char *, int);
#ifdef __VMS
extern int  PMDFaddRecipient (PMDF_nq **, char *, int, ...);
#else
extern int  PMDFaddRecipient (PMDF_nq **, char *, int, char *, int);
#endif
extern int  PMDFaddressDispose (PMDF_addr *);
extern int  PMDFaddressGet (PMDF_addr *, int, char *, int *);
extern int  PMDFaddressGetProperty (PMDF_addr *, int, int, char *, int *);
extern int  PMDFaddressParseList (PMDF_addr **, int *, char *, int);
extern int  PMDFaddressParseList2 (PMDF_addr **, int *, char *, int,
                                   char *, int);
extern int  PMDFaddressToChannel (char *, int, int, int, char *, int *);
extern int  PMDFaliasNoExpansion (PMDF_nq **);
#ifdef __VMS
extern int  PMDFcancelCallBack ();
#else
extern int  PMDFcancelCallBack (void *);
#endif
extern int  PMDFchannelDispose (PMDF_channel *);
extern int  PMDFchannelGet (PMDF_channel **, const char *, int);
extern int  PMDFchannelGetKeyword (PMDF_channel *, PMDF_keyword_item_list *);
extern int  PMDFchannelStartJobs (char *, int);
extern int  PMDFchannelToHost (const char *, int, char *, int *);
extern int  PMDFchannelToMailProtocol (char *, int, char *, int *);
extern int  PMDFcloseLogFile (void);
extern int  PMDFcloseQueueCache (void);
extern int  PMDFcommandGetInteger (PMDF_cl **, const char *, int, int *);
extern int  PMDFcommandGetValue (PMDF_cl **, const char *, int, char *, int *);
extern int  PMDFcommandInitialize (PMDF_cl **, char *, int, char *, int *);
extern int  PMDFcommandParse (PMDF_cl **, char *, int, int, char *, int *);
extern int  PMDFcommandPresent (PMDF_cl **, const char *, int);
extern int  PMDFcommandSetup (PMDF_cl **, int);
extern int  PMDFcopyMessage (PMDF_dq **, PMDF_nq **);
extern int  PMDFcreateBoundary (char *, int *);
extern int  PMDFdatabaseAddEntry (int, char *, int, char *, int, int, int, int,
                                  int);
extern int  PMDFdatabaseClose (int);
extern int  PMDFdatabaseDeleteEntry (int, char *, int);
#ifdef __VMS
extern int  PMDFdatabaseGetEntry (int, int, char *, int *, char *, int *, ...);
#else
extern int  PMDFdatabaseGetEntry (int, int, char *, int *, char *, int *,
                                  unsigned int *);
#endif
extern int  PMDFdecodeMessage (PMDF_dq **, void *, unsigned long,
	int (*input_line)(void *param, char *line, int  *line_len),
	int (*outputheader)(void * param, PMDF_hdr * hdr, int part, int depth,
			    int index), 
	int (*output_line)(void *param, char *line, int line_len),
	int (*output_block)(void *param, char *data, int data_len) );
extern int  PMDFdecodeTimeZone (char *, int, int *);
extern int  PMDFdebug (int, int);
#ifdef __VMS
extern int  PMDFdeferMessage (PMDF_dq **, int, ...);
#else
extern int  PMDFdeferMessage (PMDF_dq **, int, const char *, int);
#endif
extern int  PMDFdeleteHeaderLine (PMDF_hdr *, int);
extern int  PMDFdequeueBackoffOverride (PMDF_dq **, int);
extern int  PMDFdequeueEnd (PMDF_dq **);
extern int  PMDFdequeueInitialize (PMDF_dq **);
extern int  PMDFdequeueMessage (PMDF_dq **);
extern int  PMDFdequeueMessageEnd (PMDF_dq **, int, char *, int);
extern int  PMDFdisposeChannelAssociations (PMDF_channel_associations **);
extern int  PMDFdisposeChannelCounters (PMDF_channel_counters **);
extern int  PMDFdisposeHeader (PMDF_hdr **);
extern int  PMDFdisposeQueueInfo (PMDF_queue_info *);
extern int  PMDFdone (void);
extern int  PMDFenqueueInitialize (void);
extern int  PMDFenqueueMessage (PMDF_nq **);
extern char *PMDFerrorToText (int);
extern int  PMDFgetAddressProperty (char *, int, int, char *, int *);
extern int  PMDFgetAnyDateTime (char *, int *, int, time_t);
extern int  PMDFgetAuthInfo(PMDF_dq **, PMDF_auth_info *, size_t);
#ifdef __VMS
extern int  PMDFgetChannelName (char *, int *, ...);
#else
extern int  PMDFgetChannelName (char *, int *, int *, int *);
#endif
extern int  PMDFgetChannelAssociations (char *, int, int,
	PMDF_channel_associations **, int *);
extern int  PMDFgetChannelCounters (const char *, int, int,
	PMDF_channel_counters **, int *);
extern int  PMDFgetBlockSize (void);
extern int  PMDFgetDateTime (char *, int *);
extern int  PMDFgetDeliverBy (PMDF_dq **, PMDF_deliver_by_t *);
extern int  PMDFgetDeliveryFlags (PMDF_dq **, int *);
extern int  PMDFgetEnvelopeId (PMDF_dq **, char *, int *);
extern int  PMDFgetErrorText (PMDF_nq **, char *, int *);
extern int  PMDFgetHostName (char *, int *);
extern int  PMDFgetImageInfo (char *, int *, char *, int *);
extern int  PMDFgetIntermediateTo (PMDF_dq **, char *, int *);
extern int  PMDFgetMessage (PMDF_dq **, char *, int *, char *, int *);
extern int  PMDFgetMessageAccess (PMDF_dq **, char *, int, char *, int *);
extern int  PMDFgetMessageFile (PMDF_dq **, char *, int *, int *);
extern int  PMDFgetMessageHandle (PMDF_dq **, void **, size_t *);
extern int  PMDFgetMessageId (PMDF_dq **, char *, int *);
extern int  PMDFgetPostmasterAddress (char *, int *);
extern int  PMDFgetQueueFilename (char *, int, char *, int *, int);
extern int  PMDFgetQueueInfo (PMDF_queue_info **);
#ifdef __VMS
extern int  PMDFgetRecipient (PMDF_dq **, char *, int *, ...);
#else
extern int  PMDFgetRecipient (PMDF_dq **, char *, int *, char *, int *);
#endif
extern int  PMDFgetRecipientIntermediate(PMDF_dq **, char *, int *);
extern int  PMDFgetRecipientFlags (PMDF_dq **, int *);
extern int  PMDFgetTimeZoneInfo (char *, int *, int *);
extern int  PMDFgetUniqueString (char *, int *);
extern int  PMDFgetUserName (char *, int *);
extern int  PMDFhostToChannel (char *, int, PMDF_channel **, char *, int *);
extern int  PMDFinitialize (int);
extern int  PMDFlog (const char *, int, int);
extern int  PMDFmappingApply (int, char *, int, char *, int *, char *, int *);
extern int  PMDFaccessMappingApply (int, char *, int, char *, int *, char *,
	int *, int);
extern int  PMDFmappingLoad (const char *, int, int *);
extern int  PMDFoptionDispose (PMDF_opt *);
extern int  PMDFoptionGetInteger (PMDF_opt *, const char *, int, int *);
extern int  PMDFoptionGetReal (PMDF_opt *, const char *, int, float *);
extern int  PMDFoptionGetString (PMDF_opt *, const char *, int, char *, int *,
	int);
extern int  PMDFoptionLog (int);
extern int  PMDFoptionRead (PMDF_opt **, const char *, int);
extern int  PMDFparseAddress (char *, int, char *, int *, char *, int *, char *,
	int *);
extern int  PMDFqueueCacheEnd (PMDF_qc **);
extern int  PMDFqueueCacheGetEntry (PMDF_qc **, PMDF_keyword_item_list *,
	char *, int, char *, int);
extern int  PMDFreadFailureLog (PMDF_dq **, char *, int *, char *, int *);
extern int  PMDFreadHeader (PMDF_dq **, PMDF_hdr **);
extern int  PMDFreadLine (PMDF_dq **, char *, int *);
extern int  PMDFreadText (PMDF_dq **, char *, int *);
extern int  PMDFreceiptControl (PMDF_nq **, int, int, int, int, int);
extern int  PMDFrecipientDisposition (PMDF_dq **, int, int, char *, int, char *,
	int, char *, int);
extern int  PMDFrecipientDisposition2 (PMDF_dq **, int, int, char *, int,
	char *, int, char *, int, char *, int, int, int, int);
extern int  PMDFreturnMessage (PMDF_dq **, char *, int, char *, int,
	PMDF_item_list *);
extern int  PMDFrewindMessage (PMDF_dq **);
extern int  PMDF_send (PMDF_item_list *);
extern int  PMDFsetMutex (int (*)(void *), int (*)(void *), int (*)(void *),
	int (*)(void *), void (*)(unsigned long));
#ifdef __VMS
extern int  PMDFsetCallBack (void (*)(), const char *, int, ...);
#else
extern int  PMDFsetCallBack (void (*)(), const char *, int, void *, int);
#endif
extern int  PMDFsetEnvelopeId (PMDF_nq **, char *, int);
extern int  PMDFsetLimits (PMDF_nq **, int, int, int);
extern int  PMDFsetReceiptAddresses (PMDF_nq **, char *, int, char *, int);
extern int  PMDFsetRecipientFlags (PMDF_nq **, int);
extern int  PMDFsetRecipientType (PMDF_nq **, int, int, int, int);
extern int  PMDFsetSpecials (PMDF_nq **, int, int);
extern int  PMDFstartMessageBody (PMDF_nq **);
extern int  PMDFstartMessageEnvelope (PMDF_nq **, const char *, int,
                                      const char *, int);
extern int  PMDFstartMessageHeader (PMDF_nq **);
extern int  PMDFsyncCounters(int);
extern int  PMDFwriteDate (PMDF_nq **);
extern int  PMDFwriteFrom (PMDF_nq **, char *, int);
extern int  PMDFwriteHeader (PMDF_nq **, PMDF_hdr *);
extern int  PMDFwriteLine (PMDF_nq **, const char *, int);
extern int  PMDFwriteSubject (PMDF_nq **, char *, int);
extern int  PMDFwriteText (PMDF_nq **, const char *, int);

extern int PMDFqueueWait(PMDF_dq **, int *, int *, const char *, int , int, int);

extern int
PMDFdequeueGetDirectoryInfo(PMDF_dq **, char *, char *, char *, void *, void *);


#ifdef __IMTA

extern int  PMDFheaderAddLine (void **, int, void *, int, int);
extern int  PMDFheaderDecodeMessage (PMDF_dq **, void *, unsigned long, void *,
	void *, void *, void *);
extern int  PMDFheaderDeleteLine (void *, int);
extern void PMDFheaderDispose (void *);
extern int  PMDFheaderGetLine (void *, int, char **, int *);
extern int  PMDFheaderGetLineDispose (char *);
extern int  PMDFheaderRead (PMDF_dq **, void **);
extern int  PMDFheaderWrite (PMDF_nq **, void *);

#endif /* __IMTA */

#ifdef __cplusplus
}
#endif

#endif  /* __PMDF_APIDEF__ */
