

#ifndef _INCLUDED_gap_writer
#define _INCLUDED_gap_writer

#include "GDisp.h"
#include "ASPipe.h"
#include "ASock.h"

typedef struct gap_writer_struct gap_writer_t;


gap_writer_t *gap_writer_new(ASock *asock,
			     GDisp *gdisp,
			     void (*error)(void *ctx, int rc),
			     void *ctx);

void gap_writer_delete(gap_writer_t *writer);

void gap_writer_start(gap_writer_t *writer);

int gap_writer_write(gap_writer_t *writer,
		     const char *buf,
		     unsigned int len);

int gap_writer_printf(gap_writer_t *writer,
		      const char *format,
		      va_list ap);

int gap_writer_printf_and_write(gap_writer_t *writer,
                                char *data, unsigned int data_len,
                                const char *format, va_list ap);

#endif /* _INCLUDED_gap_writer */
