
#ifndef _INCLUDED_gap_log
#define _INCLUDED_gap_log

#ifdef _WIN32
#define __export __declspec(dllexport)
#else /* #ifdef _WIN32 */
#define __export
#endif /* #ifdef _WIN32 */

#ifdef __cplusplus
extern "C" {
#endif

/*
 * logging tools and definitions
 */
#include "nslogger.h"
#include "gap_session.h"

/* modules */
#define GAPLOG_CONNECTION	0x0001
#define GAPLOG_SESSION		0x0002
#define GAPLOG_TRANSACTION     	0x0004
#define GAPLOG_DISPATCHER     	0x0008
#define ENSLOG_API      	0x0010
#define ENSLOG_UPUB		0x0020
#define ENSLOG_RENL     	0x0040

/* number of modules - keep it up-to-date ! */
#define GAPLOG_MODULES		8

void gaplog(int level,
	    int module,
	    const char * format, ...);

void gaplog_init(void);

#ifdef __cplusplus
}
#endif

#endif /* _INCLUDED_gap_log */
