#!/bin/ksh

#############################################################################
##
## iMS monitoring and alarm script
##
## This script is part an example framework of what can be done.
## There are MANY ways that you can take this from here.
##
## File: $RCSfile: plugin4bb.sh,v $
##       A script to generate daily usage reports
##
## While this package is provided AS-IS and unsupported, we would appreciate
## your comments, feedback and bug-reports at:
##
##      mailtools-feedback @Sign sun.com
##
#############################################################################
##
## Big Brother ext plugin for monitoring iPlanet Messaging Server.
##
## Installation:
##      1) Make sure that your monitoring packages are running fine
##	2) move this file to the BBHOME/ext directory.
## 	3) add plugin4bb.sh to the BBHOME/bb-bbexttab file.
##	
##	4) USE SSH over RSH when possible. 
## 	   Create a .rhosts file in the home directory of the 'mailsrv'
##	   user which allows rsh actions by the 'bigbrother' user connecting
##	   from 127.0.0.1 and localhost. 
##
##      5) Restart Big Brother
##
#############################################################################

## BBHOME=/home/bigbrother/bbActive

. PATH_TO_SCRIPTS-Changeme/etc/alarms.cfg

if test "$BBHOME" = ""
then
        echo "BBHOME is not set... exiting"
        exit 1
fi

if test ! "$BBTMP"                      # GET DEFINITIONS IF NEEDED
then
        # echo "*** LOADING BBDEF ***"
        . $BBHOME/etc/bbdef.sh          # INCLUDE STANDARD DEFINITIONS
fi

rshoption="rsh localhost -l <local.serveruid>"	# One could use ssh instead

#
# COLLECT SOME DATA
#

$rshoption PATH_TO_SCRIPTS-Changeme/check_queues -S bigbrother
$rshoption PATH_TO_SCRIPTS-Changeme/check_files -S bigbrother
$rshoption PATH_TO_SCRIPTS-Changeme/check_mconn -S bigbrother
$rshoption PATH_TO_SCRIPTS-Changeme/check_procs -S bigbrother
$rshoption PATH_TO_SCRIPTS-Changeme/check_sys -S bigbrother
$rshoption PATH_TO_SCRIPTS-Changeme/check_rndtrip -S bigbrother
$rshoption PATH_TO_SCRIPTS-Changeme/check_ldap -S bigbrother

## end of script
