/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.page;

import com.netscape.page.Debug;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicLabelUI;

public class MultilineLabelUI
extends BasicLabelUI {
    static final String[] SEPARATORS = new String[]{" ", ".", ",", "?", "-", ":", ";", "!", "/", "\\"};
    Vector textVector;
    int[] widthArray;
    int[] offsetArray;
    protected Dimension preferredSize;
    protected Dimension calcSize;
    boolean _parsed = false;
    int _wrapWidth = 32;

    protected String layoutCL(JLabel jLabel, FontMetrics fontMetrics, String string, Icon icon, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3) {
        return this.layoutCompoundLabel(fontMetrics, string, icon, jLabel.getVerticalAlignment(), jLabel.getHorizontalAlignment(), jLabel.getVerticalTextPosition(), jLabel.getHorizontalTextPosition(), rectangle, rectangle2, rectangle3, jLabel.getIconTextGap());
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        block12: {
            int n;
            Icon icon;
            JLabel jLabel = (JLabel)jComponent;
            String string = jLabel.getText();
            Icon icon2 = icon = jLabel.isEnabled() ? jLabel.getIcon() : jLabel.getDisabledIcon();
            if (icon == null && string == null) {
                return;
            }
            Dimension dimension = jComponent.getSize();
            FontMetrics fontMetrics = graphics.getFontMetrics();
            Rectangle rectangle = new Rectangle();
            Rectangle rectangle2 = new Rectangle();
            Rectangle rectangle3 = new Rectangle(dimension);
            Insets insets = jComponent.getInsets();
            rectangle3.x = insets.left;
            rectangle3.y = insets.top;
            rectangle3.width -= insets.left + insets.right;
            rectangle3.height -= insets.top + insets.bottom;
            if (this.calcSize != null && (dimension.width != this.calcSize.width || dimension.height != this.calcSize.height)) {
                if (dimension.width != 0) {
                    this.calcSize.width = dimension.width > this._wrapWidth ? dimension.width : this._wrapWidth;
                }
                this.parse();
                jComponent.revalidate();
            }
            this.layoutCL(jLabel, fontMetrics, string, icon, rectangle3, rectangle, rectangle2);
            if (this.calcSize != null) {
                if (this.textVector.size() == 1) {
                    n = rectangle.width + rectangle2.width + insets.left + insets.right;
                    n = n > this._wrapWidth ? n : this._wrapWidth;
                    this.calcSize.width = n > dimension.width ? dimension.width : n;
                }
                this.calcSize.height = (rectangle.height > rectangle2.height ? rectangle.height : rectangle2.height) + insets.top + insets.bottom;
            } else {
                this.calcSize = new Dimension(rectangle.width + rectangle2.width + insets.left + insets.right, (rectangle.height > rectangle2.height ? rectangle.height : rectangle2.height) + insets.top + insets.bottom);
            }
            if (icon != null) {
                icon.paintIcon(null, graphics, rectangle.x, rectangle.y);
            }
            int n2 = ((JLabel)jComponent).getHorizontalAlignment();
            if (string == null) break block12;
            int n3 = rectangle2.x;
            int n4 = rectangle2.y + fontMetrics.getAscent();
            char c = (char)jLabel.getDisplayedMnemonic();
            int n5 = fontMetrics.getHeight();
            int n6 = this.findAccChar(this.textVector, c);
            if (jLabel.isEnabled()) {
                graphics.setColor(jLabel.getForeground());
                for (n = 0; n < this.textVector.size(); ++n) {
                    char c2 = n == n6 ? c : (char)'\u0000';
                    BasicGraphicsUtils.drawString(graphics, (String)this.textVector.elementAt(n), c2, this.offsetArray[0], n4 + n5 * n);
                }
            } else {
                char c3;
                graphics.setColor(Color.gray);
                for (n = 0; n < this.textVector.size(); ++n) {
                    c3 = n == n6 ? c : (char)'\u0000';
                    BasicGraphicsUtils.drawString(graphics, (String)this.textVector.elementAt(n), c3, this.offsetArray[n], n4 + n5 * n);
                }
                graphics.setColor(Color.white);
                for (n = 0; n < this.textVector.size(); ++n) {
                    c3 = n == n6 ? c : (char)'\u0000';
                    BasicGraphicsUtils.drawString(graphics, (String)this.textVector.elementAt(n), c3, this.offsetArray[n] + 1, n4 + 1 + n5 * n);
                }
            }
        }
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        Dimension dimension = super.getPreferredSize(jComponent);
        int n = this.preferredSize != null ? this.preferredSize.width : dimension.width;
        int n2 = dimension.height;
        if (this.preferredSize != null) {
            n2 = this.preferredSize.height > n2 ? this.preferredSize.height : n2;
        }
        Dimension dimension2 = new Dimension(n, n2);
        return dimension2;
    }

    private final int computeStringVWidth(FontMetrics fontMetrics, Vector vector, int[] nArray) {
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < vector.size(); ++i) {
            nArray[i] = n = SwingUtilities.computeStringWidth(fontMetrics, (String)vector.elementAt(i));
            if (n <= n2) continue;
            n2 = n;
        }
        return n2;
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new MultilineLabelUI();
    }

    public void parse() {
        this._parsed = false;
    }

    public void setWrap(int n) {
        if (this.preferredSize == null) {
            this.preferredSize = new Dimension();
        }
        if (this.calcSize == null) {
            this.calcSize = new Dimension();
        }
        this._wrapWidth = n;
        this.preferredSize.width = n;
        this.calcSize.width = n;
    }

    protected void wrapString(Vector vector, FontMetrics fontMetrics, int n, String[] stringArray) {
        String string;
        String string2;
        String string3 = (String)vector.lastElement();
        if (null == string3 || "".equals(string3)) {
            return;
        }
        if (fontMetrics.stringWidth(string3) > n) {
            string2 = string3;
            string = "";
            int n2 = -1;
            int n3 = 0;
            block0: while (fontMetrics.stringWidth(string2) > n) {
                if (n3++ > 20) {
                    Debug.println("xxx wrapString: " + string2 + "," + n);
                    break;
                }
                for (int i = 0; i < stringArray.length && ((n2 = string2.lastIndexOf(stringArray[i])) == -1 || n2 == string2.length() - 1); ++i) {
                }
                if (n2 == -1) {
                    for (int i = string2.length() - 1; i > 1; --i) {
                        String string4 = string2.substring(0, i - 1);
                        if (fontMetrics.stringWidth(string4) >= n) continue;
                        string2 = string4;
                        string = string3.substring(string2.length());
                        continue block0;
                    }
                    continue;
                }
                string2 = string2.substring(0, n2 + 1).trim();
                string = string3.substring(n2 + 1);
            }
        } else {
            return;
        }
        vector.removeElementAt(vector.size() - 1);
        vector.addElement(string2);
        vector.addElement(string.trim());
        this.wrapString(vector, fontMetrics, n, stringArray);
    }

    protected void parseTextV(String string, Vector vector) {
        if (string == null || "".equals(string)) {
            vector.addElement("");
            return;
        }
        char[] cArray = string.toCharArray();
        int n = 0;
        int n2 = 0;
        for (n2 = 0; n2 < cArray.length; ++n2) {
            if (cArray[n2] != '\n') continue;
            vector.addElement(new String(cArray, n, n2 - n));
            n = n2 + 1;
        }
        if (n != cArray.length) {
            vector.addElement(new String(cArray, n, n2 - n));
        }
    }

    public String layoutCompoundLabel(FontMetrics fontMetrics, String string, Icon icon, int n, int n2, int n3, int n4, Rectangle rectangle, Rectangle rectangle2, Rectangle rectangle3, int n5) {
        int n6;
        if (icon != null) {
            rectangle2.width = icon.getIconWidth();
            rectangle2.height = icon.getIconHeight();
        } else {
            rectangle2.height = 0;
            rectangle2.width = 0;
        }
        boolean bl = string == null || string.equals("");
        int n7 = n6 = bl || icon == null ? 0 : n5;
        if (!this._parsed) {
            this.textVector = new Vector();
            if (this.calcSize != null) {
                int n8 = icon == null ? 0 : icon.getIconWidth();
                Vector vector = new Vector();
                this.parseTextV(string, vector);
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    this.textVector.addElement(string2);
                    this.wrapString(this.textVector, fontMetrics, this.calcSize.width - n6 - n8, SEPARATORS);
                }
            } else {
                this.parseTextV(string, this.textVector);
            }
            this._parsed = true;
        }
        this.widthArray = new int[this.textVector.size()];
        this.offsetArray = new int[this.widthArray.length];
        if (bl) {
            rectangle3.height = 0;
            rectangle3.width = 0;
            string = "";
        } else {
            rectangle3.width = this.computeStringVWidth(fontMetrics, this.textVector, this.widthArray);
            rectangle3.height = fontMetrics.getHeight() * this.textVector.size();
        }
        rectangle3.y = n3 == 1 ? (n4 != 0 ? 0 : -(rectangle3.height + n6)) : (n3 == 0 ? rectangle2.height / 2 - rectangle3.height / 2 : (n4 != 0 ? rectangle2.height - rectangle3.height : rectangle2.height + n6));
        rectangle3.x = n4 == 2 ? -(rectangle3.width + n6) : (n4 == 0 ? rectangle2.width / 2 - rectangle3.width / 2 : rectangle2.width + n6);
        Rectangle rectangle4 = rectangle2.union(rectangle3);
        int n9 = n == 1 ? rectangle.y - rectangle4.y : (n == 0 ? rectangle.y + rectangle.height / 2 - (rectangle4.y + rectangle4.height / 2) : rectangle.y + rectangle.height - (rectangle4.y + rectangle4.height));
        int n10 = n2 == 2 ? rectangle.x - rectangle4.x : (n2 == 0 ? rectangle.x + rectangle.width / 2 - (rectangle4.x + rectangle4.width / 2) : rectangle.x + rectangle.width - (rectangle4.x + rectangle4.width));
        rectangle3.x += n10;
        rectangle3.y += n9;
        rectangle2.x += n10;
        rectangle2.y += n9;
        this.computeOffset(rectangle3, n2, this.widthArray, this.offsetArray);
        return string;
    }

    final void computeOffset(Rectangle rectangle, int n, int[] nArray, int[] nArray2) {
        for (int i = 0; i < nArray.length; ++i) {
            if (2 == n) {
                nArray2[i] = rectangle.x;
                continue;
            }
            if (4 == n) {
                nArray2[i] = rectangle.x + rectangle.width - nArray[i];
                continue;
            }
            if (0 != n) continue;
            nArray2[i] = rectangle.x + (int)((double)(rectangle.width - nArray[i]) * 0.5);
        }
    }

    final int findAccChar(Vector vector, char c) {
        for (int i = 0; i < vector.size(); ++i) {
            String string = (String)vector.elementAt(i);
            if (string.indexOf(c) == -1) continue;
            return i;
        }
        return 0;
    }
}

