/*
 * Decompiled with CFR 0.152.
 */
package com.netscape.page;

import com.netscape.page.BDocument;
import com.netscape.page.FormattedStringContent;
import com.netscape.page.Layout;
import com.netscape.page.PageUI;
import com.netscape.page.TEXTAREAeditor;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;

public class BTEXTAREAeditor
extends TEXTAREAeditor {
    FormattedStringContent _strContent;
    BDocument _doc;
    boolean _keyDown;

    public Component getEditor(PageUI pageUI, Layout layout) {
        this._listenToEvents = false;
        Component component = super.getEditor(pageUI, layout);
        this._strContent = new FormattedStringContent(layout);
        this._doc = new BDocument();
        this._editor.setDocument(this._doc);
        this._editor.addCaretListener(new TokenSelector());
        this._editor.addKeyListener(new BKeyListener());
        this._editor.getDocument().addDocumentListener(new BDocListener());
        this._keyDown = false;
        return component;
    }

    public Component getFocusComponent() {
        return super.getFocusComponent();
    }

    protected boolean setValueHandler(Object object) {
        boolean bl = true;
        this._strContent = new FormattedStringContent(this.layout);
        ((AbstractDocument)this._editor.getDocument()).getDocumentProperties().remove("lineLimit");
        if (object != null) {
            bl = super.setValueHandler(object);
        }
        return bl;
    }

    public Object getValue() {
        return this._strContent == null ? null : this._strContent.getOrigStringValue();
    }

    public void insertString(String string) {
        int n = this._editor.getSelectionStart();
        this._editor.replaceSelection(string);
    }

    class TokenSelector
    implements CaretListener {
        protected void select(int n, int n2) {
            BTEXTAREAeditor.this._editor.removeCaretListener(this);
            BTEXTAREAeditor.this._editor.select(n, n2);
            BTEXTAREAeditor.this._editor.addCaretListener(this);
        }

        protected void position(int n) {
            BTEXTAREAeditor.this._editor.removeCaretListener(this);
            BTEXTAREAeditor.this._editor.setCaretPosition(n);
            BTEXTAREAeditor.this._editor.addCaretListener(this);
        }

        public void caretUpdate(CaretEvent caretEvent) {
            if (BTEXTAREAeditor.this._strContent == null) {
                return;
            }
            int n = caretEvent.getDot();
            int n2 = caretEvent.getMark();
            int n3 = Math.min(n, n2);
            int n4 = Math.max(n, n2);
            int n5 = BTEXTAREAeditor.this._strContent.getReplacedSegmentCount();
            int[] nArray = BTEXTAREAeditor.this._strContent.getReplacedSegmentArray();
            if (n5 <= 0 || nArray == null) {
                return;
            }
            int n6 = 0;
            int n7 = 0;
            while (n6 < n5) {
                if (nArray[n7] < n3 && nArray[n7 + 1] >= n3) {
                    n3 = nArray[n7];
                }
                if (nArray[n7 + 1] > n4 && nArray[n7] <= n4) {
                    n4 = nArray[n7 + 1];
                }
                ++n6;
                n7 += 2;
            }
            if (n3 == n4) {
                this.position(n3);
            } else if (BTEXTAREAeditor.this._keyDown) {
                if (n == n3 + 1) {
                    this.position(n4);
                } else if (n == n4 - 1) {
                    this.position(n3);
                }
            } else {
                this.select(n3, n4);
            }
            BTEXTAREAeditor.this._keyDown = false;
        }
    }

    class BKeyListener
    extends KeyAdapter {
        BKeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            BTEXTAREAeditor.this._keyDown = true;
        }
    }

    private class ScrollState {
        JScrollPane _scrollPane;
        JScrollBar _hBar;
        JScrollBar _vBar;
        int _hScroll;
        int _vScroll;

        public ScrollState(JScrollPane jScrollPane) {
            this._scrollPane = jScrollPane;
            this._hBar = this._scrollPane.getHorizontalScrollBar();
            this._vBar = this._scrollPane.getVerticalScrollBar();
            if (this._hBar != null) {
                this._hScroll = this._hBar.getValue();
            }
            if (this._vBar != null) {
                this._vScroll = this._vBar.getValue();
            }
        }

        public void preserveState() {
            if (this._hBar != null) {
                this._hBar.setValue(this._hScroll);
            }
            if (this._vBar != null) {
                this._vBar.setValue(this._vScroll);
            }
        }
    }

    class BDocListener
    implements DocumentListener {
        protected boolean _listening = true;

        BDocListener() {
        }

        public void startListening() {
            this._listening = true;
        }

        public void stopListening() {
            this._listening = false;
        }

        public boolean isListening() {
            return this._listening;
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            if (!this.isListening()) {
                return;
            }
            if (BTEXTAREAeditor.this._strContent == null) {
                return;
            }
            int n = documentEvent.getOffset();
            int n2 = documentEvent.getLength();
            String string = BTEXTAREAeditor.this._editor.getText();
            if (n2 > 0 && n >= 0 && string != null) {
                String string2 = string.substring(n, n + n2);
                try {
                    BTEXTAREAeditor.this._strContent.insertString(n, string2);
                    this.updateTextArea();
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            if (!this.isListening()) {
                return;
            }
            int n = documentEvent.getOffset();
            int n2 = documentEvent.getLength();
            if (n2 > 0 && n >= 0) {
                try {
                    BTEXTAREAeditor.this._strContent.remove(n, n2);
                    this.updateTextArea();
                    int n3 = BTEXTAREAeditor.this._strContent.getLastRemoveOffset();
                    BTEXTAREAeditor.this._editor.select(n3, n3);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
            }
        }

        public void changedUpdate(DocumentEvent documentEvent) {
            if (!this.isListening()) {
                return;
            }
        }

        protected void updateTextArea() {
            BTEXTAREAeditor.this._doc.setUpdateMode(true);
            BTEXTAREAeditor.this._editor.setText(BTEXTAREAeditor.this._strContent.getString());
            this.stopListening();
            BTEXTAREAeditor.this._doc.fireRecentEvents();
            this.startListening();
            BTEXTAREAeditor.this._doc.setUpdateMode(false);
            if (BTEXTAREAeditor.this.owner != null) {
                BTEXTAREAeditor.this.owner.fireCtrlModified(BTEXTAREAeditor.this.getID(), BTEXTAREAeditor.this);
            }
        }
    }
}

