/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ens.test;

import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Simpleparser
extends DefaultHandler {
    private Writer out = new OutputStreamWriter(System.out);
    private String indentString = "    ";
    private int indentLevel = 0;
    private String currentElement;
    public String sessionID = "";

    public static void main(String[] stringArray) {
        if (stringArray.length != 1) {
            System.err.println("Usage: cmd filename");
            System.exit(1);
        }
        Simpleparser simpleparser = new Simpleparser();
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(new File(stringArray[0]), (DefaultHandler)simpleparser);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        System.exit(0);
    }

    public void startDocument() throws SAXException {
        this.nl();
        this.nl();
        this.emit("START DOCUMENT");
        this.nl();
        this.emit("<?xml version='1.0' encoding='UTF-8'?>");
    }

    public void endDocument() throws SAXException {
        this.nl();
        this.emit("END DOCUMENT");
        try {
            this.nl();
            this.out.flush();
        }
        catch (IOException iOException) {
            throw new SAXException("I/O error", iOException);
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        ++this.indentLevel;
        this.nl();
        this.emit("ELEMENT: ");
        String string4 = string2;
        if ("".equals(string4)) {
            string4 = string3;
        }
        this.currentElement = string4;
        this.emit("<" + string4);
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String string5 = attributes.getLocalName(i);
                if ("".equals(string5)) {
                    string5 = attributes.getQName(i);
                }
                this.nl();
                this.emit("   ATTR: ");
                this.emit(string5);
                this.emit("\t\"");
                this.emit(attributes.getValue(i));
                this.emit("\"");
            }
        }
        if (attributes.getLength() > 0) {
            this.nl();
        }
        this.emit(">");
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        this.nl();
        this.emit("END_ELM: ");
        this.emit("</" + string2 + ">");
        --this.indentLevel;
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.currentElement.equals("X-NSCP-WCAP-SESSION-ID") && this.sessionID.equals("")) {
            this.sessionID = new String(cArray, n, n2);
            this.nl();
            this.emit("Snagged SessionID!!!");
        }
        this.nl();
        this.emit("CHARS:   ");
        String string = new String(cArray, n, n2);
        if (!string.trim().equals("")) {
            this.emit(string);
        }
    }

    private void emit(String string) throws SAXException {
        try {
            this.out.write(string);
            this.out.flush();
        }
        catch (IOException iOException) {
            throw new SAXException("I/O error", iOException);
        }
    }

    private void nl() throws SAXException {
        String string = System.getProperty("line.separator");
        try {
            this.out.write(string);
            for (int i = 0; i < this.indentLevel; ++i) {
                this.out.write(this.indentString);
            }
        }
        catch (IOException iOException) {
            throw new SAXException("I/O error", iOException);
        }
    }
}

