/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ens.jms;

import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;

public class EnsMessage
implements Message {
    String JMSMessageID;
    long JMSTimestamp;
    String JMSCorrelationID;
    Destination JMSReplyTo;
    Destination JMSDestination;
    int JMSDeliveryMode;
    boolean JMSRedelivered;
    String JMSType;
    long JMSExpiration;
    int JMSPriority;
    String body = null;
    Properties props = new Properties();

    EnsMessage() throws JMSException {
        this.clearProperties();
    }

    public String getJMSMessageID() throws JMSException {
        return this.JMSMessageID;
    }

    public void setJMSMessageID(String string) throws JMSException {
        this.JMSMessageID = string;
    }

    public long getJMSTimestamp() throws JMSException {
        return this.JMSTimestamp;
    }

    public void setJMSTimestamp(long l) throws JMSException {
        this.JMSTimestamp = l;
    }

    public byte[] getJMSCorrelationIDAsBytes() throws JMSException {
        return this.JMSCorrelationID.getBytes();
    }

    public void setJMSCorrelationIDAsBytes(byte[] byArray) throws JMSException {
        this.JMSCorrelationID = new String(byArray);
    }

    public void setJMSCorrelationID(String string) throws JMSException {
        this.JMSCorrelationID = string;
    }

    public String getJMSCorrelationID() throws JMSException {
        return this.JMSCorrelationID;
    }

    public Destination getJMSReplyTo() throws JMSException {
        return this.JMSReplyTo;
    }

    public void setJMSReplyTo(Destination destination) throws JMSException {
        this.JMSReplyTo = destination;
    }

    public Destination getJMSDestination() throws JMSException {
        return this.JMSDestination;
    }

    public void setJMSDestination(Destination destination) throws JMSException {
        this.JMSDestination = destination;
    }

    public int getJMSDeliveryMode() throws JMSException {
        return this.JMSDeliveryMode;
    }

    public void setJMSDeliveryMode(int n) throws JMSException {
        this.JMSDeliveryMode = n;
    }

    public boolean getJMSRedelivered() throws JMSException {
        return this.JMSRedelivered;
    }

    public void setJMSRedelivered(boolean bl) throws JMSException {
        this.JMSRedelivered = bl;
    }

    public String getJMSType() throws JMSException {
        return this.JMSType;
    }

    public void setJMSType(String string) throws JMSException {
        this.JMSType = string;
    }

    public long getJMSExpiration() throws JMSException {
        return this.JMSExpiration;
    }

    public void setJMSExpiration(long l) throws JMSException {
        this.JMSExpiration = l;
    }

    public int getJMSPriority() throws JMSException {
        return this.JMSPriority;
    }

    public void setJMSPriority(int n) throws JMSException {
        this.JMSPriority = n;
    }

    public void clearProperties() throws JMSException {
        this.body = null;
        this.props.clear();
        this.JMSMessageID = null;
        this.JMSTimestamp = 0L;
        this.JMSCorrelationID = null;
        this.JMSReplyTo = null;
        this.JMSDestination = null;
        this.JMSDeliveryMode = 1;
        this.JMSRedelivered = false;
        this.JMSType = null;
        this.JMSExpiration = 0L;
        this.JMSPriority = 0;
    }

    public boolean propertyExists(String string) throws JMSException {
        return this.props.containsKey(string);
    }

    public boolean getBooleanProperty(String string) throws JMSException {
        Boolean bl = Boolean.valueOf((String)this.props.get(string));
        return bl;
    }

    public byte getByteProperty(String string) throws JMSException {
        Byte by = Byte.valueOf((String)this.props.get(string));
        return by;
    }

    public short getShortProperty(String string) throws JMSException {
        Short s = Short.valueOf((String)this.props.get(string));
        return s;
    }

    public int getIntProperty(String string) throws JMSException {
        Integer n = Integer.valueOf((String)this.props.get(string));
        return n;
    }

    public long getLongProperty(String string) throws JMSException {
        Long l = Long.valueOf((String)this.props.get(string));
        return l;
    }

    public float getFloatProperty(String string) throws JMSException {
        Float f = Float.valueOf((String)this.props.get(string));
        return f.floatValue();
    }

    public double getDoubleProperty(String string) throws JMSException {
        Double d = Double.valueOf((String)this.props.get(string));
        return d;
    }

    public String getStringProperty(String string) throws JMSException {
        return (String)this.props.get(string);
    }

    public Object getObjectProperty(String string) throws JMSException {
        return this.props.get(string);
    }

    public Enumeration getPropertyNames() throws JMSException {
        return this.props.propertyNames();
    }

    public void setBooleanProperty(String string, boolean bl) throws JMSException {
        this.props.put(string, "" + bl);
    }

    public void setByteProperty(String string, byte by) throws JMSException {
        this.props.put(string, "" + by);
    }

    public void setShortProperty(String string, short s) throws JMSException {
        this.props.put(string, "" + s);
    }

    public void setIntProperty(String string, int n) throws JMSException {
        this.props.put(string, "" + n);
    }

    public void setLongProperty(String string, long l) throws JMSException {
        this.props.put(string, "" + l);
    }

    public void setFloatProperty(String string, float f) throws JMSException {
        this.props.put(string, "" + f);
    }

    public void setDoubleProperty(String string, double d) throws JMSException {
        this.props.put(string, "" + d);
    }

    public void setStringProperty(String string, String string2) throws JMSException {
        this.props.put(string, string2);
    }

    public void setObjectProperty(String string, Object object) throws JMSException {
        this.props.put(string, object);
    }

    public void acknowledge() throws JMSException {
        throw new JMSException("not implemented");
    }

    public void clearBody() throws JMSException {
        this.body = null;
    }

    protected void importProperties(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.toString(), "&");
        while (stringTokenizer.hasMoreElements()) {
            String string2 = stringTokenizer.nextToken();
            int n = string2.indexOf("=");
            if (n <= 0) continue;
            String string3 = string2.substring(0, n);
            String string4 = string2.substring(n + 1);
            this.props.put(string3, string4);
            if (string3.equals("evtType")) {
                this.JMSType = string4;
                continue;
            }
            if (!string3.equals("timestamp")) continue;
            this.JMSTimestamp = Long.parseLong(string4);
        }
    }
}

