/*
 * Decompiled with CFR 0.152.
 */
package com.iplanet.ens.gap;

import com.iplanet.ens.gap.GapMsg;
import com.iplanet.ens.gap.GapMsgListener;
import com.iplanet.ens.gap.GapProtocolException;
import com.iplanet.ens.gap.GapReader;
import com.iplanet.ens.gap.ParseException;
import java.io.BufferedInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.Socket;

public class Gap {
    Socket gapSocket;
    OutputStream tos;
    InputStream tis;
    OutputStream _logStream;
    String sessID;
    long txnID = 0L;
    GapReader _reader;
    Thread _readerThread;

    public Gap(String string, int n, String string2, OutputStream outputStream) throws IOException {
        Socket socket = new Socket(string, n);
        this.tis = new BufferedInputStream(socket.getInputStream(), 8192);
        this.tos = socket.getOutputStream();
        this._logStream = outputStream;
        this._reader = new GapReader(this.tis, string2, outputStream);
        this._readerThread = new Thread(this._reader);
    }

    public Gap(String string, int n, int n2, String string2, OutputStream outputStream) throws IOException {
        this(string, n, string2, outputStream);
        this.gapSocket.setSoTimeout(n2);
    }

    void write(String string, boolean bl) throws IOException {
        this.tos.write(string.getBytes());
        if (this._logStream != null && bl) {
            this._logStream.write((">> " + string).getBytes());
        }
    }

    void flush() throws IOException {
        this.tos.flush();
    }

    int avail() throws IOException {
        return this.tis.available();
    }

    public void initSocketHandshake() throws IOException, InterruptedException {
        String string = this._reader.readLine();
        if (string == null || string.compareTo("GAP Service Ready") != 0) {
            System.err.println("Invalid initialization string:" + string + " s.b. " + "GAP Service Ready");
            throw new IOException("Invalid initialization string:" + string + " s.b. " + "GAP Service Ready");
        }
        this._readerThread.start();
        this.write("GAP/1.0 - 1234 0 0 \r\n", true);
        GapMsg gapMsg = this.readData();
        this.sessID = gapMsg.getSessID();
        String string2 = gapMsg.getTxnID();
        if (string2.compareTo("-1234") != 0) {
            System.err.println("Invalid replyID:" + string2 + " s.b. -1234");
            throw new IOException("Invalid replyID:" + string2 + " s.b. -1234");
        }
        int n = gapMsg.getLen();
        if (n != 0) {
            System.err.println("Invalid payloadLen:" + n + " s.b. 0");
            throw new IOException("Invalid payloadLen:" + n + " s.b. 0");
        }
        String string3 = gapMsg.getAddress();
        if (string3.compareTo(this.sessID) != 0) {
            System.err.println("Invalid address:" + string3 + " s.b. " + this.sessID);
            throw new IOException("Invalid address:" + string3 + " s.b. " + this.sessID);
        }
        this._reader.releaseMsg(gapMsg);
    }

    public InputStream getInputStream() {
        return this.tis;
    }

    public boolean hasData() throws IOException {
        return this.avail() > 0;
    }

    public GapMsg readData() throws ParseException, InterruptedException, IOException {
        return this._reader.readMsg();
    }

    public void writeData(String string, String string2, boolean bl) throws IOException, InterruptedException {
        this.txnID += 2L;
        if (string2 == null || string2.length() == 0) {
            this.write(GapMsg.getVersion() + " " + this.sessID + " " + this.txnID + " 0 " + string + "\r\n", true);
        } else {
            this.write(GapMsg.getVersion() + " " + this.sessID + " " + this.txnID + " " + string2.length() + " " + string + "\r\n", true);
            this.write(string2, false);
        }
        this.flush();
        if (bl) {
            GapMsg gapMsg = this.readData();
            if (gapMsg != null) {
                if (gapMsg.getAddress().compareTo("AOK") != 0) {
                    System.err.println("Unexpected response: " + gapMsg.getAddress() + " s.b. AOK");
                    throw new GapProtocolException("Unexpected response: " + gapMsg.getAddress() + " s.b. AOK");
                }
                this._reader.releaseMsg(gapMsg);
            } else {
                throw new GapProtocolException("Unexpected response: (null) s.b. AOK");
            }
        }
    }

    public void addListener(GapMsgListener gapMsgListener) {
        this._reader.addListener(gapMsgListener);
    }

    public void close() throws IOException, InterruptedException {
        try {
            this.writeData("-|logo|00000000", null, true);
        }
        catch (GapProtocolException gapProtocolException) {
            // empty catch block
        }
        this._reader.close();
        this._readerThread.join();
        this.tos.close();
        this.tis.close();
    }

    public static void main(String[] stringArray) {
        String string = "localhost";
        int n = 7997;
        try {
            string = stringArray[0];
            n = Integer.parseInt(stringArray[1]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        try {
            boolean bl = false;
            System.setErr(new PrintStream(new FileOutputStream("Gap.err", bl)));
            System.setOut(new PrintStream(new FileOutputStream("Gap.out", bl)));
            FileOutputStream fileOutputStream = new FileOutputStream("Gap.log", bl);
            Gap gap = new Gap(string, n, null, fileOutputStream);
            gap.initSocketHandshake();
            gap.writeData("enp://127.0.0.1/store|subs|00000000", "", true);
            while (true) {
                GapMsg gapMsg = gap.readData();
                System.out.println("[" + gapMsg.getAddress() + "] " + gapMsg.getPayload());
                System.out.flush();
            }
        }
        catch (Exception exception) {
            System.out.println(exception.getMessage());
            exception.printStackTrace();
            System.out.println("Done!");
            System.exit(0);
            return;
        }
    }
}

