/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cms;

import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.cms.KEKRecipientInfo;
import org.bouncycastle.asn1.cms.KeyAgreeRecipientInfo;
import org.bouncycastle.asn1.cms.KeyTransRecipientInfo;

public class RecipientInfo
implements DEREncodable {
    DEREncodable info;

    public RecipientInfo(KeyTransRecipientInfo keyTransRecipientInfo) {
        this.info = keyTransRecipientInfo;
    }

    public RecipientInfo(KeyAgreeRecipientInfo keyAgreeRecipientInfo) {
        this.info = new DERTaggedObject(true, 1, keyAgreeRecipientInfo);
    }

    public RecipientInfo(KEKRecipientInfo kEKRecipientInfo) {
        this.info = new DERTaggedObject(true, 2, kEKRecipientInfo);
    }

    public RecipientInfo(DERObject dERObject) {
        this.info = dERObject;
    }

    public static RecipientInfo getInstance(Object object) {
        if (object == null || object instanceof RecipientInfo) {
            return (RecipientInfo)object;
        }
        if (object instanceof ASN1Sequence) {
            return new RecipientInfo((ASN1Sequence)object);
        }
        if (object instanceof ASN1TaggedObject) {
            return new RecipientInfo((ASN1TaggedObject)object);
        }
        throw new IllegalArgumentException("unknown object in factory: " + object.getClass().getName());
    }

    public DERInteger getVersion() {
        if (this.info instanceof ASN1TaggedObject) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)this.info;
            switch (aSN1TaggedObject.getTagNo()) {
                case 1: {
                    return KeyAgreeRecipientInfo.getInstance(aSN1TaggedObject, true).getVersion();
                }
                case 2: {
                    return KEKRecipientInfo.getInstance(aSN1TaggedObject, true).getVersion();
                }
            }
            throw new IllegalStateException("unknown tag");
        }
        return KeyTransRecipientInfo.getInstance(this.info).getVersion();
    }

    public boolean isTagged() {
        return this.info instanceof ASN1TaggedObject;
    }

    public DEREncodable getInfo() {
        if (this.info instanceof ASN1TaggedObject) {
            ASN1TaggedObject aSN1TaggedObject = (ASN1TaggedObject)this.info;
            switch (aSN1TaggedObject.getTagNo()) {
                case 1: {
                    return KeyAgreeRecipientInfo.getInstance(aSN1TaggedObject, true);
                }
                case 2: {
                    return KEKRecipientInfo.getInstance(aSN1TaggedObject, true);
                }
            }
            throw new IllegalStateException("unknown tag");
        }
        return KeyTransRecipientInfo.getInstance(this.info);
    }

    public DERObject getDERObject() {
        return this.info.getDERObject();
    }
}

