/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SignatureException;
import java.security.cert.CRLException;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.security.cert.X509Extension;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import java.util.Iterator;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.CertificateList;
import org.bouncycastle.asn1.x509.X509CertificateStructure;

public class CMSSignedDataGenerator {
    ArrayList h;
    ArrayList i;
    public static final String j = "1.2.840.113549.2.5";
    ArrayList k = new ArrayList();
    public static final String l = "1.2.840.10040.4.3";
    CertStore m;
    public static final String n = "1.2.840.113549.1.1.1";
    public static final String o = "1.3.14.3.2.26";

    public C024 a(C046 content, boolean encapsulate, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, C063 {
        ContentInfo encInfo;
        ASN1EncodableVector digestAlgs = new ASN1EncodableVector();
        ASN1EncodableVector signerInfos = new ASN1EncodableVector();
        Iterator it = this.i.iterator();
        while (it.hasNext()) {
            C057 signer = (C057)it.next();
            try {
                AlgorithmIdentifier digAlgId = this.e(signer.e(), signer.a());
                digestAlgs.add((DEREncodable)digAlgId);
                signerInfos.add((DEREncodable)signer.b(PKCSObjectIdentifiers.data, content, sigProvider));
            }
            catch (IOException e) {
                throw new C063("encoding error.", e);
            }
            catch (InvalidKeyException e) {
                throw new C063("key inappropriate for signature.", e);
            }
            catch (SignatureException e) {
                throw new C063("error creating signature.", e);
            }
            catch (CertificateEncodingException e) {
                throw new C063("error creating sid.", e);
            }
        }
        DERSet certificates = null;
        if (this.k.size() != 0) {
            ASN1EncodableVector v = new ASN1EncodableVector();
            it = this.k.iterator();
            while (it.hasNext()) {
                v.add((DEREncodable)it.next());
            }
            certificates = new DERSet((DEREncodableVector)v);
        }
        DERSet certrevlist = null;
        if (this.h.size() != 0) {
            ASN1EncodableVector v = new ASN1EncodableVector();
            it = this.h.iterator();
            while (it.hasNext()) {
                v.add((DEREncodable)it.next());
            }
            certrevlist = new DERSet((DEREncodableVector)v);
        }
        if (encapsulate) {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            try {
                content.b(bOut);
            }
            catch (IOException e) {
                throw new C063("encapsulation error.", e);
            }
            BERConstructedOctetString octs = new BERConstructedOctetString(bOut.toByteArray());
            encInfo = new ContentInfo(PKCSObjectIdentifiers.data, (DEREncodable)octs);
        } else {
            encInfo = new ContentInfo(PKCSObjectIdentifiers.data, null);
        }
        SignedData sd = new SignedData((ASN1Set)new DERSet((DEREncodableVector)digestAlgs), encInfo, (ASN1Set)certificates, (ASN1Set)certrevlist, (ASN1Set)new DERSet((DEREncodableVector)signerInfos));
        ContentInfo contentInfo = new ContentInfo(PKCSObjectIdentifiers.signedData, (DEREncodable)sd);
        return new C024(content, contentInfo);
    }

    public void b(PrivateKey key, X509Certificate cert, String digestOID, AttributeTable signedAttr, AttributeTable unsignedAttr) throws IllegalArgumentException {
        String encOID = null;
        if (key instanceof RSAPrivateKey) {
            encOID = n;
        } else if (key instanceof DSAPrivateKey) {
            encOID = l;
            if (!digestOID.equals(o)) {
                throw new IllegalArgumentException("can't mix DSA with anything but SHA1");
            }
        }
        this.i.add(new C057(this, key, cert, digestOID, encOID, signedAttr, unsignedAttr));
    }

    public void c(PrivateKey key, X509Certificate cert, String digestOID) throws IllegalArgumentException {
        String encOID = null;
        if (key instanceof RSAPrivateKey) {
            encOID = n;
        } else if (key instanceof DSAPrivateKey) {
            encOID = l;
            if (!digestOID.equals(o)) {
                throw new IllegalArgumentException("can't mix DSA with anything but SHA1");
            }
        }
        this.i.add(new C057(this, key, cert, digestOID, encOID));
    }

    public C024 d(C046 content, String sigProvider) throws NoSuchAlgorithmException, NoSuchProviderException, C063 {
        return this.a(content, false, sigProvider);
    }

    public CMSSignedDataGenerator() {
        this.h = new ArrayList();
        this.i = new ArrayList();
    }

    private AlgorithmIdentifier e(String oid, byte[] params) throws IOException {
        if (params != null) {
            return new AlgorithmIdentifier(new DERObjectIdentifier(oid), (DEREncodable)this.g(params));
        }
        return new AlgorithmIdentifier(new DERObjectIdentifier(oid), (DEREncodable)new DERNull());
    }

    public void f(CertStore certStore) throws CertStoreException, C063 {
        X509Extension c;
        Iterator<Object> it;
        try {
            it = certStore.getCertificates(null).iterator();
            while (it.hasNext()) {
                c = (X509Certificate)it.next();
                this.k.add(new X509CertificateStructure((ASN1Sequence)this.g(((Certificate)((Object)c)).getEncoded())));
            }
        }
        catch (IOException e) {
            throw new C063("error processing certs", e);
        }
        catch (CertificateEncodingException e) {
            throw new C063("error encoding certs", e);
        }
        try {
            it = certStore.getCRLs(null).iterator();
            while (it.hasNext()) {
                c = (X509CRL)it.next();
                this.h.add(new CertificateList((ASN1Sequence)this.g(((X509CRL)c).getEncoded())));
            }
        }
        catch (IOException e) {
            throw new C063("error processing crls", e);
        }
        catch (CRLException e) {
            throw new C063("error encoding crls", e);
        }
    }

    private DERObject g(byte[] encoding) throws IOException {
        if (encoding == null) {
            return null;
        }
        ByteArrayInputStream bIn = new ByteArrayInputStream(encoding);
        ASN1InputStream aIn = new ASN1InputStream((InputStream)bIn);
        return aIn.readObject();
    }
}

