/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.smime.security.pkcs11.wrapper;

import com.sun.messaging.smime.security.pkcs11.wrapper.Functions;
import com.sun.messaging.smime.security.pkcs11.wrapper.PKCS11Constants;
import java.math.BigInteger;

public class CK_ATTRIBUTE
implements PKCS11Constants {
    public static final CK_ATTRIBUTE DECRYPT_NULL;
    public static final CK_ATTRIBUTE DECRYPT_TRUE;
    public static final CK_ATTRIBUTE DERIVE_TRUE;
    public static final CK_ATTRIBUTE WRAP_NULL;
    public static final CK_ATTRIBUTE WRAP_TRUE;
    public Object pValue;
    public static final CK_ATTRIBUTE TOKEN_FALSE;
    public static final CK_ATTRIBUTE SIGN_RECOVER_TRUE;
    public long type;
    public static final CK_ATTRIBUTE UNWRAP_TRUE;
    public static final CK_ATTRIBUTE SIGN_TRUE;
    public static final CK_ATTRIBUTE EXTRACTABLE_TRUE;
    public static final CK_ATTRIBUTE UNWRAP_NULL;
    public static final CK_ATTRIBUTE VERIFY_RECOVER_TRUE;
    public static final CK_ATTRIBUTE VERIFY_TRUE;
    public static final CK_ATTRIBUTE SENSITIVE_FALSE;
    public static final CK_ATTRIBUTE ENCRYPT_NULL;
    public static final CK_ATTRIBUTE ENCRYPT_TRUE;

    private String a() {
        if (this.pValue == null) {
            return "(null)";
        }
        return this.pValue.getClass().getName();
    }

    public CK_ATTRIBUTE(long type, Object pValue) {
        this.type = type;
        this.pValue = pValue;
    }

    public long getLong() {
        if (!(this.pValue instanceof Long)) {
            throw new RuntimeException("Not a Long: " + this.pValue.getClass().getName());
        }
        return (Long)this.pValue;
    }

    public BigInteger getBigInteger() {
        if (!(this.pValue instanceof byte[])) {
            throw new RuntimeException("Not a byte[]: " + this.a());
        }
        return new BigInteger(1, (byte[])this.pValue);
    }

    public CK_ATTRIBUTE() {
    }

    static byte[] b(BigInteger value) {
        byte[] data = value.toByteArray();
        if (data.length > 1 && data[0] == 0) {
            byte[] t = new byte[data.length - 1];
            System.arraycopy(data, 1, t, 0, data.length - 1);
            data = t;
        }
        return data;
    }

    public CK_ATTRIBUTE(long type, BigInteger value) {
        this.type = type;
        this.pValue = CK_ATTRIBUTE.b(value);
    }

    public String toString() {
        String prefix = Functions.getAttributeName(this.type) + " = ";
        if (this.type == 0L) {
            return prefix + Functions.getObjectClassName(this.getLong());
        }
        if (this.type == 256L) {
            return prefix + Functions.getKeyName(this.getLong());
        }
        return prefix + this.pValue;
    }

    public CK_ATTRIBUTE(long type, boolean value) {
        this.type = type;
        this.pValue = value;
    }

    static {
        TOKEN_FALSE = new CK_ATTRIBUTE(1L, false);
        SENSITIVE_FALSE = new CK_ATTRIBUTE(259L, false);
        EXTRACTABLE_TRUE = new CK_ATTRIBUTE(354L, true);
        ENCRYPT_TRUE = new CK_ATTRIBUTE(260L, true);
        DECRYPT_TRUE = new CK_ATTRIBUTE(261L, true);
        WRAP_TRUE = new CK_ATTRIBUTE(262L, true);
        UNWRAP_TRUE = new CK_ATTRIBUTE(263L, true);
        SIGN_TRUE = new CK_ATTRIBUTE(264L, true);
        VERIFY_TRUE = new CK_ATTRIBUTE(266L, true);
        SIGN_RECOVER_TRUE = new CK_ATTRIBUTE(265L, true);
        VERIFY_RECOVER_TRUE = new CK_ATTRIBUTE(267L, true);
        DERIVE_TRUE = new CK_ATTRIBUTE(268L, true);
        ENCRYPT_NULL = new CK_ATTRIBUTE(260L);
        DECRYPT_NULL = new CK_ATTRIBUTE(261L);
        WRAP_NULL = new CK_ATTRIBUTE(262L);
        UNWRAP_NULL = new CK_ATTRIBUTE(263L);
    }

    public CK_ATTRIBUTE(long type) {
        this.type = type;
    }

    public CK_ATTRIBUTE(long type, long value) {
        this.type = type;
        this.pValue = new Long(value);
    }

    public char[] getCharArray() {
        if (!(this.pValue instanceof char[])) {
            throw new RuntimeException("Not a char[]");
        }
        return (char[])this.pValue;
    }

    public boolean getBoolean() {
        if (!(this.pValue instanceof Boolean)) {
            throw new RuntimeException("Not a Boolean: " + this.pValue.getClass().getName());
        }
        return (Boolean)this.pValue;
    }

    public byte[] getByteArray() {
        if (!(this.pValue instanceof byte[])) {
            throw new RuntimeException("Not a byte[]: " + this.a());
        }
        return (byte[])this.pValue;
    }
}

