/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.smime.security.pkcs11;

import com.sun.messaging.smime.security.cardapi.CardAdmin;
import com.sun.messaging.smime.security.cardapi.CardException;
import com.sun.messaging.smime.security.cardapi.CardParameters;
import com.sun.messaging.smime.security.cardapi.CardReader;
import com.sun.messaging.smime.security.cardapi.CardToken;
import com.sun.messaging.smime.security.pkcs11.C052;
import com.sun.messaging.smime.security.pkcs11.C054;
import com.sun.messaging.smime.security.pkcs11.C083;
import com.sun.messaging.smime.security.pkcs11.PKCS11CardToken;
import com.sun.messaging.smime.security.pkcs11.wrapper.PKCS11;
import com.sun.messaging.smime.security.pkcs11.wrapper.PKCS11Exception;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Properties;

public final class PKCS11CardReader
extends CardReader {
    private PKCS11CardToken a;
    private CardAdmin b;
    private CardParameters c;
    private final C052 d;
    volatile boolean isShutdown;
    private boolean e;

    public synchronized CardToken getToken() throws CardException {
        if (this.isShutdown) {
            throw new CardException("Reader has been shutdown");
        }
        if (this.a != null && this.a.isValid()) {
            return this.a;
        }
        this.a = null;
        C054 pToken = this.d.c();
        if (pToken != null) {
            this.a = new PKCS11CardToken(this, pToken, this.c);
            this.a.registerCardAdmin(this.b);
        }
        return this.a;
    }

    public void registerCardAdmin(CardAdmin admin) {
        this.b = admin;
    }

    public PKCS11CardReader(CardParameters cp) throws IOException, GeneralSecurityException, CardException {
        super("PKCS#11");
        this.c = cp;
        Properties params = (Properties)cp.getParameters();
        this.e = cp.getProviderName().equalsIgnoreCase("MOZILLA");
        this.d = new C052(this.e, params, new SunPKCS11EventListener(this));
    }

    public synchronized void shutdown() throws CardException {
        if (this.isShutdown) {
            return;
        }
        try {
            this.d.f();
            if (!this.e) {
                this.d.r.C_Finalize(null);
            }
            PKCS11.releaseAllInstance();
            this.isShutdown = true;
        }
        catch (PKCS11Exception e) {
            throw new CardException("Error during shutdown", e);
        }
    }

    private static class SunPKCS11EventListener
    implements C083 {
        PKCS11CardReader reader;

        public void tokenInserted() {
            this.reader.b.reportKeystoreChange();
        }

        public void tokenRemoved() {
            this.reader.b.reportKeystoreChange();
        }

        SunPKCS11EventListener(PKCS11CardReader reader) {
            this.reader = reader;
        }
    }
}

