/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.smime.security.pkcs11;

import com.sun.messaging.smime.security.cardapi.CardException;
import com.sun.messaging.smime.security.pkcs11.C048;
import com.sun.messaging.smime.security.pkcs11.C054;
import com.sun.messaging.smime.security.pkcs11.C071;
import com.sun.messaging.smime.security.pkcs11.C084;
import com.sun.messaging.smime.security.pkcs11.wrapper.CK_ATTRIBUTE;
import com.sun.messaging.smime.security.pkcs11.wrapper.PKCS11Constants;
import com.sun.messaging.smime.security.pkcs11.wrapper.PKCS11Exception;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.security.auth.x500.X500Principal;

class C030
implements PKCS11Constants {
    private static final CK_ATTRIBUTE[] m;
    private static final byte[] n;
    private static final X509Certificate[] o;
    private static final String p = "Litronic";
    private static final CK_ATTRIBUTE[] q;
    private final C054 r;
    private static final int s = 128;
    private final boolean t;
    private static final CK_ATTRIBUTE[] u;
    private final List v;
    private final CertificateFactory w;
    private static final CK_ATTRIBUTE[] x;
    private static final boolean y = false;

    byte[][] a() throws PKCS11Exception {
        return this.j(new CK_ATTRIBUTE(258L));
    }

    X509Certificate[] b(X509Certificate cert) throws PKCS11Exception, CardException {
        X509Certificate[] x509CertificateArray;
        C071 session = null;
        X509Certificate[] chain = null;
        try {
            this.d();
            CK_ATTRIBUTE[] certAttrs = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L, cert.getEncoded())};
            session = this.r.m();
            this.r.r.C_FindObjectsInit(session.f(), certAttrs);
            long[] objs = this.r.r.C_FindObjects(session.f(), 1L);
            this.r.r.C_FindObjectsFinal(session.f());
            if (objs.length == 0) {
                throw new CardException("No such certificate");
            }
            CK_ATTRIBUTE[] keyAttrs = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258L)};
            this.r.r.C_GetAttributeValue(session.f(), objs[0], certAttrs);
            byte[] id = certAttrs[1].getByteArray();
            chain = this.i(id);
            if (chain == null) {
                chain = new X509Certificate[]{cert};
            }
            x509CertificateArray = chain;
            this.r.h(session);
        }
        catch (CertificateEncodingException e) {
            try {
                throw new CardException("Certificate error", e);
            }
            catch (Throwable throwable) {
                this.r.h(session);
                throw throwable;
            }
        }
        return x509CertificateArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private X509Certificate[] c(CK_ATTRIBUTE[] certAttrs) throws PKCS11Exception {
        C071 session = null;
        try {
            session = this.r.m();
            this.r.r.C_FindObjectsInit(session.f(), certAttrs);
            long[] objs = this.r.r.C_FindObjects(session.f(), 128L);
            this.r.r.C_FindObjectsFinal(session.f());
            if (objs.length == 0) {
                X509Certificate[] x509CertificateArray = o;
                return x509CertificateArray;
            }
            ArrayList<X509Certificate> list = new ArrayList<X509Certificate>(objs.length);
            for (int i = 0; i < objs.length; ++i) {
                CK_ATTRIBUTE[] attrs = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L)};
                try {
                    this.r.r.C_GetAttributeValue(session.f(), objs[i], attrs);
                    byte[] value = attrs[0].getByteArray();
                    X509Certificate cert = (X509Certificate)this.w.generateCertificate(new ByteArrayInputStream(value));
                    list.add(cert);
                    continue;
                }
                catch (CertificateException e) {
                    continue;
                }
                catch (PKCS11Exception e) {
                    String libVendor = new String(this.r.r.C_GetInfo().manufacturerID);
                    if (libVendor.indexOf(p) != -1) continue;
                    throw e;
                }
            }
            X509Certificate[] x509CertificateArray = list.toArray(o);
            return x509CertificateArray;
        }
        finally {
            this.r.h(session);
        }
    }

    C030(C054 token) throws GeneralSecurityException {
        this.r = token;
        this.w = CertificateFactory.getInstance("X.509");
        this.v = new ArrayList();
        this.t = (token.B.s.cryptokiVersion.minor & 0xFF) > 11;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void d() throws PKCS11Exception {
        C071 session = null;
        try {
            this.v.clear();
            session = this.r.m();
            this.r.r.C_FindObjectsInit(session.f(), x);
            long[] objs = this.r.r.C_FindObjects(session.f(), 128L);
            this.r.r.C_FindObjectsFinal(session.f());
            for (int i = 0; i < objs.length; ++i) {
                try {
                    long obj = objs[i];
                    CK_ATTRIBUTE[] attrs = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L), new CK_ATTRIBUTE(258L)};
                    this.r.r.C_GetAttributeValue(session.f(), obj, attrs);
                    byte[] enc = attrs[0].getByteArray();
                    X509Certificate cert = (X509Certificate)this.w.generateCertificate(new ByteArrayInputStream(enc));
                    Object idVal = attrs[1].pValue;
                    byte[] id = idVal == null ? n : (byte[])idVal;
                    C084 t = new C084(obj, cert, id);
                    this.v.add(t);
                    continue;
                }
                catch (PKCS11Exception e) {
                    e.printStackTrace();
                    continue;
                }
                catch (CertificateException e) {
                    e.printStackTrace();
                }
            }
            this.r.h(session);
        }
        catch (Throwable throwable) {
            this.r.h(session);
            throw throwable;
        }
    }

    byte[][] e() throws PKCS11Exception {
        return this.j(new CK_ATTRIBUTE(130L));
    }

    static {
        o = new X509Certificate[0];
        n = new byte[0];
        m = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(0L, 1L), new CK_ATTRIBUTE(128L, 0L), new CK_ATTRIBUTE(134L, true)};
        x = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(0L, 1L), new CK_ATTRIBUTE(128L, 0L)};
        q = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(0L, 3L), new CK_ATTRIBUTE(256L, 0L)};
        u = new CK_ATTRIBUTE[0];
    }

    X509Certificate[] f() throws PKCS11Exception {
        String libVendor = new String(this.r.r.C_GetInfo().manufacturerID);
        if (libVendor.indexOf(p) != -1) {
            return this.c(u);
        }
        return this.c(x);
    }

    PrivateKey g(X509Certificate cert) throws PKCS11Exception, CardException {
        PrivateKey privateKey;
        String libVendor = new String(this.r.r.C_GetInfo().manufacturerID);
        if (libVendor.indexOf(p) != -1) {
            return this.h(cert);
        }
        C071 session = null;
        try {
            PrivateKey key;
            CK_ATTRIBUTE[] certAttrs = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L, cert.getEncoded())};
            session = this.r.m();
            this.r.r.C_FindObjectsInit(session.f(), certAttrs);
            long[] objs = this.r.r.C_FindObjects(session.f(), 1L);
            this.r.r.C_FindObjectsFinal(session.f());
            if (objs.length == 0) {
                throw new CardException("No such certificate");
            }
            CK_ATTRIBUTE[] keyAttrs = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258L)};
            this.r.r.C_GetAttributeValue(session.f(), objs[0], keyAttrs);
            CK_ATTRIBUTE[] keySearchAttrs = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(1L, true), new CK_ATTRIBUTE(0L, 3L), new CK_ATTRIBUTE(256L, 0L), new CK_ATTRIBUTE(258L, keyAttrs[0].getByteArray())};
            this.r.r.C_FindObjectsInit(session.f(), keySearchAttrs);
            long[] keyObjs = this.r.r.C_FindObjects(session.f(), 128L);
            this.r.r.C_FindObjectsFinal(session.f());
            if (keyObjs.length == 0) {
                throw new CardException("Cannot find matching key");
            }
            if (keyObjs.length > 1) {
                throw new CardException("Key pair identifier not unique");
            }
            CK_ATTRIBUTE[] privateKeyAttrs = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(288L), new CK_ATTRIBUTE(258L)};
            this.r.r.C_GetAttributeValue(session.f(), keyObjs[0], privateKeyAttrs);
            int keyLength = privateKeyAttrs[0].getBigInteger().bitLength();
            privateKey = key = C048.e(session, keyObjs[0], "RSA", keyLength, privateKeyAttrs);
            this.r.h(session);
        }
        catch (CertificateEncodingException e) {
            try {
                throw new CardException("Certificate error", e);
            }
            catch (Throwable throwable) {
                this.r.h(session);
                throw throwable;
            }
        }
        return privateKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PrivateKey h(X509Certificate cert) throws PKCS11Exception, CardException {
        C071 session = null;
        PrivateKey key = null;
        try {
            CK_ATTRIBUTE[] attrs;
            int i2;
            session = this.r.m();
            this.r.r.C_FindObjectsInit(session.f(), u);
            long[] objs = this.r.r.C_FindObjects(session.f(), 128L);
            this.r.r.C_FindObjectsFinal(session.f());
            if (objs.length == 0) {
                PrivateKey privateKey = null;
                return privateKey;
            }
            byte[] keyIdentifier = null;
            X509CertSelector selector = new X509CertSelector();
            try {
                selector.setIssuer(cert.getIssuerX500Principal().getEncoded());
                selector.setSerialNumber(cert.getSerialNumber());
            }
            catch (IOException e) {
                throw new CardException("Error setting X509CertSelector: " + e.toString());
            }
            for (i2 = 0; i2 < objs.length; ++i2) {
                attrs = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L)};
                try {
                    this.r.r.C_GetAttributeValue(session.f(), objs[i2], attrs);
                    byte[] value = attrs[0].getByteArray();
                    X509Certificate certX = (X509Certificate)this.w.generateCertificate(new ByteArrayInputStream(value));
                    if (!selector.match(certX)) continue;
                    CK_ATTRIBUTE[] keyIdAttr = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258L)};
                    this.r.r.C_GetAttributeValue(session.f(), objs[i2], keyIdAttr);
                    keyIdentifier = keyIdAttr[0].getByteArray();
                    continue;
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            if (keyIdentifier == null) {
                PrivateKey i2 = null;
                return i2;
            }
            for (i2 = 0; i2 < objs.length; ++i2) {
                attrs = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(258L)};
                try {
                    this.r.r.C_GetAttributeValue(session.f(), objs[i2], attrs);
                    byte[] thisKeyIdentifier = attrs[0].getByteArray();
                    if (!Arrays.equals(keyIdentifier, thisKeyIdentifier)) continue;
                    CK_ATTRIBUTE[] privateKeyAttrs = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(288L), new CK_ATTRIBUTE(258L)};
                    this.r.r.C_GetAttributeValue(session.f(), objs[i2], privateKeyAttrs);
                    int keyLength = privateKeyAttrs[0].getBigInteger().bitLength();
                    key = C048.e(session, objs[i2], "RSA", keyLength, privateKeyAttrs);
                    break;
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
        }
        finally {
            this.r.h(session);
        }
        return key;
    }

    private X509Certificate[] i(byte[] id) {
        C084 info = null;
        Iterator t = this.v.iterator();
        while (t.hasNext() && !(info = (C084)t.next()).a(id)) {
            info = null;
        }
        if (info == null) {
            return null;
        }
        ArrayList<X509Certificate> chain = new ArrayList<X509Certificate>();
        block1: while (true) {
            X509Certificate cert = info.d;
            chain.add(cert);
            X500Principal subject = cert.getSubjectX500Principal();
            X500Principal issuer = cert.getIssuerX500Principal();
            if (subject.equals(issuer)) break;
            Iterator t2 = this.v.iterator();
            while (t2.hasNext()) {
                C084 nextInfo = (C084)t2.next();
                X500Principal nextSubject = nextInfo.d.getSubjectX500Principal();
                if (!issuer.equals(nextSubject)) continue;
                info = nextInfo;
                continue block1;
            }
            break;
        }
        return chain.toArray(o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[][] j(CK_ATTRIBUTE attr) throws PKCS11Exception {
        C071 session = null;
        try {
            session = this.r.m();
            this.r.r.C_FindObjectsInit(session.f(), x);
            long[] objs = this.r.r.C_FindObjects(session.f(), 128L);
            this.r.r.C_FindObjectsFinal(session.f());
            if (objs.length == 0) {
                byte[][] byArray = null;
                return byArray;
            }
            byte[][] returnAttrs = new byte[objs.length][];
            ArrayList list = new ArrayList(objs.length);
            for (int i = 0; i < objs.length; ++i) {
                CK_ATTRIBUTE[] attrs = new CK_ATTRIBUTE[]{attr};
                this.r.r.C_GetAttributeValue(session.f(), objs[i], attrs);
                byte[] value = attrs[0].getByteArray();
                returnAttrs[i] = value;
            }
            byte[][] byArrayArray = returnAttrs;
            return byArrayArray;
        }
        finally {
            this.r.h(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    X509Certificate[] k() throws PKCS11Exception {
        if (!this.t) {
            return o;
        }
        C071 session = null;
        try {
            session = this.r.m();
            this.r.r.C_FindObjectsInit(session.f(), m);
            long[] objs = this.r.r.C_FindObjects(session.f(), 128L);
            this.r.r.C_FindObjectsFinal(session.f());
            if (objs.length == 0) {
                X509Certificate[] x509CertificateArray = o;
                return x509CertificateArray;
            }
            ArrayList<X509Certificate> list = new ArrayList<X509Certificate>(objs.length);
            for (int i = 0; i < objs.length; ++i) {
                CK_ATTRIBUTE[] attrs = new CK_ATTRIBUTE[]{new CK_ATTRIBUTE(17L)};
                this.r.r.C_GetAttributeValue(session.f(), objs[i], attrs);
                byte[] value = attrs[0].getByteArray();
                try {
                    X509Certificate cert = (X509Certificate)this.w.generateCertificate(new ByteArrayInputStream(value));
                    list.add(cert);
                    continue;
                }
                catch (CertificateException e) {
                    // empty catch block
                }
            }
            X509Certificate[] x509CertificateArray = list.toArray(o);
            return x509CertificateArray;
        }
        finally {
            this.r.h(session);
        }
    }

    byte[][] l() throws PKCS11Exception {
        return this.j(new CK_ATTRIBUTE(129L));
    }
}

