/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.smime.security.cardapi;

import com.sun.messaging.smime.security.cardapi.CardAdmin;
import com.sun.messaging.smime.security.cardapi.CardException;
import java.security.InvalidKeyException;
import java.security.SignatureException;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Vector;
import javax.crypto.BadPaddingException;

public abstract class CardToken {
    private String a;

    public abstract X509Certificate[] getCertificateChain(X509Certificate var1) throws CardException;

    public abstract void registerCardAdmin(CardAdmin var1);

    public abstract byte[] decrypt(X509Certificate var1, String var2, byte[] var3) throws CardException, InvalidKeyException, BadPaddingException;

    public X509Certificate[] getUserCertificates(X509CertSelector selector) throws CardException {
        X509Certificate[] allUserCerts = this.getUserCertificates();
        Vector<X509Certificate> matchingCerts = new Vector<X509Certificate>(2);
        for (int i = 0; i < allUserCerts.length; ++i) {
            if (!selector.match(allUserCerts[i])) continue;
            matchingCerts.add(allUserCerts[i]);
        }
        if (matchingCerts.size() > 0) {
            return matchingCerts.toArray(new X509Certificate[0]);
        }
        return new X509Certificate[0];
    }

    protected CardToken(String providerName) {
        this.a = providerName;
    }

    public abstract X509Certificate[] getTrustedCertificates() throws CardException;

    public abstract X509Certificate[] getUserCertificates() throws CardException;

    public abstract boolean isValid() throws CardException;

    public abstract byte[] sign(X509Certificate var1, String var2, byte[] var3) throws CardException, InvalidKeyException, SignatureException, BadPaddingException;

    public String getProviderName() {
        return this.a;
    }
}

