/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.smime.security.cardapi;

import com.sun.messaging.smime.security.cardapi.CardAdmin;
import com.sun.messaging.smime.security.cardapi.CardConfiguration;
import com.sun.messaging.smime.security.cardapi.CardException;
import com.sun.messaging.smime.security.cardapi.CardToken;
import java.util.ArrayList;

public abstract class CardReader {
    private static CardReader[] a;
    private final String b;

    protected CardReader(String type) {
        if (type == null) {
            throw new NullPointerException();
        }
        this.b = type;
    }

    public static CardReader[] getCards() throws CardException {
        if (a == null) {
            throw new CardException("No cards configured");
        }
        return (CardReader[])a.clone();
    }

    public String toString() {
        return this.b + " CardReader";
    }

    public final String getType() {
        return this.b;
    }

    public static void setConfiguration(CardConfiguration[] config) throws CardException {
        ArrayList<CardReader> list = new ArrayList<CardReader>();
        for (int i = 0; i < config.length; ++i) {
            CardReader card = config[i].getCardReader();
            if (card == null) continue;
            list.add(card);
        }
        if (list.isEmpty()) {
            throw new CardException("No cards configured");
        }
        a = list.toArray(new CardReader[0]);
    }

    public abstract void shutdown() throws CardException;

    public abstract void registerCardAdmin(CardAdmin var1) throws CardException;

    public abstract CardToken getToken() throws CardException;
}

