/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.smime.applet;

import com.sun.messaging.smime.applet.AppletConstants;
import com.sun.messaging.smime.applet.AppletLogger;
import com.sun.messaging.smime.applet.C067;
import com.sun.messaging.smime.applet.SMIMEAppletAPI;
import com.sun.messaging.smime.applet.SMIMEAppletBase;
import com.sun.messaging.smime.applet.SMIMEAppletSpec;
import com.sun.messaging.smime.applet.TokenPinDialog;
import com.sun.messaging.smime.applet.X509CertWrapper;
import com.sun.messaging.smime.security.cardapi.CardAdmin;
import com.sun.messaging.smime.security.cardapi.CardException;
import com.sun.messaging.smime.security.cardapi.CardToken;
import com.sun.messaging.smime.security.fedcard.FedReader;
import com.sun.messaging.smime.security.fedcard.FedToken;
import java.applet.Applet;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Principal;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CertStoreParameters;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.security.cert.CollectionCertStoreParameters;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Header;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimeUtility;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.smime.SMIMECapabilitiesAttribute;
import org.bouncycastle.asn1.smime.SMIMECapability;
import org.bouncycastle.asn1.smime.SMIMECapabilityVector;
import org.bouncycastle.asn1.smime.SMIMEEncryptionKeyPreferenceAttribute;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.mail.smime.SMIMEUtil;

public class SMIMEAppletCard
extends SMIMEAppletBase
implements SMIMEAppletSpec,
AppletConstants {
    HashMap K = new HashMap();
    private String L;
    private static final int M = 2;
    private String N;
    private boolean O;
    private String P;
    private Session Q;
    private String R;
    private static final int S = 0;
    private X509CertWrapper[] T;
    private static final String U = "<br>";
    FedToken V;
    private String W;
    private IssuerAndSerialNumber X;
    private Applet Y;
    private boolean Z = false;
    private static final int ba = 1;
    private CardAdmin bb;

    public void setMessageBodyCharset(String strMessageID, String charset) {
        this.resetError();
        C047 msg = (C047)this.K.get(strMessageID);
        if (msg != null) {
            msg.bA(charset);
        } else {
            this.setError(AppletConstants.ERR_INVALID_MSGID);
        }
    }

    public String getCertificateProvider() {
        return this.P;
    }

    private Object a(C047 msgToSend) throws MessagingException, IOException {
        MimePart part = null;
        List list = msgToSend.bw();
        if (list.size() > 1) {
            MimeMultipart mpWrap = new MimeMultipart();
            for (int idx = 0; idx < list.size(); ++idx) {
                mpWrap.addBodyPart((BodyPart)((MimeBodyPart)list.get(idx)));
            }
            part = mpWrap;
        } else {
            part = (MimePart)list.get(0);
        }
        return part;
    }

    public String initMessage() {
        this.resetError();
        C065 guid = new C065();
        String sMsgID = guid.toString();
        C047 msg = new C047(sMsgID);
        this.K.put(sMsgID, msg);
        return sMsgID;
    }

    public boolean setAppletParameter(String sParam, String sValue) {
        boolean bOK = false;
        this.resetError();
        AppletLogger.log("Set Applet param " + sParam + " = " + sValue);
        if (sValue != null) {
            if ("card.admin".equalsIgnoreCase(sParam)) {
                this.L = sValue;
                AppletLogger.log("Card Admin = " + this.L);
                bOK = true;
            } else if ("crypt.forsender".equalsIgnoreCase(sParam)) {
                this.O = Boolean.valueOf(sValue);
                AppletLogger.log("Encrypt for sender = " + this.O);
                bOK = true;
            } else if ("card.libpath".equalsIgnoreCase(sParam)) {
                this.R = sValue;
                bOK = true;
            } else if ("card.tokenpath".equalsIgnoreCase(sParam)) {
                this.N = sValue;
                bOK = true;
            } else if ("card.htmllogin".equalsIgnoreCase(sParam)) {
                this.Z = Boolean.valueOf(sValue);
                bOK = true;
            } else {
                bOK = super.setAppletParameter(sParam, sValue);
            }
        }
        return bOK;
    }

    public String getSubject(String strMessageID) {
        this.resetError();
        String sSubject = "";
        C047 msg = (C047)this.K.get(strMessageID);
        if (msg != null) {
            sSubject = msg.R();
        } else {
            this.setError(AppletConstants.ERR_INVALID_MSGID);
        }
        return sSubject;
    }

    public SMIMEAppletCard() {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    public static boolean testCRLs(SMIMEAppletSpec applet) throws Exception {
        System.out.println(" BEGIN CRL TESTING ");
        boolean bPassed = true;
        X509CertWrapper[] arrWrappers = applet.getSignCertificates(null);
        for (int idx = 0; idx < arrWrappers.length; ++idx) {
            C045 certiaCert = new C045(arrWrappers[idx].b());
            System.out.println("Dist points for " + certiaCert.g() + ", " + arrWrappers[idx].a());
            if (certiaCert.q()) {
                List list = certiaCert.c(null);
                if (list.size() <= 0) {
                    System.out.println("\tFaield");
                    bPassed = false;
                    continue;
                }
                for (int idxDist = 0; idxDist < list.size(); ++idxDist) {
                    System.out.println("\t" + list.get(idxDist).toString());
                }
                continue;
            }
            System.out.println("\tNone");
        }
        System.out.println(" END CRL TESTING ");
        return bPassed;
    }

    public void removeAttachment(String strMessageID, int index) {
        this.resetError();
        C047 msg = (C047)this.K.get(strMessageID);
        if (msg != null) {
            msg.bf(index);
        } else {
            this.setError(AppletConstants.ERR_INVALID_MSGID);
        }
    }

    public void setMessageBodyTextType(String strMessageID, String contentType) {
        this.resetError();
        C047 msg = (C047)this.K.get(strMessageID);
        if (msg != null) {
            msg.bI(contentType);
        } else {
            this.setError(AppletConstants.ERR_INVALID_MSGID);
        }
    }

    public boolean isSignatureVerified(String strMessageID) {
        return this.h(strMessageID, 3);
    }

    public X509CertWrapper[] getSignCertificates(String sEmail) {
        this.resetError();
        if (this.T == null) {
            try {
                X509Certificate[] arrCerts = this.y().getUserCertificates();
                this.T = this.I(sEmail, arrCerts, true, false, null);
            }
            catch (CardException exp) {
                AppletLogger.log(exp);
                this.setError(AppletConstants.ERR_CARD_ERROR);
            }
        }
        return this.T;
    }

    private void b(Part part, C047 msgData) throws MessagingException, IOException {
        int BUF_SIZE = 8192;
        try {
            String fileName;
            File fileAtttached = null;
            try {
                fileName = MimeUtility.decodeWord((String)part.getFileName());
            }
            catch (Exception e) {
                fileName = part.getFileName();
            }
            fileName = this.o(fileName);
            fileAtttached = new File(msgData.T(fileName), fileName);
            fileAtttached.deleteOnExit();
            C078 attachOut = new C078(fileAtttached);
            InputStream attachIn = part.getDataHandler().getInputStream();
            byte[] buf = new byte[8192];
            int numRead = attachIn.read(buf);
            while (numRead >= 0) {
                if (numRead == 8192) {
                    attachOut.d(buf, 0, numRead);
                } else {
                    for (int k = 0; k < numRead; ++k) {
                        attachOut.a(buf[k]);
                    }
                }
                buf = new byte[8192];
                numRead = attachIn.read(buf);
            }
            attachOut.b();
            attachOut.e();
            attachIn.close();
            AppletLogger.log("Tmp save attachment " + fileAtttached);
            msgData.bt(fileAtttached);
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public void saveAttachment(String messageID, int fileHashCode, String fileName) {
        this.resetError();
        C047 msg = (C047)this.K.get(messageID);
        if (msg != null) {
            try {
                msg.t(fileHashCode, fileName);
            }
            catch (IOException exp) {
                this.setError(AppletConstants.ERR_ATTACH_SAVE_ERROR, exp);
                AppletLogger.log(exp);
            }
        } else {
            this.setError(AppletConstants.ERR_INVALID_MSGID);
        }
    }

    public void setWMAPParameters(String strMessageID, float tzoffset, String copy, String receipt, String priority) {
        this.resetError();
        C047 msg = (C047)this.K.get(strMessageID);
        if (msg != null) {
            msg.bu("TZ", new Float(tzoffset));
            msg.bu("COPY", copy);
            msg.bu("RECPT", receipt);
            msg.bu("PRI", priority);
        } else {
            this.setError(AppletConstants.ERR_INVALID_MSGID);
        }
    }

    private X509Certificate c(IssuerAndSerialNumber issAndSerial, FedToken card, String sProvider) throws IOException, CardException {
        X509Certificate found = null;
        X509CertSelector selector = new X509CertSelector();
        selector.setIssuer(issAndSerial.getName().toString());
        selector.setSerialNumber(issAndSerial.getSerialNumber().getValue());
        X509Certificate[] certs = null;
        certs = sProvider != null && sProvider.length() > 0 ? card.getUserCertificates(selector, sProvider) : card.getUserCertificates(selector);
        if (certs != null && certs.length >= 1) {
            found = certs[0];
        } else {
            this.setError(AppletConstants.ERR_NO_SIGN_CERT);
        }
        return found;
    }

    public String getInvalidRecipientList(String strMessageID) {
        this.resetError();
        C047 msg = (C047)this.K.get(strMessageID);
        String sInvalid = "";
        if (msg != null) {
            sInvalid = msg.f(false);
        } else {
            this.setError(AppletConstants.ERR_INVALID_MSGID);
        }
        return sInvalid;
    }

    public void setVerificationOptions(String strMessageID, int iOption, boolean bSet) {
        this.resetError();
        C047 msg = (C047)this.K.get(strMessageID);
        if (msg != null) {
            switch (iOption) {
                case 0: {
                    msg.i(7, false);
                    msg.i(8, false);
                    msg.i(9, false);
                    msg.i(10, false);
                    msg.i(11, false);
                    msg.i(12, false);
                    break;
                }
                case 1: {
                    msg.i(7, bSet);
                    break;
                }
                case 2: {
                    msg.i(8, bSet);
                    break;
                }
                case 3: {
                    msg.i(9, bSet);
                    break;
                }
                case 4: {
                    msg.i(10, bSet);
                    break;
                }
                case 5: {
                    msg.i(11, bSet);
                    break;
                }
                case 6: {
                    msg.i(12, bSet);
                    break;
                }
                default: {
                    this.setError(AppletConstants.ERR_INVALID_VERIFY_OPTION);
                }
            }
            msg.bs(0);
        } else {
            this.setError(AppletConstants.ERR_INVALID_MSGID);
        }
    }

    public long getAttachmentSize(String strMessageID, String strAttachment) {
        this.resetError();
        long lSize = -1L;
        C047 msg = (C047)this.K.get(strMessageID);
        if (msg != null) {
            lSize = msg.h(strAttachment);
        } else {
            this.setError(AppletConstants.ERR_INVALID_MSGID);
        }
        return lSize;
    }

    public boolean setDigestAlg(String strMessageID, String strAlg) {
        this.resetError();
        boolean bOK = false;
        C047 msg = (C047)this.K.get(strMessageID);
        if (msg != null) {
            bOK = msg.B(strAlg);
        } else {
            this.setError(AppletConstants.ERR_INVALID_MSGID);
        }
        return bOK;
    }

    public void destroy() {
        this.resetError();
    }

    private int d(C047 msgToSend) {
        return 0;
    }

    private int e(C047 msgToSend) {
        return 0;
    }

    private String f(Address[] arrAddr) {
        StringBuffer buffer = new StringBuffer();
        for (int idx = 0; idx < arrAddr.length; ++idx) {
            if (buffer.length() > 0) {
                buffer.append(";");
            }
            if (arrAddr[idx] instanceof InternetAddress) {
                InternetAddress rfc822Addr = (InternetAddress)arrAddr[idx];
                buffer.append(rfc822Addr.toString());
                continue;
            }
            buffer.append(arrAddr[idx].toString());
        }
        return buffer.toString();
    }

    public void stop() {
        if (this.V != null) {
            try {
                this.V.shutdown();
            }
            catch (CardException e) {
                AppletLogger.log("Error in shuting down crypto token: " + e);
            }
        }
        this.resetError();
    }

    public String getUnhandledMimePartsListErrors(String strMessageID) {
        this.resetError();
        C047 msg = (C047)this.K.get(strMessageID);
        if (msg != null) {
            return msg.w();
        }
        this.setError(AppletConstants.ERR_INVALID_MSGID);
        return null;
    }

    public int addAttachment(String strMessageID, String strFilename) {
        this.resetError();
        C047 msg = (C047)this.K.get(strMessageID);
        if (msg == null) {
            this.setError(AppletConstants.ERR_INVALID_MSGID);
            return 0;
        }
        try {
            C095 entity = msg.bl(strFilename, this.maxPostSize, this.maxMessageSize);
            return entity.b();
        }
        catch (C013 e) {
            switch (e.a()) {
                case 2: {
                    this.setError(AppletConstants.ERR_CANNOT_READ_FILE);
                    break;
                }
                case 1: {
                    this.setError(AppletConstants.ERR_NONEXISTENT_FILE);
                    break;
                }
                case 4: {
                    this.setError(AppletConstants.ERR_OVER_MAX_MESSAGE_SIZE);
                    break;
                }
                case 3: {
                    this.setError(AppletConstants.ERR_OVER_MAX_POST_SIZE);
                    break;
                }
                case 5: {
                    this.setError(AppletConstants.ERR_FILE_ALREADY_ATTACHED);
                    break;
                }
                default: {
                    AppletLogger.log("Unprocessed exception from addAttachment");
                    AppletLogger.log(e);
                }
            }
            return 0;
        }
    }

    public static boolean testSend(SMIMEAppletSpec applet, boolean bSMTP) {
        System.out.println(" BEGIN SEND TESTING ");
        boolean bPassed = false;
        String[][] arrMsgData = new String[][]{{Integer.toString(0), "Attached-mime", "<b>Body for Attached mime</b>", "C:\\Documents and Settings\\rjacob\\My Documents\\My Pictures\\test.zip"}, {Integer.toString(1), "Signed", "<b>Body for Signed</b>", ""}, {Integer.toString(1), "Signed-Attachment", "<b>Body for Signed Attachment</b>", "C:\\Documents and Settings\\rjacob\\My Documents\\My Pictures\\test.zip"}, {Integer.toString(3), "Encrypted", "<b>Body for Encrypted</b>", ""}, {Integer.toString(3), "EncryptedAttach", "<b>Body for EncryptedAttach</b>", "C:\\Documents and Settings\\rjacob\\My Documents\\My Pictures\\test.zip"}, {Integer.toString(2), "SignEncrypted", "<b>Body for SignEncrypted</b>", ""}, {Integer.toString(2), "SignEncryptedAttach", "<b>Body for SignEncryptedAttach</b>", "C:\\Documents and Settings\\rjacob\\My Documents\\My Pictures\\test.zip"}};
        int idx = 0;
        for (idx = 0; idx < arrMsgData.length; ++idx) {
            System.out.println("\n\n\n---Sending " + arrMsgData[idx][1] + " --------");
            String sMsgID = applet.initMessage();
            int iMsgType = Integer.valueOf(arrMsgData[idx][0]);
            applet.setMessageType(sMsgID, iMsgType);
            applet.setFrom(sMsgID, "rjacob@ilumin.co.uk");
            applet.addRecipient(sMsgID, "tom@ilumin.co.uk", 1);
            applet.setSubject(sMsgID, arrMsgData[idx][1]);
            applet.setMessageBodyText(sMsgID, arrMsgData[idx][2]);
            applet.setMessageBodyTextType(sMsgID, "text/html");
            applet.setVerificationOptions(sMsgID, 4, true);
            applet.setVerificationOptions(sMsgID, 1, true);
            applet.setVerificationOptions(sMsgID, 5, true);
            applet.setVerificationOptions(sMsgID, 2, true);
            if (arrMsgData[idx][3].length() > 0) {
                applet.addAttachment(sMsgID, arrMsgData[idx][3]);
                if (applet.getAttachmentSize(sMsgID, arrMsgData[idx][3]) < 0L) {
                    System.out.println("Invalid attachment size " + arrMsgData[idx][3]);
                    break;
                }
            }
            applet.setWMAPParameters(sMsgID, 0.0f, "Sent", "0", "normal");
            applet.setDigestAlg(sMsgID, "MD5");
            int iSend = applet.send(sMsgID);
            if (iSend != 1 && iSend != 2 && iSend != 0) {
                System.out.println("Failed to send " + arrMsgData[idx][1] + " error " + SMIMEAppletAPI.toCertVerifyString(iSend));
                if (iSend == 15 || iSend == 12 || iSend == 14 || iSend == 13 || iSend == 11) {
                    System.out.println("Invalid recipients " + applet.getInvalidRecipientList(sMsgID));
                    StringBuffer buff = new StringBuffer();
                    String sErrors = applet.getInvalidRecipientListErrors(sMsgID);
                    if (sErrors.indexOf(";") >= 0) {
                        StringTokenizer tokens = new StringTokenizer(sErrors, ";");
                        while (tokens.hasMoreTokens()) {
                            int iError = Integer.parseInt(tokens.nextToken().trim());
                            buff.append(SMIMEAppletAPI.toCertVerifyString(iError));
                            buff.append(", ");
                        }
                    } else {
                        int iError = Integer.parseInt(sErrors.trim());
                        buff.append(SMIMEAppletAPI.toCertVerifyString(iError));
                    }
                    System.out.println("Errors " + buff.toString());
                }
                --idx;
                break;
            }
            if (applet.getLastErrorNumber() < 0) {
                --idx;
                break;
            }
            applet.releaseMessage(sMsgID);
            System.out.println("---Done " + arrMsgData[idx][1] + " --------\n\n\n");
        }
        bPassed = idx == arrMsgData.length;
        System.out.println(" END SEND TESTING ");
        return bPassed;
    }

    public void setAttachments(String strMessageID, String strAttachments) {
        this.resetError();
        AppletLogger.log("Set attachements " + strAttachments);
        C047 msg = (C047)this.K.get(strMessageID);
        if (msg == null) {
            this.setError(AppletConstants.ERR_INVALID_MSGID);
            return;
        }
        StringTokenizer tokens = new StringTokenizer(strAttachments, File.pathSeparator);
        block9: while (tokens.hasMoreTokens()) {
            String sAttach = tokens.nextToken();
            try {
                C095 entity = msg.bl(sAttach, this.maxPostSize, this.maxMessageSize);
            }
            catch (C013 e) {
                switch (e.a()) {
                    case 2: {
                        this.setError(AppletConstants.ERR_CANNOT_READ_FILE);
                        continue block9;
                    }
                    case 1: {
                        this.setError(AppletConstants.ERR_NONEXISTENT_FILE);
                        continue block9;
                    }
                    case 4: {
                        this.setError(AppletConstants.ERR_OVER_MAX_MESSAGE_SIZE);
                        continue block9;
                    }
                    case 3: {
                        this.setError(AppletConstants.ERR_OVER_MAX_POST_SIZE);
                        continue block9;
                    }
                    case 5: {
                        this.setError(AppletConstants.ERR_FILE_ALREADY_ATTACHED);
                        continue block9;
                    }
                }
                AppletLogger.log("Unprocessed exception from addAttachment");
                AppletLogger.log(e);
            }
        }
    }

    private void g(Part message, C047 msgData) {
        try {
            Address[] arrBCC;
            Address[] arrCC;
            MimeMessage mimeMsg = (MimeMessage)message.getContent();
            msgData.s("<br><br><hr style=\"width: 100%; height: 2px;\"><br>");
            Address[] arrFrom = mimeMsg.getFrom();
            msgData.s("From: " + this.f(arrFrom) + U);
            String arrDate = mimeMsg.getSentDate().toString();
            msgData.s("Sent: " + arrDate + U);
            Address[] arrTo = mimeMsg.getRecipients(MimeMessage.RecipientType.TO);
            if (arrTo != null && arrTo.length > 0) {
                msgData.s("To: " + this.f(arrTo) + U);
            }
            if ((arrCC = mimeMsg.getRecipients(MimeMessage.RecipientType.CC)) != null && arrTo.length > 0) {
                msgData.s("CC: " + this.f(arrCC) + U);
            }
            if ((arrBCC = mimeMsg.getRecipients(MimeMessage.RecipientType.BCC)) != null && arrCC.length > 0) {
                msgData.s("BCC: " + this.f(arrBCC) + U);
            }
            msgData.s("Subject: " + mimeMsg.getSubject() + U + U);
        }
        catch (Exception e) {
            AppletLogger.log("Error adding mail headers: " + e);
        }
    }

    public int saveDraft(String strMessageID) {
        int iResult = -1;
        this.resetError();
        if (this.m_sendMethod == 0 || this.m_sendMethod == 1) {
            this.setError(AppletConstants.ERR_INVALID_SENDMETHOD);
        } else {
            C047 msgToSend = (C047)this.K.get(strMessageID);
            if (msgToSend != null) {
                msgToSend.p(6);
                Object msgParts = null;
                try {
                    msgParts = this.t(msgToSend);
                }
                catch (Exception exp) {
                    AppletLogger.log(exp);
                    this.setError(AppletConstants.ERR_MIME_ERROR);
                }
                iResult = msgToSend.K();
                AppletLogger.log("Saving draft");
                if (msgParts != null) {
                    C066 wmap = new C066(this.m_strSendURL, this.m_wmapSid, msgParts);
                    wmap.b(C066.u, msgToSend.bq(1));
                    wmap.b(C066.K, msgToSend.bq(2));
                    wmap.b(C066.Q, msgToSend.bq(3));
                    wmap.n(C066.H, msgToSend.R());
                    Object junk = msgToSend.j("COPY");
                    wmap.b(C066.P, msgToSend.j("PRI"));
                    wmap.b(C066.z, msgToSend.j("RECPT"));
                    wmap.b(C066.y, msgToSend.j("TZ"));
                    wmap.n(C066.q, "false");
                    if (msgToSend.bc(C066.I) == null) {
                        wmap.n(C066.I, "Drafts");
                    }
                    wmap.i(msgToSend.bj());
                    try {
                        int nuid;
                        C023 resp = wmap.e(3);
                        if (resp.e() != 0) {
                            this.setError(resp.e(), resp.f());
                            iResult = 24;
                        }
                        if ((nuid = resp.d()) != -1) {
                            this.setLastUID(nuid);
                        }
                    }
                    catch (Exception exp) {
                        AppletLogger.log(exp);
                        this.setError(AppletConstants.ERR_HTTP_ERROR);
                        iResult = 24;
                    }
                }
            } else {
                this.setError(AppletConstants.ERR_INVALID_MSGID);
            }
        }
        return iResult;
    }

    private boolean h(String sMsgID, int iFlag) {
        this.resetError();
        boolean bFlag = false;
        C047 msg = (C047)this.K.get(sMsgID);
        if (msg != null) {
            bFlag = msg.bH(iFlag);
        } else {
            this.setError(AppletConstants.ERR_INVALID_MSGID);
        }
        return bFlag;
    }

    public boolean addRecipient(String strMessageID, String email, int type) {
        this.resetError();
        boolean bValid = false;
        C047 msg = (C047)this.K.get(strMessageID);
        if (msg != null) {
            bValid = msg.bN(email, type);
            if (!bValid) {
                this.setError(AppletConstants.ERR_INVALID_EMAILADDRESS, email);
            }
        } else {
            this.setError(AppletConstants.ERR_INVALID_MSGID);
        }
        return bValid;
    }

    private boolean i(C047 msgData) throws Exception {
        if (msgData.bH(0)) {
            return true;
        }
        MimeMessage msg = msgData.bC();
        AppletLogger.log(msg.getContentType());
        if (this.q(msg.getContentType())) {
            msgData.p(2);
            AppletLogger.log("Decrypt enveloped message");
        }
        Part decodedPart = this.C((Part)msg, msgData);
        if (this.q(msg.getContentType())) {
            this.v(msg, decodedPart);
            AppletLogger.log("replaceMessageContent called: explicit setDataHandler!!!!!!!!!!!!!!!!");
            msg.setDataHandler(decodedPart.getDataHandler());
        }
        msg.saveChanges();
        return msgData.bH(0);
    }

    private Session j() {
        if (this.Q == null) {
            Properties props = new Properties();
            props.put("mail.smtp.host", "mailhost");
            this.Q = Session.getDefaultInstance((Properties)props, null);
        }
        return this.Q;
    }

    public void init() {
        if (this.Y == null) {
            this.Y = this;
        }
        super.init();
        this.setAppletParameter("crypt.forsender", this.getOwner().getParameter("crypt.forsender"));
        this.setAppletParameter("card.admin", this.getOwner().getParameter("card.admin"));
        this.setAppletParameter("card.libpath", this.getOwner().getParameter("card.libpath"));
        this.setAppletParameter("card.tokenpath", this.getOwner().getParameter("card.tokenpath"));
        this.setAppletParameter("card.htmllogin", this.getOwner().getParameter("card.htmllogin"));
        this.resetError();
    }

    private boolean k(C047 msgToSend, C101 gen) throws AddressException, CertificateException {
        boolean bOK = true;
        int iVerify = 0;
        if (msgToSend.bH(6) || this.O) {
            AppletLogger.log("Encrypt for sender");
            Address addrfrom = msgToSend.C();
            X509Certificate[] certs = this.lookupCert(addrfrom.toString());
            X509CertWrapper[] wrappers = null;
            if (certs != null) {
                wrappers = this.I(addrfrom.toString(), certs, false, true, "LDAP");
            }
            if (wrappers != null && wrappers.length == 1) {
                try {
                    C045 certiaCert = new C045(wrappers[0].b());
                    iVerify = this.verifyCertificate(certiaCert, msgToSend.bH(11), msgToSend.bH(8), null, Calendar.getInstance().getTime());
                    if (iVerify == 1 || iVerify == 0) {
                        gen.g(wrappers[0].b());
                    } else {
                        msgToSend.be(this.D(iVerify, 1));
                        this.setError(AppletConstants.ERR_RECIPIENT_CERT_VERIFY);
                        bOK = false;
                    }
                    msgToSend.bs(this.D(iVerify, 1));
                }
                catch (Exception exp) {
                    AppletLogger.log(exp);
                    this.setError(-422, "Failed to verify " + exp.getMessage());
                    msgToSend.bs(13);
                    msgToSend.be(3);
                }
            } else {
                AppletLogger.log("!!Failed during sender cert find!!" + addrfrom.toString());
                if (wrappers != null && wrappers.length > 1) {
                    AppletLogger.log("!! number of certs found=" + wrappers.length);
                    msgToSend.be(17);
                    msgToSend.bs(17);
                } else {
                    msgToSend.be(12);
                    msgToSend.bs(12);
                }
                bOK = false;
            }
        }
        if (!msgToSend.bH(6) && bOK) {
            Address[] arrTo = msgToSend.bq(1);
            Address[] arrCC = msgToSend.bq(2);
            Address[] arrBCC = msgToSend.bq(3);
            Address[][] types = new Address[][]{arrTo, arrCC, arrBCC};
            for (int idxType = 0; idxType < types.length; ++idxType) {
                for (int idx = 0; idx < types[idxType].length; ++idx) {
                    String sEmailAddress = types[idxType][idx].toString();
                    int inx = sEmailAddress.indexOf("+");
                    if (inx >= 0) {
                        AppletLogger.log("!!Found shared folder!!" + sEmailAddress);
                        int inx2 = sEmailAddress.indexOf("@");
                        String s2 = sEmailAddress.substring(inx2);
                        sEmailAddress = sEmailAddress.substring(0, inx) + s2;
                    }
                    X509Certificate[] certs = this.lookupCert(sEmailAddress);
                    X509CertWrapper[] wrappers = null;
                    if (certs != null) {
                        wrappers = this.I(sEmailAddress, certs, false, true, "LDAP");
                    }
                    if (wrappers != null && wrappers.length == 1) {
                        AppletLogger.log("!!Found recipient cert!!" + sEmailAddress);
                        X509Certificate cert = wrappers[0].b();
                        try {
                            C045 certiaCert = new C045(cert.getEncoded());
                            iVerify = this.verifyCertificate(certiaCert, msgToSend.bH(11), msgToSend.bH(8), null, Calendar.getInstance().getTime());
                            msgToSend.u(types[idxType][idx], idxType + 1, this.D(iVerify, 1));
                            if (iVerify == 1 || iVerify == 0) {
                                gen.g(cert);
                                continue;
                            }
                            msgToSend.bs(this.D(iVerify, 1));
                            this.setError(AppletConstants.ERR_RECIPIENT_CERT_VERIFY);
                            bOK = false;
                        }
                        catch (Exception exp) {
                            AppletLogger.log(exp);
                            this.setError(-422, "Failed to verify " + exp.getMessage());
                            msgToSend.bs(13);
                            msgToSend.u(types[idxType][idx], idxType + 1, 3);
                        }
                        continue;
                    }
                    AppletLogger.log("!!Failed during recipient cert find!!" + sEmailAddress);
                    if (wrappers != null && wrappers.length > 1) {
                        AppletLogger.log("!! number of certs found=" + wrappers.length);
                        msgToSend.u(types[idxType][idx], idxType + 1, 17);
                        msgToSend.bs(17);
                    } else {
                        msgToSend.u(types[idxType][idx], idxType + 1, 12);
                        msgToSend.bs(12);
                    }
                    bOK = false;
                }
            }
        }
        if (bOK) {
            msgToSend.bs(iVerify);
        }
        return bOK;
    }

    public void removeAttachmentN(String messageID, int fileHashCode) {
        this.resetError();
        C047 msg = (C047)this.K.get(messageID);
        if (msg != null) {
            msg.N(fileHashCode);
        } else {
            this.setError(AppletConstants.ERR_INVALID_MSGID);
        }
    }

    public void setSubject(String strMessageID, String strSubject) {
        this.resetError();
        C047 msg = (C047)this.K.get(strMessageID);
        if (msg != null) {
            msg.bK(strSubject);
        } else {
            this.setError(AppletConstants.ERR_INVALID_MSGID);
        }
    }

    public String getAttachmentList(String strMessageID) {
        this.resetError();
        C047 msg = (C047)this.K.get(strMessageID);
        String sResult = "";
        if (msg != null) {
            sResult = msg.n();
        } else {
            this.setError(AppletConstants.ERR_INVALID_MSGID);
        }
        return sResult;
    }

    public int send(String strMessageID) {
        int iResult;
        block24: {
            this.resetError();
            iResult = 24;
            C047 msgToSend = (C047)this.K.get(strMessageID);
            if (msgToSend != null) {
                msgToSend.i(6, false);
                long estimatedSize = msgToSend.bo();
                if (estimatedSize + 500L > this.maxPostSize) {
                    this.setError(AppletConstants.ERR_OVER_MAX_POST_SIZE);
                    return iResult;
                }
                if (estimatedSize > this.maxMessageSize) {
                    this.setError(AppletConstants.ERR_OVER_MAX_MESSAGE_SIZE);
                    return iResult;
                }
                try {
                    Object msgParts = null;
                    try {
                        msgParts = this.t(msgToSend);
                    }
                    catch (Exception exp) {
                        AppletLogger.log(exp);
                        this.setError(AppletConstants.ERR_MIME_ERROR);
                    }
                    iResult = msgToSend.K();
                    if (msgParts == null || iResult != 2 && iResult != 0 && iResult != 1) break block24;
                    switch (this.m_sendMethod) {
                        case 0: {
                            try {
                                Address[] to = msgToSend.bq(1);
                                MimeMessage email = new MimeMessage(this.j());
                                email.setFrom(msgToSend.C());
                                email.setRecipients(Message.RecipientType.TO, to);
                                email.setSubject(msgToSend.R());
                                List listHeaders = msgToSend.q();
                                Iterator it = listHeaders.iterator();
                                while (it.hasNext()) {
                                    email.addHeaderLine(it.next().toString());
                                }
                                if (msgParts instanceof MimeBodyPart) {
                                    email.setContent(((MimeBodyPart)msgParts).getContent(), ((MimeBodyPart)msgParts).getContentType());
                                } else {
                                    email.setContent((Multipart)((MimeMultipart)msgParts));
                                }
                                email.saveChanges();
                                Transport.send((Message)email);
                            }
                            catch (Exception exp) {
                                AppletLogger.log(exp);
                                this.setError(AppletConstants.ERR_SMTP_ERROR);
                            }
                            break;
                        }
                        case 2: 
                        case 3: {
                            try {
                                AppletLogger.log("Sending WMAP");
                                C066 wmap = new C066(this.m_strSendURL, this.m_wmapSid, msgParts);
                                wmap.g(this.maxPostSize);
                                wmap.m(this.maxMessageSize);
                                wmap.b(C066.u, msgToSend.bq(1));
                                wmap.b(C066.K, msgToSend.bq(2));
                                wmap.b(C066.Q, msgToSend.bq(3));
                                wmap.n(C066.H, msgToSend.R());
                                wmap.b(C066.E, msgToSend.j("COPY"));
                                wmap.b(C066.P, msgToSend.j("PRI"));
                                wmap.b(C066.z, msgToSend.j("RECPT"));
                                wmap.b(C066.y, msgToSend.j("TZ"));
                                wmap.i(msgToSend.bj());
                                C023 resp = wmap.e(3);
                                if (resp.c() != null) {
                                    this.setError(resp.c());
                                    iResult = 24;
                                    break;
                                }
                                if (resp.e() != 0) {
                                    this.setError(resp);
                                    iResult = 24;
                                }
                                break;
                            }
                            catch (Exception exp) {
                                AppletLogger.log(exp);
                                this.setError(AppletConstants.ERR_HTTP_ERROR);
                                iResult = 24;
                            }
                        }
                    }
                }
                catch (OutOfMemoryError errmem) {
                    AppletLogger.log(errmem);
                    this.setError(AppletConstants.ERR_SEND_MEMORY_ERROR);
                    System.gc();
                }
                catch (Error err) {
                    Throwable t = err.getCause();
                    if (t != null && t instanceof C041) {
                        AppletLogger.log(t);
                        this.setError(-5500, t.getMessage());
                    } else {
                        AppletLogger.log(err);
                        this.setError(-5000, err.getMessage());
                    }
                    iResult = 0;
                }
            } else {
                this.setError(AppletConstants.ERR_INVALID_MSGID);
            }
        }
        return iResult;
    }

    public String getMessageBody(String strMessageID) {
        this.resetError();
        C047 msg = (C047)this.K.get(strMessageID);
        String sBody = "";
        if (msg != null) {
            sBody = msg.D();
        } else {
            this.setError(AppletConstants.ERR_INVALID_MSGID);
        }
        return sBody;
    }

    public int getAttachmentHashCode(String messageID, int index) {
        this.resetError();
        C047 msg = (C047)this.K.get(messageID);
        int hashCode = 0;
        if (msg != null) {
            hashCode = msg.bF(index);
        } else {
            this.setError(AppletConstants.ERR_ATTACH_GET_HASHCODE_ERROR);
        }
        return hashCode;
    }

    private void l(Part signedContent, C047 msgData) throws MessagingException, IOException, MessagingException, NoSuchAlgorithmException, C063, CertStoreException, C002, NoSuchProviderException, CertificateExpiredException, CertificateNotYetValidException {
        MimeBodyPart content;
        Object cont;
        msgData.g();
        AppletLogger.log("Decode signed part");
        if (msgData.bp()) {
            msgData.p(1);
        }
        C059 signed = null;
        InputStream sigIn = null;
        if (signedContent.getContent() instanceof MimeMultipart) {
            MimeMultipart mpart = (MimeMultipart)signedContent.getContent();
            for (int i = 0; i < mpart.getCount(); ++i) {
                BodyPart bp = mpart.getBodyPart(i);
                String fullType = bp.getContentType();
                String type = null;
                type = fullType.indexOf(";") > 0 ? fullType.substring(0, fullType.indexOf(";")) : fullType;
                String disp = bp.getDisposition();
                if (type == null || disp == null || !type.toLowerCase().equals("application/x-pkcs7-signature") && !type.toLowerCase().equals("application/pkcs7-signature") || !disp.toLowerCase().equals("attachment")) continue;
                sigIn = bp.getInputStream();
            }
            if (sigIn == null) {
                sigIn = signedContent.getInputStream();
            }
            signed = new C059((MimeMultipart)signedContent.getContent());
        } else {
            signed = new C059(signedContent);
            sigIn = signedContent.getInputStream();
        }
        if (msgData.bp()) {
            msgData.J(signed);
        }
        if ((cont = (content = signed.d()).getContent()) instanceof String) {
            msgData.bL((String)cont, content.getContentType());
        } else if (cont instanceof Multipart) {
            Multipart mp = (Multipart)cont;
            int count = mp.getCount();
            for (int i = 0; i < count; ++i) {
                this.C((Part)mp.getBodyPart(i), msgData);
            }
        } else {
            AppletLogger.log("in signed decode: unprocessed object cont");
        }
        AppletLogger.log("Status:");
        if (sigIn != null) {
            sigIn.close();
            sigIn = null;
        }
        if (msgData.bp()) {
            this.E(signed, msgData);
        }
        msgData.p(0);
        msgData.bD();
    }

    private boolean m(String sContentType) {
        boolean bSignedReceipt = false;
        int idxType = sContentType.toLowerCase().indexOf("smime-type");
        if (idxType >= 0) {
            String sMimeType = sContentType.substring(idxType).toLowerCase().trim();
            bSignedReceipt = sMimeType.indexOf("signed-receipt") >= 0;
        }
        return bSignedReceipt;
    }

    public int isCertificateVerified(String strMessageID) {
        this.resetError();
        if (!this.isMessageSigned(strMessageID) && !this.isMessageEncrypted(strMessageID)) {
            return 1;
        }
        C047 msg = (C047)this.K.get(strMessageID);
        int iValue = 0;
        if (msg != null) {
            iValue = msg.K();
            if (iValue == 0) {
                iValue = this.x(msg);
            }
        } else {
            this.setError(AppletConstants.ERR_INVALID_MSGID);
        }
        return iValue;
    }

    public void addMimeHeader(String strMessageID, String strHeader) {
        this.resetError();
        C047 msg = (C047)this.K.get(strMessageID);
        if (msg != null) {
            msg.A(strHeader);
        } else {
            this.setError(AppletConstants.ERR_INVALID_MSGID);
        }
    }

    public void setMessageBodyText(String strMessageID, String strMessage) {
        this.resetError();
        C047 msg = (C047)this.K.get(strMessageID);
        if (msg != null) {
            msg.bM(strMessage);
        } else {
            this.setError(AppletConstants.ERR_INVALID_MSGID);
        }
    }

    private IssuerAndSerialNumber n(String idCert) {
        IssuerAndSerialNumber iss = null;
        StringTokenizer tokens = new StringTokenizer(idCert, "|");
        if (tokens.countTokens() == 2) {
            String sIssuer = tokens.nextToken().trim();
            String sSerial = tokens.nextToken().trim();
            BigInteger bigSerial = new BigInteger(sSerial, 16);
            X509Name name = new X509Name(sIssuer);
            iss = new IssuerAndSerialNumber(name, bigSerial);
        }
        return iss;
    }

    public String setSignCertificate(int idxCert, String sEmail) {
        this.resetError();
        String sCertID = "";
        X509CertWrapper[] arrWrappers = this.getSignCertificates(sEmail);
        if (arrWrappers != null) {
            if (idxCert < arrWrappers.length) {
                X509Certificate cert = arrWrappers[idxCert].b();
                String sIssuer = cert.getIssuerDN().getName();
                BigInteger serial = cert.getSerialNumber();
                sCertID = this.s(sIssuer, serial);
                AppletLogger.log("Selected cert " + sCertID + " " + cert.getSubjectDN().getName());
                try {
                    this.X = new IssuerAndSerialNumber(new X509Name(sIssuer), serial);
                    this.P = this.y().getProviderName(cert);
                }
                catch (CardException exp) {
                    AppletLogger.log(exp);
                    this.setError(AppletConstants.ERR_CARD_ERROR, exp);
                }
            } else {
                this.setError(AppletConstants.ERR_INVALID_CERT_INDEX);
            }
        }
        AppletLogger.log("in setSignCertificate:returning string");
        return sCertID;
    }

    private String o(String fileName) {
        String result = fileName;
        int idx = result.indexOf("?");
        if (idx >= 0) {
            result = result.replace('?', '_');
            AppletLogger.log("attachment filename renamed:" + result);
        }
        return result;
    }

    public boolean isMessageSigned(String strMessageID) {
        AppletLogger.log("Is Message signed " + this.h(strMessageID, 1));
        return this.h(strMessageID, 1);
    }

    public void removeRecipientList(String strMessageID, String recipientList) {
        this.resetError();
        C047 msg = (C047)this.K.get(strMessageID);
        if (msg != null) {
            if (recipientList.indexOf(";") >= 0) {
                StringTokenizer tokens = new StringTokenizer(recipientList, ";");
                while (tokens.hasMoreTokens()) {
                    msg.bJ(tokens.nextToken().trim());
                }
            } else {
                msg.bJ(recipientList);
            }
        } else {
            this.setError(AppletConstants.ERR_INVALID_MSGID);
        }
    }

    public String getFrom(String strMessageID) {
        this.resetError();
        String sAddress = null;
        C047 msg = (C047)this.K.get(strMessageID);
        if (msg != null) {
            if (msg.C() != null) {
                sAddress = msg.C().toString();
            }
        } else {
            this.setError(AppletConstants.ERR_INVALID_MSGID);
        }
        return sAddress;
    }

    public String getMessageBodyTextType(String strMessageID) {
        this.resetError();
        C047 msg = (C047)this.K.get(strMessageID);
        if (msg != null) {
            return msg.r();
        }
        this.setError(AppletConstants.ERR_INVALID_MSGID);
        return null;
    }

    private CardAdmin p(String sAdmin) throws CardException {
        try {
            ClassLoader cl = this.getClass().getClassLoader();
            Class<?> clazz = cl == null ? Class.forName(sAdmin) : cl.loadClass(sAdmin);
            return (CardAdmin)clazz.newInstance();
        }
        catch (IllegalAccessException exp) {
            throw new CardException("CardAdmin class not public " + sAdmin, exp);
        }
        catch (ClassNotFoundException exp) {
            throw new CardException("CardAdmin class not found " + sAdmin, exp);
        }
        catch (InstantiationException exp) {
            throw new CardException("CardAdmin class could not be constructed " + sAdmin, exp);
        }
    }

    public void setForwardMessageID(String strMessageID, String strFwdMsgID) {
        this.resetError();
        C047 msg = (C047)this.K.get(strMessageID);
        C047 msgForward = (C047)this.K.get(strFwdMsgID);
        try {
            if (msg != null && strFwdMsgID != null) {
                msg.S(msgForward);
            } else {
                this.setError(AppletConstants.ERR_INVALID_MSGID);
            }
        }
        catch (MessagingException exp) {
            AppletLogger.log(exp);
            this.setError(AppletConstants.ERR_READ_ERROR_MIME, strFwdMsgID);
        }
    }

    private boolean q(String contentType) {
        boolean ret = false;
        int index = contentType.toLowerCase().indexOf("smime-type");
        if (index >= 0) {
            String sMimeType = contentType.substring(index).toLowerCase().trim();
            ret = sMimeType.indexOf("enveloped-data") >= 0;
        } else {
            int i = contentType.toLowerCase().indexOf("x-pkcs7-mime");
            int ii = contentType.toLowerCase().indexOf("pkcs7-mime");
            if (i > 0 || ii > 0) {
                ret = true;
            }
        }
        return ret;
    }

    public void setMessageType(String strMessageID, int iMessageType) {
        this.resetError();
        C047 msg = (C047)this.K.get(strMessageID);
        if (msg != null) {
            msg.b(iMessageType);
        } else {
            this.setError(AppletConstants.ERR_INVALID_MSGID);
        }
    }

    public static boolean testRead(SMIMEAppletSpec applet) throws Exception {
        System.out.println(" BEGIN READ TESTING ");
        boolean bPassed = false;
        String[] arrTestMessages = new String[]{"http://localhost:8080/smimetest/msg.jsp?mbox=dummy&format=raw&uid=Attached-mime_29-Mar-2004-16-33-49.eml", "http://localhost:8080/smimetest/msg.jsp?mbox=dummy&format=raw&uid=EncryptedAttach_29-Mar-2004-16-33-54.eml", "http://localhost:8080/smimetest/msg.jsp?mbox=dummy&format=raw&uid=Encrypted_29-Mar-2004-16-33-53.eml", "http://localhost:8080/smimetest/msg.jsp?mbox=dummy&format=raw&uid=Signed-Attachment_29-Mar-2004-16-33-52.eml", "http://localhost:8080/smimetest/msg.jsp?mbox=dummy&format=raw&uid=Signed_29-Mar-2004-16-33-52.eml", "http://localhost:8080/smimetest/msg.jsp?mbox=dummy&format=raw&uid=SignEncryptedAttach_29-Mar-2004-16-33-54.eml", "http://localhost:8080/smimetest/msg.jsp?mbox=dummy&format=raw&uid=SignEncrypted_29-Mar-2004-16-33-54.eml"};
        int idx = 0;
        for (idx = 0; idx < arrTestMessages.length; ++idx) {
            System.out.println("----Reading message-----");
            System.out.println(arrTestMessages[idx]);
            if (!SMIMEAppletCard.testRead(applet, arrTestMessages[idx], idx)) break;
            System.out.println("----Message Done-----\n\n\n\n");
        }
        bPassed = idx == arrTestMessages.length;
        System.out.println(" END READ TESTING ");
        return bPassed;
    }

    public boolean isMessageEncrypted(String strMessageID) {
        return this.h(strMessageID, 2);
    }

    public int getAttachmentCount(String strMessageID) {
        this.resetError();
        C047 msg = (C047)this.K.get(strMessageID);
        int nResult = 0;
        if (msg != null) {
            nResult = msg.X();
        } else {
            this.setError(AppletConstants.ERR_INVALID_MSGID);
        }
        return nResult;
    }

    private Part r(Part envolopedPart, C047 msgData) throws MessagingException, IOException, MessagingException, NoSuchAlgorithmException, C063, CertStoreException, C002, NoSuchProviderException, CertificateExpiredException, CertificateNotYetValidException {
        Part decryptedPart = envolopedPart;
        AppletLogger.log("Decrypt envoloped part");
        if (!(envolopedPart instanceof MimePart)) {
            throw new MessagingException("Envoloped Part is not MimePart");
        }
        C102 m = new C102((MimePart)envolopedPart);
        C028 recipients = m.a();
        C094 recipient = null;
        X509Certificate cert = null;
        Iterator it = recipients.c().iterator();
        while (it.hasNext()) {
            C094 recip = (C094)it.next();
            try {
                X509Certificate[] matchingCerts = this.y().getUserCertificates(recip.a());
                if (matchingCerts == null || matchingCerts.length <= 0) continue;
                cert = matchingCerts[0];
                recipient = recip;
                msgData.bE(cert);
                break;
            }
            catch (CardException e) {
                AppletLogger.log("Error getting encryption cert for" + recip + e);
            }
        }
        if (recipient != null) {
            try {
                C067 listener = new C067(cert, (CardToken)this.y());
                ((C080)((Object)recipient)).b(listener);
            }
            catch (CardException e) {
                AppletLogger.log("Failed to create CardCrypto");
                this.setError(AppletConstants.ERR_DECODE_CERT);
            }
            byte[] arrDecrypted = recipient.a(null, "BC");
            MimeBodyPart mimeBodyPart = SMIMEUtil.a(arrDecrypted);
            decryptedPart = this.C((Part)mimeBodyPart, msgData);
            msgData.p(0);
        } else {
            msgData.bs(23);
            AppletLogger.log("Failed to find recipient info for cert");
            this.setError(AppletConstants.ERR_DECODE_CERT);
        }
        return decryptedPart;
    }

    protected void setError(C023 resp) {
        switch (resp.e()) {
            case 27: {
                this.setError(AppletConstants.ERR_WMAP_FILE_TOLARGE);
                break;
            }
            case 646957: {
                this.setError(AppletConstants.ERR_WMAP_MSG_TOLARGE);
                break;
            }
            case 646858: {
                this.setError(AppletConstants.ERR_WMAP_SESSIONTIMOUT);
                break;
            }
            default: {
                this.setError(AppletConstants.ERR_WMAP_UNKNOWN, resp.f());
            }
        }
    }

    private String s(String sIssuerDN, BigInteger serial) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(sIssuerDN);
        buffer.append("|");
        buffer.append(serial.toString(16));
        return buffer.toString();
    }

    private Object t(C047 msgToSend) throws Exception {
        Object mimePart = null;
        switch (msgToSend.bB()) {
            case 0: {
                mimePart = this.a(msgToSend);
                break;
            }
            case 1: {
                mimePart = this.w(msgToSend);
                break;
            }
            case 2: {
                mimePart = this.G(msgToSend);
                break;
            }
            case 3: {
                mimePart = this.H(msgToSend);
            }
        }
        return mimePart;
    }

    private boolean u(X509Certificate cert, String email) throws CertificateParsingException {
        boolean bFound = false;
        String sMail = X509CertWrapper.getSubjectAltName(cert, 1);
        if (sMail == null || sMail.length() == 0) {
            sMail = X509CertWrapper.getSubjectDNValue(cert, "EMAILADDRESS|E");
        }
        return email.equalsIgnoreCase(sMail);
    }

    public String addRecipientList(String strMessageID, String list, int type) {
        this.resetError();
        C047 msg = (C047)this.K.get(strMessageID);
        String sInvalid = "";
        if (msg != null) {
            if (list.indexOf(";") >= 0) {
                StringBuffer bufInvalid = new StringBuffer();
                StringTokenizer tokens = new StringTokenizer(list, ";");
                while (tokens.hasMoreTokens()) {
                    String sAddress = tokens.nextToken().trim();
                    if (msg.bN(sAddress, type)) continue;
                    if (bufInvalid.length() > 0) {
                        bufInvalid.append(";");
                    }
                    bufInvalid.append(sAddress);
                }
                sInvalid = bufInvalid.toString();
            } else if (!msg.bN(list, type)) {
                sInvalid = list;
            }
            if (sInvalid.length() > 0) {
                this.setError(AppletConstants.ERR_INVALID_EMAILADDRESS);
            }
        } else {
            this.setError(AppletConstants.ERR_INVALID_MSGID);
        }
        return sInvalid;
    }

    private void v(MimeMessage message, Part newContent) throws Exception {
        Enumeration headers = newContent.getAllHeaders();
        message.removeHeader("Content-Disposition");
        while (headers.hasMoreElements()) {
            Header header = (Header)headers.nextElement();
            message.setHeader(header.getName(), header.getValue());
        }
        message.saveChanges();
    }

    private MimeMultipart w(C047 msgToSend) throws Exception {
        FedToken card = this.y();
        X509Certificate certSign = null;
        MimeMultipart mmSigned = null;
        if (this.X != null) {
            certSign = this.c(this.X, card, this.P);
        } else {
            X509CertWrapper[] arrCerts = this.getSignCertificates(msgToSend.C().toString());
            if (arrCerts != null && arrCerts.length == 1) {
                certSign = arrCerts[0].b();
            } else {
                msgToSend.bs(10);
            }
        }
        if (certSign != null) {
            C045 certiaCert = new C045(certSign);
            Address fromAddress = msgToSend.C();
            String rfc822FromAddress = null;
            rfc822FromAddress = fromAddress instanceof InternetAddress ? ((InternetAddress)fromAddress).getAddress() : fromAddress.toString();
            int iVerify = this.verifyCertificate(certiaCert, msgToSend.bH(10), msgToSend.bH(7), rfc822FromAddress, Calendar.getInstance().getTime());
            msgToSend.bs(this.D(iVerify, 0));
            if (iVerify == 1 || iVerify == 0) {
                ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
                certList.add(certSign);
                CertStore certsAndcrls = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(certList), "BC");
                SMIMECapabilityVector caps = new SMIMECapabilityVector();
                caps.addCapability(SMIMECapability.dES_EDE3_CBC);
                caps.addCapability(SMIMECapability.rC2_CBC, 128);
                caps.addCapability(SMIMECapability.dES_CBC);
                ASN1EncodableVector signedAttrs = new ASN1EncodableVector();
                signedAttrs.add((DEREncodable)new SMIMECapabilitiesAttribute(caps));
                Principal issuer = certSign.getIssuerDN();
                X509Name issuerName = new X509Name(((Object)issuer).toString());
                IssuerAndSerialNumber issAndSer = new IssuerAndSerialNumber(issuerName, certSign.getSerialNumber());
                signedAttrs.add((DEREncodable)new SMIMEEncryptionKeyPreferenceAttribute(issAndSer));
                C030 gen = new C030();
                gen.b(certSign, msgToSend.Q(), new AttributeTable((DEREncodableVector)signedAttrs), null, new C067(certSign, (CardToken)card));
                gen.h(certsAndcrls);
                Object part = this.a(msgToSend);
                if (part instanceof MimeMultipart) {
                    MimeBodyPart partWrapper = new MimeBodyPart();
                    partWrapper.setContent((Multipart)((MimeMultipart)part));
                    part = partWrapper;
                }
                mmSigned = gen.g((MimeBodyPart)part, null);
            } else {
                this.setError(AppletConstants.ERR_SIGN_CERT_VERIFY);
            }
        } else {
            this.setError(AppletConstants.ERR_NO_SIGN_CERT);
            msgToSend.bs(8);
        }
        return mmSigned;
    }

    private int x(C047 msg) {
        if (msg.K() == 0 && msg.bH(0)) {
            if (msg.bH(1) || msg.bH(2)) {
                if (msg.bH(1)) {
                    try {
                        C059 signed = msg.l();
                        CertStore certs = signed.a("Collection", "BC");
                        C017 signers = signed.b();
                        Collection c = signers.b();
                        Iterator it = c.iterator();
                        int iVerify = 0;
                        while (it.hasNext()) {
                            C088 signer = (C088)it.next();
                            Collection<? extends Certificate> certCollection = certs.getCertificates(signer.c());
                            Iterator<? extends Certificate> certIt = certCollection.iterator();
                            X509Certificate x509Cert = (X509Certificate)certIt.next();
                            C045 certiaCert = new C045(x509Cert);
                            Address fromAddress = msg.C();
                            String rfc822FromAddress = null;
                            rfc822FromAddress = fromAddress instanceof InternetAddress ? ((InternetAddress)fromAddress).getAddress() : fromAddress.toString();
                            iVerify = this.verifyCertificate(certiaCert, msg.bH(10), msg.bH(7), rfc822FromAddress, this.getMessageTime(msg));
                            if (iVerify == 1) continue;
                            break;
                        }
                        msg.bs(this.D(iVerify, 0));
                    }
                    catch (Exception exp) {
                        AppletLogger.log(exp);
                        this.setError(-422, "Failed to verify " + exp.getMessage());
                        msg.bs(4);
                    }
                }
                if ((msg.bH(12) || msg.bH(9)) && msg.bH(2) && msg.W() != null && (msg.K() == 0 || msg.K() == 1)) {
                    try {
                        X509Certificate cert = msg.W();
                        C045 certiaCert = new C045(cert);
                        int iVerify = this.verifyCertificate(certiaCert, msg.bH(12), msg.bH(9), null, this.getMessageTime(msg));
                        msg.bs(this.D(iVerify, 2));
                    }
                    catch (Exception exp) {
                        AppletLogger.log(exp);
                        this.setError(-422, "Failed to verify " + exp.getMessage());
                        msg.bs(19);
                    }
                }
            } else {
                msg.bs(2);
            }
        }
        AppletLogger.log("Verify certificates " + msg.K());
        return msg.K();
    }

    protected Applet getOwner() {
        return this.Y;
    }

    public String getTo(String strMessageID) {
        return this.B(strMessageID, 1);
    }

    public void start() {
        this.resetError();
    }

    public boolean setSignCertificate(String idCert, String sProvider) {
        this.resetError();
        String sCertID = "";
        X509Certificate certSign = null;
        IssuerAndSerialNumber certID = this.n(idCert);
        if (certID != null) {
            try {
                FedToken token = this.y();
                certSign = this.c(certID, token, sProvider);
                if (certSign != null) {
                    this.X = certID;
                    this.P = sProvider;
                }
            }
            catch (CardException exp) {
                this.setError(AppletConstants.ERR_CARD_ERROR, exp);
            }
            catch (IOException exp) {
                this.setError(AppletConstants.ERR_INVALID_ISSUER_SERIAL, exp);
            }
        } else {
            this.setError(AppletConstants.ERR_INVALID_ISSUER_SERIAL);
        }
        AppletLogger.log("in setSignCertificate:returning boolean");
        return certSign != null;
    }

    private FedToken y() throws CardException {
        if (this.V == null && this.W != null) {
            FedReader reader = new FedReader(this.W);
            if (this.L != null) {
                CardAdmin delegate = this.p(this.L);
                this.bb = new DelegatedCardAdmin(delegate);
            } else {
                this.bb = new DelegatedCardAdmin();
            }
            reader.registerCardAdmin(this.bb);
            this.V = (FedToken)reader.getToken();
            if (this.V.isValid()) {
                AppletLogger.log("Valid Token present");
            }
        }
        return this.V;
    }

    boolean z(String messageID, int fileHashCode) {
        this.resetError();
        C047 msg = (C047)this.K.get(messageID);
        try {
            msg.e(fileHashCode);
            return true;
        }
        catch (Exception e) {
            AppletLogger.log(e.getMessage(), e.getCause());
            this.setError(AppletConstants.ERR_ATTACH_SAVE_ERROR);
            return false;
        }
    }

    public void addWMAPParameter(String strMessageID, String sParam, String sValue) {
        this.resetError();
        C047 msg = (C047)this.K.get(strMessageID);
        if (msg != null) {
            msg.bu(sParam, sValue);
        } else {
            this.setError(AppletConstants.ERR_INVALID_MSGID);
        }
    }

    private boolean A(String sContentType) {
        boolean bSignedData = false;
        int idxType = sContentType.toLowerCase().indexOf("smime-type");
        if (idxType >= 0) {
            String sMimeType = sContentType.substring(idxType).toLowerCase().trim();
            bSignedData = sMimeType.indexOf("signed-data") >= 0;
        }
        return bSignedData;
    }

    public String getAttachmentURI(String messageID, int fileHashCode) {
        this.resetError();
        C047 msg = (C047)this.K.get(messageID);
        return msg.bm(fileHashCode);
    }

    private String B(String sMsgID, int iType) {
        this.resetError();
        C047 msg = (C047)this.K.get(sMsgID);
        String sAddress = "";
        if (msg != null) {
            sAddress = this.f(msg.bq(iType));
        } else {
            this.setError(AppletConstants.ERR_INVALID_MSGID);
        }
        return sAddress;
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("jcealg_map.path", "/dev/ilumin-uk/smime/Sun1/src/jcealg_map.conf");
        SMIMEAppletCard applet = new SMIMEAppletCard(null);
        applet.setAppletParameter("logging", "true");
        applet.setAppletParameter("throw", "true");
        applet.setAppletParameter("wmap.sid", System.getProperty("WMAP_SID"));
        applet.setAppletParameter("ldap", "file:///C:/dev/ilumin-uk/smime/Sun1/smimetest/ldap.conf");
        applet.setAppletParameter("crl.request.url", "http://ims.ilumin.co.uk/smimetest/crl.msc");
        applet.setAppletParameter("card.libpath", "/dev/ilumin-uk/smime/Sun1/capibridge/Debug");
        applet.setAppletParameter("crypt.forsender", "true");
        System.setProperty("sun.net.client.defaultConnectTimeout", "5000");
        applet.setTokenConfiguration("CAPI:library=capibridge.dll;");
        boolean bTestCrl = false;
        boolean bTestSend = true;
        boolean bTestRead = true;
        boolean bSmtp = false;
        if (bSmtp) {
            applet.setAppletParameter("mail.sendurl", "mailhost");
            applet.setAppletParameter("mail.sendmethod", "smtp");
        } else {
            applet.setAppletParameter("mail.sendmethod", "http");
            applet.setAppletParameter("mail.sendurl", "http://ims.ilumin.co.uk/msg.msc");
        }
        if (bTestCrl && !SMIMEAppletCard.testCRLs(applet)) {
            System.out.println(" CRL FAILED CRL FAILED CRL FAILED CRL FAILED ");
            return;
        }
        if (bTestSend && !SMIMEAppletCard.testSend(applet, bSmtp)) {
            System.out.println(" SEND FAILED SEND FAILED SEND FAILED SEND FAILED ");
            System.out.println("Last error = " + applet.getLastErrorMsgText());
            return;
        }
        if (bTestRead && !SMIMEAppletCard.testRead(applet)) {
            System.out.println(" READ FAILED READ FAILED READ FAILED READ FAILED ");
            System.out.println("Last error = " + applet.getLastErrorMsgText());
        }
    }

    public static boolean testRead(SMIMEAppletSpec applet, String sUrl, int idxMsg) throws Exception {
        boolean bPassed = false;
        String sMsgID = applet.setMessageData(sUrl);
        if (applet.getLastErrorNumber() == 0) {
            int idxAttach;
            applet.setVerificationOptions(sMsgID, 4, true);
            applet.setVerificationOptions(sMsgID, 1, true);
            applet.setVerificationOptions(sMsgID, 6, true);
            applet.setVerificationOptions(sMsgID, 3, true);
            int iVerified = applet.isCertificateVerified(sMsgID);
            System.out.println("\n\nMessage data");
            System.out.println("Subject:\n\t" + applet.getSubject(sMsgID));
            System.out.println("Body:\n\t" + applet.getMessageBody(sMsgID));
            System.out.println("Signed:\n\t" + Boolean.toString(applet.isMessageSigned(sMsgID)));
            System.out.println("Encrypted:\n\t" + Boolean.toString(applet.isMessageEncrypted(sMsgID)));
            System.out.println("Verified:\n\t" + Boolean.toString(applet.isSignatureVerified(sMsgID)));
            System.out.println("Cert Verified:\n\t" + SMIMEAppletAPI.toCertVerifyString(iVerified));
            System.out.println("To:\n\t" + applet.getTo(sMsgID));
            System.out.println("From:\n\t" + applet.getFrom(sMsgID));
            System.out.println("CC:\n\t" + applet.getCc(sMsgID));
            Enumeration enumAttached = applet.getAttachments(sMsgID);
            int nAttached = applet.getAttachmentCount(sMsgID);
            if (nAttached > 0) {
                System.out.println("Attachments:");
            }
            boolean bAttachmentsOK = false;
            for (idxAttach = 0; idxAttach < nAttached; ++idxAttach) {
                String sAttach = enumAttached.nextElement().toString();
                if (sAttach.endsWith(".eml")) {
                    System.out.println("----Reading attached message-----");
                    if (!SMIMEAppletCard.testRead(applet, sAttach, idxMsg)) break;
                    System.out.println("----Attached message done-----");
                    continue;
                }
                long lLen = applet.getAttachmentSize(sMsgID, sAttach);
                File filePath = new File("attachments" + File.separator + sAttach + idxMsg);
                System.out.println("\t" + filePath.getAbsolutePath() + " length = " + lLen);
            }
            bAttachmentsOK = idxAttach == nAttached;
            applet.releaseMessage(sMsgID);
            bPassed = iVerified == 1 || iVerified == 2 || iVerified == 0;
        }
        return bPassed;
    }

    public boolean setTokenConfiguration(String sConfig) {
        boolean bLoaded = false;
        if (sConfig != null && sConfig.length() > 0) {
            this.W = sConfig;
            this.V = null;
            try {
                bLoaded = this.y() != null;
            }
            catch (CardException exp) {
                AppletLogger.log(exp);
                if (exp.getMessage().indexOf("DLL Load failed") >= 0) {
                    this.setError(AppletConstants.ERR_DLL_LOAD_ERROR, exp);
                }
                this.setError(AppletConstants.ERR_CARD_ERROR, exp);
            }
        }
        return bLoaded;
    }

    private Part C(Part part, C047 msgData) throws MessagingException, IOException, MessagingException, NoSuchAlgorithmException, C063, CertStoreException, C002, NoSuchProviderException, CertificateExpiredException, CertificateNotYetValidException {
        Part decodedPart = part;
        if (part.isMimeType("text/plain") || part.isMimeType("text/html")) {
            String disposition = part.getDisposition();
            if (disposition != null && disposition.equalsIgnoreCase("attachment")) {
                this.b(part, msgData);
            } else if (disposition != null && disposition.equalsIgnoreCase("inline")) {
                String fileName = part.getFileName();
                if (fileName != null) {
                    this.b(part, msgData);
                }
                msgData.bL((String)part.getContent(), part.getContentType());
            } else {
                msgData.bL((String)part.getContent(), part.getContentType());
            }
        } else if (part.isMimeType("multipart/mixed") || part.isMimeType("multipart/related") || part.isMimeType("multipart/alternative")) {
            Multipart mp = (Multipart)part.getContent();
            int count = mp.getCount();
            for (int i = 0; i < count; ++i) {
                BodyPart bodyPart = mp.getBodyPart(i);
                Part decoded = this.C((Part)bodyPart, msgData);
                if (decoded == null || !(decoded instanceof BodyPart) || !msgData.F()) continue;
                mp.removeBodyPart(i);
                mp.addBodyPart((BodyPart)decoded, i);
            }
            if (msgData.F()) {
                part.setContent(mp);
                part.setHeader("Content-Type", mp.getContentType());
            }
        } else if (part.isMimeType("multipart/signed") || part.isMimeType("application/pkcs7-signature") || part.isMimeType("application/x-pkcs7-signature")) {
            this.l(part, msgData);
        } else if (part.isMimeType("application/pkcs7-mime") || part.isMimeType("application/x-pkcs7-mime")) {
            String content_type = part.getContentType();
            if (this.A(content_type)) {
                this.l(part, msgData);
            } else if (this.q(content_type)) {
                decodedPart = this.r(part, msgData);
            } else if (this.m(content_type)) {
                this.l(part, msgData);
                String[] to = part.getHeader("To");
                String[] sub = part.getHeader("Subject");
                String[] datesent = part.getHeader("Date");
                String receipt = "Your Secure Receipt:<br><br>To: " + to[0] + U + "Subject: " + sub[0] + U + U + "was sent " + datesent[0];
                msgData.bL(receipt, "text/html");
            } else {
                msgData.I("Cannot process pkcs7: " + content_type, "application/pkcs7-mine");
            }
        } else if (part.isMimeType("message/rfc822")) {
            if (part.getContent() instanceof MimeMessage) {
                msgData.E();
                this.g(part, msgData);
                MimeMessage mimeMsg = (MimeMessage)part.getContent();
                Part decoded = this.C((Part)mimeMsg, msgData);
                if (decoded != null && msgData.F()) {
                    try {
                        this.v(mimeMsg, decoded);
                        part.setContent((Object)mimeMsg, "message/rfc822");
                        part.setHeader("Content-Type", "message/rfc822");
                        part.setHeader("Content-Transfer-Encoding", "8bit");
                        part.setHeader("Content-Disposition", "attachment");
                    }
                    catch (Exception e) {
                        AppletLogger.log("Cannot remove envolope because " + e);
                    }
                }
                msgData.bg();
            } else {
                msgData.I("MIME content message/rfc822 is not MimeMessage instance", "message/rfc822");
            }
        } else if (part.isMimeType("image/*")) {
            String msg = "image part found: " + part.getContentType();
            AppletLogger.log(msg);
        } else {
            String disposition = part.getDisposition();
            if (disposition != null && (disposition.equalsIgnoreCase("attachment") || disposition.equalsIgnoreCase("inline"))) {
                String fileName = part.getFileName();
                if (fileName != null) {
                    this.b(part, msgData);
                } else {
                    msgData.I("Cannot handle disposition:" + disposition, "disposition");
                }
            } else {
                msgData.I("Cannot handle " + part.getContentType(), "unknown");
            }
        }
        return decodedPart;
    }

    public String getCc(String strMessageID) {
        return this.B(strMessageID, 2);
    }

    public String setMessageData(String msgUrl) {
        AppletLogger.log("setMessageData " + msgUrl);
        this.resetError();
        String sMsgID = null;
        try {
            block11: {
                try {
                    URL urlMessage = new URL(msgUrl);
                }
                catch (MalformedURLException exp) {
                    if (!msgUrl.endsWith(".eml") || msgUrl.indexOf("_") <= 0) break block11;
                    StringTokenizer toks = new StringTokenizer(msgUrl, "_");
                    sMsgID = toks.nextToken().trim();
                    C047 msgParent = (C047)this.K.get(sMsgID);
                    if (msgParent != null) {
                        File fileMsg = msgParent.bk(msgUrl);
                        if (fileMsg != null) {
                            msgUrl = "file:///" + fileMsg.getAbsolutePath();
                        }
                        throw exp;
                    }
                    throw exp;
                }
            }
            C065 guid = new C065();
            sMsgID = guid.toString();
            C047 msg = new C047(msgUrl, this.j(), sMsgID);
            this.K.put(sMsgID, msg);
            this.i(msg);
        }
        catch (MalformedURLException exp) {
            AppletLogger.log(exp);
            this.setError(AppletConstants.ERR_READ_ERROR_URL, exp);
        }
        catch (UnsupportedEncodingException exp) {
            AppletLogger.log(exp);
            this.setError(AppletConstants.ERR_ENCODING_ERROR_IO, exp);
        }
        catch (IOException exp) {
            AppletLogger.log(exp);
            this.setError(AppletConstants.ERR_READ_ERROR_IO, exp);
        }
        catch (MessagingException exp) {
            AppletLogger.log(exp);
            this.setError(AppletConstants.ERR_READ_ERROR_MIME, exp);
        }
        catch (OutOfMemoryError memerror) {
            AppletLogger.log(memerror);
            this.setError(AppletConstants.ERR_READ_MEMORY_ERROR);
            System.gc();
        }
        catch (Exception exp) {
            AppletLogger.log(exp);
            this.setError(AppletConstants.ERR_DECODE_ERROR, exp);
        }
        return sMsgID;
    }

    private int D(int iCertVerify, int iType) {
        int iResult = 0;
        block0 : switch (iCertVerify) {
            case 0: {
                iResult = 0;
                break;
            }
            case 1: {
                iResult = 1;
                break;
            }
            case 2: {
                switch (iType) {
                    case 0: {
                        iResult = 3;
                        break;
                    }
                    case 1: {
                        iResult = 11;
                        break;
                    }
                    case 2: {
                        iResult = 18;
                    }
                }
                break;
            }
            case 3: {
                switch (iType) {
                    case 0: {
                        iResult = 4;
                        break;
                    }
                    case 1: {
                        iResult = 13;
                        break;
                    }
                    case 2: {
                        iResult = 19;
                    }
                }
                break;
            }
            case 4: {
                switch (iType) {
                    case 0: {
                        iResult = 5;
                        break;
                    }
                    case 1: {
                        iResult = 14;
                        break;
                    }
                    case 2: {
                        iResult = 20;
                    }
                }
                break;
            }
            case 5: {
                switch (iType) {
                    case 0: {
                        iResult = 6;
                        break;
                    }
                    case 1: {
                        iResult = 15;
                        break;
                    }
                    case 2: {
                        iResult = 21;
                    }
                }
                break;
            }
            case 6: {
                switch (iType) {
                    case 0: {
                        iResult = 7;
                        break;
                    }
                    case 1: {
                        iResult = 16;
                        break;
                    }
                    case 2: {
                        iResult = 22;
                    }
                }
                break;
            }
            case 7: {
                switch (iType) {
                    case 0: {
                        iResult = 9;
                        break block0;
                    }
                }
                throw new RuntimeException("Invalid use of cert verify, email shoould only be checked for siging certs");
            }
        }
        return iResult;
    }

    public boolean releaseMessage(String strMessageID) {
        this.resetError();
        boolean bRemoved = false;
        C047 msg = (C047)this.K.get(strMessageID);
        if (msg != null) {
            msg.m();
            this.K.remove(strMessageID);
            bRemoved = true;
        } else {
            this.setError(AppletConstants.ERR_INVALID_MSGID);
        }
        return bRemoved;
    }

    private void E(C059 signed, C047 msgData) throws NoSuchAlgorithmException, CertStoreException, NoSuchProviderException, C063, CertificateExpiredException, CertificateNotYetValidException {
        CertStore certs = signed.a("Collection", "BC");
        C017 signers = signed.b();
        Collection c = signers.b();
        Iterator it = c.iterator();
        boolean bVerified = false;
        while (it.hasNext()) {
            Collection<? extends Certificate> certCollection;
            Iterator<? extends Certificate> certIt;
            X509Certificate cert;
            C088 signer = (C088)it.next();
            if (signer.g(cert = (X509Certificate)(certIt = (certCollection = certs.getCertificates(signer.c())).iterator()).next(), "BC")) {
                bVerified = true;
                AppletLogger.log("Signature verified " + cert.getSubjectDN().getName());
                continue;
            }
            bVerified = false;
            AppletLogger.log("Signature NOT verified " + cert.getSubjectDN().getName());
            break;
        }
        if (bVerified) {
            msgData.p(3);
        }
    }

    private int F(C047 msgToSend, int nUnencryptedSize) throws Exception {
        int nSize = 0;
        C101 gen = new C101();
        if (this.k(msgToSend, gen)) {
            nSize = gen.b(nUnencryptedSize, "1.2.840.113549.3.7", "BC");
        }
        return nSize;
    }

    private MimeBodyPart G(C047 msgToSend) {
        MimeBodyPart encryptedBody = null;
        try {
            C101 gen;
            MimeMultipart signedPart = this.w(msgToSend);
            if (signedPart != null && this.k(msgToSend, gen = new C101())) {
                MimeBodyPart partWrapper = new MimeBodyPart();
                partWrapper.setContent((Multipart)signedPart);
                encryptedBody = gen.a(partWrapper, "1.2.840.113549.3.7", "BC");
            }
        }
        catch (Exception exp) {
            AppletLogger.log(exp);
        }
        return encryptedBody;
    }

    public SMIMEAppletCard(Applet owner) {
        this.Y = owner;
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    private MimeBodyPart H(C047 msgToSend) throws Exception {
        MimeBodyPart encryptedBody = null;
        C101 gen = new C101();
        if (this.k(msgToSend, gen)) {
            Object part = this.a(msgToSend);
            if (part instanceof MimeMultipart) {
                MimeBodyPart partWrapper = new MimeBodyPart();
                partWrapper.setContent((Multipart)((MimeMultipart)part));
                part = partWrapper;
            }
            encryptedBody = gen.a((MimeBodyPart)part, "1.2.840.113549.3.7", "BC");
        }
        return encryptedBody;
    }

    private X509CertWrapper[] I(String sEmailAddress, X509Certificate[] arrCerts, boolean bSign, boolean bKeyEncrypt, String sProvider) {
        X509CertWrapper[] arrCertWrappers = null;
        X509CertSelector selector = new X509CertSelector();
        boolean[] arrUsage = new boolean[]{bSign, bSign, bKeyEncrypt, false, false, false, false, false, false};
        selector.setKeyUsage(arrUsage);
        List<X509Certificate> listCerts = Arrays.asList(arrCerts);
        try {
            CertStore certStore = CertStore.getInstance("Collection", (CertStoreParameters)new CollectionCertStoreParameters(listCerts), "BC");
            Collection<? extends Certificate> colSigning = certStore.getCertificates(selector);
            ArrayList<X509CertWrapper> listWrappers = new ArrayList<X509CertWrapper>();
            Iterator<? extends Certificate> itCerts = colSigning.iterator();
            while (itCerts.hasNext()) {
                X509Certificate cert = (X509Certificate)itCerts.next();
                if (sEmailAddress != null && !this.u(cert, sEmailAddress)) continue;
                String sCertID = this.s(cert.getIssuerDN().getName(), cert.getSerialNumber());
                X509CertWrapper wrapper = new X509CertWrapper(cert, sProvider != null ? sProvider : this.y().getProviderName(cert), sCertID);
                listWrappers.add(wrapper);
            }
            arrCertWrappers = listWrappers.toArray(new X509CertWrapper[listWrappers.size()]);
        }
        catch (Exception exp) {
            AppletLogger.log(exp);
            this.setError(AppletConstants.ERR_JCE_ERROR, " Loading certs into certstore");
        }
        return arrCertWrappers;
    }

    public Enumeration getAttachments(String strMessageID) {
        this.resetError();
        Enumeration enumAttachments = null;
        C047 msg = (C047)this.K.get(strMessageID);
        if (msg != null) {
            enumAttachments = msg.br();
        } else {
            this.setError(AppletConstants.ERR_INVALID_MSGID);
        }
        return enumAttachments;
    }

    private X509Certificate J(String email, FedToken card) throws CardException, CertificateParsingException {
        AppletLogger.log("Looking for cerdentials for " + email);
        X509Certificate[] certs = card.getUserCertificates();
        X509Certificate found = null;
        for (int idx = 0; idx < certs.length; ++idx) {
            X509Certificate cert = certs[idx];
            if (this.u(cert, email)) {
                found = cert;
            }
            if (found != null) break;
        }
        return found;
    }

    static /* synthetic */ X509CertWrapper[] access$202(SMIMEAppletCard x0, X509CertWrapper[] x1) {
        x0.T = x1;
        return x1;
    }

    public void setFrom(String strMessageID, String strFrom) {
        this.resetError();
        C047 msg = (C047)this.K.get(strMessageID);
        if (msg != null) {
            try {
                msg.o(strFrom);
            }
            catch (AddressException exp) {
                AppletLogger.log(exp);
                this.setError(AppletConstants.ERR_INVALID_EMAILADDRESS, strFrom);
            }
        } else {
            this.setError(AppletConstants.ERR_INVALID_MSGID);
        }
    }

    public String getInvalidRecipientListErrors(String strMessageID) {
        this.resetError();
        String sList = "";
        C047 msg = (C047)this.K.get(strMessageID);
        if (msg != null) {
            sList = msg.f(true);
        } else {
            this.setError(AppletConstants.ERR_INVALID_MSGID);
        }
        return sList;
    }

    public void removeAllRecipients(String strMessageID) {
        this.resetError();
        C047 msg = (C047)this.K.get(strMessageID);
        if (msg != null) {
            msg.k();
        } else {
            this.setError(AppletConstants.ERR_INVALID_MSGID);
        }
    }

    public class DelegatedCardAdmin
    implements CardAdmin {
        protected CardAdmin m_delegatedAdmin;

        public DelegatedCardAdmin(CardAdmin delegate) {
            this.m_delegatedAdmin = delegate;
        }

        public void reportTokenStatus(boolean tokenAvailable, String message) {
            if (this.m_delegatedAdmin != null) {
                this.m_delegatedAdmin.reportTokenStatus(tokenAvailable, message);
            } else {
                SMIMEAppletCard.access$202(SMIMEAppletCard.this, null);
                ((SMIMEAppletAPI)SMIMEAppletCard.this.getOwner()).reportTokenStatus(tokenAvailable, message);
            }
        }

        public String getDllPath(String providerId) {
            if (this.m_delegatedAdmin != null) {
                return this.m_delegatedAdmin.getDllPath(providerId);
            }
            return SMIMEAppletCard.this.R;
        }

        public void reportProviderError(String providerId, String message) {
            if (this.m_delegatedAdmin != null) {
                this.m_delegatedAdmin.reportProviderError(providerId, message);
            } else {
                ((SMIMEAppletAPI)SMIMEAppletCard.this.getOwner()).reportProviderError(providerId, message);
            }
        }

        public String getLogin(String providerId, String prompt) {
            String sPass = null;
            if (this.m_delegatedAdmin != null) {
                sPass = this.m_delegatedAdmin.getLogin(providerId, prompt);
            } else if (SMIMEAppletCard.this.Z) {
                sPass = ((SMIMEAppletAPI)SMIMEAppletCard.this.getOwner()).getLogin(providerId, prompt);
            } else {
                Frame frm = new Frame();
                TokenPinDialog dlg = new TokenPinDialog(frm, providerId, prompt);
                dlg.show();
                sPass = dlg.getPassword();
                frm.setVisible(false);
            }
            return sPass;
        }

        public void reportKeystoreChange() {
            if (this.m_delegatedAdmin != null) {
                this.m_delegatedAdmin.reportKeystoreChange();
            } else {
                SMIMEAppletCard.access$202(SMIMEAppletCard.this, null);
            }
        }

        public DelegatedCardAdmin() {
            this.m_delegatedAdmin = null;
        }

        public String getTokenPath(String providerId) {
            if (this.m_delegatedAdmin != null) {
                return this.m_delegatedAdmin.getTokenPath(providerId);
            }
            return SMIMEAppletCard.this.N;
        }
    }
}

