/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.KEKIdentifier;
import org.bouncycastle.asn1.cms.KEKRecipientInfo;
import org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import org.bouncycastle.asn1.cms.RecipientIdentifier;
import org.bouncycastle.asn1.cms.RecipientInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;

class C103 {
    X509Certificate b;
    ASN1OctetString c;
    KEKIdentifier d;
    PublicKey e;
    SecretKey f;
    private final /* synthetic */ C083 g;
    AlgorithmIdentifier h;

    C103(C083 this$0, SecretKey secKey, KEKIdentifier secKeyId) {
        this.g = this$0;
        this.f = secKey;
        this.d = secKeyId;
        if (secKey.getAlgorithm().startsWith("DES")) {
            this.h = new AlgorithmIdentifier(new DERObjectIdentifier("1.2.840.113549.1.9.16.3.6"), (DEREncodable)new DERNull());
        } else if (secKey.getAlgorithm().startsWith("RC2")) {
            this.h = new AlgorithmIdentifier(new DERObjectIdentifier("1.2.840.113549.1.9.16.3.7"), (DEREncodable)new DERInteger(58));
        } else {
            throw new IllegalArgumentException("unknown algorithm");
        }
    }

    C103(C083 this$0, PublicKey pubKey, ASN1OctetString subKeyId) {
        this.g = this$0;
        this.e = pubKey;
        this.c = subKeyId;
        try {
            byte[] bytes = pubKey.getEncoded();
            ByteArrayInputStream bIn = new ByteArrayInputStream(bytes);
            ASN1InputStream aIn = new ASN1InputStream((InputStream)bIn);
            SubjectPublicKeyInfo info = SubjectPublicKeyInfo.getInstance((Object)aIn.readObject());
            this.h = info.getAlgorithmId();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("can't extract key algorithm from this key");
        }
    }

    RecipientInfo a(SecretKey key, String prov) throws IOException, GeneralSecurityException {
        Cipher keyCipher = Cipher.getInstance(C069.b(this.h.getObjectId().getId()), prov);
        if (this.e != null) {
            byte[] rawKey = key.getEncoded();
            keyCipher.init(1, this.e);
            DEROctetString encKey = new DEROctetString(keyCipher.doFinal(rawKey));
            if (this.b != null) {
                ByteArrayInputStream bIn = new ByteArrayInputStream(this.b.getTBSCertificate());
                ASN1InputStream aIn = new ASN1InputStream((InputStream)bIn);
                TBSCertificateStructure tbs = TBSCertificateStructure.getInstance((Object)aIn.readObject());
                IssuerAndSerialNumber encSid = new IssuerAndSerialNumber(tbs.getIssuer(), this.b.getSerialNumber());
                return new RecipientInfo(new KeyTransRecipientInfo(new RecipientIdentifier(encSid), this.h, (ASN1OctetString)encKey));
            }
            return new RecipientInfo(new KeyTransRecipientInfo(new RecipientIdentifier(this.c), this.h, (ASN1OctetString)encKey));
        }
        keyCipher.init(3, this.f);
        DEROctetString encKey = new DEROctetString(keyCipher.wrap(key));
        return new RecipientInfo(new KEKRecipientInfo(this.d, this.h, (ASN1OctetString)encKey));
    }

    C103(C083 this$0, X509Certificate cert) {
        this.g = this$0;
        this.b = cert;
        this.e = cert.getPublicKey();
        try {
            byte[] bytes = cert.getTBSCertificate();
            ByteArrayInputStream bIn = new ByteArrayInputStream(bytes);
            ASN1InputStream aIn = new ASN1InputStream((InputStream)bIn);
            TBSCertificateStructure tbs = TBSCertificateStructure.getInstance((Object)aIn.readObject());
            SubjectPublicKeyInfo info = tbs.getSubjectPublicKeyInfo();
            this.h = info.getAlgorithmId();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("can't extract key algorithm from this cert");
        }
        catch (CertificateEncodingException e) {
            throw new IllegalArgumentException("can't extract tbs structure from this cert");
        }
    }
}

