#!/bin/sh
#
#  (c) 2004 Sun Microsystems, Inc. Use is subject to license terms.
#
#  This script updates the database for dbwriter and ARCo reporting
#
#  Scriptname: updatedb
#

umask 022

DBWRITER_PWD=`pwd`
cd ..
. ./util/arch_variables
. ./util/install_modules/inst_common.sh
. $DBWRITER_PWD/inst_util.sh



BasicSettings
SetUpInfoText

JARS="jax-qname.jar jaxb-api.jar jaxb-impl.jar jaxb-libs.jar \
 namespace.jar relaxngDatatype.jar xsdlib.jar"

CP=$DBWRITER_PWD/lib/dbwriter.jar
for i in $JARS; do
  CP="$CP:$DBWRITER_PWD/lib/$i"
done


queryDBWriterConfig() {
   dummy=`pwd`
   $INFOTEXT -n "\nPlease enter your SGE_ROOT [$dummy] >> "
   SGE_ROOT=`Enter $dummy`
   
   dummy="default"
   $INFOTEXT -n "\nPlease enter your SGE_CELL [$dummy] >> "
   SGE_CELL=`Enter $dummy`
   
   
   DBWRITER_CONF=$SGE_ROOT/$SGE_CELL/common/dbwriter.conf
   while [ 1 ]; do
      dummy=$DBWRITER_CONF
      $INFOTEXT -n "\nPlease enter the path to the dbwriter configuration file [$dummy]>> "
      DBWRITER_CONF=`Enter $dummy`
      
      if [ -r $DBWRITER_CONF ]; then
          break
      else 
         $INFOTEXT "Error: configuration file for dbwriter not found"
      fi 
   done
}

## Main

$INFOTEXT  "\n"
$INFOTEXT  -u "Installation / Upgrade for the N1GE6 ARCo database"
$INFOTEXT  "\n"

queryJavaHome

$INFOTEXT -n -ask y n -def y \
          "\nDo you have a installation of the dbwriter? (y/n) [y] >> "

if [ $? -eq 0 ]; then
   queryDBWriterConfig
   # source the dbwriter configuration
   . $DBWRITER_CONF
   
   DB_PW=$DBWRITER_USER_PW
   DB_USER=$DBWRITER_USER
   DB_URL=$DBWRITER_URL
   DB_DRIVER=$DBWRITER_DRIVER

   # The name of the database schema is not stored
   # in the dbwriter config file.
   # Query the schema name
   queryDBSchema
   
   searchJDBCDriverJar $DB_DRIVER $DBWRITER_PWD/lib
   
   testDB
   
else 
   setupDB arco_read $DBWRITER_PWD/lib
fi

# database parameters a correct try update

case "$DB_DRIVER" in
  "org.postgresql.Driver")
          DB_DEF=$DBWRITER_PWD/database/postgres/dbdefinition.xml;;
  "oracle.jdbc.driver.OracleDriver")
          DB_DEF=$DBWRITER_PWD/database/oracle/dbdefinition.xml;;
  *)
      $INFOTEXT "Unkown database with driver $DB_DRIVER";
      exit 1;;
esac

#
# DB_VERSION is defined in inst_util.sh
installDB $DB_VERSION $DB_DEF







