/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.postgresql.core.PGStream;
import org.postgresql.jdbc3.Jdbc3Connection;
import org.postgresql.util.PSQLException;
import org.postgresql.util.PSQLState;

public class Driver
implements java.sql.Driver {
    public static final int DEBUG = 2;
    public static final int INFO = 1;
    public static boolean logDebug = false;
    public static boolean logInfo = false;
    private static String[] protocols;
    private static int m_buildNumber;

    public Connection connect(String url, Properties info) throws SQLException {
        Properties props = this.parseURL(url, info);
        if (props == null) {
            if (logDebug) {
                Driver.debug("Error in url" + url);
            }
            return null;
        }
        try {
            if (logDebug) {
                Driver.debug("connect " + url);
            }
            Jdbc3Connection con = (Jdbc3Connection)Class.forName("org.postgresql.jdbc3.Jdbc3Connection").newInstance();
            con.openConnection(this.host(props), this.port(props), props, this.database(props), url, this);
            return con;
        }
        catch (ClassNotFoundException ex) {
            if (logDebug) {
                Driver.debug("error", ex);
            }
            throw new PSQLException("postgresql.jvm.version", PSQLState.SYSTEM_ERROR, (Object)ex);
        }
        catch (PSQLException ex1) {
            throw ex1;
        }
        catch (Exception ex2) {
            if (logDebug) {
                Driver.debug("error", ex2);
            }
            throw new PSQLException("postgresql.unusual", PSQLState.UNEXPECTED_ERROR, (Object)ex2);
        }
    }

    public boolean acceptsURL(String url) throws SQLException {
        return this.parseURL(url, null) != null;
    }

    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        this.parseURL(url, info);
        return new DriverPropertyInfo[0];
    }

    public int getMajorVersion() {
        return 7;
    }

    public int getMinorVersion() {
        return 4;
    }

    public static String getVersion() {
        return "PostgreSQL 7.4.2 JDBC3 with SSL (build " + m_buildNumber + ")";
    }

    public boolean jdbcCompliant() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Properties parseURL(String url, Properties defaults) throws SQLException {
        int state = -1;
        Properties urlProps = new Properties(defaults);
        String l_urlServer = url;
        String l_urlArgs = "";
        int l_qPos = url.indexOf(63);
        if (l_qPos != -1) {
            l_urlServer = url.substring(0, l_qPos);
            l_urlArgs = url.substring(l_qPos + 1);
        }
        int ipv6start = l_urlServer.indexOf("[");
        int ipv6end = l_urlServer.indexOf("]");
        String ipv6address = null;
        if (ipv6start != -1 && ipv6end > ipv6start) {
            ipv6address = l_urlServer.substring(ipv6start + 1, ipv6end);
            l_urlServer = l_urlServer.substring(0, ipv6start) + "ipv6host" + l_urlServer.substring(ipv6end + 1);
        }
        StringTokenizer st = new StringTokenizer(l_urlServer, ":/", true);
        int count = 0;
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (count <= 3) {
                if (count % 2 != 1 || !token.equals(":")) {
                    if (count % 2 != 0) return null;
                    boolean found = count == 0;
                    int tmp = 0;
                    while (tmp < protocols.length) {
                        if (token.equals(protocols[tmp]) && count == 2 && tmp > 0) {
                            urlProps.put("Protocol", token);
                            found = true;
                        }
                        ++tmp;
                    }
                    if (!found) {
                        return null;
                    }
                }
            } else if (count > 3) {
                if (count == 4 && token.equals("/")) {
                    state = 0;
                } else if (count == 4) {
                    urlProps.put("PGDBNAME", token);
                    state = -2;
                } else if (count == 5 && state == 0 && token.equals("/")) {
                    state = 1;
                } else {
                    if (count == 5 && state == 0) {
                        return null;
                    }
                    if (count == 6 && state == 1) {
                        urlProps.put("PGHOST", token);
                    } else if (count == 7 && token.equals(":")) {
                        state = 2;
                    } else if (count == 8 && state == 2) {
                        try {
                            Integer portNumber = Integer.decode(token);
                            urlProps.put("PGPORT", portNumber.toString());
                        }
                        catch (Exception e) {
                            return null;
                        }
                    } else if (!(count != 7 && count != 9 || state != 1 && state != 2 || !token.equals("/"))) {
                        state = -1;
                    } else if (state == -1) {
                        urlProps.put("PGDBNAME", token);
                        state = -2;
                    }
                }
            }
            ++count;
        }
        if (ipv6address != null) {
            urlProps.put("PGHOST", ipv6address);
        }
        StringTokenizer qst = new StringTokenizer(l_urlArgs, "&");
        int count2 = 0;
        while (qst.hasMoreTokens()) {
            String token = qst.nextToken();
            int l_pos = token.indexOf(61);
            if (l_pos == -1) {
                urlProps.put(token, "");
            } else {
                urlProps.put(token.substring(0, l_pos), token.substring(l_pos + 1));
            }
            ++count2;
        }
        return urlProps;
    }

    public String host(Properties props) {
        return props.getProperty("PGHOST", "localhost");
    }

    public int port(Properties props) {
        return Integer.parseInt(props.getProperty("PGPORT", "5432"));
    }

    public String database(Properties props) {
        return props.getProperty("PGDBNAME", "");
    }

    public static SQLException notImplemented() {
        return new PSQLException("postgresql.unimplemented", PSQLState.NOT_IMPLEMENTED);
    }

    public static void setLogLevel(int logLevel) {
        logDebug = logLevel >= 2;
        logInfo = logLevel >= 1;
    }

    public static void debug(String msg) {
        if (logDebug) {
            DriverManager.println(msg);
        }
    }

    public static void debug(String msg, Exception ex) {
        if (logDebug) {
            DriverManager.println(msg);
            if (ex != null) {
                DriverManager.println(ex.toString());
            }
        }
    }

    public static void info(String msg) {
        if (logInfo) {
            DriverManager.println(msg);
        }
    }

    public static void info(String msg, Exception ex) {
        if (logInfo) {
            DriverManager.println(msg);
            if (ex != null) {
                DriverManager.println(ex.toString());
            }
        }
    }

    public static void makeSSL(PGStream p_stream) throws IOException {
        if (logDebug) {
            Driver.debug("converting regular socket connection to ssl");
        }
        SSLSocketFactory factory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        p_stream.connection = (SSLSocket)factory.createSocket(p_stream.connection, p_stream.host, p_stream.port, true);
        p_stream.pg_input = new BufferedInputStream(p_stream.connection.getInputStream(), 8192);
        p_stream.pg_output = new BufferedOutputStream(p_stream.connection.getOutputStream(), 8192);
    }

    public static boolean sslEnabled() {
        boolean l_return = false;
        l_return = true;
        return l_return;
    }

    static {
        try {
            DriverManager.registerDriver(new Driver());
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        protocols = new String[]{"jdbc", "postgresql"};
        m_buildNumber = 212;
    }
}

