/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind;

public abstract class WhiteSpaceProcessor {
    protected static final boolean isWhiteSpace(char ch) {
        if (ch > ' ') {
            return false;
        }
        return ch == '\t' || ch == '\n' || ch == '\r' || ch == ' ';
    }

    public static String collapse(String text) {
        int len = text.length();
        int s = 0;
        while (s < len) {
            if (WhiteSpaceProcessor.isWhiteSpace(text.charAt(s))) break;
            ++s;
        }
        if (s == len) {
            return text;
        }
        StringBuffer result = new StringBuffer(len);
        if (s != 0) {
            int i = 0;
            while (i < s) {
                result.append(text.charAt(i));
                ++i;
            }
            result.append(' ');
        }
        boolean inStripMode = true;
        int i = s + 1;
        while (i < len) {
            char ch = text.charAt(i);
            boolean b = WhiteSpaceProcessor.isWhiteSpace(ch);
            if (!inStripMode || !b) {
                inStripMode = b;
                if (inStripMode) {
                    result.append(' ');
                } else {
                    result.append(ch);
                }
            }
            ++i;
        }
        len = result.length();
        if (len > 0 && result.charAt(len - 1) == ' ') {
            result.setLength(len - 1);
        }
        return result.toString();
    }

    public static String replace(String text) {
        int len = text.length();
        StringBuffer result = new StringBuffer(len);
        int i = 0;
        while (i < len) {
            char ch = text.charAt(i);
            if (WhiteSpaceProcessor.isWhiteSpace(ch)) {
                result.append(' ');
            } else {
                result.append(ch);
            }
            ++i;
        }
        return result.toString();
    }
}

