/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.bind.marshaller;

import com.sun.xml.bind.marshaller.CharacterEscapeHandler;
import com.sun.xml.bind.marshaller.EncoderFactory;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.CharsetEncoder;

public class NioEscapeHandler
implements CharacterEscapeHandler {
    private final CharsetEncoder encoder;

    public void escape(char[] ch, int start, int length, boolean isAttVal, Writer out) throws IOException {
        int limit = start + length;
        int i = start;
        while (i < limit) {
            switch (ch[i]) {
                case '&': {
                    out.write("&amp;");
                    break;
                }
                case '<': {
                    out.write("&lt;");
                    break;
                }
                case '>': {
                    out.write("&gt;");
                    break;
                }
                case '\"': {
                    if (isAttVal) {
                        out.write("&quot;");
                        break;
                    }
                    out.write(34);
                    break;
                }
                default: {
                    if (this.encoder.canEncode(ch[i])) {
                        out.write(ch[i]);
                        break;
                    }
                    out.write("&#");
                    out.write(Integer.toString(ch[i]));
                    out.write(59);
                }
            }
            ++i;
        }
    }

    public NioEscapeHandler(String charsetName) {
        this.encoder = EncoderFactory.createEncoder(charsetName);
    }
}

