/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.util;

import com.sun.grid.logging.SGELog;
import com.sun.grid.util.sqlutil.Command;
import com.sun.grid.util.sqlutil.UpdateDbModelCommand;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.StreamHandler;

public class SQLUtil {
    private Connection connection;
    private boolean done = false;
    private Logger logger;
    private Handler handler;
    private Map cmdMap = new HashMap();
    private Map variables = new HashMap();
    public static final Level[] DEBUG_LEVELS = new Level[]{Level.SEVERE, Level.WARNING, Level.INFO, Level.CONFIG, Level.FINE};

    public SQLUtil() {
        this.logger = Logger.getLogger(this.getClass().getName());
        this.logger.setUseParentHandlers(false);
        this.handler = new MyHandler((Formatter)new MyFormatter());
        this.logger.addHandler(this.handler);
        this.logger.setLevel(Level.INFO);
        this.handler.setLevel(Level.INFO);
        SGELog.init(this.logger);
        this.initCmds();
    }

    private void reg(Command cmd) {
        this.cmdMap.put(cmd.getName().toLowerCase(), cmd);
    }

    public final Connection getConnection() {
        return this.connection;
    }

    public final String getValue(String variable) {
        return (String)this.variables.get(variable.toUpperCase());
    }

    public final void setValue(String variable, String value) {
        SGELog.fine("set variable ''{0}'' = ''{1}''", (Object)variable, (Object)value);
        this.variables.put(variable.toUpperCase(), value);
    }

    public final String[] getVariables() {
        String[] ret = new String[this.variables.size()];
        this.variables.keySet().toArray(ret);
        return ret;
    }

    private Command getCommand(String name) {
        return (Command)this.cmdMap.get(name.toLowerCase());
    }

    private void initCmds() {
        this.reg(new ConnectCommand(this));
        this.reg(new SQLCommand(this, "select"));
        this.reg(new SQLCommand(this, "insert"));
        this.reg(new SQLCommand(this, "update"));
        this.reg(new SQLCommand(this, "delete"));
        this.reg(new SQLCommand(this, "create"));
        this.reg(new SQLCommand(this, "alter"));
        this.reg(new SQLCommand(this, "drop"));
        this.reg(new HelpCommand(this));
        this.reg(new ExitCommand(this));
        this.reg(new UpdateDbModelCommand(this, "install"));
        this.reg(new DebugLevelCommand(this, "debug"));
        this.reg(new SetCommand(this, "set"));
        this.reg(new EnvCommand(this, "env"));
    }

    public final void run() {
        try {
            InputStreamReader reader = new InputStreamReader(System.in);
            BufferedReader in = new BufferedReader(reader);
            StringBuffer buf = new StringBuffer();
            String line = null;
            while (!this.done) {
                buf.setLength(0);
                if (this.logger.isLoggable(Level.INFO)) {
                    System.err.print("prompt: ");
                }
                while (!this.done && (line = in.readLine()) != null) {
                    if (line.endsWith("\\")) {
                        buf.append(line.substring(0, line.length() - 1));
                        continue;
                    }
                    buf.append(line);
                    break;
                }
                if (buf.length() == 0) continue;
                line = buf.toString();
                int index = line.indexOf(32);
                String cmdName = null;
                String args = null;
                if (index > 0) {
                    cmdName = line.substring(0, index);
                    args = line.substring(index + 1);
                } else {
                    cmdName = line;
                    args = null;
                }
                Command cmd = this.getCommand(cmdName);
                if (cmd == null) {
                    SGELog.warning("Command ''{0}'' unknown", (Object)cmdName);
                    cmd = this.getCommand("help");
                    cmd.run(null);
                    System.exit(1);
                    continue;
                }
                int ret = cmd.run(args);
                if (ret == 0) continue;
                SGELog.warning("Last command failed, exit");
                System.exit(ret);
            }
        }
        catch (Exception e) {
            SGELog.severe((Throwable)e, "Unknown error: {0}", (Object)e.getMessage());
            e.printStackTrace();
            System.exit(-1);
        }
    }

    public static void main(String[] args) {
        SQLUtil util = new SQLUtil();
        util.run();
    }

    public final String replaceVariables(String str) {
        StringBuffer buf = new StringBuffer(str);
        int open = -1;
        int close = -1;
        String var = null;
        String value = null;
        int index = 0;
        while (index < buf.length() && (open = buf.indexOf("{", index)) >= 0 && (close = buf.indexOf("}", open + 1)) > open) {
            var = buf.substring(open + 1, close);
            value = this.getValue(var);
            if (value == null) {
                value = "";
            }
            buf.replace(open, close + 1, value);
            index = open + value.length();
        }
        return buf.toString();
    }

    class DebugLevelCommand
    extends Command {
        public DebugLevelCommand(SQLUtil sSQLUtil, String name) {
            super(sSQLUtil, name);
        }

        public int run(String args) {
            if (args != null) {
                try {
                    Level level = Level.parse(args.toUpperCase());
                    SQLUtil.this.logger.setLevel(level);
                    SQLUtil.this.handler.setLevel(level);
                    SGELog.fine("set debug level to {0}", level);
                    return 0;
                }
                catch (IllegalArgumentException iae) {
                    SGELog.severe("{0} is not a valid debug level", (Object)args);
                    SGELog.info(this.usage());
                    return 1;
                }
            }
            SGELog.info("current debug level is {0}", SQLUtil.this.logger.getLevel());
            return 0;
        }

        public final String usage() {
            StringBuffer ret = new StringBuffer();
            ret.append(this.getName());
            ret.append(" [(");
            for (int i = 0; i < DEBUG_LEVELS.length; ++i) {
                if (i > 0) {
                    ret.append("|");
                }
                ret.append(DEBUG_LEVELS[i]);
            }
            ret.append(")]");
            return ret.toString();
        }
    }

    class SetCommand
    extends Command {
        public SetCommand(SQLUtil aSQLUtil, String aName) {
            super(aSQLUtil, aName);
        }

        public final int run(String args) {
            int index = args.indexOf(32);
            if (index <= 0) {
                SGELog.severe(this.usage());
                return 1;
            }
            String variable = args.substring(0, index).trim();
            String value = args.substring(index + 1).trim();
            SQLUtil.this.setValue(variable, value);
            return 0;
        }

        public final String usage() {
            return this.getName() + " <variable> <value>";
        }
    }

    class EnvCommand
    extends Command {
        public EnvCommand(SQLUtil aSQLUtil, String aName) {
            super(aSQLUtil, aName);
        }

        public final int run(String args) {
            String[] vars = SQLUtil.this.getVariables();
            for (int i = 0; i < vars.length; ++i) {
                SGELog.info("{0}={1}", (Object)vars[i], (Object)SQLUtil.this.getValue(vars[i]));
            }
            return 0;
        }

        public String usage() {
            return this.getName();
        }
    }

    class MyHandler
    extends StreamHandler {
        public MyHandler(Formatter formatter) {
            super(System.out, formatter);
        }

        public final void publish(LogRecord record) {
            super.publish(record);
            this.flush();
        }
    }

    class MyFormatter
    extends Formatter {
        private StringBuffer buf = new StringBuffer();

        MyFormatter() {
        }

        public final String format(LogRecord record) {
            if (!Level.INFO.equals(record.getLevel())) {
                this.buf.append(record.getLevel().getName());
                this.buf.append(": ");
            }
            String msg = null;
            msg = record.getParameters() != null ? MessageFormat.format(record.getMessage(), record.getParameters()) : record.getMessage();
            this.buf.append(msg);
            this.buf.append("\n");
            String ret = this.buf.toString();
            this.buf.setLength(0);
            return ret;
        }
    }

    class SQLCommand
    extends Command {
        public SQLCommand(SQLUtil aSqlUtil, String name) {
            super(aSqlUtil, name);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final int run(String args) {
            if (SQLUtil.this.connection == null) {
                SGELog.severe("Can not execute this command, not connected");
                return 1;
            }
            try {
                block15: {
                    Statement stmt = SQLUtil.this.connection.createStatement();
                    try {
                        String sql = this.getName();
                        if (args != null) {
                            sql = sql + " " + SQLUtil.this.replaceVariables(args);
                        }
                        if (stmt.execute(sql)) {
                            ResultSet rs = stmt.getResultSet();
                            try {
                                int colCount = rs.getMetaData().getColumnCount();
                                StringBuffer buf = new StringBuffer();
                                while (rs.next()) {
                                    buf.setLength(0);
                                    for (int i = 1; i <= colCount; ++i) {
                                        if (i > 1) {
                                            buf.append('\t');
                                        }
                                        buf.append(rs.getString(i));
                                    }
                                    SGELog.info(buf.toString());
                                }
                                break block15;
                            }
                            finally {
                                rs.close();
                            }
                        }
                        if (stmt.getUpdateCount() > 0) {
                            SGELog.info("{0} rows updated", new Integer(stmt.getUpdateCount()));
                        }
                    }
                    finally {
                        stmt.close();
                    }
                }
                return 0;
            }
            catch (SQLException sqle) {
                SGELog.severe("sql: {0}", (Object)sqle.getMessage());
                return 1;
            }
        }

        public final String usage() {
            return this.getName() + " (sql command, depends on the database)";
        }
    }

    class HelpCommand
    extends Command {
        public HelpCommand(SQLUtil aSqlUtil) {
            super(aSqlUtil, "help");
        }

        public final int run(String args) {
            if (args != null && args.length() > 0) {
                Command cmd = SQLUtil.this.getCommand(args);
                if (cmd == null) {
                    SGELog.warning("Command ''{0}'' unknown", (Object)args);
                } else {
                    SGELog.info("usage: {0}", (Object)cmd.usage());
                }
            } else {
                StringBuffer cmds = new StringBuffer();
                Iterator iter = SQLUtil.this.cmdMap.keySet().iterator();
                while (iter.hasNext()) {
                    cmds.append(iter.next());
                    cmds.append(' ');
                }
                SGELog.info("available commands: {0}", cmds);
            }
            return 0;
        }

        public final String usage() {
            return "help [command]";
        }
    }

    class ExitCommand
    extends Command {
        public ExitCommand(SQLUtil aSqlUtil) {
            super(aSqlUtil, "exit");
        }

        public final int run(String args) {
            System.exit(0);
            return 0;
        }

        public final String usage() {
            return this.getName();
        }
    }

    class ConnectCommand
    extends Command {
        public ConnectCommand(SQLUtil aSqlUtil) {
            super(aSqlUtil, "connect");
        }

        public final int run(String args) {
            if (args == null) {
                SGELog.severe(this.usage());
                return 1;
            }
            StringTokenizer st = new StringTokenizer(SQLUtil.this.replaceVariables(args), " ");
            String driver = null;
            String url = null;
            String user = null;
            String pw = null;
            switch (st.countTokens()) {
                case 3: {
                    driver = st.nextToken();
                    url = st.nextToken();
                    user = st.nextToken();
                    break;
                }
                case 4: {
                    driver = st.nextToken();
                    url = st.nextToken();
                    user = st.nextToken();
                    pw = st.nextToken();
                    break;
                }
                default: {
                    SGELog.severe("invalid arguments for command " + this.getName());
                    SGELog.severe(this.usage());
                    return 1;
                }
            }
            SGELog.fine("driver is ''{0}''", (Object)driver);
            try {
                Class.forName(driver);
            }
            catch (ClassNotFoundException cnfe) {
                SGELog.severe("driver class " + driver + "not found");
                return 2;
            }
            try {
                SGELog.info("connect to {0} as user {1}", (Object)url, (Object)user);
                SQLUtil.this.connection = DriverManager.getConnection(url, user, pw);
                SGELog.info("connected");
                return 0;
            }
            catch (SQLException sqle) {
                SGELog.severe("Can not get a connection to {0}", (Object)url);
                SGELog.severe(sqle.getMessage());
                return 3;
            }
        }

        public final String usage() {
            return this.getName() + " <driver> <url> <user> [<password>]";
        }
    }
}

