/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.dbwriter.file;

import com.sun.grid.logging.SGELog;
import com.sun.grid.reporting.dbwriter.db.DatabaseField;
import com.sun.grid.reporting.dbwriter.db.DateField;
import com.sun.grid.reporting.dbwriter.db.DoubleField;
import com.sun.grid.reporting.dbwriter.db.IntegerField;
import com.sun.grid.reporting.dbwriter.db.StringField;
import com.sun.grid.reporting.dbwriter.file.ReportFileReader;
import com.sun.grid.reporting.dbwriter.file.ReportingSource;
import java.util.Map;

public class ReportingFileReader
extends ReportFileReader {
    DatabaseField[] accountingFields = new DatabaseField[]{new DateField("time"), new StringField("type"), new StringField("a_qname"), new StringField("a_hostname"), new StringField("a_group"), new StringField("a_owner"), new StringField("a_job_name"), new IntegerField("a_job_number"), new StringField("a_account"), new IntegerField("a_priority"), new DateField("a_submission_time"), new DateField("a_start_time"), new DateField("a_end_time"), new IntegerField("a_failed"), new IntegerField("a_exit_status"), new IntegerField("a_ru_wallclock"), new DoubleField("a_ru_utime"), new DoubleField("a_ru_stime"), new IntegerField("a_ru_maxrss", true, true), new IntegerField("a_ru_ixrss", true, true), new IntegerField("a_ru_issmrss", true, true), new IntegerField("a_ru_idrss", true, true), new IntegerField("a_ru_isrss", true, true), new IntegerField("a_ru_minflt", true, true), new IntegerField("a_ru_majflt", true, true), new IntegerField("a_ru_nswap", true, true), new IntegerField("a_ru_inblock", true, true), new IntegerField("a_ru_outblock", true, true), new IntegerField("a_ru_msgsnd", true, true), new IntegerField("a_ru_msgrcv", true, true), new IntegerField("a_ru_nsignals", true, true), new IntegerField("a_ru_nvcsw", true, true), new IntegerField("a_ru_nivcsw", true, true), new StringField("a_project"), new StringField("a_department"), new StringField("a_granted_pe"), new IntegerField("a_slots"), new IntegerField("a_task_number"), new DoubleField("a_cpu"), new DoubleField("a_mem"), new DoubleField("a_io"), new StringField("a_category"), new DoubleField("a_iow"), new StringField("a_pe_taskid"), new DoubleField("a_maxvmem")};
    Map accountingMap = this.createMap(this.accountingFields);
    DatabaseField[] hostFields = new DatabaseField[]{new DateField("time"), new StringField("type"), new StringField("h_name"), new DateField("h_time"), new StringField("h_state"), new StringField("h_load")};
    Map hostMap = this.createMap(this.hostFields);
    DatabaseField[] hostConsumableFields = new DatabaseField[]{new DateField("time"), new StringField("type"), new StringField("hc_name"), new DateField("hc_time"), new StringField("hc_state"), new StringField("hc_consumables")};
    Map hostConsumableMap = this.createMap(this.hostConsumableFields);
    DatabaseField[] queueFields = new DatabaseField[]{new DateField("time"), new StringField("type"), new StringField("q_qname"), new StringField("q_qhostname"), new DateField("q_time"), new StringField("q_state")};
    Map queueMap = this.createMap(this.queueFields);
    DatabaseField[] queueConsumableFields = new DatabaseField[]{new DateField("time"), new StringField("type"), new StringField("qc_qname"), new StringField("qc_qhostname"), new DateField("qc_time"), new StringField("qc_state"), new StringField("qc_consumables")};
    Map queueConsumableMap = this.createMap(this.queueConsumableFields);
    DatabaseField[] sharelogFields = new DatabaseField[]{new DateField("time"), new StringField("type"), new DateField("sl_curr_time"), new DateField("sl_usage_time"), new StringField("sl_node"), new StringField("sl_user"), new StringField("sl_project"), new IntegerField("sl_shares"), new IntegerField("sl_job_count"), new DoubleField("sl_level"), new DoubleField("sl_total"), new DoubleField("sl_long_target_share"), new DoubleField("sl_short_target_share"), new DoubleField("sl_actual_share"), new DoubleField("sl_usage"), new DoubleField("sl_cpu"), new DoubleField("sl_mem"), new DoubleField("sl_io"), new DoubleField("sl_ltcpu"), new DoubleField("sl_ltmem"), new DoubleField("sl_ltio"), new StringField("dummy")};
    Map sharelogMap = this.createMap(this.sharelogFields);
    DatabaseField[] newjobFields = new DatabaseField[]{new DateField("time"), new StringField("type"), new DateField("nj_submission_time"), new IntegerField("nj_job_number"), new IntegerField("nj_task_number"), new StringField("nj_pe_taskid"), new StringField("nj_job_name"), new StringField("nj_owner"), new StringField("nj_group"), new StringField("nj_project"), new StringField("nj_department"), new StringField("nj_account"), new IntegerField("nj_priority")};
    Map newjobMap = this.createMap(this.newjobFields);
    DatabaseField[] joblogFields = new DatabaseField[]{new DateField("time"), new StringField("type"), new DateField("jl_time"), new StringField("jl_event"), new IntegerField("jl_job_number"), new IntegerField("jl_task_number"), new StringField("jl_pe_taskid"), new StringField("jl_state"), new StringField("jl_user"), new StringField("jl_host"), new IntegerField("jl_state_time"), new IntegerField("jl_priority"), new DateField("jl_submission_time"), new StringField("jl_job_name"), new StringField("jl_owner"), new StringField("jl_group"), new StringField("jl_project"), new StringField("jl_department"), new StringField("jl_account"), new StringField("jl_message")};
    Map joblogMap = this.createMap(this.joblogFields);
    DatabaseField[] jobdoneFields = new DatabaseField[]{new DateField("time"), new StringField("type"), new IntegerField("jd_job_number"), new IntegerField("jd_task_number"), new StringField("jd_pe_taskid")};
    Map jobdoneMap = this.createMap(this.jobdoneFields);

    public ReportingFileReader(String p_fileName, String p_delimiter) {
        super(p_fileName, p_delimiter, ReportingSource.REPORTING);
    }

    protected boolean parseLineType(String[] splitLine) {
        String type = splitLine[1];
        if (type.compareTo("acct") == 0) {
            this.setInfo(this.accountingFields, this.accountingMap, ReportingSource.ACCOUNTING);
        } else if (type.compareTo("host") == 0) {
            this.setInfo(this.hostFields, this.hostMap, ReportingSource.REP_HOST);
        } else if (type.compareTo("host_consumable") == 0) {
            this.setInfo(this.hostConsumableFields, this.hostConsumableMap, ReportingSource.REP_HOST_CONSUMABLE);
        } else if (type.compareTo("queue") == 0) {
            this.setInfo(this.queueFields, this.queueMap, ReportingSource.REP_QUEUE);
        } else if (type.compareTo("queue_consumable") == 0) {
            this.setInfo(this.queueConsumableFields, this.queueConsumableMap, ReportingSource.REP_QUEUE_CONSUMABLE);
        } else if (type.compareTo("sharelog") == 0) {
            this.setInfo(this.sharelogFields, this.sharelogMap, ReportingSource.SHARELOG);
        } else if (type.compareTo("new_job") == 0) {
            this.setInfo(this.newjobFields, this.newjobMap, ReportingSource.NEWJOB);
        } else if (type.compareTo("job_log") == 0) {
            this.setInfo(this.joblogFields, this.joblogMap, ReportingSource.JOBLOG);
        } else if (type.compareTo("job_done") == 0) {
            this.setInfo(this.jobdoneFields, this.jobdoneMap, ReportingSource.JOBDONE);
        } else {
            SGELog.warning("ReportingFileReader.invalidReportType", (Object)type);
        }
        return true;
    }
}

