/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.dbwriter.file;

import com.sun.grid.logging.SGELog;
import com.sun.grid.reporting.dbwriter.ReportingEventObject;
import com.sun.grid.reporting.dbwriter.ReportingException;
import com.sun.grid.reporting.dbwriter.db.Database;
import com.sun.grid.reporting.dbwriter.db.DatabaseField;
import com.sun.grid.reporting.dbwriter.file.NewObjectListener;
import com.sun.grid.reporting.dbwriter.file.ReportingSource;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;

public class ReportFileReader {
    public static final String CHECKPOINT_SUFFIX = ".checkpoint";
    private ReportingSource reportingSource;
    private List newObjectListeners = new ArrayList();
    private String fileName;
    private String delimiter;
    protected DatabaseField[] fields;
    protected Map fieldMap;
    private boolean stopProcessing;

    public ReportFileReader(String p_fileName, String p_delimiter, ReportingSource p_reportingSource) {
        this.fileName = p_fileName;
        this.delimiter = p_delimiter;
        this.reportingSource = p_reportingSource;
    }

    protected void setInfo(DatabaseField[] p_fields, Map p_fieldMap, ReportingSource p_source) {
        this.fields = p_fields;
        this.fieldMap = p_fieldMap;
        if (this.fieldMap == null) {
            this.fieldMap = this.createMap(this.fields);
        }
        this.reportingSource = p_source;
    }

    public void stop() {
        this.stopProcessing = true;
    }

    public boolean isStopped() {
        return this.stopProcessing;
    }

    protected Map createMap(DatabaseField[] fields) {
        HashMap<String, DatabaseField> map = new HashMap<String, DatabaseField>();
        for (int i = 0; i < fields.length; ++i) {
            map.put(fields[i].getName(), fields[i]);
        }
        return map;
    }

    public ReportingSource getReportingSource() {
        return this.reportingSource;
    }

    public void addNewObjectListener(NewObjectListener l) {
        if (!this.newObjectListeners.contains(l)) {
            this.newObjectListeners.add(l);
        }
    }

    public NewObjectListener[] getNewObjectListeners() {
        return (NewObjectListener[])this.newObjectListeners.toArray();
    }

    public void removeNewObjectListener(NewObjectListener l) {
        this.newObjectListeners.remove(l);
    }

    public void writeCheckpoint(String fileName, int checkpoint) {
        try {
            FileWriter fw = new FileWriter(fileName + CHECKPOINT_SUFFIX);
            PrintWriter pw = new PrintWriter(fw);
            pw.println(checkpoint);
            fw.flush();
            fw.close();
        }
        catch (IOException ioe) {
            SGELog.severe(ioe, "ReportFileReader.writeCheckpointError");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private int readCheckpoint(String fileName) {
        int checkpoint;
        block14: {
            File checkpointFile;
            block15: {
                checkpoint = -1;
                checkpointFile = new File(fileName + CHECKPOINT_SUFFIX);
                if (!checkpointFile.exists()) break block14;
                BufferedReader reader = ReportFileReader.getFileReader(checkpointFile);
                if (reader != null) {
                    String line = reader.readLine();
                    if (line != null && line.length() != 0) {
                        try {
                            checkpoint = Integer.parseInt(line);
                        }
                        catch (NumberFormatException e) {
                            SGELog.warning("ReportFileReader.invalidCheckpoint", (Object)line);
                            checkpoint = -1;
                        }
                    }
                    Object var8_8 = null;
                    try {
                        reader.close();
                    }
                    catch (IOException ce) {
                        SGELog.warning((Throwable)ce, "ReportFileReader.checkpointCloseError", (Object)ce.getMessage());
                    }
                    break block15;
                    {
                        catch (IOException e) {
                            SGELog.warning((Throwable)e, "ReportFileReader.checkpointIOError", (Object)e.getMessage());
                            checkpoint = -1;
                            Object var8_9 = null;
                            try {
                                reader.close();
                            }
                            catch (IOException ce) {
                                SGELog.warning((Throwable)ce, "ReportFileReader.checkpointCloseError", (Object)ce.getMessage());
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        Object var8_10 = null;
                        try {
                            reader.close();
                        }
                        catch (IOException ce) {
                            SGELog.warning((Throwable)ce, "ReportFileReader.checkpointCloseError", (Object)ce.getMessage());
                        }
                        throw throwable;
                    }
                }
            }
            if (!checkpointFile.delete()) {
                SGELog.warning("ReportFileReader.deleteCheckpointFileError", (Object)checkpointFile.getAbsolutePath());
            }
        }
        if (checkpoint == -1) {
            SGELog.warning("ReportFileReader.noCheckpointFound");
        }
        return checkpoint;
    }

    public void processFile(Database database) throws ReportingException {
        this.stopProcessing = false;
        File originalFile = new File(this.fileName);
        File workingFile = new File(this.fileName + ".processing");
        if (workingFile.exists()) {
            SGELog.warning("ReportFileReader.workingFileExists", (Object)workingFile.getName());
            int firstLine = this.readCheckpoint(this.fileName);
            if (firstLine >= 0) {
                this.parseFile(database, this.fileName, workingFile, firstLine);
            } else if (!workingFile.delete()) {
                SGELog.warning("ReportFileReader.workingFileDeleteError", (Object)workingFile.getName());
            }
        }
        if (!this.isStopped()) {
            if (!originalFile.exists()) {
                SGELog.config("ReportFileReader.orignalFileNotExists", (Object)originalFile.getName());
            } else {
                SGELog.info("ReportFileHeader.renameFile", (Object)originalFile.getName(), (Object)workingFile.getName());
                if (!originalFile.renameTo(workingFile)) {
                    SGELog.severe("ReportFileReader.renameError", (Object)originalFile.getName(), (Object)workingFile.getName());
                } else {
                    this.parseFile(database, this.fileName, workingFile, 0);
                }
            }
        }
    }

    public static BufferedReader getFileReader(File file) {
        BufferedReader reader;
        try {
            reader = new BufferedReader(new FileReader(file.toString()));
        }
        catch (FileNotFoundException e) {
            reader = null;
            SGELog.severe((Throwable)e, "ReportFileHeader.cantOpenFile", (Object)e.getMessage());
        }
        return reader;
    }

    private void parseFile(Database database, String fileName, File file, int firstLine) throws ReportingException {
        SGELog.fine("ReportFileHander.parseFile", (Object)file.getName());
        BufferedReader reader = ReportFileReader.getFileReader(file);
        if (reader != null) {
            int lineNumber = 0;
            long startTime = System.currentTimeMillis();
            boolean eofReached = false;
            Connection connection = database.getConnection();
            while (!this.isStopped() && !Thread.currentThread().isInterrupted()) {
                String line;
                try {
                    line = reader.readLine();
                }
                catch (InterruptedIOException iioe) {
                    SGELog.info("ReportFileHandler.interrupted");
                    break;
                }
                catch (IOException readException) {
                    SGELog.warning((Throwable)readException, "ReportFileReader.ioError", (Object)fileName, (Object)readException.getMessage());
                    break;
                }
                ++lineNumber;
                if (line == null) {
                    eofReached = true;
                    break;
                }
                if (lineNumber < firstLine || line.length() == 0 || line.charAt(0) == '#') continue;
                if (lineNumber % 100 == 0) {
                    SGELog.config("ReportFileReader.processLine", new Integer(lineNumber));
                }
                try {
                    this.parseLine(line, connection);
                    database.commit(connection);
                }
                catch (ReportingException e) {
                    SGELog.severe("ReportFileReader.errorInLine", new Integer(lineNumber), (Object)line);
                    database.rollback(connection);
                    if (this.isStopped()) break;
                    e.log();
                    break;
                }
            }
            database.release(connection);
            try {
                reader.close();
            }
            catch (IOException e) {
                SGELog.warning((Throwable)e, "ReportFileHander.closeError", (Object)fileName, (Object)e.getMessage());
            }
            if (eofReached) {
                SGELog.info("ReportFileReader.deleteFile", (Object)file.getName());
                if (!file.delete()) {
                    SGELog.severe("ReportFileReader.deleteFileFailed", (Object)file.getName());
                }
            } else if (lineNumber > 0) {
                Thread.currentThread();
                Thread.interrupted();
                this.writeCheckpoint(fileName, lineNumber);
            }
            if (SGELog.isLoggable(Level.INFO)) {
                double secs = (double)(System.currentTimeMillis() - startTime) / 1000.0;
                double speed = Math.abs(secs) > 1.0E-5 ? (double)lineNumber / secs : 0.0;
                SGELog.info("Processed {0} lines in {1,number,#.##}s ({2,number,#.##} lines/s)", new Integer(lineNumber), (Object)new Double(secs), (Object)new Double(speed));
            }
        }
    }

    protected boolean parseLine(String line, Connection connection) throws ReportingException {
        boolean ret = true;
        String[] splitLine = line.split(this.delimiter, -100);
        ret = this.parseLineType(splitLine);
        if (ret) {
            if (splitLine.length != this.fields.length) {
                SGELog.warning("ReportFileReader.invalidNumberOfFields", new Integer(splitLine.length), (Object)new Integer(this.fields.length));
                for (int i = 0; i < splitLine.length; ++i) {
                    SGELog.warning("ReportFileHeader.field", new Integer(i), (Object)splitLine[i]);
                }
                ret = false;
            } else {
                for (int i = 0; i < this.fields.length; ++i) {
                    this.fields[i].setValue(splitLine[i]);
                }
                ReportingEventObject e = new ReportingEventObject(this, this.reportingSource, this.fieldMap);
                for (int i = 0; i < this.newObjectListeners.size(); ++i) {
                    NewObjectListener listener = (NewObjectListener)this.newObjectListeners.get(i);
                    listener.handleNewObject(e, connection);
                }
            }
        }
        return ret;
    }

    protected boolean parseLineType(String[] splitLine) {
        return true;
    }
}

