/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.dbwriter.db;

import com.sun.grid.reporting.dbwriter.db.DatabaseField;
import java.sql.ResultSet;
import java.sql.SQLException;

public class IntegerField
extends DatabaseField {
    private int value = 0;
    private boolean parseDouble = false;

    public IntegerField(String p_name, boolean p_store, boolean p_parseDouble) {
        super(p_name, p_store);
        this.parseDouble = p_parseDouble;
    }

    public IntegerField(String p_name, boolean p_store) {
        super(p_name, p_store);
    }

    public IntegerField(String p_name) {
        super(p_name);
    }

    public void setValue(String newValue) {
        if (this.parseDouble) {
            this.setValue((int)Double.parseDouble(newValue));
        } else {
            this.setValue(Integer.parseInt(newValue));
        }
    }

    public void setValue(int newValue) {
        if (this.value != newValue) {
            this.value = newValue;
            this.changed = true;
        }
    }

    public int getValue() {
        return this.value;
    }

    public String toString() {
        return new String(this.getName() + ": " + this.getValueString(false));
    }

    public String getValueString(boolean quote) {
        return String.valueOf(this.value);
    }

    public void setValue(DatabaseField newValue) {
        IntegerField field = (IntegerField)newValue;
        this.setValue(field.getValue());
    }

    public void setValueFromResultSet(ResultSet rs, String attrib) throws SQLException {
        this.setValue(rs.getInt(attrib));
    }
}

