/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.dbwriter.db;

import com.sun.grid.logging.SGELog;
import com.sun.grid.reporting.dbwriter.ReportingException;
import com.sun.grid.reporting.dbwriter.db.Database;
import com.sun.grid.reporting.dbwriter.db.DatabaseObject;
import com.sun.grid.reporting.dbwriter.db.DatabaseObjectCache;
import com.sun.grid.reporting.dbwriter.db.DatabaseObjectManager;
import java.sql.Connection;
import java.sql.Statement;

public class DatabaseStoredObjectManager
extends DatabaseObjectManager {
    protected String condition;
    protected String[] primaryKeyFields;
    protected DatabaseObjectCache storedObjects;

    public DatabaseStoredObjectManager(Database p_database, String p_table, String p_prefix, boolean hasParent, String[] p_primaryKey, DatabaseObject p_template, String p_condition) throws ReportingException {
        super(p_database, p_table, p_prefix, hasParent, p_template);
        this.condition = p_condition;
        this.primaryKeyFields = p_primaryKey;
        this.storedObjects = new DatabaseObjectCache(this);
    }

    public String getCondition() {
        return this.condition;
    }

    public String[] getPrimaryKeyFields() {
        return this.primaryKeyFields;
    }

    public DatabaseObject getObject(String[] key, Connection connection) throws ReportingException {
        return this.storedObjects.getObject(key, connection);
    }

    public Statement queryAllObjects(Connection connection) throws ReportingException {
        StringBuffer sql = new StringBuffer("SELECT * FROM ");
        sql.append(this.getTable());
        return this.database.executeQuery(sql.toString(), connection);
    }

    public void store(DatabaseObject obj, Connection connection) throws ReportingException {
        String[] key = obj.getPrimaryKey();
        if (key == null) {
            SGELog.warning("DatabaseStoredObjectManager.primaryKeyError");
        } else {
            String lkey = DatabaseObjectCache.buildLookupKey(key);
            SGELog.fine("DatabaseStoredObjectManager.store", (Object)lkey);
            if (this.storedObjects.getObject(key, connection) == null) {
                super.store(obj, connection);
                this.storedObjects.addObject(obj, key);
            }
        }
    }
}

