/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.dbwriter.db;

import com.sun.grid.reporting.dbwriter.ReportingException;
import com.sun.grid.reporting.dbwriter.db.Database;
import com.sun.grid.reporting.dbwriter.db.DatabaseObject;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class DatabaseObjectManager {
    protected Database database;
    protected DatabaseObject template;
    protected String table;
    protected String prefix;
    protected String idFieldName;
    protected String parentFieldName;
    protected int lastId = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DatabaseObjectManager(Database p_database, String p_table, String p_prefix, boolean hasParent, DatabaseObject p_template) throws ReportingException {
        this.database = p_database;
        this.table = p_table;
        this.prefix = p_prefix;
        this.idFieldName = new String(this.prefix + "id");
        if (hasParent) {
            this.parentFieldName = new String(this.prefix + "parent");
        }
        this.template = p_template;
        Connection conn = this.database.getConnection();
        try {
            this.readLastId(conn);
        }
        finally {
            this.database.release(conn);
        }
    }

    public Database getDatabase() {
        return this.database;
    }

    public String getTable() {
        return this.table;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getIdFieldName() {
        return this.idFieldName;
    }

    public String getParentFieldName() {
        return this.parentFieldName;
    }

    public DatabaseObject getTemplate() {
        return this.template;
    }

    public String[] getPrimaryKeyFields() {
        return null;
    }

    public DatabaseObject getObject(String[] key, Connection connection) throws ReportingException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readLastId(Connection connection) throws ReportingException {
        try {
            StringBuffer cmd = new StringBuffer("SELECT MAX(");
            cmd.append(this.idFieldName);
            cmd.append(") AS max FROM ");
            cmd.append(this.table);
            Statement stmt = this.database.executeQuery(cmd.toString(), connection);
            try {
                ResultSet rs = stmt.getResultSet();
                try {
                    if (rs.next()) {
                        this.lastId = rs.getInt("max");
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                stmt.close();
            }
        }
        catch (SQLException e) {
            ReportingException re = new ReportingException("DatabaseObjectManager.readLastIdError", e.getMessage());
            re.initCause(e);
            throw re;
        }
    }

    public DatabaseObject newObject() throws InstantiationException, IllegalAccessException {
        return this.template.newObject(this);
    }

    public void store(DatabaseObject obj, Connection connection) throws ReportingException {
        obj.setId(++this.lastId);
        obj.insertInDatabase(connection);
    }

    public void execute(String sql, Connection connection) throws ReportingException {
        this.database.execute(sql, connection);
    }

    public Statement executeQuery(String sql, Connection connection) throws ReportingException {
        return this.database.executeQuery(sql, connection);
    }

    public Statement queryAllObjects(Connection connection) throws ReportingException {
        return null;
    }
}

