/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.dbwriter.db;

import com.sun.grid.logging.SGELog;
import com.sun.grid.reporting.dbwriter.ReportingException;
import com.sun.grid.reporting.dbwriter.db.DatabaseObject;
import com.sun.grid.reporting.dbwriter.db.DatabaseStoredObjectManager;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DatabaseObjectCache {
    public static final int MAX_CACHE_SIZE = 1000;
    DatabaseStoredObjectManager manager;
    private Object syncObj = new Object();
    protected ArrayList store;
    protected Map storeMap;
    private static List instances = new ArrayList();

    public DatabaseObjectCache(DatabaseStoredObjectManager p_manager) {
        this.manager = p_manager;
        this.store = new ArrayList();
        this.storeMap = new HashMap();
        instances.add(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearAllCaches() {
        SGELog.info("clear all caches");
        List list = instances;
        synchronized (list) {
            Iterator iter = instances.iterator();
            while (iter.hasNext()) {
                ((DatabaseObjectCache)iter.next()).clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.syncObj;
        synchronized (object) {
            this.store.clear();
            this.storeMap.clear();
        }
    }

    public static String buildLookupKey(String[] key) {
        StringBuffer lkey = new StringBuffer();
        for (int i = 0; i < key.length; ++i) {
            if (i > 0) {
                lkey.append(":");
            }
            if (key[i] == null) continue;
            lkey.append(key[i]);
        }
        return lkey.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatabaseObject getObjectFromCache(String[] key) {
        String lookupKey = DatabaseObjectCache.buildLookupKey(key);
        Object object = this.syncObj;
        synchronized (object) {
            return (DatabaseObject)this.storeMap.get(lookupKey);
        }
    }

    public DatabaseObject getObject(String[] key, Connection connection) throws ReportingException {
        DatabaseObject obj = this.getObjectFromCache(key);
        if (obj == null) {
            obj = this.readObject(key, connection);
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObject(DatabaseObject obj, String[] key) {
        String lookupKey = DatabaseObjectCache.buildLookupKey(key);
        Object object = this.syncObj;
        synchronized (object) {
            if (!this.storeMap.containsKey(lookupKey)) {
                this.store.add(obj);
                this.storeMap.put(lookupKey, obj);
                if (this.store.size() > 1000) {
                    DatabaseObject toDelete = (DatabaseObject)this.store.remove(0);
                    lookupKey = DatabaseObjectCache.buildLookupKey(toDelete.getPrimaryKey());
                    this.storeMap.remove(lookupKey);
                    SGELog.fine("DatabaseObjectCache.removeObject", (Object)lookupKey);
                }
            }
        }
        SGELog.fine("DatabaseObjectCache.addObject", new Integer(obj.getId()), (Object)lookupKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DatabaseObject readObject(String[] key, Connection connection) throws ReportingException {
        DatabaseObject obj = null;
        try {
            StringBuffer cmd = new StringBuffer("SELECT * FROM ");
            cmd.append(this.manager.getTable());
            cmd.append(" WHERE ");
            String[] keyFields = this.manager.getPrimaryKeyFields();
            if (key.length != keyFields.length) {
                return null;
            }
            for (int i = 0; i < keyFields.length; ++i) {
                if (key[i] == null) continue;
                if (i > 0) {
                    cmd.append(" AND ");
                }
                cmd.append(keyFields[i]);
                cmd.append(" = ");
                cmd.append(key[i]);
            }
            String condition = this.manager.getCondition();
            if (condition != null) {
                cmd.append(" AND ");
                cmd.append(condition);
            }
            Statement stmt = this.manager.getDatabase().executeQuery(cmd.toString(), connection);
            try {
                ResultSet rs = stmt.getResultSet();
                try {
                    if (rs.getFetchSize() > 1) {
                        // empty if block
                    }
                    if (rs.next()) {
                        obj = this.manager.newObject();
                        obj.initFromResultSet(rs);
                        this.addObject(obj, obj.getPrimaryKey());
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                stmt.close();
            }
        }
        catch (Exception e) {
            ReportingException re = new ReportingException("DatabaseObjectCache.readObjectFailed", e.getMessage());
            re.initCause(e);
            throw re;
        }
        return obj;
    }
}

