/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.dbwriter.db;

import com.sun.grid.logging.SGELog;
import com.sun.grid.reporting.dbwriter.ReportingException;
import com.sun.grid.reporting.dbwriter.db.DatabaseField;
import com.sun.grid.reporting.dbwriter.db.DatabaseObjectManager;
import com.sun.grid.reporting.dbwriter.db.IntegerField;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public abstract class DatabaseObject {
    protected DatabaseObjectManager manager;
    protected IntegerField idField;
    protected IntegerField parentField;
    protected DatabaseField[] fields;
    protected Map fieldsHash;

    public DatabaseObject(DatabaseObjectManager p_manager) {
        this.manager = p_manager;
        if (this.manager != null) {
            this.idField = new IntegerField(this.manager.getIdFieldName());
            String parentFieldName = this.manager.getParentFieldName();
            if (parentFieldName != null) {
                this.parentField = new IntegerField(parentFieldName);
            }
        }
    }

    protected void setFields(DatabaseField[] p_fields) {
        this.fields = p_fields;
        this.fieldsHash = new HashMap();
        for (int i = 0; i < this.fields.length; ++i) {
            this.fieldsHash.put(this.fields[i].getName(), this.fields[i]);
        }
    }

    public void setId(int id) {
        this.idField.setValue(id);
    }

    public int getId() {
        return this.idField.getValue();
    }

    public void setParent(int id) {
        if (this.parentField != null) {
            this.parentField.setValue(id);
        }
    }

    public int getParent() {
        int ret = 0;
        if (this.parentField != null) {
            ret = this.parentField.getValue();
        }
        return ret;
    }

    public DatabaseField getField(String name) {
        return (DatabaseField)this.fieldsHash.get(name);
    }

    public String[] getPrimaryKey() {
        String[] primaryKeyFields = this.manager.getPrimaryKeyFields();
        if (primaryKeyFields == null) {
            return null;
        }
        String[] key = new String[primaryKeyFields.length];
        for (int i = 0; i < primaryKeyFields.length; ++i) {
            key[i] = this.getField(primaryKeyFields[i]).getValueString(true);
        }
        return key;
    }

    public boolean initFromStringArray(Map data) {
        for (int i = 0; i < this.fields.length; ++i) {
            DatabaseField newField = (DatabaseField)data.get(this.fields[i].getName());
            if (newField == null) continue;
            try {
                this.fields[i].setValue(newField);
                continue;
            }
            catch (Exception e) {
                SGELog.warning((Throwable)e, "DatabaseObject.fieldError", (Object)this.fields[i].getName(), (Object)newField.getValueString(false), (Object)e.getMessage());
            }
        }
        return true;
    }

    public void initFromResultSet(ResultSet rs) throws SQLException {
        this.idField.setValueFromResultSet(rs);
        for (int i = 0; i < this.fields.length; ++i) {
            this.fields[i].setValueFromResultSet(rs);
        }
    }

    public void initFromResultSet(ResultSet rs, Map map) throws SQLException {
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            String objKey = (String)iter.next();
            String dataKey = (String)map.get(objKey);
            DatabaseField objField = this.getField(objKey);
            objField.setValueFromResultSet(rs, dataKey);
        }
    }

    public void store(Connection connection) throws ReportingException {
        this.manager.store(this, connection);
    }

    public void insertInDatabase(Connection connection) throws ReportingException {
        StringBuffer cmdFields = new StringBuffer(this.idField.getName());
        StringBuffer cmdValues = new StringBuffer(this.idField.getValueString(true));
        if (this.parentField != null) {
            cmdFields.append(", ");
            cmdValues.append(", ");
            cmdFields.append(this.parentField.getName());
            cmdValues.append(this.parentField.getValueString(true));
        }
        for (int i = 0; i < this.fields.length; ++i) {
            if (!this.fields[i].doStore()) continue;
            cmdFields.append(", ");
            cmdValues.append(", ");
            cmdFields.append(this.fields[i].getName());
            cmdValues.append(this.fields[i].getValueString(true));
        }
        StringBuffer cmd = new StringBuffer("INSERT INTO ");
        cmd.append(this.manager.getTable());
        cmd.append(" (");
        cmd.append(cmdFields);
        cmd.append(") VALUES (");
        cmd.append(cmdValues);
        cmd.append(")");
        this.manager.getDatabase().execute(cmd.toString(), connection);
    }

    public abstract DatabaseObject newObject(DatabaseObjectManager var1);
}

