/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.dbwriter.db;

import com.sun.grid.logging.SGELog;
import com.sun.grid.reporting.dbwriter.ReportingException;
import com.sun.grid.reporting.dbwriter.db.DatabaseObjectCache;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;

public class Database {
    public static final int TYPE_POSTGRES = 1;
    public static final int TYPE_ORACLE = 2;
    public static final int DEFAULT_MAX_CONNECTIONS = 2;
    public static final int UNKNOWN_ERROR = 0;
    public static final int NO_CONNECTION_ERROR = 1;
    public static final int SYNTAX_ERROR = 2;
    protected String driver;
    protected String url;
    protected String userName;
    protected String userPW;
    protected ErrorHandler errorHandler;
    protected int type;
    private ArrayList usedConnections = new ArrayList();
    private ArrayList unusedConnections = new ArrayList();
    private int maxConnections = 2;

    public Database(String p_driver, String p_url, String p_userName, String p_userPW) throws ReportingException {
        this.driver = p_driver;
        this.url = p_url;
        this.userName = p_userName;
        this.userPW = p_userPW;
        this.type = Database.getDatabaseTypeFromURL(p_url);
        try {
            SGELog.fine("register jdbc driver ''{0}''", (Object)this.driver);
            Class.forName(this.driver);
        }
        catch (ClassNotFoundException e) {
            throw new ReportingException("Database.driverNotFound", this.driver);
        }
        if (this.driver.equals("org.postgresql.Driver")) {
            this.errorHandler = new PostgresErrorHandler();
        }
    }

    public static int getDatabaseTypeFromURL(String url) throws ReportingException {
        if ((url = url.toLowerCase()).startsWith("jdbc:oracle")) {
            return 2;
        }
        if (url.startsWith("jdbc:postgres")) {
            return 1;
        }
        throw new ReportingException("Database.unsupportedURL", url);
    }

    public int getType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean test() throws ReportingException {
        Connection conn = this.getConnection();
        try {
            Statement stmt = this.executeQuery("select count(*) from sge_host", conn);
            try {
                stmt.close();
            }
            catch (SQLException sqe) {
                boolean bl = false;
                this.release(conn);
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (ReportingException re) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.release(conn);
        }
    }

    private ReportingException createSQLError(String message, Object[] args, SQLException sqle, Connection connection) {
        if (connection != null && this.getErrorType(sqle) != 2) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                ReportingException re = new ReportingException("Database.closeFailed");
                re.initCause(e);
                re.log();
            }
        }
        ReportingException re = new ReportingException(message, args);
        re.initCause(sqle);
        return re;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection getConnection() throws ReportingException {
        Connection ret = null;
        ArrayList arrayList = this.usedConnections;
        synchronized (arrayList) {
            while (this.unusedConnections.isEmpty()) {
                if (this.getConnectionCount() >= this.maxConnections) {
                    try {
                        SGELog.fine("All connections in use, thread {0} is waiting for the next free connection", (Object)Thread.currentThread().getName());
                        this.usedConnections.wait();
                        continue;
                    }
                    catch (InterruptedException ire) {
                        throw new ReportingException("interrupted");
                    }
                }
                try {
                    SGELog.fine("opening connection to ''{0}'' as user ''{1}''", (Object)this.url, (Object)this.userName);
                    Connection connection = DriverManager.getConnection(this.url, this.userName, this.userPW);
                    ConnectionProxy proxy = new ConnectionProxy(connection, this.getConnectionCount() + 1);
                    SGELog.fine("connection {0} opened", proxy);
                    this.unusedConnections.add(proxy);
                }
                catch (SQLException e) {
                    throw this.createSQLError("Database.connectError", new Object[]{this.url, e.getMessage()}, e, null);
                }
            }
            ret = (Connection)this.unusedConnections.remove(0);
            this.usedConnections.add(ret);
        }
        SGELog.fine("Thread {0} gots connection {1}", (Object)Thread.currentThread().getName(), (Object)ret);
        return ret;
    }

    public int getConnectionCount() {
        return this.usedConnections.size() + this.unusedConnections.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(Connection connection) throws ReportingException {
        SGELog.fine("Thread {0} releases {1}", (Object)Thread.currentThread().getName(), (Object)connection);
        ArrayList arrayList = this.usedConnections;
        synchronized (arrayList) {
            this.usedConnections.remove(connection);
            if (!((ConnectionProxy)connection).getIsClosedFlag()) {
                this.unusedConnections.add(connection);
            }
            this.usedConnections.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAll() {
        ArrayList arrayList = this.usedConnections;
        synchronized (arrayList) {
            Iterator iter = this.usedConnections.iterator();
            while (iter.hasNext()) {
                try {
                    ((Connection)iter.next()).close();
                }
                catch (SQLException sqle) {
                    this.createSQLError("Database.closeFailed", null, sqle, null).log();
                }
            }
            iter = this.unusedConnections.iterator();
            while (iter.hasNext()) {
                try {
                    ((Connection)iter.next()).close();
                }
                catch (SQLException sqle) {
                    this.createSQLError("Database.closeFailed", null, sqle, null).log();
                }
            }
            this.usedConnections.clear();
            this.unusedConnections.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(String sql, Connection connection) throws ReportingException {
        try {
            Statement stmt = connection.createStatement();
            try {
                SGELog.fine("Database.sql", (Object)sql);
                stmt.execute(sql);
            }
            finally {
                stmt.close();
            }
        }
        catch (SQLException sqle) {
            throw this.createSQLError("Database.sqlError", new Object[]{sql}, sqle, connection);
        }
    }

    public Statement executeQuery(String sql, Connection connection) throws ReportingException {
        try {
            Statement stmt = connection.createStatement();
            SGELog.fine("Database.sql", (Object)sql);
            stmt.executeQuery(sql);
            return stmt;
        }
        catch (SQLException sqle) {
            throw this.createSQLError("Database.sqlError", new Object[]{sql}, sqle, connection);
        }
    }

    public String getUrl() {
        return this.url;
    }

    public int getErrorType(SQLException sqle) {
        if (this.errorHandler != null) {
            return this.errorHandler.getErrorType(sqle);
        }
        return 0;
    }

    public void commit(Connection connection) throws ReportingException {
        try {
            SGELog.fine("commit {0}", connection);
            connection.commit();
        }
        catch (SQLException sqle) {
            throw this.createSQLError("Database.commitFailed", null, sqle, connection);
        }
    }

    public void rollback(Connection connection) {
        if (connection != null) {
            DatabaseObjectCache.clearAllCaches();
            try {
                SGELog.fine("rollback {0}", connection);
                connection.rollback();
            }
            catch (SQLException sqle) {
                this.createSQLError("Database.rollbackFailed", null, sqle, connection).log();
            }
        }
    }

    private class ConnectionProxy
    implements Connection {
        private Connection realConnection;
        private int id;
        private boolean isClosed;

        public ConnectionProxy(Connection connection, int id) {
            this.realConnection = connection;
        }

        public int getId() {
            return this.id;
        }

        public String toString() {
            return "Connection " + this.id + " (" + Database.this.userName + "@" + Database.this.url + ")";
        }

        public void clearWarnings() throws SQLException {
            this.realConnection.clearWarnings();
        }

        public void close() throws SQLException {
            this.isClosed = true;
            this.realConnection.close();
        }

        public void commit() throws SQLException {
            this.realConnection.commit();
        }

        public Statement createStatement() throws SQLException {
            return this.realConnection.createStatement();
        }

        public Statement createStatement(int param, int param1) throws SQLException {
            return this.realConnection.createStatement(param, param1);
        }

        public Statement createStatement(int param, int param1, int param2) throws SQLException {
            return this.realConnection.createStatement(param, param1, param2);
        }

        public boolean getAutoCommit() throws SQLException {
            return this.realConnection.getAutoCommit();
        }

        public String getCatalog() throws SQLException {
            return this.realConnection.getCatalog();
        }

        public int getHoldability() throws SQLException {
            return this.realConnection.getHoldability();
        }

        public DatabaseMetaData getMetaData() throws SQLException {
            return this.realConnection.getMetaData();
        }

        public int getTransactionIsolation() throws SQLException {
            return this.realConnection.getTransactionIsolation();
        }

        public Map getTypeMap() throws SQLException {
            return this.realConnection.getTypeMap();
        }

        public SQLWarning getWarnings() throws SQLException {
            return this.realConnection.getWarnings();
        }

        public boolean isClosed() throws SQLException {
            if (!this.isClosed) {
                this.isClosed = this.realConnection.isClosed();
            }
            return this.isClosed;
        }

        public boolean getIsClosedFlag() {
            return this.isClosed;
        }

        public boolean isReadOnly() throws SQLException {
            return this.realConnection.isReadOnly();
        }

        public String nativeSQL(String str) throws SQLException {
            return this.realConnection.nativeSQL(str);
        }

        public CallableStatement prepareCall(String str) throws SQLException {
            return this.realConnection.prepareCall(str);
        }

        public CallableStatement prepareCall(String str, int param, int param2) throws SQLException {
            return this.realConnection.prepareCall(str, param, param2);
        }

        public CallableStatement prepareCall(String str, int param, int param2, int param3) throws SQLException {
            return this.realConnection.prepareCall(str, param, param2, param3);
        }

        public PreparedStatement prepareStatement(String str) throws SQLException {
            return this.realConnection.prepareStatement(str);
        }

        public PreparedStatement prepareStatement(String str, String[] str1) throws SQLException {
            return this.realConnection.prepareStatement(str, str1);
        }

        public PreparedStatement prepareStatement(String str, int param) throws SQLException {
            return this.realConnection.prepareStatement(str, param);
        }

        public PreparedStatement prepareStatement(String str, int[] values) throws SQLException {
            return this.realConnection.prepareStatement(str, values);
        }

        public PreparedStatement prepareStatement(String str, int param, int param2) throws SQLException {
            return this.realConnection.prepareStatement(str, param, param2);
        }

        public PreparedStatement prepareStatement(String str, int param, int param2, int param3) throws SQLException {
            return this.realConnection.prepareStatement(str, param, param2, param3);
        }

        public void releaseSavepoint(Savepoint savepoint) throws SQLException {
            this.realConnection.releaseSavepoint(savepoint);
        }

        public void rollback() throws SQLException {
            this.realConnection.rollback();
        }

        public void rollback(Savepoint savepoint) throws SQLException {
            this.realConnection.rollback(savepoint);
        }

        public void setAutoCommit(boolean param) throws SQLException {
            this.realConnection.setAutoCommit(param);
        }

        public void setCatalog(String str) throws SQLException {
            this.realConnection.setCatalog(str);
        }

        public void setHoldability(int param) throws SQLException {
            this.realConnection.setHoldability(param);
        }

        public void setReadOnly(boolean param) throws SQLException {
            this.realConnection.setReadOnly(param);
        }

        public Savepoint setSavepoint() throws SQLException {
            return this.realConnection.setSavepoint();
        }

        public Savepoint setSavepoint(String str) throws SQLException {
            return this.realConnection.setSavepoint(str);
        }

        public void setTransactionIsolation(int param) throws SQLException {
            this.realConnection.setTransactionIsolation(param);
        }

        public void setTypeMap(Map map) throws SQLException {
            this.realConnection.setTypeMap(map);
        }
    }

    static class PostgresErrorHandler
    implements ErrorHandler {
        PostgresErrorHandler() {
        }

        public int getErrorType(SQLException sqle) {
            String state = sqle.getSQLState();
            if (state == null) {
                return 0;
            }
            if (state.startsWith("44")) {
                return 1;
            }
            if (state.startsWith("42")) {
                return 2;
            }
            return 0;
        }
    }

    static interface ErrorHandler {
        public int getErrorType(SQLException var1);
    }
}

