/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.dbwriter;

import com.sun.grid.logging.SGELog;
import com.sun.grid.reporting.dbwriter.ReportingException;
import com.sun.grid.reporting.dbwriter.ReportingObjectManager;
import com.sun.grid.reporting.dbwriter.db.Database;
import com.sun.grid.reporting.dbwriter.db.DatabaseObject;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class ReportingValueManager
extends ReportingObjectManager {
    protected Map derivedMap = new HashMap();
    protected String derivedVariableField = null;

    public ReportingValueManager(Database p_database, String p_table, String p_prefix, boolean hasParent, DatabaseObject p_template) throws ReportingException {
        super(p_database, p_table, p_prefix, hasParent, p_template);
        this.derivedMap.put(new String(p_prefix + "time_start"), "time_start");
        this.derivedMap.put(new String(p_prefix + "time_end"), "time_end");
        this.derivedMap.put(new String(p_prefix + "dvalue"), "value");
        this.derivedVariableField = new String(p_prefix + "variable");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Timestamp getLastEntryTime(int parent, String variableName, Connection connection) throws ReportingException {
        Timestamp result = null;
        StringBuffer cmd = new StringBuffer("SELECT ");
        cmd.append("max(");
        cmd.append(this.databaseObjectManager.getPrefix());
        cmd.append("time_end) AS max FROM ");
        cmd.append(this.databaseObjectManager.getTable());
        cmd.append(" WHERE ");
        cmd.append(this.databaseObjectManager.getParentFieldName());
        cmd.append(" = ");
        cmd.append(parent);
        cmd.append(" AND ");
        cmd.append(this.databaseObjectManager.getPrefix());
        cmd.append("variable = '");
        cmd.append(variableName);
        cmd.append("'");
        SGELog.fine(cmd.toString());
        try {
            Statement stmt = this.databaseObjectManager.executeQuery(cmd.toString(), connection);
            try {
                ResultSet rs = stmt.getResultSet();
                try {
                    if (rs.next()) {
                        result = rs.getTimestamp("max");
                    }
                }
                finally {
                    rs.close();
                }
            }
            finally {
                stmt.close();
            }
        }
        catch (SQLException e) {
            ReportingException re = new ReportingException("ReportingValueManager.sqlError", e.getMessage());
            re.initCause(e);
            throw re;
        }
        if (result == null) {
            result = new Timestamp(0L);
        }
        return result;
    }

    public void handleNewDerivedObject(DatabaseObject parent, String variable, ResultSet rs, Connection connection) {
        try {
            DatabaseObject obj = this.databaseObjectManager.newObject();
            obj.setParent(parent.getId());
            obj.getField(this.derivedVariableField).setValue(variable);
            obj.initFromResultSet(rs, this.derivedMap);
            obj.store(connection);
        }
        catch (Exception e) {
            SGELog.warning((Throwable)e, "ReportingValueManager.createDBObjectError", (Object)e.getMessage());
        }
    }

    public String[] getDeleteRuleSQL(String time_range, int time_amount, List values) {
        Timestamp time = ReportingValueManager.getDeleteTimeEnd(time_range, time_amount);
        StringBuffer sql = new StringBuffer("DELETE FROM ");
        sql.append(this.databaseObjectManager.getTable());
        sql.append(" WHERE ");
        sql.append(this.databaseObjectManager.getPrefix());
        sql.append("time_end < '");
        sql.append(time.toString());
        sql.append("'");
        if (values != null && !values.isEmpty()) {
            sql.append(" AND ");
            sql.append(this.databaseObjectManager.getPrefix());
            sql.append("variable IN (");
            for (int i = 0; i < values.size(); ++i) {
                if (i > 0) {
                    sql.append(", ");
                }
                sql.append("'");
                sql.append(values.get(i));
                sql.append("'");
            }
            sql.append(")");
        }
        String[] result = new String[]{sql.toString()};
        return result;
    }
}

