/*
 * Decompiled with CFR 0.152.
 */
package com.sun.grid.reporting.dbwriter;

import com.sun.grid.logging.SGELog;
import com.sun.grid.reporting.dbwriter.ReportingEventObject;
import com.sun.grid.reporting.dbwriter.ReportingException;
import com.sun.grid.reporting.dbwriter.ReportingObjectManager;
import com.sun.grid.reporting.dbwriter.ReportingValueManager;
import com.sun.grid.reporting.dbwriter.db.Database;
import com.sun.grid.reporting.dbwriter.db.DatabaseField;
import com.sun.grid.reporting.dbwriter.db.DatabaseObject;
import com.sun.grid.reporting.dbwriter.db.DatabaseObjectManager;
import com.sun.grid.reporting.dbwriter.db.DatabaseStoredObjectManager;
import com.sun.grid.reporting.dbwriter.model.DeriveRuleType;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Map;

public abstract class ReportingStoredObjectManager
extends ReportingObjectManager {
    protected ReportingValueManager valueManager = null;

    public ReportingStoredObjectManager(Database p_database, String p_table, String p_prefix, boolean hasParent, String[] p_primaryKey, DatabaseObject p_template, String p_condition) throws ReportingException {
        super(new DatabaseStoredObjectManager(p_database, p_table, p_prefix, hasParent, p_primaryKey, p_template, p_condition));
    }

    public void handleNewObject(ReportingEventObject e, Connection connection) throws ReportingException {
        DatabaseObject obj = this.findObject(e, connection);
        if (obj == null) {
            super.handleNewObject(e, connection);
        } else {
            this.initSubObjectsFromEvent(obj, e, connection);
        }
    }

    public DatabaseObject findObjectFromEventData(Map data, Map map, Connection connection) throws ReportingException {
        DatabaseObject obj = null;
        String[] keyFields = this.databaseObjectManager.getPrimaryKeyFields();
        String[] key = new String[keyFields.length];
        for (int i = 0; i < keyFields.length; ++i) {
            String fieldName = (String)map.get(keyFields[i]);
            if (fieldName == null || fieldName.length() == 0) {
                SGELog.warning("ReportingStoredObjectManager.dataForField", (Object)keyFields[i]);
                key = null;
                break;
            }
            DatabaseField field = (DatabaseField)data.get(fieldName);
            if (field == null) {
                SGELog.warning("ReportingStoredObjectManager.fieldNotFound", (Object)fieldName);
                key = null;
                break;
            }
            key[i] = field.getValueString(true);
        }
        if (key != null) {
            obj = this.databaseObjectManager.getObject(key, connection);
        }
        return obj;
    }

    private String createAutoSQL(String interval, String function, String sourceVariable) {
        int dbType = this.valueManager.getDatabaseObjectManager().getDatabase().getType();
        switch (dbType) {
            case 2: {
                return this.createAutoSQLOracle(interval, function, sourceVariable);
            }
            case 1: {
                return this.createAutoSQLPostgres(interval, function, sourceVariable);
            }
        }
        throw new IllegalStateException("DB Type " + dbType + " is not supported");
    }

    private String createAutoSQLOracle(String interval, String function, String sourceVariable) {
        DatabaseObjectManager dbManager = this.valueManager.getDatabaseObjectManager();
        DatabaseObjectManager dbParent = this.getDatabaseObjectManager();
        StringBuffer sql = new StringBuffer();
        String time_startField = dbManager.getPrefix() + "time_start";
        String time_endField = dbManager.getPrefix() + "time_end";
        String table = dbManager.getTable();
        String variableField = dbManager.getPrefix() + "variable";
        String valueField = dbManager.getPrefix() + "dvalue";
        String parentField = dbManager.getParentFieldName();
        String parentTable = dbParent.getTable();
        String parentIdField = dbParent.getIdFieldName();
        String[] parentKeys = dbParent.getPrimaryKeyFields();
        String truncInterval = interval.equalsIgnoreCase("hour") ? "'HH24'" : '\'' + interval + '\'';
        sql.append("SELECT  time_start, time_end, ");
        sql.append(function);
        sql.append("(");
        sql.append(valueField);
        sql.append(")");
        sql.append(" FROM ( ");
        sql.append("SELECT ");
        sql.append("TRUNC( ");
        sql.append(time_startField);
        sql.append(", ");
        sql.append(truncInterval);
        sql.append(" ) as time_start, ");
        sql.append("TRUNC( ");
        sql.append(time_startField);
        sql.append(", ");
        sql.append(truncInterval);
        sql.append(" ) + INTERVAL '1' ");
        sql.append(interval);
        sql.append(" as time_end, ");
        sql.append(valueField);
        sql.append(" FROM ");
        sql.append(table);
        sql.append(" WHERE ");
        sql.append(variableField);
        sql.append(" = '");
        sql.append(sourceVariable);
        sql.append("' AND ");
        sql.append(parentField);
        sql.append(" = (SELECT ");
        sql.append(parentIdField);
        sql.append(" FROM ");
        sql.append(parentTable);
        sql.append(" WHERE ");
        for (int i = 0; i < parentKeys.length; ++i) {
            sql.append(parentKeys[i]);
            sql.append(" = __key_");
            sql.append(i);
            sql.append("__) AND ");
        }
        sql.append(time_startField);
        sql.append(" <= {ts '__time_end__'} AND ");
        sql.append(time_endField);
        sql.append(" > {ts '__time_start__'}");
        sql.append(" ) ");
        sql.append("GROUP BY time_start, time_end");
        return sql.toString();
    }

    private String createAutoSQLPostgres(String interval, String function, String sourceVariable) {
        DatabaseObjectManager dbManager = this.valueManager.getDatabaseObjectManager();
        DatabaseObjectManager dbParent = this.getDatabaseObjectManager();
        StringBuffer sql = new StringBuffer();
        String time_startField = dbManager.getPrefix() + "time_start";
        String time_endField = dbManager.getPrefix() + "time_end";
        String table = dbManager.getTable();
        String variableField = dbManager.getPrefix() + "variable";
        String valueField = dbManager.getPrefix() + "dvalue";
        String parentField = dbManager.getParentFieldName();
        String parentTable = dbParent.getTable();
        String parentIdField = dbParent.getIdFieldName();
        String[] parentKeys = dbParent.getPrimaryKeyFields();
        sql.append("SELECT DATE_TRUNC('");
        sql.append(interval);
        sql.append("', ");
        sql.append(time_startField);
        sql.append(") AS time_start, DATE_TRUNC('");
        sql.append(interval);
        sql.append("', ");
        sql.append(time_startField);
        sql.append(") + INTERVAL '1 ");
        sql.append(interval);
        sql.append("' AS time_end, ");
        sql.append(function);
        sql.append("(");
        sql.append(valueField);
        sql.append(") AS value FROM ");
        sql.append(table);
        sql.append(" WHERE ");
        sql.append(variableField);
        sql.append(" = '");
        sql.append(sourceVariable);
        sql.append("' AND ");
        sql.append(parentField);
        sql.append(" = (SELECT ");
        sql.append(parentIdField);
        sql.append(" FROM ");
        sql.append(parentTable);
        sql.append(" WHERE ");
        for (int i = 0; i < parentKeys.length; ++i) {
            sql.append(parentKeys[i]);
            sql.append(" = __key_");
            sql.append(i);
            sql.append("__) AND ");
        }
        sql.append(time_startField);
        sql.append(" <= {ts '__time_end__'} AND ");
        sql.append(time_endField);
        sql.append(" > {ts '__time_start__'} GROUP BY time_start");
        return sql.toString();
    }

    public void calculateDerivedValues(DeriveRuleType rule, Connection connection) throws ReportingException {
        String sourceVariable;
        DeriveRuleType.AutoType auto;
        String function;
        String sql;
        String interval = rule.getInterval();
        String targetVariable = rule.getVariable();
        if (rule.isSetSql()) {
            this.calculateDerivedValues(interval, targetVariable, rule.getSql(), connection);
        } else if (rule.isSetAuto() && (sql = this.createAutoSQL(interval, function = (auto = rule.getAuto()).getFunction(), sourceVariable = auto.getVariable())) != null) {
            SGELog.config("ReportingStoredObjectManager.createdAutoSQL", (Object)sql);
            rule.setSql(sql);
            this.calculateDerivedValues(interval, targetVariable, sql, connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void calculateDerivedValues(String timeRange, String variableName, String sql, Connection connection) throws ReportingException {
        SGELog.config("ReportingStoredObjectManager.executeRule", (Object)this.getClass().getName(), (Object)variableName);
        Timestamp timeEnd = ReportingStoredObjectManager.getDerivedTimeEnd(timeRange);
        Statement objectsStmt = this.databaseObjectManager.queryAllObjects(connection);
        try {
            ResultSet objects = objectsStmt.getResultSet();
            try {
                while (objects.next()) {
                    DatabaseObject obj = this.databaseObjectManager.newObject();
                    obj.initFromResultSet(objects);
                    Timestamp timeStart = this.valueManager.getLastEntryTime(obj.getId(), variableName, connection);
                    if (timeStart.compareTo(timeEnd) == 0) continue;
                    String[] key = obj.getPrimaryKey();
                    String cmd = sql.replaceAll("__time_start__", timeStart.toString());
                    cmd = cmd.replaceAll("__time_end__", timeEnd.toString());
                    for (int i = 0; i < key.length; ++i) {
                        StringBuffer pattern = new StringBuffer("__key_");
                        pattern.append(i);
                        pattern.append("__");
                        cmd = cmd.replaceAll(pattern.toString(), key[i]);
                    }
                    Statement stmt = this.databaseObjectManager.executeQuery(cmd.toString(), connection);
                    try {
                        ResultSet rs = stmt.getResultSet();
                        try {
                            while (rs.next()) {
                                this.valueManager.handleNewDerivedObject(obj, variableName, rs, connection);
                                this.databaseObjectManager.getDatabase().commit(connection);
                            }
                        }
                        finally {
                            rs.close();
                        }
                    }
                    finally {
                        stmt.close();
                    }
                }
            }
            finally {
                objects.close();
            }
        }
        catch (ReportingException re) {
            this.databaseObjectManager.getDatabase().rollback(connection);
            throw re;
        }
        catch (Exception e) {
            this.databaseObjectManager.getDatabase().rollback(connection);
            SGELog.warning((Throwable)e, "ReportStoredObjectManager.unknownError", (Object)e.getMessage());
        }
        finally {
            try {
                objectsStmt.close();
            }
            catch (SQLException sqle) {
                SGELog.warning(sqle, "ReportingStoredObjectManager.stmtCloseFailed");
            }
        }
    }

    public abstract DatabaseObject findObject(ReportingEventObject var1, Connection var2) throws ReportingException;

    public abstract void initObjectFromEvent(DatabaseObject var1, ReportingEventObject var2) throws ReportingException;
}

